/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usage;

import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.usage.NullUsagesTracker;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.dbtools.raptor.usages.OptInHandler;
import oracle.dbtools.raptor.usages.UsagesPrefs;
import oracle.dbtools.raptor.usages.UsagesTrackerImpl;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public abstract class UsagesTracker {
    protected static boolean _isOn;
    private static UsagesTracker _nullTracker;
    private static UsagesTracker usagesTracker;

    public static synchronized UsagesTracker getUsagesTracker() {
        if (usagesTracker == null) {
            UsagesPrefs usagesPrefs = UsagesPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            boolean bl = usagesPrefs.containsKey("track-usages");
            if (!bl) {
                UsagesTracker.initTracker();
            } else {
                _isOn = usagesPrefs.isTrackUsages();
                usagesTracker = _isOn ? new UsagesTrackerImpl() : UsagesTracker.getNullUsagesTracker();
            }
        }
        return usagesTracker;
    }

    public static boolean isOn() {
        return _isOn;
    }

    public abstract UsageData createUsageData();

    public abstract void report(UsageData var1);

    private static UsagesTracker getNullUsagesTracker() {
        if (_nullTracker == null) {
            _nullTracker = new NullUsagesTracker();
        }
        return _nullTracker;
    }

    public static void initTracker() {
        final UsagesPrefs usagesPrefs = UsagesPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        boolean bl = usagesPrefs.containsKey("track-usages");
        if (!bl) {
            if (Boolean.getBoolean("ide.debugbuild")) {
                usagesPrefs.setTrackUsages(false);
            } else {
                usagesPrefs.setTrackUsages(true);
                IdeArgs ideArgs = Ide.getIdeArgs();
                if (!ideArgs.hasArg("-nonag")) {
                    final OptInHandler optInHandler = new OptInHandler();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            optInHandler.showPrompt();
                            _isOn = usagesPrefs.isTrackUsages();
                        }
                    });
                } else {
                    _isOn = usagesPrefs.isTrackUsages();
                }
            }
        } else {
            _isOn = usagesPrefs.isTrackUsages();
        }
        usagesPrefs.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    if (!"track-usages".equals(changeInfo.getPropertyName())) continue;
                    _isOn = changeInfo.getNewValueAsBoolean();
                    break;
                }
            }
        });
    }
}

