/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.usages.HttpUtils;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocations;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;

class FileSender {
    private static final FileSender _instance = new FileSender();
    private List _uploadServers;
    private static final Logger LOGGER = Logger.getLogger(FileSender.class.getName());

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean logToServer(File ... fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        boolean bl = false;
        Object var3_3 = null;
        DefaultHttpClient defaultHttpClient = HttpUtils.getInstance().getNewHttpClient();
        try {
            FileSender.maybeConfigureProxySettings(defaultHttpClient);
            defaultHttpClient.getParams().setParameter("http.useragent", (Object)"SQL Developer Usage Tracker");
            defaultHttpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
            FileEntity[] fileEntityArray = new FileEntity[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                fileEntityArray[i] = new FileEntity(fileArray[i], "text/xml");
            }
            List list = this.getUsageServers();
            Iterator iterator = list.iterator();
            while (!bl && iterator.hasNext()) {
                ServerLocation serverLocation = (ServerLocation)iterator.next();
                for (FileEntity fileEntity : fileEntityArray) {
                    if (!FileSender.sendEntity(fileEntity, defaultHttpClient, serverLocation)) continue;
                    iterator.remove();
                }
            }
        }
        catch (IOException iOException) {
            Assert.printStackTrace((Throwable)iOException);
        }
        catch (Exception exception) {
            Assert.printStackTrace((Throwable)exception);
        }
        finally {
            if (var3_3 != null) {
                defaultHttpClient.getConnectionManager().shutdown();
            }
        }
        return bl;
    }

    private static boolean sendEntity(FileEntity fileEntity, DefaultHttpClient defaultHttpClient, ServerLocation serverLocation) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(serverLocation.getUrl());
        httpPost.setEntity((HttpEntity)fileEntity);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        if (LOGGER.isLoggable(Level.FINE)) {
            httpResponse.getEntity().writeTo((OutputStream)System.out);
        }
        return 200 == httpResponse.getStatusLine().getStatusCode();
    }

    private static void maybeConfigureProxySettings(DefaultHttpClient defaultHttpClient) {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        Boolean bl = proxyOptions.getUseProxy();
        if (bl.booleanValue()) {
            String string = proxyOptions.getProxyHost();
            Integer n = Integer.valueOf(proxyOptions.getProxyPort());
            HttpHost httpHost = new HttpHost(string, n.intValue());
            defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)httpHost);
            if (proxyOptions.getUseProxyAuthentication().booleanValue()) {
                AuthScope authScope = new AuthScope(string, n.intValue());
                defaultHttpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(proxyOptions.getProxyUserName(), new String(proxyOptions.getProxyPassword())));
            } else {
                Object var6_7 = null;
            }
        }
    }

    private List getUsageServers() {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers());
        }
        return this._uploadServers;
    }
}

