/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.BufferedInputStream;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocationsParser;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.javatools.codeex.Base64;

final class ServerLocations {
    static String _masterServerURL;

    ServerLocations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<ServerLocation> getServers() {
        HashSet<ServerLocation> hashSet = new HashSet<ServerLocation>();
        try {
            URL uRL = URLFactory.newURL((String)ServerLocations.getMasterUsageServerURL());
            BufferedInputStream bufferedInputStream = null;
            try {
                URLConnection uRLConnection = ServerLocations.urlConnect(uRL);
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                List list = new ServerLocationsParser().parse(bufferedInputStream);
                for (ServerLocation serverLocation : list) {
                    hashSet.add(serverLocation);
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            Assert.println((String)"Failed to upload usage logs to server. Possible cause: proxy may not be configured correctly.");
            Assert.printStackTrace((Throwable)noRouteToHostException);
        }
        catch (Throwable throwable) {
            Assert.println((String)"Failed to upload usage logs to server.");
            Assert.printStackTrace((Throwable)throwable);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static URLConnection urlConnect(URL uRL) throws Exception {
        URLConnection uRLConnection;
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxy().booleanValue()) {
            String string = proxyOptions.getProxyHost();
            Integer n = Integer.valueOf(proxyOptions.getProxyPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, (int)n));
            uRLConnection = uRL.openConnection(proxy);
            if (proxyOptions.getUseProxyAuthentication().booleanValue()) {
                String string2 = proxyOptions.getProxyUserName() + ':' + new String(proxyOptions.getProxyPassword());
                String string3 = Base64.base64Encode((byte[])string2.getBytes());
                uRLConnection.setRequestProperty("Proxy-Authorization", string3);
            }
        } else {
            uRLConnection = uRL.openConnection();
        }
        return uRLConnection;
    }

    static String getMasterUsageServerURL() {
        if (_masterServerURL == null) {
            String string = System.getProperty("ide.update.usage.servers");
            if (string == null || string.trim().length() == 0) {
                string = "http://download.oracle.com/otn-pub/jdeveloper/cfu/usage.xml";
            }
            _masterServerURL = string;
        }
        return _masterServerURL;
    }
}

