/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.compare.Stream;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.merge.MergeNode;
import oracle.jdeveloper.merge.MergeURLFileSystemHelper;

public class TextMergeNode
extends TextNode
implements MergeNode<TextBuffer> {
    private TextBuffer _saveResult;
    private URL _saveUrl;
    private boolean _skipSave;

    @Override
    public final void setSaveResult(TextBuffer saveResult) {
        this._saveResult = saveResult;
    }

    @Override
    public final void setSaveURL(URL saveUrl) {
        this._saveUrl = saveUrl;
    }

    @Override
    public final void setSkipSave(boolean skipSave) {
        this._skipSave = skipSave;
    }

    @Override
    public final boolean isSkipSave() {
        return this._skipSave;
    }

    public TextMergeNode(URL url) {
        super(MergeURLFileSystemHelper.newMergeURL(url));
        this.initializeAttributes();
    }

    protected Reader createReader(URL url) throws IOException {
        return super.createReader(MergeURLFileSystemHelper.getSaveURL(url));
    }

    protected void initializeAttributes() {
        this.getAttributes().unset(ElementAttributes.DELETEABLE);
        this.getAttributes().unset(ElementAttributes.RENAMEABLE);
        this.getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
    }

    public final boolean setReadOnly(boolean readOnly) {
        return true;
    }

    public final Icon getIcon() {
        return OracleIcons.getIcon((String)"union.png");
    }

    protected final void saveImpl() throws IOException {
        URL saveUrl;
        if (this.isSkipSave()) {
            return;
        }
        if (this._saveResult == null) {
            return;
        }
        URL uRL = saveUrl = this._saveUrl != null ? this._saveUrl : MergeURLFileSystemHelper.getSaveURL(this.getURL());
        if (saveUrl == null) {
            throw new NullPointerException("saveUrl");
        }
        if ("ide.merge".equals(saveUrl.getProtocol())) {
            throw new IllegalStateException("attempt to save merge protocol URL");
        }
        TextMergeNode.saveResultToURL(this._saveResult, saveUrl);
    }

    static final void saveResultToURL(TextBuffer saveTextBuffer, URL url) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saveTextBuffer.write((Writer)new OutputStreamWriter(baos));
        Stream stream = StreamDecoder.getStream((String)URLFileSystem.getSuffix((URL)url), (InputStream)new ByteArrayInputStream(baos.toByteArray()), (String)StreamDecoder.getDefaultEncoding((URL)url));
        try {
            stream.getReader().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        saveTextBuffer.write((Writer)new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), stream.getEncoding())));
    }
}

