/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.Assert;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.SectionView;
import oracle.javatools.util.Version;
import oracle.jdeveloper.vcs.annotations.AnnotationComponent;
import oracle.jdeveloper.vcs.annotations.AnnotationMark;
import oracle.jdeveloper.vcs.annotations.AnnotationView;
import oracle.jdeveloper.vcs.annotations.Annotations;

abstract class AnnotationController
implements Controller {
    private AnnotationComponent _component;

    public AnnotationController(AnnotationComponent component) {
        this._component = component;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    void refresh() {
        SwingWorker<Annotations, Object> task = new SwingWorker<Annotations, Object>(){

            @Override
            protected Annotations doInBackground() throws Exception {
                return AnnotationController.this.getAnnotations();
            }

            @Override
            protected void done() {
                try {
                    AnnotationController.this.refresh((Annotations)this.get());
                }
                catch (Exception ignore) {
                    Assert.printStackTrace((Throwable)ignore);
                }
            }
        };
        task.execute();
    }

    private void refresh(Annotations annotations) {
        if (annotations != null) {
            this._component.setAnnotations(annotations, this.getAnnotationMarkSet(annotations));
        } else {
            this._component.invalidateState();
        }
    }

    public Collection getAnnotationMarkSet(Annotations annotations) {
        LinkedHashSet<AnnotationMark> annotationMarkSet = new LinkedHashSet<AnnotationMark>();
        int totalLines = annotations.getLineCount();
        DateFormat dateFormat = this.getDateFormat();
        for (int i = 0; i < totalLines; ++i) {
            int j;
            AnnotationMark mark = new AnnotationMark(i, annotations.getAuthor(i), annotations.getRevision(i), annotations.getChanged(i), annotations.getComment(i), annotations.getBugNumbers(i));
            mark.setDateFormat(dateFormat);
            mark.setComparable((Comparable)new Version(annotations.getRevision(i)));
            mark.setExtendedRevision(annotations.getExtendedRevision(i));
            if (annotationMarkSet.contains(mark)) continue;
            int n = j = i == totalLines ? i : i + 1;
            while (j < totalLines) {
                if (annotations.getRevision(i).equals(annotations.getRevision(j))) {
                    mark.addLineToScope(j);
                }
                ++j;
            }
            mark.createScopePairSet();
            annotationMarkSet.add(mark);
        }
        this.setAnnotationMarkColors(annotationMarkSet);
        return annotationMarkSet;
    }

    public void setAnnotationMarkColors(Collection<AnnotationMark> annotationMarkSet) {
        int alphaDelta;
        Color color = new Color(31726);
        ArrayList<AnnotationMark> annotationMarkList = new ArrayList<AnnotationMark>(annotationMarkSet);
        Collections.sort(annotationMarkList);
        Collections.reverse(annotationMarkList);
        Iterator<AnnotationMark> i = annotationMarkList.iterator();
        int n = alphaDelta = annotationMarkList.isEmpty() ? 0 : Math.max(5, 230 / annotationMarkList.size());
        while (i.hasNext()) {
            AnnotationMark mark = i.next();
            mark.setColor(color);
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.max(25, color.getAlpha() - alphaDelta));
        }
    }

    protected abstract Annotations getAnnotations();

    protected abstract DateFormat getDateFormat();

    static final boolean closeAnnotationComponent() {
        BasicEditorPane editorPane = AnnotationController.getBasicEditorPane();
        if (editorPane == null) {
            return false;
        }
        JComponent leftMargin = AnnotationController.getScrollableLeftMargin(editorPane);
        Collection<AnnotationView> annotationViews = AnnotationController.getAnnotationViews(editorPane);
        for (AnnotationView annotationView : annotationViews) {
            editorPane.deinstallPlugin((EditorPlugin)annotationView);
            if (leftMargin == null) continue;
            leftMargin.remove((Component)((Object)annotationView));
        }
        return !annotationViews.isEmpty();
    }

    static final BasicEditorPane getBasicEditorPane() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || !(editor instanceof CodeEditor)) {
            return null;
        }
        return ((CodeEditor)editor).getFocusedEditorPane();
    }

    static final JComponent getScrollableLeftMargin(BasicEditorPane basicEditorPane) {
        JComponent comp = (JComponent)CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).getScrollableLeftMargin();
        if (comp instanceof SectionView) {
            comp = ((SectionView)comp).getWrappedComponent();
        }
        return comp;
    }

    static final Collection<AnnotationView> getAnnotationViews(BasicEditorPane editorPane) {
        ArrayList<AnnotationView> annotationViews = new ArrayList<AnnotationView>();
        for (PropertyChangeListener pcl : editorPane.getPropertyChangeListeners()) {
            if (!(pcl instanceof AnnotationView)) continue;
            annotationViews.add((AnnotationView)((Object)pcl));
        }
        return annotationViews;
    }
}

