/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ide.webbrowser.internal.Util;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.annotations.AnnotationMark;

final class AnnotationHover
extends InfoTipHover {
    private static volatile boolean isInsideOracle;
    private static final String BUG_URL = "https://bug.oraclecorp.com/pls/bug/webbug_edit.edit_info_top?rptno=";

    static AnnotationHover get(AnnotationMark mark, JComponent parent, Rectangle r, final InfoTipStyles style) {
        Collection<Integer> bugs;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = style.getBorderInsets();
        panel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        panel.setOpaque(false);
        String revision = mark.getRevisionLabel();
        CopyableLabel revisionField = new CopyableLabel(revision);
        revisionField.setBorder(BorderFactory.createEmptyBorder());
        revisionField.setOpaque(false);
        revisionField.setEditable(false);
        revisionField.setFont(style.getItemTitleFont());
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        panel.add((Component)revisionField, gbc);
        String date = mark.getDate();
        if (date != null) {
            CopyableLabel dateField = new CopyableLabel(date);
            dateField.setBorder(BorderFactory.createEmptyBorder());
            dateField.setForeground(style.getContentTextColor());
            gbc.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)dateField, gbc);
        }
        CopyableLabel authorField = new CopyableLabel(mark.getAuthor());
        authorField.setBorder(BorderFactory.createEmptyBorder());
        authorField.setForeground(style.getContentTextColor());
        gbc.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)authorField, gbc);
        String comment = mark.getComment();
        int preferredWidth = Math.max(300, revisionField.getPreferredSize().width);
        if (comment != null && !comment.isEmpty()) {
            JTextArea text = new JTextArea(comment.trim());
            text.setBackground(Color.WHITE);
            text.setEditable(false);
            text.setColumns(50);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setRows(10);
            text.setForeground(style.getContentTextColor());
            JScrollPane pane = new JScrollPane(text);
            pane.setBorder(BorderFactory.createLineBorder(style.getInternalBorderColor()));
            pane.setHorizontalScrollBarPolicy(31);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(3, 0, 0, 0);
            panel.add((Component)pane, gbc);
            preferredWidth = Math.max(preferredWidth, pane.getPreferredSize().width);
        }
        if ((bugs = mark.getBugNumbers()) != null && !bugs.isEmpty()) {
            ArrayList<Integer> bugList = new ArrayList<Integer>(bugs);
            Collections.sort(bugList);
            JPanel bugPanel = new JPanel(new FlowLayout(0, 0, 0));
            bugPanel.setOpaque(false);
            JLabel label = new JLabel(VCSArb.get("ANNOTATIONS_BUG_LABEL"));
            label.setOpaque(false);
            label.setForeground(style.getContentTextColor());
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
            bugPanel.add(label);
            final Font normal = label.getFont();
            HashMap attributes = new HashMap(normal.getAttributes());
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font underlined = normal.deriveFont(attributes);
            int w = 0;
            int h = 0;
            int maxHeight = 0;
            for (final Integer bug : bugList) {
                final CopyableLabel bugField = new CopyableLabel(Integer.toString(bug));
                if (AnnotationHover.canOpenBugs()) {
                    bugField.setForeground(style.getHyperLinkTextColor(false));
                } else {
                    bugField.setForeground(style.getContentTextColor());
                }
                bugField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                Dimension d = bugField.getPreferredSize();
                d.width += 5;
                bugField.setPreferredSize(d);
                if ((w += d.width) > preferredWidth) {
                    w = d.width;
                    h += maxHeight;
                    maxHeight = 0;
                }
                maxHeight = Math.max(maxHeight, d.height);
                bugField.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (AnnotationHover.canOpenBugs()) {
                            bugField.setFont(underlined);
                            bugField.setForeground(style.getHyperLinkTextColor(true));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (AnnotationHover.canOpenBugs()) {
                            bugField.setFont(normal);
                            bugField.setForeground(style.getHyperLinkTextColor(false));
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        AnnotationHover.openBug(bug);
                    }
                });
                bugPanel.add(bugField);
            }
            bugPanel.setPreferredSize(new Dimension(w + 3, h += maxHeight));
            gbc.insets = new Insets(3, 0, 0, 0);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            panel.add((Component)bugPanel, gbc);
        }
        return new AnnotationHover((Template)new BasicTemplate((JComponent)panel), InfoTipStyles.DEFAULT, parent, r);
    }

    private static boolean canOpenBugs() {
        return isInsideOracle && BrowserRunner.getBrowserRunner() != null;
    }

    private static void openBug(int bug) {
        URL url;
        BrowserRunner runner;
        if (isInsideOracle && (runner = BrowserRunner.getBrowserRunner()) != null && (url = AnnotationHover.getBugUrl(bug)) != null) {
            runner.runBrowserOnURL(url, null, null);
        }
    }

    private static URL getBugUrl(int bug) {
        try {
            return new URL(BUG_URL + bug);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private AnnotationHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location) {
        super(template, style, parent, location, HoverFlavor.getFlavor((String)"info"));
    }

    public boolean shouldHideHover(KeyEvent event) {
        return false;
    }

    static {
        Util.isInsideOracle((Util.Worker)new Util.Worker(){

            public void onResult(boolean isInsideOracle) {
                isInsideOracle = isInsideOracle;
            }
        });
    }

    private static final class CopyableLabel
    extends JTextField {
        public CopyableLabel(String text) {
            super(text);
            this.setOpaque(false);
            this.setEditable(false);
            this.setCaret(new DefaultCaret(){

                @Override
                public void paint(Graphics g) {
                }
            });
        }
    }
}

