/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.annotations;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.Timer;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.annotations.AnnotationController;
import oracle.jdeveloper.vcs.annotations.AnnotationView;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSContextualController;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;

public abstract class AnnotationsCommand
extends VCSCommand {
    private Node _node = null;

    public static final IdeAction getAnnotationsAction(String command, String vcsId) {
        final int id = Ide.findOrCreateCmdID((String)command);
        IdeAction annotationsAction = IdeAction.find((int)id);
        if (annotationsAction != null) {
            return annotationsAction;
        }
        annotationsAction = IdeAction.findOrCreate((int)id, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(vcsId), command), (String)StringUtils.stripMnemonic((String)VCSArb.get("TOGGLE_ANNOTATIONS")), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)VCSArb.get("TOGGLE_ANNOTATIONS"))), null, null, (boolean)true);
        annotationsAction.putValue("Check", (Object)true);
        if (vcsId == null) {
            return null;
        }
        annotationsAction.addController((Controller)new VCSContextualController(id, vcsId));
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)new VCSContextMenuListener(vcsId){

            @Override
            protected Component[] getContextMenuItems(Context context) {
                BasicEditorPane editorPane = AnnotationsCommand.getBasicEditorPane();
                IdeAction.find((int)id).setState(editorPane != null && !AnnotationsCommand.getAnnotationViews(editorPane).isEmpty());
                return new Component[]{VCSMenuUtils.createMenuItem(id)};
            }

            @Override
            protected float getSection() {
                return 4.6f;
            }
        });
        return annotationsAction;
    }

    protected AnnotationsCommand(int id) {
        super(id);
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        JComponent leftMargin = AnnotationsCommand.getScrollableLeftMargin();
        if (leftMargin == null) {
            return false;
        }
        Node node = EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        return node != null && this.isAvailableImpl((Locatable)node);
    }

    @Override
    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        return locatable.getURL() != null && VCSManager.getVCSManager().isVersioned(locatable.getURL());
    }

    protected abstract boolean isUnmodifiedStatus(VCSStatus var1);

    @Override
    protected int doitImpl() throws Exception {
        JComponent leftMargin = AnnotationsCommand.getScrollableLeftMargin();
        if (leftMargin == null) {
            return 1;
        }
        if (AnnotationsCommand.closeAnnotationComponent()) {
            return 0;
        }
        final Node node = EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        final NodeListener[] l = new NodeListener[1];
        final Observer[] o = new Observer[1];
        final CodeExpansionListener[] cel = new CodeExpansionListener[1];
        final Timer[] timer = new Timer[1];
        this._node = node;
        final CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)AnnotationsCommand.getBasicEditorPane().getProperty("code-folding-margin");
        final AnnotationView annotationView = new AnnotationView(this.getContext()){

            @Override
            protected Annotations getAnnotations() {
                try {
                    return AnnotationsCommand.this.getAnnotations();
                }
                catch (Exception e) {
                    AnnotationsCommand.this.getExceptionHandler().handleException(e);
                    return null;
                }
            }

            @Override
            protected DateFormat getDateFormat() {
                return AnnotationsCommand.this.getDateFormat();
            }

            @Override
            public void deinstallImpl(BasicEditorPane editor) {
                timer[0].stop();
                super.deinstallImpl(editor);
                AnnotationsCommand.this.removeValidityListeners(node, l[0], o[0], codeFoldingMargin, cel[0]);
            }
        };
        l[0] = new NodeListener(){

            public void nodeDirtyStateChanged(NodeEvent ne, boolean isNowDirty) {
                timer[0].restart();
            }

            public void nodeReverted(NodeEvent ne) {
                timer[0].restart();
            }

            public void nodeClosed(NodeEvent ne) {
                timer[0].stop();
                AnnotationsCommand.this.removeValidityListeners(node, l[0], o[0], codeFoldingMargin, cel[0]);
            }
        };
        o[0] = this.getStatusCacheBridge() instanceof StatusCache ? new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                StatusCacheEvent e = (StatusCacheEvent)arg;
                URLFilter filter = StatusCacheUtil.createDepthFilter(e.getURLs(), e.getDepth());
                if (filter.accept(node.getURL())) {
                    timer[0].restart();
                }
            }
        } : new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                URL[] urls;
                String externalUrl = node.getURL().toExternalForm();
                for (URL url : urls = (URL[])arg) {
                    if (!url.toExternalForm().equals(externalUrl)) continue;
                    timer[0].restart();
                    break;
                }
            }
        };
        timer[0] = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnnotationsCommand.this.updateValidity(annotationView, node, node.isDirty());
            }
        });
        timer[0].setRepeats(false);
        timer[0].setCoalesce(true);
        AnnotationsCommand.getBasicEditorPane().installPlugin((EditorPlugin)annotationView);
        leftMargin.add((Component)((Object)annotationView), "West");
        node.addNodeListener(l[0]);
        ((Observable)((Object)this.getStatusCacheBridge())).addObserver(o[0]);
        timer[0].start();
        return 0;
    }

    private void updateValidity(final AnnotationView annotationView, Node node, boolean nodeDirty) {
        try {
            if (!this.isStateValid(node, nodeDirty, this.getStatusCacheBridge().get(node.getURL()))) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        annotationView.invalidateState();
                    }
                });
                return;
            }
            ((AnnotationController)annotationView.getController()).refresh();
        }
        catch (Exception e) {
            annotationView.invalidateState();
            e.printStackTrace();
        }
    }

    private void removeValidityListeners(Node node, NodeListener l, Observer o, CodeFoldingMargin codeFoldingMargin, CodeExpansionListener cel) {
        if (l != null) {
            node.removeNodeListener(l);
        }
        if (o != null) {
            ((Observable)((Object)this.getStatusCacheBridge())).deleteObserver(o);
        }
        if (cel != null) {
            codeFoldingMargin.removeCodeExpansionListener(cel);
        }
    }

    private boolean isStateValid(Node node, boolean nodeDirty, VCSStatus status) {
        long timestamp = URLFileSystem.lastModified((URL)node.getURL());
        return timestamp == node.getUnmodifiedTimestamp() && !nodeDirty && this.isUnmodifiedStatus(status);
    }

    private Annotations getAnnotations() throws Exception {
        URL url = this._node.getURL();
        return url != null ? this.getAnnotations(new File(URLFileSystem.getPlatformPathName((URL)url))) : null;
    }

    protected Annotations getAnnotations(File file) throws Exception {
        return this.getAnnotations(file.toURI().toURL());
    }

    protected abstract Annotations getAnnotations(URL var1) throws Exception;

    protected DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    private static final JComponent getScrollableLeftMargin() {
        BasicEditorPane editorPane = AnnotationsCommand.getBasicEditorPane();
        return editorPane != null ? AnnotationsCommand.getScrollableLeftMargin(editorPane) : null;
    }

    private static final JComponent getScrollableLeftMargin(BasicEditorPane basicEditorPane) {
        return AnnotationController.getScrollableLeftMargin(basicEditorPane);
    }

    private static final Collection<AnnotationView> getAnnotationViews(BasicEditorPane editorPane) {
        return AnnotationController.getAnnotationViews(editorPane);
    }

    private static final BasicEditorPane getBasicEditorPane() {
        return AnnotationController.getBasicEditorPane();
    }

    private static final boolean closeAnnotationComponent() {
        return AnnotationController.closeAnnotationComponent();
    }
}

