/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.awt.EventQueue;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.cache.URICache;

public abstract class StatusCache<V>
extends Observable
implements StatusCacheBridge<V> {
    static final int CACHE_SIZE = 5000;
    protected final Class<V> _valueType;
    private final Map<URI, V> _cache;
    private Collection<StatusCacheListener> _listeners;
    protected final ReadWriteLock _invalidationLock = new ReentrantReadWriteLock();

    public StatusCache(Class<V> valueType) {
        this._valueType = valueType;
        this._cache = this.createCache(5000);
    }

    protected Map<URI, V> createCache(int bound) {
        return Collections.synchronizedMap(new Maps.CacheMap(bound, Maps.CacheMap.NOT_CANONICAL));
    }

    @Override
    public final V get(URL url) throws Exception {
        return this.get(new URL[]{url})[0];
    }

    @Override
    public final V[] get(URL[] urls) throws Exception {
        return this._get(urls, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V[] _get(final URL[] urls, final boolean blocking) throws Exception {
        if (this._invalidationLock != null) {
            this._invalidationLock.readLock().lock();
        }
        try {
            V[] VArray = this.maybeCallSynchronized(new Callable<V[]>(){

                @Override
                public final V[] call() throws Exception {
                    return StatusCache.this._get2(urls, blocking);
                }
            }, blocking);
            return VArray;
        }
        finally {
            if (this._invalidationLock != null) {
                this._invalidationLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V[] _get2(URL[] urls, boolean blocking) throws Exception {
        BitSet bits = new BitSet(urls.length);
        Lock[] locks = this.getLocks(urls);
        if (!this.lock(locks, blocking)) {
            return null;
        }
        try {
            int i;
            V[] values = this.getCachedValues(urls);
            for (int i2 = 0; i2 < urls.length; ++i2) {
                bits.set(i2, values[i2] == null);
            }
            if (bits.isEmpty()) {
                V[] i2 = values;
                return i2;
            }
            int n = bits.cardinality();
            URL[] urls2 = new URL[n];
            V[] values2 = this.createValueArray(n);
            int j = 0;
            for (i = 0; i < urls.length; ++i) {
                if (i < bits.length() && bits.get(i)) {
                    urls2[j++] = urls[i];
                }
                if (i < bits.length() && bits.get(i)) continue;
                this.unlock(locks, i);
            }
            this._get3(urls2, values2);
            this.populateCachedValues(urls2, values2);
            j = 0;
            for (i = 0; i < bits.length(); ++i) {
                if (!bits.get(i)) continue;
                values[i] = values2[j++];
            }
            V[] VArray = values;
            return VArray;
        }
        finally {
            this.unlock(locks);
        }
    }

    protected void _get3(URL[] urls, V[] values) throws Exception {
        this.getNatively(urls, values);
    }

    protected <T> T maybeCallSynchronized(Callable<T> c, boolean blocking) throws Exception {
        return c.call();
    }

    protected Lock[] getLocks(URL[] urls) {
        return null;
    }

    protected boolean lock(Lock[] locks, boolean blocking) {
        return true;
    }

    protected void unlock(Lock[] locks) {
    }

    protected void unlock(Lock[] locks, int i) {
    }

    @Override
    public final V getEDT(URL url) throws Exception {
        return this.getEDT(new URL[]{url})[0];
    }

    @Override
    public final V[] getEDT(URL[] urls) throws Exception {
        try {
            return this.getOrFail(urls);
        }
        catch (ConcurrentGetException cge) {
            return this.getAsynchronously(urls);
        }
    }

    private final V[] getOrFail(URL[] urls) throws ConcurrentGetException, Exception {
        V[] values = this._get(urls, false);
        if (values == null) {
            throw new ConcurrentGetException();
        }
        return values;
    }

    private final V[] getAsynchronously(URL[] urls) throws Exception {
        V[] values = this.createValueArray(urls.length);
        this.getNatively(urls, values);
        return values;
    }

    private final V[] createValueArray(int length) {
        return (Object[])Array.newInstance(this._valueType, length);
    }

    protected abstract void getNatively(URL[] var1, V[] var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invalidate() {
        if (this._invalidationLock != null) {
            this._invalidationLock.writeLock().lock();
        }
        try {
            this._cache.clear();
        }
        finally {
            if (this._invalidationLock != null) {
                this._invalidationLock.writeLock().unlock();
            }
            this.notifyOnClear(null, null, true);
        }
    }

    @Override
    public final void clear() {
        this.invalidate();
    }

    @Override
    public final void clear(URL url) {
        this.clear(new URL[]{url});
    }

    @Override
    public final void clear(URL[] urls) {
        this.clear(urls, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(URL[] urls, Depth depth) {
        block10: {
            if (this._invalidationLock != null) {
                this._invalidationLock.writeLock().lock();
            }
            try {
                for (URL url : urls) {
                    this._cache.remove(URICache.get(url));
                }
                if (depth == null) {
                    depth = Depth.EMPTY;
                }
                if (depth == Depth.EMPTY) break block10;
                URLFilter filter = StatusCacheUtil.createDepthFilter(urls, depth);
                try {
                    Iterator<URI> itr = this._cache.keySet().iterator();
                    while (itr.hasNext()) {
                        if (!filter.accept(itr.next().toURL())) continue;
                        itr.remove();
                    }
                }
                catch (MalformedURLException murle) {
                    FeedbackManager.reportException((Throwable)murle);
                }
            }
            finally {
                if (this._invalidationLock != null) {
                    this._invalidationLock.writeLock().unlock();
                }
                this.notifyOnClear(urls, depth, false);
            }
        }
    }

    private final void notifyOnClear(URL[] urls, Depth depth, boolean invalidate) {
        final StatusCacheEvent e = new StatusCacheEvent(this, urls, depth, invalidate);
        this.fireValuesCleared(e);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                StatusCache.this.setChanged();
                StatusCache.this.notifyObservers(e);
            }
        });
    }

    public final synchronized void addCacheListener(StatusCacheListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<StatusCacheListener>();
        }
        this._listeners.add(l);
    }

    public final synchronized void removeCacheListener(StatusCacheListener l) {
        if (this._listeners != null) {
            this._listeners.remove(l);
        }
    }

    private final void fireValuesCleared(StatusCacheEvent e) {
        if (this._listeners == null) {
            return;
        }
        for (StatusCacheListener l : this._listeners) {
            l.statusesCleared(e);
        }
    }

    @Override
    public abstract LocalStatusCache<V> newLocalCache();

    public boolean isLocalCache() {
        return false;
    }

    private final V[] getCachedValues(URL[] urls) {
        urls = VersioningCoreUtil.removeRefAndQueryParts((URL[])urls);
        V[] values = this.createValueArray(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            values[i] = this.getValueInternal(urls[i]);
        }
        return values;
    }

    private final V getValueInternal(URL url) {
        return this._cache.get(URICache.get(url));
    }

    private final void putValueInternal(URL url, V value) {
        this._cache.put(URICache.get(url), value);
    }

    private final void populateCachedValues(URL[] urls, V[] values) {
        urls = VersioningCoreUtil.removeRefAndQueryParts((URL[])urls);
        for (int i = 0; i < urls.length; ++i) {
            this.putValueInternal(urls[i], values[i]);
        }
    }

    public ReadWriteLock getInvalidationLock() {
        return this._invalidationLock;
    }

    private static final class ConcurrentGetException
    extends Exception {
        private ConcurrentGetException() {
        }
    }
}

