/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.URICache;

public abstract class TransactionalStatusCache<V>
extends StatusCache<V> {
    protected final Lock _atomicityLock = new ReentrantLock();
    private Map<URI, Lock> _locks;

    public TransactionalStatusCache(Class<V> valueType) {
        super(valueType);
        this.createLocks();
    }

    private final void createLocks() {
        this._locks = new Maps.WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Lock[] getLocks(URL[] urls) {
        Lock[] locks = new Lock[urls.length];
        URI[] uris = URICache.get(urls);
        Map<URI, Lock> map = this._locks;
        synchronized (map) {
            int i = 0;
            for (URI uri : uris) {
                Lock lock = this._locks.get(uri);
                if (lock == null) {
                    lock = new ReentrantLock();
                    this._locks.put(uri, lock);
                }
                locks[i++] = lock;
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean lock(Lock[] locks, boolean blocking) {
        this._atomicityLock.lock();
        try {
            if (blocking) {
                for (Lock lock : locks) {
                    lock.lock();
                }
                boolean arr$ = true;
                return arr$;
            }
            for (int i = 0; i < locks.length; ++i) {
                if (locks[i].tryLock()) continue;
                for (int j = 0; j < i; ++j) {
                    locks[j].unlock();
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._atomicityLock.unlock();
        }
    }

    @Override
    protected final void unlock(Lock[] locks) {
        for (Lock lock : locks) {
            if (lock == null) continue;
            lock.unlock();
        }
    }

    @Override
    protected final void unlock(Lock[] locks, int i) {
        locks[i].unlock();
        locks[i] = null;
    }

    @Override
    public final LocalStatusCache<V> newLocalCache() {
        return new LocalStatusCache(this._valueType, this);
    }
}

