/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.nav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdeveloper.vcs.nav.ConnectionPlaceholderNode;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;

public abstract class BaseConnectionProvider
extends ConnectionProvider {
    public abstract Node getConnectionListNode();

    @Override
    public Element createConnectionListNode(Collection<Map<String, String>> criteria, boolean createConnections) {
        Collection<String> directoryPaths;
        HashMap<ConnectionNode, ArrayList<String>> nodeToPathsMap = new HashMap<ConnectionNode, ArrayList<String>>();
        ArrayList<Element> placeholderNodes = new ArrayList<Element>();
        for (Map<String, String> criteria1 : criteria) {
            criteria1 = this.createTestCriteria(criteria1);
            try {
                this.getConnectionListNode().open();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
            ConnectionNode connectionNode = this.findConnectionNode(criteria1);
            if (connectionNode == null && createConnections) {
                connectionNode = this.createConnectionNodeSilently(criteria1);
            }
            if (connectionNode == null) {
                placeholderNodes.add(this.createConnectionPlaceholderNode(criteria1));
                continue;
            }
            directoryPaths = (Collection)nodeToPathsMap.get(connectionNode);
            if (directoryPaths == null) {
                directoryPaths = new ArrayList<String>();
                nodeToPathsMap.put(connectionNode, (ArrayList<String>)directoryPaths);
            }
            directoryPaths.add(this.getCriteriaDirectory(criteria1));
        }
        ConnectionListFilterNode listNode = this.createConnectionListFilterNode();
        for (Map.Entry entry : nodeToPathsMap.entrySet()) {
            directoryPaths = (ArrayList<String>)entry.getValue();
            Element connectionFilterNode = this.createConnectionFilterNode((ConnectionNode)entry.getKey(), new ConnectionFilter(){

                @Override
                public boolean accept(String path) {
                    for (String directoryPath : directoryPaths) {
                        if (!BaseConnectionProvider.this.isPathFromMutualParent(directoryPath, path)) continue;
                        return true;
                    }
                    return false;
                }
            });
            ConnectionNodeDecorator connectionDecoratorNode = new ConnectionNodeDecorator(connectionFilterNode);
            connectionDecoratorNode.setConnectionNode((ConnectionNode)entry.getKey());
            listNode.addConnectionNode((Element)connectionDecoratorNode);
        }
        for (Element element : placeholderNodes) {
            listNode.addPlaceholderNode(element);
        }
        this.addOverlayClient((Node)listNode);
        return listNode;
    }

    @Override
    public Map<String, String> matchConnectionToCriteria(Collection<Map<String, String>> criteria, Map<String, String> connection) {
        for (Map<String, String> criteria1 : criteria) {
            criteria1 = this.createTestCriteria(criteria1);
            try {
                this.getConnectionListNode().open();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
            ConnectionNode connectionNode = this.findConnectionNode(criteria1);
            if (connectionNode == null || !connectionNode.getConnectionCriteria().equals(connection)) continue;
            return criteria1;
        }
        return null;
    }

    protected String getCriteriaDirectory(Map<String, String> criteria) {
        return criteria.get("path");
    }

    protected String getCriteriaHost(Map<String, String> criteria) {
        return criteria.get("host");
    }

    protected String getCriteriaFullPath(Map<String, String> criteria) {
        return criteria.get("path");
    }

    protected String getCriteriaMethod(Map<String, String> criteria) {
        return criteria.get("method");
    }

    protected ConnectionNode findConnectionNode(Map<String, String> criteria1) {
        Map<String, String> criteria0;
        ArrayList<ConnectionNode> matches = new ArrayList<ConnectionNode>();
        for (ConnectionNode connectionNode : this.getConnectionNodes()) {
            criteria0 = connectionNode.getConnectionCriteria();
            if (!this.nullSafeEquals(this.getCriteriaHost(criteria0), this.getCriteriaHost(criteria1)) || this.getCriteriaFullPath(criteria0) == null || this.getCriteriaFullPath(criteria1) == null || !this.canonicalizePath(this.getCriteriaFullPath(criteria1)).startsWith(this.canonicalizePath(this.getCriteriaFullPath(criteria0)))) continue;
            matches.add(connectionNode);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (ConnectionNode)matches.iterator().next();
        }
        if (this.getCriteriaMethod(criteria1) != null) {
            for (ConnectionNode connectionNode : matches) {
                criteria0 = connectionNode.getConnectionCriteria();
                if (this.getCriteriaMethod(criteria0) == null || !this.getCriteriaMethod(criteria0).equals(this.getCriteriaMethod(criteria1))) continue;
                return connectionNode;
            }
        }
        return (ConnectionNode)matches.iterator().next();
    }

    protected ConnectionNode createConnectionNodeSilently(Map<String, String> criteria) {
        return null;
    }

    private final Collection<ConnectionNode> getConnectionNodes() {
        ArrayList<ConnectionNode> connectionNodes = new ArrayList<ConnectionNode>();
        Iterator itr = this.getConnectionListNode().getChildren();
        if (itr != null) {
            while (itr.hasNext()) {
                Element element = (Element)itr.next();
                if (!(element instanceof ConnectionNode)) continue;
                connectionNodes.add((ConnectionNode)element);
            }
        }
        return connectionNodes;
    }

    protected Element createConnectionPlaceholderNode(Map<String, String> criteria) {
        return new ConnectionPlaceholderNode(criteria){

            @Override
            protected boolean createConnection(Map<String, String> criteria, Context context) {
                criteria = BaseConnectionProvider.this.createTestCriteria(criteria);
                return BaseConnectionProvider.this.createConnection(criteria, context);
            }
        };
    }

    protected abstract boolean createConnection(Map<String, String> var1, Context var2);

    protected abstract ConnectionListFilterNode createConnectionListFilterNode();

    protected abstract Element createConnectionFilterNode(ConnectionNode var1, ConnectionFilter var2);

    protected void addOverlayClient(Node listNode) {
    }

    protected boolean isPathFromMutualParent(String path1, String path2) {
        if (path1 == null) {
            return true;
        }
        path1 = this.canonicalizePath(path1);
        path2 = this.canonicalizePath(path2);
        if (path1.equals("/") || path2.equals("/")) {
            return true;
        }
        if (path2.equals(path1)) {
            return true;
        }
        if (path2.startsWith(path1)) {
            return true;
        }
        return path1.startsWith(path2);
    }

    protected String canonicalizePath(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    protected boolean nullSafeEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public boolean isConnected() {
        return !this.getConnectionNodes().isEmpty();
    }

    public void runConnect(Context context) {
        this.createConnection(Collections.<String, String>emptyMap(), context);
    }
}

