/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.spi.VCSCommentTemplatesPrefs;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public abstract class VCSCommentTemplatesTraversable
extends VCSPreferencesTraversable<VCSCommentTemplatesPrefs> {
    private final String _extensionId;
    private CommentTemplatesPanel _panel;

    protected VCSCommentTemplatesTraversable(String extensionId) {
        this.setHelpID("f1_scsversiontemplates_html");
        this._extensionId = extensionId;
    }

    @Override
    protected VCSCommentTemplatesPrefs getPreferences(PropertyStorage prefs) {
        return VCSCommentTemplatesPrefs.getInstance(prefs, this._extensionId);
    }

    @Override
    protected Component layOutPage(Component page) {
        return page;
    }

    @Override
    protected Component getPage() {
        if (this._panel == null) {
            this._panel = new CommentTemplatesPanel();
        }
        return this._panel;
    }

    @Override
    protected void validatePreferences() throws TraversalException {
    }

    @Override
    protected void savePreferences(VCSCommentTemplatesPrefs prefs) {
        this.getComponent();
        prefs.getTemplates().clear();
        for (String template : this._panel.getTemplates()) {
            prefs.getTemplates().add((Object)template);
        }
        prefs.setDefaultTemplateIndex(this._panel.getDefaultTemplateIndex());
    }

    @Override
    protected void loadPreferences(VCSCommentTemplatesPrefs prefs) {
        this.getComponent();
        String[] templates = (String[])prefs.getTemplates().toArray((Object[])new String[0]);
        this._panel.setTemplates(templates);
        this._panel.setDefaultTemplateIndex(prefs.getDefaultTemplateIndex());
        this._panel.updateFromSelection();
    }

    private static class CommentTemplatesPanel
    extends JPanel {
        private final JLabel _templatesLabel = new JLabel();
        private final JList _templatesList = new JList(new DefaultListModel());
        private final JLabel _previewLabel = new JLabel();
        private final JTextArea _previewTextArea = new JTextArea();
        private final JButton _addButton = new JButton();
        private final JButton _removeButton = new JButton();
        private final JButton _editButton = new JButton();
        private final JButton _setAsDefaultButton = new JButton();
        private final JPanel _buttonPanel = new JPanel();
        private final JButton _importButton = new JButton();
        private final JButton _exportButton = new JButton();
        private int _defaultTemplateIndex = -1;
        private URL _lastImportExportURL;
        private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"comment-templates");
        private static final String ROOT_TAG = "templates_list";

        CommentTemplatesPanel() {
            this.createComponents();
            this.resComponents();
            this.layoutComponents();
        }

        private void createComponents() {
            this._previewTextArea.setBackground(UIManager.getColor("control"));
            this._templatesList.setSelectionMode(0);
            this._templatesList.setDragEnabled(false);
            this._templatesList.setCellRenderer(new VCSCommentsCustomizer.CommentListCellRenderer(){
                private final Icon BLANK_ICON = new NullIcon(16, 16);

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (CommentTemplatesPanel.this._defaultTemplateIndex == index) {
                        label.setIcon(OracleIcons.getIcon((String)"pin.png"));
                        label.setFont(label.getFont().deriveFont(1));
                        label.setText(VCSArb.format("DEFAULT_TEMPLATE_POSTFIX", label.getText()));
                    } else {
                        label.setIcon(this.BLANK_ICON);
                        label.setFont(label.getFont().deriveFont(0));
                    }
                    return label;
                }
            });
            this._addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    class TemplateInputDialog
                    extends SimpleInputDialog {
                        TemplateInputDialog() {
                            super((Component)CommentTemplatesPanel.this);
                        }

                        protected JTextComponent createInputComponent() {
                            JTextArea textArea = new JTextArea();
                            textArea.setRows(5);
                            textArea.setColumns(50);
                            textArea.setLineWrap(false);
                            textArea.setWrapStyleWord(false);
                            return textArea;
                        }
                    }
                    TemplateInputDialog dialog = new TemplateInputDialog();
                    if (!dialog.show(VCSArb.get("ADD_TEMPLATE_TITLE"), VCSArb.get("TEMPLATE_LABEL"), "f1_scsaddtemplate_html")) {
                        return;
                    }
                    if (CommentTemplatesPanel.this._templatesList.getModel().getSize() == 0) {
                        CommentTemplatesPanel.this.setDefaultTemplateIndex(0);
                    }
                    ((DefaultListModel)CommentTemplatesPanel.this._templatesList.getModel()).removeElement(dialog.getInputValue());
                    ((DefaultListModel)CommentTemplatesPanel.this._templatesList.getModel()).addElement(dialog.getInputValue());
                    CommentTemplatesPanel.this._templatesList.setSelectedValue(dialog.getInputValue(), true);
                }
            });
            this._editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TemplateInputDialog dialog = new TemplateInputDialog();
                    int i = CommentTemplatesPanel.this._templatesList.getSelectedIndex();
                    dialog.setInputValue((String)((DefaultListModel)CommentTemplatesPanel.this._templatesList.getModel()).getElementAt(i));
                    if (i < 0) {
                        return;
                    }
                    if (!dialog.show(VCSArb.get("EDIT_TEMPLATE_TITLE"), VCSArb.get("TEMPLATE_LABEL"), "f1_scsedittemplate_html")) {
                        return;
                    }
                    ((DefaultListModel)CommentTemplatesPanel.this._templatesList.getModel()).setElementAt(dialog.getInputValue(), i);
                    CommentTemplatesPanel.this.updateFromSelection();
                }
            });
            this._removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int i = CommentTemplatesPanel.this._templatesList.getSelectedIndex();
                    if (i < 0) {
                        return;
                    }
                    DefaultListModel listModel = (DefaultListModel)CommentTemplatesPanel.this._templatesList.getModel();
                    listModel.remove(i);
                    if (i <= CommentTemplatesPanel.this._defaultTemplateIndex) {
                        CommentTemplatesPanel.this.setDefaultTemplateIndex(CommentTemplatesPanel.this._defaultTemplateIndex - 1);
                    }
                    if (listModel.size() <= 0) {
                        CommentTemplatesPanel.this.updateFromSelection();
                        return;
                    }
                    CommentTemplatesPanel.this._templatesList.setSelectedIndex(Math.min(i, listModel.size() - 1));
                }
            });
            this._setAsDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CommentTemplatesPanel.this.setDefaultTemplateIndex(CommentTemplatesPanel.this._templatesList.getSelectedIndex());
                    CommentTemplatesPanel.this.updateFromSelection();
                }
            });
            this._importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CommentTemplatesPanel.this.importTemplates();
                }
            });
            this._exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CommentTemplatesPanel.this.exportTemplates();
                }
            });
            this._templatesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    CommentTemplatesPanel.this.updateFromSelection();
                }
            });
            this.updateFromSelection();
            this._previewTextArea.setEditable(false);
            this._previewTextArea.setRows(7);
            this._buttonPanel.setLayout(new BorderLayout());
            JPanel buttonPanelNorth = new JPanel((LayoutManager)new VerticalFlowLayout(0));
            JPanel buttonPanelSouth = new JPanel((LayoutManager)new VerticalFlowLayout(0));
            this._buttonPanel.add((Component)buttonPanelNorth, "North");
            this._buttonPanel.add(Box.createGlue(), "Center");
            this._buttonPanel.add((Component)buttonPanelSouth, "South");
            buttonPanelNorth.add(this._addButton);
            buttonPanelNorth.add(this._removeButton);
            buttonPanelNorth.add(this._editButton);
            buttonPanelNorth.add(this._setAsDefaultButton);
            buttonPanelSouth.add(this._importButton);
            buttonPanelSouth.add(this._exportButton);
        }

        private void resComponents() {
            ResourceUtils.resLabel((JLabel)this._templatesLabel, (Component)this._templatesList, (String)VCSArb.get("TEMPLATES"));
            ResourceUtils.resLabel((JLabel)this._previewLabel, (Component)this._previewTextArea, (String)VCSArb.get("PREVIEW_TEMPLATE"));
            ResourceUtils.resButton((AbstractButton)this._addButton, (String)VCSArb.get("ADD_TEMPLATE"));
            ResourceUtils.resButton((AbstractButton)this._removeButton, (String)VCSArb.get("REMOVE_TEMPLATE"));
            ResourceUtils.resButton((AbstractButton)this._editButton, (String)VCSArb.get("EDIT_TEMPLATE"));
            ResourceUtils.resButton((AbstractButton)this._setAsDefaultButton, (String)VCSArb.get("SET_TEMPLATE_AS_DEFAULT"));
            ResourceUtils.resButton((AbstractButton)this._importButton, (String)VCSArb.get("IMPORT_TEMPLATES"));
            ResourceUtils.resButton((AbstractButton)this._exportButton, (String)VCSArb.get("EXPORT_TEMPLATES"));
        }

        private void layoutComponents() {
            LayoutBuilder layoutBuilder = new LayoutBuilder();
            Insets insets = new Insets(2, 2, 2, 2);
            layoutBuilder.add((Component)this._templatesLabel, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)new JScrollPane(this._templatesList), insets, 1, true, true);
            layoutBuilder.add((Component)this._buttonPanel, null, 1, true, false);
            layoutBuilder.nl();
            layoutBuilder.addVGap();
            layoutBuilder.nl();
            layoutBuilder.add((Component)this._previewLabel, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)new JScrollPane(this._previewTextArea), insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.addToPanel((Container)this);
        }

        final void updateFromSelection() {
            String template = (String)this._templatesList.getSelectedValue();
            this._editButton.setEnabled(template != null);
            this._removeButton.setEnabled(template != null);
            this._previewTextArea.setText(template != null ? template : "");
            this._setAsDefaultButton.setEnabled(template != null && this._defaultTemplateIndex != this._templatesList.getSelectedIndex());
            this._exportButton.setEnabled(this._templatesList.getModel().getSize() > 0);
        }

        final String[] getTemplates() {
            ArrayList<String> templates = new ArrayList<String>();
            for (Object o : ((DefaultListModel)this._templatesList.getModel()).toArray()) {
                templates.add((String)o);
            }
            return templates.toArray(new String[0]);
        }

        final void setTemplates(String[] templates) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            if (templates != null) {
                for (String template : templates) {
                    model.addElement(template);
                }
            }
            this._templatesList.setModel(model);
        }

        final void setDefaultTemplateIndex(int defaultTemplateIndex) {
            this._defaultTemplateIndex = defaultTemplateIndex;
            this._templatesList.repaint();
        }

        final int getDefaultTemplateIndex() {
            return this._defaultTemplateIndex;
        }

        private void importTemplates() {
            URLChooser chooser = DialogUtil.newURLChooser();
            chooser.clearChooseableURLFilters();
            DefaultURLFilter filter = new DefaultURLFilter(VCSArb.get("TEMPLATES_FILTER_NAME"), ".xml");
            chooser.addChooseableURLFilter((URLFilter)filter);
            chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            chooser.setURLFilter((URLFilter)filter);
            if (this._lastImportExportURL != null) {
                chooser.setSelectedURL(this._lastImportExportURL);
            } else {
                URL url = this.getUserHomeDirectory();
                if (url != null) {
                    chooser.setSelectedURL(url);
                }
            }
            int result = chooser.showOpenDialog((Component)this, VCSArb.get("IMPORT_TEMPLATES_TITLE"));
            if (result == 0) {
                if (this.getTemplates().length > 0 && !MessageDialog.optionalConfirm((String)"VCS.ImportCommentTemplatesConfirm", (Component)this, (Object)VCSArb.get("CONFIRM_IMPORT_TEMPLATES"), (String)VCSArb.get("CONFIRM_IMPORT_TEMPLATES_TITLE"), null)) {
                    return;
                }
                try {
                    URL url = chooser.getSelectedURL();
                    this.importFrom(url);
                    this._lastImportExportURL = URLFileSystem.getParent((URL)url);
                }
                catch (IOException ioe) {
                    ExceptionDialog.showExceptionDialog((Component)this, (Throwable)ioe);
                }
            }
        }

        private URL getUserHomeDirectory() {
            URL url = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
            return URLFileSystem.exists((URL)url) ? url : null;
        }

        private void importFrom(URL url) throws IOException {
            if (url == null || !URLFileSystem.exists((URL)url)) {
                return;
            }
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setLogger(0, new Object2DomLogger(){

                public void logXMLParseException(XMLParseException e) {
                }

                public void logSAXParseException(SAXParseException e) {
                }

                public void logUnmarshalException(int line, int col, Throwable t) {
                }

                public void logOtherException(Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                }

                public void logMessage(String mesg) {
                }

                public void logXMLDocument(XMLDocument document) {
                }
            });
            HashStructure properties = (HashStructure)new HashStructureIO(NAMESPACE_URI, ROOT_TAG).load(url);
            int defaultTemplateIndex = properties.getInt("defaultTemplateIndex");
            ListStructure templates = properties.getListStructure("templates");
            this.setTemplates(templates != null ? (String[])templates.toArray((Object[])new String[0]) : new String[]{});
            this.setDefaultTemplateIndex(Math.max(-1, Math.min(this._templatesList.getModel().getSize() - 1, defaultTemplateIndex)));
        }

        private void exportTemplates() {
            ExportURLChooser chooser = new ExportURLChooser();
            DialogUtil.initURLChooser((URLChooser)chooser, null);
            if (this._lastImportExportURL != null) {
                chooser.setSelectedURL(this._lastImportExportURL);
            } else {
                URL url = this.getUserHomeDirectory();
                if (url != null) {
                    chooser.setSelectedURL(url);
                }
            }
            chooser.clearChooseableURLFilters();
            DefaultURLFilter filter = new DefaultURLFilter(VCSArb.get("TEMPLATES_FILTER_NAME"), ".xml");
            chooser.addChooseableURLFilter((URLFilter)filter);
            chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            chooser.setURLFilter((URLFilter)filter);
            int result = chooser.showSaveDialog(this, VCSArb.get("EXPORT_TEMPLATES_TITLE"));
            if (result == 0) {
                URL url = chooser.getSelectedURL();
                if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                    url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
                }
                try {
                    this.exportTo(url);
                    this._lastImportExportURL = URLFileSystem.getParent((URL)url);
                }
                catch (Exception e) {
                    String message = VCSArb.format("EXPORT_ERROR_MESSAGE", URLFileSystem.getPlatformPathName((URL)url), e.toString());
                    String title = VCSArb.get("EXPORT_ERROR_TITLE");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
                }
            }
        }

        private void exportTo(URL url) throws IOException {
            if (url == null) {
                return;
            }
            HashStructure properties = HashStructure.newInstance();
            ListStructure templates = ListStructure.newInstance();
            templates.addAll(Arrays.asList(this.getTemplates()));
            properties.putInt("defaultTemplateIndex", this.getDefaultTemplateIndex());
            properties.putListStructure("templates", templates);
            new HashStructureIO(NAMESPACE_URI, ROOT_TAG).save(url, (Object)properties);
        }

        private class ExportURLChooser
        extends URLChooser {
            public boolean approveSelection() {
                return super.approveSelection() && this.checkExistingFile() && this.checkReadOnlyFile();
            }

            private boolean checkExistingFile() {
                URL url = this.getSelectedURL();
                if (URLFileSystem.exists((URL)url)) {
                    String message = VCSArb.format("EXPORT_OVERWRITE_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)url));
                    String title = VCSArb.get("EXPORT_OVERWRITE_WARNING_TITLE");
                    int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, title, 2);
                    return result == 0;
                }
                return true;
            }

            private boolean checkReadOnlyFile() {
                URL url = this.getSelectedURL();
                if (URLFileSystem.isReadOnly((URL)url)) {
                    String message = VCSArb.format("EXPORT_READ_ONLY_MESSAGE", URLFileSystem.getPlatformPathName((URL)url));
                    String title = VCSArb.get("EXPORT_ERROR_TITLE");
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
                    return false;
                }
                return true;
            }
        }
    }
}

