/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changeset.ChangeSetManager;
import oracle.jdeveloper.vcs.spi.VCSCommentTemplatesPrefs;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;

public class VCSCommentsCustomizer
implements VCSOptionsCustomizer {
    @Deprecated
    protected static final String KEY_PROPERTY_TEMPLATES = "templates";
    @Deprecated
    protected static final String KEY_PROPERTY_DEFAULT_TEMPLATE_INDEX = "defaultTemplateIndex";
    public static final String KEY_SETTING_COMMENTS = "setting_comments";
    public static final String KEY_SETTING_REUSE_COMMENTS = "setting_reuse_comments";
    public static final String COMMENT_TEMPLATES_NAVIGABLE_LABEL = VCSArb.get("VERSIONING_COMMENT_TEMPLATES_NAVIGABLE");
    private final String _extensionId;
    private final VCSOptionsCustomizer _delegateCustomizer;
    private JPanel _panel;
    private VCSCommentsCustomizerUI _commentsUI;
    private boolean _showReuseCommentsOption;
    private VCSRecentCommentsModel _commentsModel;
    private int _defaultRows = 3;
    private boolean _flatLook;
    private boolean _showTemplatesAndCommentsCombo;
    private int _templatesAndCommentsOrientation = 5;
    private String _systemTemplate;
    private String[] _templatesSettingsPath;
    private URL[] _contextUrls;
    private boolean _suppressDefaultTemplate;
    private boolean _templateOnly = false;

    public VCSCommentsCustomizer(String extensionId) {
        this(extensionId, null);
    }

    public VCSCommentsCustomizer(String extensionId, VCSOptionsCustomizer delegateCustomizer) {
        this._extensionId = extensionId;
        this._delegateCustomizer = delegateCustomizer;
    }

    protected String getExtensionID() {
        return this._extensionId;
    }

    public void setShowReuseCommentsOption(boolean showReuseCommentsOption) {
        this._showReuseCommentsOption = showReuseCommentsOption;
    }

    public void setRecentCommentsModel(VCSRecentCommentsModel commentsModel) {
        this._commentsModel = commentsModel;
    }

    public VCSRecentCommentsModel getRecentCommentsModel() {
        return this._commentsModel;
    }

    public void setShowTemplatesAndCommentsCombo(boolean showTemplatesAndCommentsCombo) {
        this._showTemplatesAndCommentsCombo = showTemplatesAndCommentsCombo;
    }

    public boolean isShowTemplatesAndCommentsCombo() {
        return this._showTemplatesAndCommentsCombo;
    }

    public void setTemplatesAndCommentsOrientation(int templatesAndCommentsOrientation) {
        if (templatesAndCommentsOrientation != 5 && templatesAndCommentsOrientation != 2) {
            throw new IllegalArgumentException("Orientation must be SwingConstants.SOUTH or SwingConstants.NORTH_EAST");
        }
        this._templatesAndCommentsOrientation = templatesAndCommentsOrientation;
    }

    public void setSystemTemplate(String systemTemplate) {
        this._systemTemplate = systemTemplate;
    }

    public void setTemplatesSettingsPath(String[] templatesSettingsPath) {
        this._templatesSettingsPath = templatesSettingsPath;
    }

    @Deprecated
    public void setSuppressContextMenu(boolean suppressContextMenu) {
    }

    public void setDefaultVisibleRows(int rows) {
        this._defaultRows = rows;
    }

    @Deprecated
    public void setVisiblePopupRows(int popupRows) {
    }

    public void setFlatLook(boolean isFlat) {
        this._flatLook = isFlat;
    }

    public final void setContextURLs(URL[] contextUrls) {
        this._contextUrls = contextUrls;
    }

    public final void setSuppressDefaultTemplate(boolean suppressDefaultTemplate) {
        this._suppressDefaultTemplate = suppressDefaultTemplate;
    }

    public final void setTemplateOnly(boolean template) {
        this._templateOnly = template;
    }

    @Override
    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._commentsUI = new VCSCommentsCustomizerUI();
            this._commentsUI.initializeDefaultTemplate();
            this.initializeUI();
            this.layoutContainer(this._panel, this._commentsUI, this._delegateCustomizer != null ? this._delegateCustomizer.getComponent() : null);
        }
        return this._panel;
    }

    @Override
    public Component getInitialFocusComponent() {
        Component delegateFocusComponent = null;
        if (this._delegateCustomizer != null && this._delegateCustomizer.getInitialFocusComponent() != null) {
            delegateFocusComponent = this._delegateCustomizer.getInitialFocusComponent();
        }
        if (delegateFocusComponent == null) {
            this.getComponent();
            return this._commentsUI.getCommentsArea();
        }
        return delegateFocusComponent;
    }

    @Override
    public void setOptions(Map<?, ?> options) {
        Boolean b;
        this.getComponent();
        String s = (String)options.get(KEY_SETTING_COMMENTS);
        if (s != null) {
            this._commentsUI.getCommentsArea().setText(s);
        }
        if (this._showReuseCommentsOption && (b = (Boolean)options.get(KEY_SETTING_REUSE_COMMENTS)) != null) {
            this._commentsUI.getReuseCommentsCheckBox().setSelected(b);
        }
        this.updateStateForReuseComments();
        if (this._delegateCustomizer != null) {
            this._delegateCustomizer.setOptions(options);
        }
    }

    @Override
    public Map<?, ?> getOptions() {
        this.getComponent();
        HashMap<String, Object> m = new HashMap<String, Object>();
        boolean reuseComments = this._commentsUI.getReuseCommentsCheckBox().isSelected();
        if (!reuseComments) {
            m.put(KEY_SETTING_COMMENTS, this._commentsUI.getCommentsArea().getText());
        }
        if (this._showReuseCommentsOption) {
            m.put(KEY_SETTING_REUSE_COMMENTS, reuseComments);
        }
        if (this._delegateCustomizer != null) {
            m.putAll(this._delegateCustomizer.getOptions());
        }
        return m;
    }

    @Override
    public void validateOptions() throws VCSException {
        String comment;
        if (this._delegateCustomizer != null) {
            this._delegateCustomizer.validateOptions();
        }
        if (this._commentsModel != null && !this._commentsUI.getReuseCommentsCheckBox().isSelected() && !(comment = this._commentsUI.getCommentsArea().getText()).equals("")) {
            this._commentsModel.addComment(comment);
        }
    }

    public void setCommentsComponentsEnabled(boolean enabled) {
        this._commentsUI.getCommentsLabel().setEnabled(enabled);
        this._commentsUI.getCommentsArea().setEnabled(enabled);
        this._commentsUI.getCommentsArea().setOpaque(enabled);
        if (this._commentsUI.getRecentCommentsCombo() != null) {
            this._commentsUI.getRecentCommentsCombo().setEnabled(enabled);
        }
    }

    protected final void updateTemplatesAndComments() {
        this.getComponent();
        this._commentsUI.updateTemplatesAndComments();
    }

    protected void layoutContainer(Container container, Component commentsUI, Component delegateUI) {
        container.setLayout(new BorderLayout());
        JPanel container2 = null;
        if (this._delegateCustomizer != null) {
            container2 = new JPanel(new BorderLayout());
            container2.add(delegateUI, "Center");
            container2.add(Box.createVerticalStrut(5), "South");
        }
        if (container2 != null) {
            container.add(container2, "North");
        }
        container.add(commentsUI, "Center");
    }

    protected JTextComponent getTextComponent() {
        this.getComponent();
        return this._commentsUI.getCommentsArea();
    }

    private void initializeUI() {
        if (this._commentsUI == null) {
            return;
        }
        this._commentsUI.getReuseCommentsCheckBox().setVisible(this._showReuseCommentsOption);
        if (this._flatLook) {
            this._commentsUI._commentsScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("controlShadow")));
        }
        this._commentsUI.getCommentsArea().setRows(this._defaultRows);
        this._commentsUI.getCommentsArea().setColumns(80);
        if (!this._showReuseCommentsOption) {
            return;
        }
        this._commentsUI.getReuseCommentsCheckBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                VCSCommentsCustomizer.this.updateStateForReuseComments();
            }
        });
        this.updateStateForReuseComments();
    }

    private void updateStateForReuseComments() {
        if (this._commentsUI == null) {
            return;
        }
        this.setCommentsComponentsEnabled(!this._commentsUI.getReuseCommentsCheckBox().isSelected());
    }

    protected final boolean isCommentTextChanged() {
        String[] templatesValue = this.getTemplatesFromSettings();
        String text = this.getTextComponent().getText();
        return !(text.equals("") || templatesValue != null && Arrays.asList(templatesValue).contains(text) || this.getRecentCommentsModel() != null && Arrays.asList(this.getRecentCommentsModel().toArray()).contains(text));
    }

    private final String[] getTemplatesFromSettings() {
        if (this._extensionId == null) {
            return null;
        }
        VCSCommentTemplatesPrefs prefs = VCSCommentTemplatesPrefs.getInstance((PropertyStorage)Preferences.getPreferences(), this._extensionId);
        return (String[])prefs.getTemplates().toArray((Object[])new String[0]);
    }

    static class CommentListCellRenderer
    extends DefaultListCellRenderer {
        CommentListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            text = text.replaceAll("\\n", "\\\\");
            this.setText(text);
            this.setPreferredSize(this.getPreferredSize());
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }

    private class VCSCommentsCustomizerUI
    extends JPanel {
        private final JLabel _commentsLabel;
        private final CompletionTextArea _commentsArea;
        private final JCheckBox _reuseCommentsCheckBox;
        private final JScrollPane _commentsScrollPane;
        private JLabel _templateOrPreviousCommentLabel;
        private JComboBox _recentCommentsCombo;
        private String[] _templates;
        private Object[] _comments;
        private int _defaultTemplateIndex;

        VCSCommentsCustomizerUI() {
            super(VCSCommentsCustomizer.this._templatesAndCommentsOrientation != 2 ? new BorderLayout(4, 4) : new BorderLayout(2, 2));
            this._templates = null;
            this._comments = null;
            this.updateTemplatesFromSettings();
            this._comments = VCSCommentsCustomizer.this._commentsModel != null ? VCSCommentsCustomizer.this._commentsModel.toArray() : null;
            JPanel centerPanel = new JPanel(VCSCommentsCustomizer.this._templatesAndCommentsOrientation != 2 ? new BorderLayout(4, 4) : new BorderLayout(2, 2));
            this._commentsLabel = new JLabel();
            this._commentsArea = new CompletionTextArea();
            this._reuseCommentsCheckBox = new JCheckBox();
            this._commentsScrollPane = new JScrollPane((Component)this._commentsArea);
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)this._commentsLabel, "Center");
            centerPanel.add((Component)northPanel, "North");
            centerPanel.add((Component)this._commentsScrollPane, "Center");
            this._commentsScrollPane.setPreferredSize(new Dimension(0, 20 * VCSCommentsCustomizer.this._defaultRows));
            this.add((Component)centerPanel, "Center");
            this.add((Component)this._reuseCommentsCheckBox, "North");
            this._commentsArea.setLineWrap(true);
            this._commentsArea.setWrapStyleWord(true);
            this._commentsLabel.setLabelFor((Component)this._commentsArea);
            this._commentsLabel.setText(VCSArb.get("COMMENTS_LABEL_TEXT"));
            this._commentsLabel.setDisplayedMnemonic(VCSArb.get("COMMENTS_LABEL_MNEMONIC").charAt(0));
            this._reuseCommentsCheckBox.setText(VCSArb.get("REUSE_COMMENTS_CHECKBOX_TEXT"));
            this._reuseCommentsCheckBox.setMnemonic(VCSArb.get("REUSE_COMMENTS_CHECKBOX_MNEMONIC").charAt(0));
            if (!VCSCommentsCustomizer.this._showTemplatesAndCommentsCombo && VCSCommentsCustomizer.this._templatesSettingsPath == null) {
                return;
            }
            Box templatesAndCommentsPanel = Box.createVerticalBox();
            if (VCSCommentsCustomizer.this._showTemplatesAndCommentsCombo) {
                this._recentCommentsCombo = new JComboBox(this.createCommentsComboBoxModel());
                this._recentCommentsCombo.putClientProperty("VCSCommentsCustomizer.commentsSelectionComponent", Boolean.TRUE);
                this._recentCommentsCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Object o = VCSCommentsCustomizerUI.this._recentCommentsCombo.getSelectedItem();
                        if (o instanceof CommentItem) {
                            if (VCSCommentsCustomizer.this.isCommentTextChanged() && !MessageDialog.optionalConfirm((String)"VCS.OverwriteCommentsConfirm", (Component)VCSCommentsCustomizerUI.this._commentsArea, (Object)VCSArb.get("CONFIRM_OVERWRITE_COMMENTS"), (String)VCSArb.get("CONFIRM_OVERWRITE_COMMENTS_TITLE"), null)) {
                                return;
                            }
                            VCSCommentsCustomizerUI.this._commentsArea.setText(((CommentItem)o).getComment());
                        }
                    }
                });
                this._recentCommentsCombo.setRenderer(new CommentListCellRenderer());
                this._templateOrPreviousCommentLabel = new JLabel();
                if (!VCSCommentsCustomizer.this._templateOnly) {
                    ResourceUtils.resLabel((JLabel)this._templateOrPreviousCommentLabel, (Component)this._recentCommentsCombo, (String)VCSArb.get("TEMPLATE_OR_PREVIOUS_COMMENT"));
                } else {
                    ResourceUtils.resLabel((JLabel)this._templateOrPreviousCommentLabel, (Component)this._recentCommentsCombo, (String)VCSArb.get("TEMPLATE_ONLY"));
                }
                templatesAndCommentsPanel.add(Box.createVerticalStrut(2));
                if (VCSCommentsCustomizer.this._templatesAndCommentsOrientation != 2) {
                    templatesAndCommentsPanel.add(this._templateOrPreviousCommentLabel);
                    templatesAndCommentsPanel.add(Box.createVerticalStrut(4));
                    templatesAndCommentsPanel.add(this._recentCommentsCombo);
                } else {
                    JPanel templatesAndCommentsPanel2 = new JPanel(new BorderLayout(2, 2));
                    templatesAndCommentsPanel2.add((Component)this._templateOrPreviousCommentLabel, "West");
                    templatesAndCommentsPanel2.add((Component)this._recentCommentsCombo, "Center");
                    templatesAndCommentsPanel.add(templatesAndCommentsPanel2);
                    this._recentCommentsCombo.setPrototypeDisplayValue(StringUtils.stripMnemonic((String)VCSArb.get("TEMPLATE_OR_PREVIOUS_COMMENT")));
                }
            }
            if (VCSCommentsCustomizer.this._templatesSettingsPath != null) {
                RichHintLabel button = new RichHintLabel();
                button.setHtmlText(VCSArb.get("COMMENT_TEMPLATES_HYPERLINK_TEXT"));
                button.registerAction("commentTemplatesAction", (Action)new AbstractAction(VCSArb.get("COMMENT_TEMPLATES_HYPERLINK_TEXT")){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Ide.getSettings().showDialog(IdeUtil.getMainWindow(), VCSCommentsCustomizer.this._templatesSettingsPath);
                        final boolean wasEnabled = VCSCommentsCustomizerUI.this._recentCommentsCombo.isEnabled();
                        VCSCommentsCustomizerUI.this._recentCommentsCombo.setEnabled(false);
                        SwingUtils.invokeAfterRepaint((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    VCSCommentsCustomizerUI.this.updateTemplatesAndComments();
                                    if (!VCSCommentsCustomizer.this.isCommentTextChanged()) {
                                        VCSCommentsCustomizerUI.this.initializeDefaultTemplate();
                                    }
                                }
                                finally {
                                    VCSCommentsCustomizerUI.this._recentCommentsCombo.setEnabled(wasEnabled);
                                }
                            }
                        });
                    }
                });
                templatesAndCommentsPanel.add(Box.createVerticalStrut(4));
                templatesAndCommentsPanel.add((Component)button);
            }
            if (VCSCommentsCustomizer.this._templatesAndCommentsOrientation == 2) {
                northPanel.add((Component)templatesAndCommentsPanel, "East");
            } else {
                this.add((Component)templatesAndCommentsPanel, "South");
            }
            this.setAlignmentXRecursively(this);
        }

        private final void setAlignmentXRecursively(Component c) {
            if (c instanceof JComponent) {
                ((JComponent)c).setAlignmentX(0.0f);
                for (Component child : ((JComponent)c).getComponents()) {
                    this.setAlignmentXRecursively(child);
                }
            }
        }

        final void initializeDefaultTemplate() {
            String changeSetComments;
            if (VCSCommentsCustomizer.this._suppressDefaultTemplate) {
                return;
            }
            String string = changeSetComments = VCSCommentsCustomizer.this._contextUrls != null ? ChangeSetManager.getChangeSetManager().getChangeSetComments(VCSCommentsCustomizer.this._contextUrls) : null;
            if (changeSetComments != null) {
                this._commentsArea.setText(changeSetComments);
                return;
            }
            if (VCSCommentsCustomizer.this._systemTemplate != null) {
                this._commentsArea.setText(VCSCommentsCustomizer.this._systemTemplate);
                return;
            }
            if (VCSCommentsCustomizer.this._systemTemplate == null && this._templates != null && this._defaultTemplateIndex >= 0 && this._defaultTemplateIndex < this._templates.length) {
                this._commentsArea.setText(this._templates[this._defaultTemplateIndex]);
                if (this._recentCommentsCombo != null) {
                    this._recentCommentsCombo.setSelectedItem(new CommentItem(this._templates[this._defaultTemplateIndex]));
                }
            }
        }

        final void updateTemplatesAndComments() {
            Object[] oldTemplates = this._templates;
            this.updateTemplatesFromSettings();
            Object[] oldComments = this._comments;
            Object[] objectArray = this._comments = VCSCommentsCustomizer.this._commentsModel != null ? VCSCommentsCustomizer.this._commentsModel.toArray() : null;
            if (this.nullSafeEquals(oldTemplates, this._templates) && this.nullSafeEquals(oldComments, this._comments)) {
                return;
            }
            if (this._recentCommentsCombo != null) {
                this._recentCommentsCombo.setModel(this.createCommentsComboBoxModel());
            }
        }

        private final boolean nullSafeEquals(Object[] oa1, Object[] oa2) {
            if (oa1 == null && oa2 == null) {
                return true;
            }
            return oa1 != null && oa2 != null && Arrays.equals(oa1, oa2);
        }

        private void updateTemplatesFromSettings() {
            if (!VCSCommentsCustomizer.this._showTemplatesAndCommentsCombo) {
                this._templates = null;
                this._defaultTemplateIndex = -1;
                return;
            }
            ArrayList<String> templates = new ArrayList<String>();
            if (VCSCommentsCustomizer.this._systemTemplate != null) {
                templates.add(VCSCommentsCustomizer.this._systemTemplate);
            }
            String[] templatesValue = null;
            Integer defaultTemplateIndex = null;
            if (VCSCommentsCustomizer.this._extensionId != null) {
                VCSCommentTemplatesPrefs prefs = VCSCommentTemplatesPrefs.getInstance((PropertyStorage)Preferences.getPreferences(), VCSCommentsCustomizer.this._extensionId);
                templatesValue = (String[])prefs.getTemplates().toArray((Object[])new String[0]);
                defaultTemplateIndex = prefs.getDefaultTemplateIndex();
            }
            if (templatesValue != null) {
                templates.addAll(Arrays.asList(templatesValue));
            }
            this._templates = templates.isEmpty() ? null : templates.toArray(new String[0]);
            this._defaultTemplateIndex = defaultTemplateIndex != null ? defaultTemplateIndex : -1;
        }

        private ComboBoxModel createCommentsComboBoxModel() {
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
            model.addElement(VCSArb.get("CHOOSE_PREVIOUS_COMMENT"));
            if (this._templates != null) {
                for (String template : this._templates) {
                    model.addElement(new TemplateCommentItem(template));
                }
            }
            if (this._comments != null) {
                for (Object comment : this._comments) {
                    model.addElement(new CommentItem(comment.toString()));
                }
            }
            return model;
        }

        public JLabel getCommentsLabel() {
            return this._commentsLabel;
        }

        public CompletionTextArea getCommentsArea() {
            return this._commentsArea;
        }

        public JCheckBox getReuseCommentsCheckBox() {
            return this._reuseCommentsCheckBox;
        }

        public JComboBox getRecentCommentsCombo() {
            return this._recentCommentsCombo;
        }

        private class TemplateCommentItem
        extends CommentItem {
            TemplateCommentItem(String comment) {
                super(comment);
            }

            @Override
            public String toString() {
                return this.getComment();
            }
        }

        private class CommentItem {
            private final String _comment;

            CommentItem(String comment) {
                this._comment = comment;
            }

            String getComment() {
                return this._comment;
            }

            public String toString() {
                return this._comment;
            }

            public boolean equals(Object o) {
                return o instanceof CommentItem && this._comment.equals(((CommentItem)o)._comment);
            }

            public int hashCode() {
                return this._comment.hashCode();
            }
        }
    }
}

