/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;

public abstract class VCSDirectoryInvokable {
    public static final int DEFAULT_MILLIS_TO_DECIDE_TO_POPUP = 500;
    public static final int DEFAULT_MILLIS_TO_POPUP = 2000;
    private static final int PROGRESS_MAX = 100;
    private final VCSInvokableState _state;
    private DeterminateProgressMonitor _monitor;
    private int _progress;
    private boolean _ignoreSubdirs;

    public VCSDirectoryInvokable(VCSInvokableState state, int maxArguments) {
        this(state, maxArguments, false);
    }

    public VCSDirectoryInvokable(VCSInvokableState state, int maxArguments, boolean ignoreSubdirs) {
        this._state = state;
        this._state.initialize(maxArguments);
        this._ignoreSubdirs = ignoreSubdirs;
    }

    public VCSInvokableState getState() {
        return this._state;
    }

    public void setProgressMonitor(DeterminateProgressMonitor monitor) {
        this._monitor = monitor;
        if (this._monitor != null) {
            this.initializeProgressMonitor(this._monitor);
        }
    }

    public DeterminateProgressMonitor getProgressMonitor() {
        return this._monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInvokable() throws Exception {
        try {
            this._progress = 0;
            if (this._state.getN() <= 0) {
                boolean bl = true;
                return bl;
            }
            if (this._monitor != null) {
                this._monitor.setMaximum(100);
            }
            boolean bl = this.runInvokableImpl();
            return bl;
        }
        finally {
            if (this._monitor != null) {
                this._monitor.close();
            }
        }
    }

    protected void initializeProgressMonitor(DeterminateProgressMonitor monitor) {
        monitor.setMillisToDecideToPopup(500);
        monitor.setMillisToPopup(2000);
    }

    protected abstract boolean doInvocation(URL var1, URL[] var2) throws Exception;

    private boolean runInvokableImpl() throws Exception {
        URL[] batchUrls;
        while ((batchUrls = this._state.nextURLs()) != null) {
            URL parent;
            if (this._monitor != null && this._monitor.isCanceled()) {
                return false;
            }
            this._progress += batchUrls.length;
            URL uRL = parent = batchUrls.length > 0 ? URLFileSystem.getParent((URL)batchUrls[0]) : null;
            if (parent != null) {
                if (this._monitor != null) {
                    this._monitor.setProgress(Math.min(99, (int)((double)this._progress / (double)this._state.getN() * 100.0)));
                    String note = this._state.getProgressNote(parent);
                    this._monitor.getPanel().setNote(note);
                }
                this._state.notifyProcessed(batchUrls);
                URL[] invocationArgs = batchUrls;
                if (this._ignoreSubdirs) {
                    ArrayList<URL> c = new ArrayList<URL>(batchUrls.length * 2);
                    c.addAll(Arrays.asList(batchUrls));
                    for (int i = 0; i < batchUrls.length; ++i) {
                        if (!URLFileSystem.isDirectoryPath((URL)batchUrls[i])) continue;
                        c.remove(batchUrls[i]);
                    }
                    invocationArgs = c.toArray(new URL[c.size()]);
                }
                if (batchUrls.length > 0 && !this.doInvocation(parent, invocationArgs)) {
                    return false;
                }
            }
            this._state.notifyCompleted(batchUrls);
        }
        return true;
    }
}

