/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public class VCSExceptionHandler {
    public final void handleException(Exception e) {
        this.handleException(e, null);
    }

    public final void handleException(final Exception e, final Component parent) {
        if (!Ide.getIdeArgs().getCreateUI()) {
            this.handleExceptionImpl(e, null);
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.handleExceptionImpl(e, parent != null ? parent : VCSWindowUtils.getCurrentWindow());
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public final void run() {
                    VCSExceptionHandler.this.handleException(e, parent);
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
        }
    }

    protected void handleExceptionImpl(Exception e, Component parent) {
        if (e instanceof ChangeVetoException) {
            return;
        }
        if (!Ide.getIdeArgs().getCreateUI()) {
            e.printStackTrace();
            return;
        }
        if (e instanceof VCSException) {
            this.handleVCSException((VCSException)e, parent);
            return;
        }
        if (FeedbackManager.isOn()) {
            FeedbackManager.reportException((Throwable)e);
            return;
        }
        ExceptionDialog.showExceptionDialog((Component)parent, (Throwable)e, (String)IdeUtil.getProgramName(), (String)e.getMessage(), null);
    }

    protected final void handleVCSException(VCSException ce, Component parent) {
        String detail;
        if (ce instanceof VCSCancelException) {
            return;
        }
        String title = ce.getTitle();
        if (title == null) {
            title = IdeUtil.getProgramName();
        }
        String string = detail = ce instanceof VCSDetailException ? ((VCSDetailException)ce).getDetail() : null;
        if (detail != null && !detail.equals("")) {
            DetailDialog detailDialog = VCSComponents.createDetailDialog(parent, title, (Object)ce.getMessage(), detail, null);
            detailDialog.setResizable(true);
            detailDialog.setDetailVisible(true);
            detailDialog.runDialog();
            return;
        }
        MessageDialog.error((Component)parent, (Object)ce.getMessage(), (String)title, null);
    }
}

