/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.icons.OracleIcons;

public abstract class VCSExplorer
extends Explorer
implements Observer {
    private JScrollPane _scrollPane;
    private JTree _tree;
    private Node _node;
    private boolean _observing;

    public Component getGUI() {
        if (this._tree == null) {
            this._tree = new JTree();
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new ExplorerCellRenderer());
            ToolTipManager.sharedInstance().registerComponent(this._tree);
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void setContext(Context context) {
        Node n = context.getNode();
        if (n != null) {
            this._node = n;
            this._tree = null;
        }
    }

    public Context getContext(EventObject eventObject) {
        return this._node != null ? Context.newIdeContext((Node)this._node) : Context.newIdeContext();
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                this.loadTree();
                this.beginObservation();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.endObservation();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int id;
        if (this._observing && this._node != null && object == this._node && ((id = updateMessage.getMessageID()) == UpdateMessage.STRUCTURE_CHANGED || id == UpdateMessage.OBJECT_RELOADED)) {
            this.loadTree();
        }
    }

    protected abstract DefaultMutableTreeNode createTreeNodes();

    protected Icon getExplorerIcon() {
        return OracleIcons.getIcon((String)"field.png");
    }

    protected void setNode(Node node) {
        this._node = node;
    }

    protected Node getNode() {
        return this._node;
    }

    protected void clearTree() {
        this._tree = null;
    }

    private void beginObservation() {
        if (!this._observing && this._node != null) {
            this._node.attach((Observer)this);
            this._observing = true;
        }
    }

    private void endObservation() {
        if (this._observing && this._node != null) {
            this._node.detach((Observer)this);
            this._observing = false;
        }
    }

    private void loadTree() {
        if (this._tree == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.setRoot(this.createTreeNodes());
        model.reload();
        for (int i = 0; i < this._tree.getRowCount(); ++i) {
            this._tree.expandRow(i);
        }
    }

    private final class ExplorerCellRenderer
    extends DefaultTreeCellRenderer {
        private ExplorerCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                this.setIcon(VCSExplorer.this.getExplorerIcon());
            }
            return this;
        }
    }
}

