/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusConstants;

public abstract class VCSExtension
implements VCS,
ShutdownHook {
    private VCSExceptionHandler _exceptionHandler;
    private String _id;

    protected VCSExtension(String id) {
        this._id = id;
    }

    public final String getId() {
        return this._id;
    }

    public abstract boolean isControlled(URL var1);

    public int getControlPrecedence() {
        return 2;
    }

    public final VCSStatus[] getStatus(URL[] urls) throws Exception {
        StatusCacheBridge<VCSStatus> statusCache = this.getStatusCacheBridge();
        if (statusCache != null) {
            return statusCache.get(urls);
        }
        Object[] statuses = new VCSStatus[urls.length];
        Arrays.fill(statuses, VCSStatusConstants.STATUS_UNRECOGNIZED);
        return statuses;
    }

    public VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    @Deprecated
    public VCSStatusCache getStatusCache() {
        return null;
    }

    public StatusCache<VCSStatus> getPolicyStatusCache() {
        return null;
    }

    public StatusCacheBridge<VCSStatus> getStatusCacheBridge() {
        StatusCache<VCSStatus> cache = this.getPolicyStatusCache();
        return cache != null ? cache : this.getStatusCache();
    }

    public URLFilter getURLFilter() {
        return null;
    }

    public VCSExtensionInformation getInformation() {
        String className = this.getClass().getName();
        int i = className.lastIndexOf(46);
        if (i >= 0 && i < className.length() - 1) {
            className = className.substring(i + 1);
        }
        return new VCSExtensionInformation(className);
    }

    public VCSHistoryProvider getHistoryProvider() {
        return null;
    }

    public boolean canCheckOut(URL url) throws Exception {
        return URLFileSystem.isReadOnly((URL)url) && VCSManager.getVCSManager().isVersioned(url);
    }

    @Deprecated
    public boolean setReadWrite(URL url) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean setReadWrite(URL[] urls) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean setReadWrite(URL[] urls, VCSProgress progress) throws Exception {
        try {
            return this.setReadWrite(urls);
        }
        catch (UnsupportedOperationException uoe) {
            try {
                for (URL url : urls) {
                    if (progress.isCancelled()) {
                        return false;
                    }
                    if (!this.setReadWrite(url)) {
                        return false;
                    }
                    progress.incrementProgress();
                }
                return true;
            }
            catch (UnsupportedOperationException uoe2) {
                for (URL url : urls) {
                    if (!URLFileSystem.isReadOnly((URL)url)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public String getCheckOutCommand() {
        return null;
    }

    public String getVersionName(URL url) {
        return null;
    }

    public boolean isConflictsStatus(VCSStatus status) {
        return false;
    }

    public boolean isConflictsStatus(URL url) {
        try {
            VCSStatus status = this.getStatus(new URL[]{url})[0];
            return status != null && this.isConflictsStatus(status);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        try {
            this.initializeEx();
        }
        finally {
            VCSRegistry.register((VCS)this);
        }
    }

    public final void initializeEx() {
        ExitCommand.addShutdownHook((ShutdownHook)this);
        this.initializeImpl();
    }

    protected abstract void initializeImpl();

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

