/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.vcscore.FileContentProvider;
import oracle.ideimpl.vcscore.FileContentProviderRegistry;
import oracle.jdeveloper.vcs.spi.VCSFile;
import oracle.jdeveloper.vcs.spi.VCSModifiedFile;
import oracle.jdeveloper.vcs.spi.VCSRevision;

public abstract class VCSFileContentProvider
extends FileContentProvider {
    public abstract String getRevision(URL var1) throws Exception;

    public abstract Collection<VCSRevision> getRevisions(Map<String, String> var1, String var2, int var3) throws Exception;

    public abstract Collection<VCSFile> getFiles(Map<String, String> var1, String var2, String var3) throws Exception;

    public abstract Collection<VCSModifiedFile> getModifiedFiles(Context var1, Map<String, String> var2) throws Exception;

    public static final VCSFileContentProvider lookupProvider(String vcsId) {
        FileContentProvider provider = FileContentProviderRegistry.getInstance().lookupProvider(vcsId);
        return provider instanceof VCSFileContentProvider ? (VCSFileContentProvider)provider : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getContent(InputStream is) throws IOException {
        BufferedInputStream reader = null;
        ByteArrayOutputStream into = new ByteArrayOutputStream();
        try {
            int r;
            reader = new BufferedInputStream(is);
            byte[] buf = new byte[1024];
            while ((r = reader.read(buf)) > -1) {
                into.write(buf, 0, r);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException io) {}
            }
            into.close();
        }
        return into;
    }
}

