/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.BaseHistoryEntry;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.resource.HistoryArb;

public abstract class VCSHistoryEntry
extends BaseHistoryEntry {
    public boolean canRestore(Context context) {
        try {
            Node node = context.getNode();
            if (CompositeFileElementRegistry.isCompositeElement((Element)node)) {
                HistoryProvider provider = this.getProvider(node);
                return provider.getRestoreFromRevision() != null;
            }
            return super.canRestore(context);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void restore(Context context) throws Exception {
        if (this.canRestore(context)) {
            final Node node = context.getNode();
            URL[] urls = CompositeFileElementRegistry.getCompositeFileURLs((Element)node);
            if (urls.length > 1) {
                final WaitCursor cursor = new WaitCursor((Component)Ide.getMainWindow());
                cursor.show(0L);
                SwingWorker worker = new SwingWorker(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Object doInBackground() throws Exception {
                        try {
                            VCSHistoryEntry.this.restoreComposite(node);
                            Object var1_1 = null;
                            return var1_1;
                        }
                        finally {
                            cursor.hide();
                        }
                    }
                };
                worker.execute();
            } else {
                super.restore(context);
            }
        }
    }

    private void restoreComposite(Node node) throws Exception {
        HistoryProvider provider = this.getProvider(node);
        RestoreFromRevisionClass helper = provider.getRestoreFromRevision();
        if (helper != null) {
            URL[] urls = CompositeFileElementRegistry.getCompositeFileURLs((Element)node);
            urls = this.sort(urls, node.getURL());
            Object rev = this.getValue(SharedProperties.getRevisionProperty());
            if (rev instanceof RevisionIdentifier) {
                final Map<Node, Long> timestamp = this.getTimeStamp(urls);
                if (!helper.canRestore(urls, ((RevisionIdentifier)rev).getLabel(), (HistoryEntry)this)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)Bundle.format("RESTORE_FILE_ERROR", node.getURL().getPath()), (String)Bundle.get("RESTORE_FILE_TITLE"), null);
                    return;
                }
                if (node.isReadOnly() && !URLFileSystem.setReadOnly((URL)node.getURL(), (boolean)false)) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)HistoryArb.format((String)"RESTORE_READ_ONLY", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)node.getURL())}), (String)HistoryArb.get((String)"RESTORE_READ_ONLY_TITLE"), null);
                }
                helper.restore(urls, ((RevisionIdentifier)rev).getLabel(), (HistoryEntry)this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VCSBufferUtils.reloadBuffers(timestamp);
                    }
                });
            }
        }
    }

    private HistoryProvider getProvider(Node node) {
        Collection providers = HistoryManager.getHistoryManager().getProviders();
        for (HistoryProvider provider : providers) {
            if (!provider.isProviderFor(node.getURL())) continue;
            return provider;
        }
        return null;
    }

    private Map<Node, Long> getTimeStamp(URL[] urls) {
        HashMap<Node, Long> timestampMap = new HashMap<Node, Long>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int u = 0; u < urls.length; ++u) {
            Node node = NodeFactory.find((URL)urls[u]);
            if (node == null) continue;
            nodes.add(node);
        }
        NodeUtil.storeTimestamps(timestampMap, nodes, (oracle.ide.model.NodeFilter)new NodeFilter());
        return timestampMap;
    }

    private URL[] sort(URL[] urls, final URL last) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (URL url : urls) {
            urlList.add(url);
        }
        Collections.sort(urlList, new Comparator(){

            public int compare(Object o1, Object o2) {
                URL u1 = (URL)o1;
                URL u2 = (URL)o2;
                if (u1.getPath().equals(last.getPath())) {
                    return 1;
                }
                if (u2.getPath().equals(last.getPath())) {
                    return -1;
                }
                return u1.getPath().compareTo(u2.getPath());
            }
        });
        return urlList.toArray(new URL[0]);
    }

    private static class NodeFilter
    implements oracle.ide.model.NodeFilter {
        private NodeFilter() {
        }

        public boolean accept(Node node) {
            return true;
        }
    }
}

