/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.controls.ThrobberLabel;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationTreePanel;
import oracle.jdevimpl.vcs.util.PopupMenuListener;

public abstract class VCSTreeDockableWindow
extends DockableWindow {
    private static final String GUI_PROGRESS = "Progress";
    private static final String GUI_MESSAGE = "Message";
    private static final String GUI_RESULTS = "Results";
    private final Controller _controller = this.createController();
    private boolean _initialized;
    private JPanel _gui;
    private JPanel _center;
    private Toolbar _toolbar;
    private ContextMenu _contextMenu;
    private boolean _busy;
    private CardLayout _layout;
    private ThrobberLabel _progress;
    private FocusableLabel _message;
    private VersionOperationTreePanel _vop;
    private ContextMenuListener _contextMenuListener;

    protected abstract Controller createController();

    protected abstract void createLocalActions();

    protected abstract void refresh();

    protected abstract String getThobberLabel();

    protected abstract Toolbar getToolbarImpl();

    protected abstract ContextMenuListener getContextMenuListener();

    protected abstract void registerMenuItems(ContextMenu var1);

    protected abstract Node findOrCreateNode(ChangeListItem var1, Project var2) throws IllegalAccessException, InstantiationException;

    public VCSTreeDockableWindow(String viewId) {
        super(viewId);
        this.createLocalActions();
        this.setType(96);
    }

    public final void dockableShown(DockableEvent event) {
        super.dockableShown(event);
        if (this.isBusy()) {
            return;
        }
        this.initialize();
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public final Controller getController() {
        return this._controller;
    }

    protected Element[] getSelectionFromUI() {
        return this._vop.isShowing() ? this._vop.getSelection() : new Element[]{};
    }

    protected final VersionOperationTreePanel getTreePanel() {
        if (this._vop == null) {
            this._vop = new VersionOperationTreePanel();
        }
        return this._vop;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._layout = new CardLayout();
            this._center = new JPanel(this._layout);
            this._progress = new ThrobberLabel(this.getThobberLabel());
            this._message = new FocusableLabel();
            this.getTreePanel().setSelectOnRightClick(true);
            this.getTreePanel().setBorderLook(1);
            this._center.add((Component)this._progress, GUI_PROGRESS);
            this._center.add((Component)this._message, GUI_MESSAGE);
            this._center.add((Component)this.getTreePanel(), GUI_RESULTS);
            this._gui.add((Component)this.getToolbar(), "North");
            this._gui.add((Component)this._center, "Center");
            this.getTreePanel().addMouseListener(new PopupMenuListener((View)this));
        }
        return this._gui;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = this.getToolbarImpl();
        }
        return this._toolbar;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu(new MnemonicSolver());
            this.registerMenuItems(this._contextMenu);
            this._contextMenu.addContextMenuListener(this.getContextMenuListener());
        }
        return this._contextMenu;
    }

    public final Context getContext(EventObject eo) {
        Context context = super.getContext(eo);
        Element[] selection = this.getSelectionFromUI();
        Project[] projects = new Project[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            if (!(selection[i] instanceof ChangeListItem)) continue;
            ChangeListItem changeListItem = (ChangeListItem)selection[i];
            projects[i] = changeListItem.getProject();
            try {
                Node n = this.findOrCreateNode(changeListItem, context.getProject());
                if (n != null) {
                    selection[i] = n;
                }
                if (projects[i] != null || !(n instanceof Project)) continue;
                projects[i] = (Project)n;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        context.setSelection(selection);
        if (selection.length == 1) {
            context.setNode(selection[0] instanceof Node ? (Node)selection[0] : null);
            Project project = projects[0] != null ? projects[0] : context.getProject();
            context.setProject(project);
            context.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context.getWorkspace());
        } else {
            ArrayList<Context> contexts = new ArrayList<Context>();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] == null) continue;
                Context context2 = new Context(context);
                context2.setNode(selection[i] instanceof Node ? (Node)selection[i] : null);
                context2.setSelection(new Element[]{selection[i]});
                Project project = projects[i] != null ? projects[i] : context2.getProject();
                context2.setProject(project);
                context2.setWorkspace(project != null ? this.findWorkspaceForProject(project) : context2.getWorkspace());
                contexts.add(context2);
            }
            context.setProperty("ChangeListWindow.CONTEXTS", (Object)contexts.toArray(new Context[0]));
        }
        return context;
    }

    private Workspace findWorkspaceForProject(Project project) {
        for (Workspace workspace : VCSModelUtils.findCachedWorkspaces()) {
            if (!workspace.isOpen() || !workspace.projects().contains(project)) continue;
            return workspace;
        }
        return null;
    }

    private final void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                VCSTreeDockableWindow.this.refresh();
            }
        });
    }

    protected final boolean isBusy() {
        return this._busy;
    }

    protected final void showProgress() {
        this._busy = true;
        this._layout.show(this._center, GUI_PROGRESS);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._progress.requestFocusInWindow();
        }
    }

    protected final void showMessage(String message) {
        this._busy = false;
        this._message.setText(message);
        this._layout.show(this._center, GUI_MESSAGE);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._message.requestFocusInWindow();
        }
    }

    protected final void showResults() {
        this._busy = false;
        this._layout.show(this._center, GUI_RESULTS);
        this._center.invalidate();
        this.updateVisibleActions();
        if (this.isWindowActive()) {
            this._vop.requestFocusInWindow();
        }
    }

    private final boolean isWindowActive() {
        return (DockStation.getDockStation().getDockableStatus((Dockable)this) & 0x10) > 0;
    }
}

