/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.FSMWizard;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.util.CheckboxProperty;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;
import oracle.jdevimpl.vcs.vop.ClientVersionOperationModel;

public final class VCSComponents {
    private VCSComponents() {
    }

    public static WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        WizardDialog wd;
        Dialog dlg = DialogUtil.getAncestorDialog((Component)parent);
        if (dlg != null) {
            wd = wizard.getDialog(dlg);
        } else {
            Frame f = DialogUtil.getAncestorFrame((Component)parent);
            wd = wizard.getDialog(f);
        }
        return wd;
    }

    public static final CheckBoxListModel createCheckBoxListModel(Object[] userObjects, boolean checkedList) {
        return VersioningCoreUtil.createCheckBoxListModel((Object[])userObjects, (boolean)checkedList);
    }

    public static final MutableVersionOperationModel createFileListerModel(Collection<?> nodes, DisplayProperty[] extraProperties) {
        ClientDisplayProperty locationProperty = new ClientDisplayProperty(VCSArb.get("VOP_LOCATION"), null, 2, "C:\\some\\example\\path\\that\\is\\reasonably\\long", null, String.class, 420);
        return VCSComponents.createFileListerModel(nodes, locationProperty, extraProperties);
    }

    public static final MutableVersionOperationModel createFileListerModel(Collection<?> nodes, DisplayProperty locationProperty, DisplayProperty[] extraProperties) {
        DisplayProperty[] properties = new DisplayProperty[extraProperties == null ? 1 : extraProperties.length + 1];
        properties[0] = locationProperty;
        if (extraProperties != null) {
            System.arraycopy(extraProperties, 0, properties, 1, extraProperties.length);
        }
        ClientVersionOperationModel opModel = new ClientVersionOperationModel(properties);
        ArrayList items = new ArrayList();
        nodes = new ArrayList(nodes);
        Iterator<?> itr = nodes.iterator();
        while (itr.hasNext()) {
            Object item = itr.next();
            if (items.contains(item)) {
                itr.remove();
                continue;
            }
            items.add(item);
        }
        opModel.add(nodes);
        int row = 0;
        for (Object o : nodes) {
            if (o instanceof Locatable) {
                URL u = ((Locatable)o).getURL();
                u = URLFileSystem.getParent((URL)u);
                opModel.setProperty(row++, locationProperty, URLFileSystem.getPlatformPathName((URL)u));
                continue;
            }
            opModel.setProperty(row++, locationProperty, "");
        }
        return opModel;
    }

    public static final VersionOperationPanel createFileListerComponent(Collection<?> nodes) {
        return VCSComponents.createFileListerComponent(nodes, null);
    }

    public static final VersionOperationPanel createFileListerComponent(Collection<?> nodes, TableCellRenderer renderer) {
        MutableVersionOperationModel opModel = VCSComponents.createFileListerModel(nodes, null);
        VersionOperationPanel panel = new VersionOperationPanel();
        if (renderer != null) {
            panel.getTable().setDefaultRenderer(Displayable.class, renderer);
        }
        panel.installModel(opModel);
        return panel;
    }

    public static final DetailDialog createDetailDialog(Component parent, String title, Object message, Collection<String> detail, String helpTopicId) {
        DetailDialog dialog = VCSComponents.createDetailDialog(parent, title, message, true, helpTopicId);
        JTextArea textArea = new JTextArea();
        Iterator<String> it = detail.iterator();
        while (it.hasNext()) {
            textArea.append(it.next());
            textArea.append("\n");
        }
        dialog.setDetailContent((Component)VCSComponents.setDetailComponent(textArea));
        return dialog;
    }

    public static final DetailDialog createDetailDialog(Component parent, String title, Object message, Object detail, String helpTopicId) {
        DetailDialog dialog = VCSComponents.createDetailDialogImpl(parent, title, message, detail != null, helpTopicId);
        if (detail != null) {
            if (!(detail instanceof Component)) {
                JTextArea textArea = new JTextArea(detail.toString());
                detail = VCSComponents.setDetailComponent(textArea);
            }
            dialog.setDetailContent((Component)detail);
        }
        return dialog;
    }

    private static Object setDetailComponent(JTextArea textArea) {
        textArea.setEditable(false);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFont(new JLabel().getFont());
        int preferredHeight = VCSComponents.createPrototypeLabel((int)3).getPreferredSize().height + textArea.getInsets().top + textArea.getInsets().bottom;
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, preferredHeight));
        return scrollPane;
    }

    private static DetailDialog createDetailDialogImpl(Component parent, String title, Object message, boolean detail, String helpTopicId) {
        title = title != null ? title : IdeUtil.getProgramName();
        int buttons = 1;
        if (detail) {
            buttons |= 0x10;
        }
        if (helpTopicId != null) {
            buttons |= 4;
        }
        DetailDialog dialog = DetailDialog.createDetailDialog((Component)parent, (String)title, (int)buttons);
        MessagePanel msgPanel = new MessagePanel();
        msgPanel.setMessage(message);
        msgPanel.setMessageType(3);
        dialog.setContent((Component)msgPanel);
        if (helpTopicId != null) {
            dialog.setHelpTopicId(helpTopicId);
        }
        return dialog;
    }

    public static final JEWTDialog createOperationDialog(Component parent, String title, String hint, Component center, Component south, String helpTopicId) {
        return VersioningCoreUtil.createOperationDialog((Component)parent, (String)title, (String)hint, (Component)center, (Component)south, (String)helpTopicId);
    }

    public static final JEWTDialog createOperationDialog(Component parent, String title, String hint, Component center, Component south, String helpTopicId, Component initialFocus) {
        return VersioningCoreUtil.createOperationDialog((Component)parent, (String)title, (String)hint, (Component)center, (Component)south, (String)helpTopicId, (Component)initialFocus);
    }

    public static final JEWTDialog createOperationDetailDialog(Component parent, String title, String hint, Component center, Component south, String helpTopicId, Component initialFocus, Component detail) {
        int buttons = VersioningCoreUtil.createOperationButtonMask((String)helpTopicId);
        buttons |= 0x10;
        JPanel content = VersioningCoreUtil.createOperationContentPanel((Component)center, (Component)south);
        if (initialFocus == null) {
            initialFocus = content;
        }
        center.setMinimumSize(center.getPreferredSize());
        DetailDialog dialog = DetailDialog.createDetailDialog((Component)parent, (String)(title != null ? title : IdeUtil.getProgramName()), (int)buttons);
        dialog.setDetailContent(detail);
        dialog.setContent((Component)content);
        dialog.setInitialFocus(initialFocus);
        dialog.setResizable(true);
        dialog.setDetailVisible(false);
        if (helpTopicId != null) {
            dialog.setHelpTopicId(helpTopicId);
        }
        return dialog;
    }

    public static final VersionOperationSelectTablePanel createSelectFileListerComponent(Collection nodes) {
        VersionOperationModel opModel = VCSComponents.getSelectTableModel(nodes);
        VersionOperationSelectTablePanel panel = new VersionOperationSelectTablePanel();
        panel.installModel(opModel);
        return panel;
    }

    private static VersionOperationModel getSelectTableModel(Collection nodes) {
        DisplayProperty[] extraProperties = new DisplayProperty[]{new CheckboxProperty()};
        MutableVersionOperationModel opModel = VCSComponents.createFileListerModel(nodes, extraProperties);
        for (int i = 0; i < nodes.size(); ++i) {
            opModel.setProperty(i, extraProperties[0], extraProperties[0].getPrototypeValue());
        }
        return opModel;
    }

    private static final JWrappedLabel createPrototypeLabel(int rows) {
        StringBuilder prototypeTextBuffer = new StringBuilder();
        for (int i = 0; i < rows; ++i) {
            prototypeTextBuffer.append('\n');
        }
        return new JWrappedLabel(prototypeTextBuffer.toString());
    }
}

