/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.awt.Component;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.util.Executors;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSNodeOverlayTracker;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSContextUtils;

public final class VCSDefaultUtils {
    private VCSDefaultUtils() {
    }

    public static final IdeActivationListener createActivationListener(StatusCacheBridge<VCSStatus> cache) {
        return new DefaultIdeActivationListener(cache);
    }

    public static final KeyStrokeContext createKeyStrokeContext(IdeAction[] actions, String name) {
        return VersioningCoreUtil.createKeyStrokeContext((IdeAction[])actions, (String)name);
    }

    public static final ContextMenuListener createContextMenuListener(Component child, URLFilter filter, String vcsId) {
        return new DefaultContextMenuListener(child, filter, vcsId);
    }

    @Deprecated
    public static final IconOverlayTracker createNodeOverlayTracker(int batchSize, StatusCacheBridge<VCSStatus> cache, URLFilter filter, String vcsId) {
        return VCSDefaultUtils.createNodeOverlayTracker(batchSize, new VCSOverlayItemProducer(vcsId, cache), filter, vcsId);
    }

    @Deprecated
    public static final IconOverlayTracker createNodeOverlayTracker(int batchSize, VCSOverlayItemProducer overlayItemProducer, URLFilter filter, String vcsId) {
        return new VCSNodeOverlayTracker(batchSize, overlayItemProducer, filter, vcsId);
    }

    public static final VCSStatus createRecognizedStatus(boolean versioned, Icon icon, String tooltip) {
        return new DefaultStatus(versioned ? 2 : 1, icon, tooltip);
    }

    public static final VCSStatus createUnrecognizedStatus() {
        return new DefaultStatus(3, null, null);
    }

    private static class DefaultContextMenuListener
    extends VCSContextMenuListener {
        private final URLFilter _filter;
        private final Component _child;

        public DefaultContextMenuListener(Component child, URLFilter filter, String vcsId) {
            super(vcsId);
            this._filter = filter;
            this._child = child;
        }

        @Override
        protected Component[] getContextMenuItems(Context context) {
            Locatable[] locatables = null;
            try {
                locatables = VCSContextUtils.getContextLocatables(context, this._filter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (locatables == null || locatables.length <= 0) {
                return null;
            }
            return new Component[]{this._child};
        }
    }

    private static class DefaultStatus
    implements VCSStatus {
        public static final int STATE_UNVERSIONED = 1;
        public static final int STATE_VERSIONED = 2;
        public static final int STATE_OTHER = 3;
        private final int _state;
        private final IconOverlay _overlay;

        public DefaultStatus(int state, Icon icon, String tooltip) {
            this._state = state;
            this._overlay = new IconOverlay(icon, null, tooltip);
        }

        @Override
        public boolean isVersioned() {
            return this._state == 2;
        }

        @Override
        public boolean isCandidate() {
            return this._state == 1;
        }

        @Override
        public IconOverlay getOverlay() {
            return this._overlay;
        }
    }

    private static class DefaultIdeActivationListener
    implements IdeActivationListener {
        private final StatusCacheBridge<VCSStatus> _cache;

        public DefaultIdeActivationListener(StatusCacheBridge<VCSStatus> cache) {
            this._cache = cache;
        }

        public void activated(IdeActivationEvent e) {
            java.util.concurrent.Executors.newSingleThreadExecutor(Executors.namedThreadFactory((String)"VCSDefaultUtils.DefaultIdeActivationListener")).execute(new Runnable(){

                @Override
                public final void run() {
                    DefaultIdeActivationListener.this._cache.clear();
                }
            });
        }

        public void deactivated(IdeActivationEvent e) {
        }
    }
}

