/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.Window;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.vcs.util.DialogCallback;
import oracle.jdevimpl.vcs.util.DialogCloseListener;

public abstract class AsynchronousDialogCallback
implements DialogCallback {
    private Exception m_exception = null;
    private JEWTDialog m_dialog;

    @Override
    public final void run(final JEWTDialog dialog) throws Exception {
        this.m_exception = null;
        this.m_dialog = dialog;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WaitCursor wc = null;
                try {
                    dialog.setOKButtonEnabled(false);
                    wc = new WaitCursor((Component)dialog);
                    wc.show();
                    if (AsynchronousDialogCallback.this.runImpl()) {
                        AsynchronousDialogCallback.this.m_dialog.setVisible(false);
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Window)AsynchronousDialogCallback.this.m_dialog, (Exception)re);
                    AsynchronousDialogCallback.this.m_exception = re;
                }
                catch (Exception e) {
                    AsynchronousDialogCallback.this.handleException((Component)AsynchronousDialogCallback.this.m_dialog, e);
                    AsynchronousDialogCallback.this.m_exception = e;
                }
                finally {
                    if (wc != null) {
                        wc.hide();
                        wc.dispose();
                    }
                    AsynchronousDialogCallback.this.m_dialog.setOKButtonEnabled(true);
                }
            }
        };
        Thread t = new Thread(r, this.getThreadName());
        t.start();
        throw new DialogCloseListener.KeepOpenException();
    }

    protected final JEWTDialog getDialog() {
        return this.m_dialog;
    }

    protected String getThreadName() {
        return "AsynchronousDialogCallback";
    }

    protected abstract boolean runImpl() throws Exception;

    protected void handleException(Component parent, Exception exception) {
        MessageDialog.error((Component)parent, (Object)exception.getMessage(), (String)"", null);
    }
}

