/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.util.CreateFilterPanel;
import oracle.jdevimpl.vcs.util.DialogFactory;
import oracle.jdevimpl.vcs.util.FileOrFolderFilter;
import oracle.jdevimpl.vcs.util.SimpleDocumentListener;
import oracle.jdevimpl.vcs.util.Validatable;
import oracle.jdevimpl.vcs.util.res.UtilArb;

public class DefaultCreateFilterPanel
extends JPanel
implements CreateFilterPanel,
Validatable {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel m_lbApplyTo = new JLabel();
    private JRadioButton m_rbFiles = new JRadioButton();
    private JRadioButton m_rbFolders = new JRadioButton();
    private JRadioButton m_rbFilesAndFolders = new JRadioButton();
    private JLabel m_lbDescription = new JLabel();
    private JTextField m_tfDescription = new JTextField();
    private JLabel m_lbFilter = new JLabel();
    private JTextField m_tfFilter = new JTextField();
    private boolean m_isDefaultingDescription = true;
    private boolean m_ignoreDescriptionUpdates = false;

    public DefaultCreateFilterPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SimpleDocumentListener filterListener = new SimpleDocumentListener(){

            @Override
            protected void update(DocumentEvent de) {
                boolean isComplete = DefaultCreateFilterPanel.this.isComplete();
                DefaultCreateFilterPanel.this.firePropertyChange("isComplete", !isComplete, isComplete);
                DefaultCreateFilterPanel.this.updateDefaultDescription();
            }
        };
        this.m_tfFilter.getDocument().addDocumentListener(filterListener);
        DocumentListener descriptionListener = new DocumentListener(){

            private void doit() {
                if (!DefaultCreateFilterPanel.this.m_ignoreDescriptionUpdates) {
                    DefaultCreateFilterPanel.this.m_isDefaultingDescription = false;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.doit();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.doit();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.doit();
            }
        };
        this.m_tfDescription.getDocument().addDocumentListener(descriptionListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rbFiles);
        bg.add(this.m_rbFolders);
        bg.add(this.m_rbFilesAndFolders);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultCreateFilterPanel.this.updateDefaultDescription();
            }
        };
        this.m_rbFiles.addActionListener(al);
        this.m_rbFolders.addActionListener(al);
        this.m_rbFilesAndFolders.addActionListener(al);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultDescription() {
        if (this.m_isDefaultingDescription) {
            this.m_ignoreDescriptionUpdates = true;
            try {
                String description = "";
                if (this.m_rbFiles.isSelected()) {
                    description = UtilArb.format("CREATE_FILTER_DESC_FILES", this.m_tfFilter.getText());
                } else if (this.m_rbFolders.isSelected()) {
                    description = UtilArb.format("CREATE_FILTER_DESC_FOLDERS", this.m_tfFilter.getText());
                } else if (this.m_rbFilesAndFolders.isSelected()) {
                    description = UtilArb.format("CREATE_FILTER_DESC_BOTH", this.m_tfFilter.getText());
                }
                this.m_tfDescription.setText(description);
            }
            finally {
                this.m_ignoreDescriptionUpdates = false;
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.m_lbApplyTo, (Component)this.m_rbFiles, (String)UtilArb.get("CREATE_FILTER_APPLY_TO"));
        ResourceUtils.resButton((AbstractButton)this.m_rbFiles, (String)UtilArb.get("CREATE_FILTER_FILES"));
        ResourceUtils.resButton((AbstractButton)this.m_rbFolders, (String)UtilArb.get("CREATE_FILTER_FOLDERS"));
        ResourceUtils.resButton((AbstractButton)this.m_rbFilesAndFolders, (String)UtilArb.get("CREATE_FILTER_FILES_AND_FOLDERS"));
        ResourceUtils.resLabel((JLabel)this.m_lbDescription, (Component)this.m_tfDescription, (String)UtilArb.get("CREATE_FILTER_DESCRIPTION"));
        ResourceUtils.resLabel((JLabel)this.m_lbFilter, (Component)this.m_tfFilter, (String)UtilArb.get("CREATE_FILTER_FILTER"));
        this.m_rbFiles.setSelected(true);
        this.add((Component)this.m_lbApplyTo, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_rbFiles, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.m_rbFolders, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.m_rbFilesAndFolders, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.m_lbDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 15, 12), 0, 0));
        this.add((Component)this.m_tfDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 150, 0));
        this.add((Component)this.m_lbFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.m_tfFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
    }

    @Override
    public boolean isComplete() {
        return this.m_tfFilter.getText().trim().length() > 0;
    }

    @Override
    public URLFilter runDialog(Component parent) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_scmdcreatefilter_html");
        boolean ok = new DialogFactory().runDialog(parent, UtilArb.get("CREATE_FILTER_TITLE"), 7, this);
        if (ok) {
            FileOrFolderFilter filter = new FileOrFolderFilter();
            filter.setUserDefined(true);
            filter.setFilter(this.m_tfFilter.getText());
            if (this.m_tfDescription.getText().trim().length() == 0) {
                filter.setDescription(this.m_tfFilter.getText());
            } else {
                filter.setDescription(this.m_tfDescription.getText());
            }
            filter.setApplyToFiles(this.m_rbFiles.isSelected() || this.m_rbFilesAndFolders.isSelected());
            filter.setApplyToFolders(this.m_rbFolders.isSelected() || this.m_rbFilesAndFolders.isSelected());
            return filter;
        }
        return null;
    }
}

