/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

public class DelimitedStrings {
    private static final DelimitedStrings CSV = new DelimitedStrings(",", new Character('\"'));
    private static final DelimitedStrings TSV = new DelimitedStrings("\t", new Character('\"'));
    private final String _delimiters;
    private final Character _qualifier;

    public DelimitedStrings(char delimiter, char qualifier) {
        this("" + delimiter, new Character(qualifier));
    }

    public DelimitedStrings(String delimiters, Character qualifier) {
        if (delimiters.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._delimiters = delimiters;
        this._qualifier = qualifier;
    }

    private final int countFields(String s) {
        int count = 0;
        int quoted = 0;
        int ptr = 0;
        int strlen = s.length();
        if (strlen == 0) {
            return 1;
        }
        while (ptr < strlen) {
            if (this._qualifier != null) {
                if (ptr < strlen - 1 && s.charAt(ptr) == this._qualifier.charValue() && s.charAt(ptr + 1) == this._qualifier.charValue()) {
                    ptr += 2;
                    continue;
                }
                if (s.charAt(ptr) == this._qualifier.charValue()) {
                    quoted = 1 - quoted;
                } else if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                    count += 1 - quoted;
                }
            } else if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                ++count;
            }
            ++ptr;
        }
        return count + 1;
    }

    private final String[] smashFields(String s, String[] array) {
        int idx;
        int ptr = 0;
        int strlen = s.length();
        StringBuilder sb = new StringBuilder();
        if (strlen == 0) {
            for (idx = 0; idx < array.length; ++idx) {
                array[idx] = "";
            }
            return array;
        }
        while (idx < array.length && ptr >= 0 && ptr < strlen) {
            sb.setLength(0);
            if (this._qualifier != null && s.charAt(ptr) == this._qualifier.charValue()) {
                ptr = this.cutQuoted(s, ptr, sb);
                array[idx++] = sb.toString();
                continue;
            }
            ptr = this.cutComma(s, ptr, sb);
            array[idx++] = sb.toString().trim();
        }
        while (idx < array.length) {
            array[idx++] = "";
        }
        return array;
    }

    private final int cutQuoted(String s, int ptr, StringBuilder sb) {
        int strlen = s.length();
        ++ptr;
        while (ptr < strlen) {
            if (ptr < strlen - 1 && s.charAt(ptr) == this._qualifier.charValue() && s.charAt(ptr + 1) == this._qualifier.charValue()) {
                sb.append(this._qualifier.charValue());
                ptr += 2;
                continue;
            }
            if (s.charAt(ptr) == this._qualifier.charValue()) {
                while (++ptr < strlen && this._delimiters.indexOf(s.charAt(ptr)) < 0) {
                }
                return ++ptr;
            }
            sb.append(s.charAt(ptr++));
        }
        return -1;
    }

    private final int cutComma(String s, int ptr, StringBuilder sb) {
        int strlen = s.length();
        while (ptr < strlen) {
            if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                return ++ptr;
            }
            sb.append(s.charAt(ptr++));
        }
        return ptr;
    }

    public final String[] parse(String values) {
        if (this._delimiters.length() == 0) {
            throw new IllegalArgumentException();
        }
        int len = this.countFields(values);
        String[] array = new String[len];
        return this.smashFields(values, array);
    }

    public final String format(String[] values) {
        StringBuilder sb = new StringBuilder();
        char delimiter = this._delimiters.charAt(0);
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            if (values[i] == null) continue;
            boolean quote = false;
            int pos = sb.length();
            int strlen = values[i].length();
            for (int j = 0; j < strlen; ++j) {
                char c = values[i].charAt(j);
                if (this._qualifier != null) {
                    if (c == this._qualifier.charValue()) {
                        quote = true;
                        sb.append(this._qualifier.charValue());
                    } else if (c == this._qualifier.charValue() || c <= ' ') {
                        quote = true;
                    }
                }
                sb.append(c);
            }
            if (!quote) continue;
            sb.insert(pos, this._qualifier.charValue());
            sb.append(this._qualifier.charValue());
        }
        return sb.toString();
    }

    public static final DelimitedStrings getCommaSeparatedInstance() {
        return CSV;
    }

    public static final DelimitedStrings getTabSeparatedInstance() {
        return TSV;
    }
}

