/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.nulls.NullIcon;
import oracle.jdevimpl.vcs.util.res.UtilArb;

public abstract class BrowserModelWorker {
    private final Subject _parent;
    private final Collection _children;
    private final Lock _lock;
    private final Element _loadingElement = new LoadingElement();
    private final SwingWorker<Collection, Object> _worker = new SwingWorker<Collection, Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection doInBackground() {
            BrowserModelWorker.this._lock.lock();
            try {
                Collection collection = BrowserModelWorker.this.getChildrenInBackground();
                return collection;
            }
            finally {
                BrowserModelWorker.this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            try {
                Collection collection = BrowserModelWorker.this._children;
                synchronized (collection) {
                    BrowserModelWorker.this._children.clear();
                    BrowserModelWorker.this._children.addAll((Collection)this.get());
                    if (BrowserModelWorker.this._deferred != null) {
                        for (Runnable r : BrowserModelWorker.this._deferred) {
                            r.run();
                        }
                    }
                    UpdateMessage.fireStructureChanged((Subject)BrowserModelWorker.this._parent);
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    };
    private Collection<Runnable> _deferred;

    public BrowserModelWorker(Subject parent, Collection children, Lock lock) {
        this._parent = parent;
        this._children = children;
        this._lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        Collection collection = this._children;
        synchronized (collection) {
            this._children.clear();
            this._children.add(this._loadingElement);
        }
        this._worker.execute();
    }

    protected abstract Collection getChildrenInBackground();

    public final void defer(Runnable r) {
        this.getDeferred().add(r);
    }

    public final void fail(Runnable r) {
        this.getDeferred().clear();
        this.getDeferred().add(r);
        this._deferred = Collections.unmodifiableCollection(this._deferred);
    }

    private Collection<Runnable> getDeferred() {
        if (this._deferred == null) {
            this._deferred = new ArrayList<Runnable>();
        }
        return this._deferred;
    }

    private final class LoadingElement
    extends IdeSubject
    implements Element,
    Displayable {
        private LoadingElement() {
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return DefaultAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return UtilArb.get("LOADING_LABEL");
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public Icon getIcon() {
            return new NullIcon(0, 0);
        }

        public String getToolTipText() {
            return null;
        }
    }
}

