/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.awt.Component;
import java.util.Collection;
import javax.naming.Context;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitWorker;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;

public abstract class ALMCommitManager {
    private static final String ALM_COMMIT_MANAGER_NAME = "ide/alm-commit-manager";

    public static ALMCommitManager getALMCommitManager() {
        ALMCommitManager almCommitManager = (ALMCommitManager)Names.lookup((Context)Names.newInitialContext(), (String)ALM_COMMIT_MANAGER_NAME);
        return almCommitManager != null ? almCommitManager : NullALMCommitManager.getInstance();
    }

    public static void setALMCommitManager(ALMCommitManager almCommitManager) {
        Names.bind((Context)Names.newInitialContext(), (String)ALM_COMMIT_MANAGER_NAME, (Object)almCommitManager);
    }

    public abstract boolean isConnectedToALM();

    protected abstract Component createCommitUI(ALMCommitContext var1);

    protected abstract boolean createCodeReview(String var1);

    public abstract boolean validate(ALMCommitContext var1) throws VCSException;

    public final void executeCommitWorker(XVCSCommandState commandState) {
        if (!this.isConnectedToALM()) {
            return;
        }
        ALMCommitContext almCommitContext = commandState.getALMCommitContext();
        Collection<ALMCommitFile> almCommitFiles = commandState.getALMCommitFiles();
        Collection<VCSFile> almReviewFiles = commandState.getALMCodeReviewFile();
        if (almCommitContext == null) {
            return;
        }
        if (almCommitFiles == null || almCommitFiles.isEmpty()) {
            return;
        }
        this.executeCommitWorker(new ALMCommitWorker(almCommitContext, almCommitFiles, almReviewFiles));
    }

    public final void executeCommitWorker(ALMCommitWorker worker) {
        worker.start();
    }

    protected abstract void commitToALM(ALMCommitContext var1, Collection<ALMCommitFile> var2, Collection<VCSFile> var3) throws Exception;

    public abstract boolean isALMAvailable();

    private static class NullALMCommitManager
    extends ALMCommitManager {
        private static final NullALMCommitManager _instance = new NullALMCommitManager();

        private NullALMCommitManager() {
        }

        public static NullALMCommitManager getInstance() {
            return _instance;
        }

        @Override
        public boolean isConnectedToALM() {
            return false;
        }

        @Override
        public boolean isALMAvailable() {
            return false;
        }

        @Override
        protected void commitToALM(ALMCommitContext context, Collection<ALMCommitFile> files, Collection<VCSFile> revFiles) {
        }

        @Override
        public boolean validate(ALMCommitContext context) throws VCSException {
            return true;
        }

        @Override
        protected boolean createCodeReview(String source) {
            return false;
        }

        @Override
        protected Component createCommitUI(ALMCommitContext context) {
            return null;
        }
    }
}

