/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdevimpl.vcs.xspi.ALMCommitManager;

public class CodeReviewController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        if (context.getView() instanceof ChangeListWindow) {
            ChangeListWindow view = (ChangeListWindow)context.getView();
            ChangeList cList = view.getContextChangeList();
            Locatable[] locs = this.getLocatables(cList.getElements(), null);
            if (locs.length == 0) {
                return true;
            }
            if (!ALMCommitManager.getALMCommitManager().isConnectedToALM()) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Bundle.get("CODE_REVIEW_NO_TPC_LOGIN"), (String)Bundle.get("CODE_REVIEW_NO_TPC_TITLE"), null);
                return true;
            }
            ALMCommitManager.getALMCommitManager().createCodeReview("pending changes window");
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (context.getView() instanceof ChangeListWindow) {
            ChangeListWindow view = (ChangeListWindow)context.getView();
            ChangeList cList = view.getContextChangeList();
            action.setEnabled(cList.getCount() > 0);
        } else {
            action.setEnabled(false);
        }
        return true;
    }

    private Locatable[] getLocatables(Element[] elements, URLFilter filter) {
        ArrayList<Locatable> loc = new ArrayList<Locatable>();
        for (Element elm : elements) {
            if (!(elm instanceof Locatable) || filter != null && !filter.accept(((Locatable)elm).getURL())) continue;
            loc.add((Locatable)elm);
        }
        return loc.toArray(new Locatable[0]);
    }

    private static class URLFilesFilter
    implements URLFilter {
        private URLFilesFilter() {
        }

        public boolean accept(URL url) {
            return !URLFileSystem.isDirectory((URL)url);
        }
    }
}

