/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.browse;

import java.awt.EventQueue;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bm.browse.BrowseModelProvider;
import oracle.bm.browse.BrowseTreeModel;
import oracle.bm.browse.CompositeCreator;
import oracle.bm.browse.util.IconNode;
import oracle.bm.browse.util.ProxyTreeModel;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.javatools.icons.OracleIcons;

class LazyBrowseModelProvider
implements BrowseModelProvider {
    private MetaClass m_mc;
    private String m_label;
    private BrowseModelProvider m_provider;

    LazyBrowseModelProvider(MetaClass mc, String label) {
        this.m_mc = mc;
        this.m_label = label;
    }

    @Override
    public TreeModel createTreeModel(Transferable context, Flavor[] flavors) {
        return new LazyBrowseTreeModel(context, flavors);
    }

    public boolean equals(Object o) {
        if (o instanceof LazyBrowseModelProvider) {
            LazyBrowseModelProvider p = (LazyBrowseModelProvider)o;
            return this.m_label.equals(p.m_label) && this.m_mc.getClassName().equals(p.m_mc.getClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.m_label.hashCode() + this.m_mc.getClassName().hashCode();
    }

    private class LazyBrowseTreeModel
    extends ProxyTreeModel
    implements BrowseTreeModel,
    Runnable {
        private Transferable m_context;
        private Flavor[] m_flavors;
        private boolean m_isLoading;
        private TreeModel m_model;

        public LazyBrowseTreeModel(Transferable context, Flavor[] flavors) {
            this.m_context = context;
            this.m_flavors = flavors;
        }

        @Override
        protected ProxyTreeModel.ProxyNode createRoot() {
            class RootNode
            implements ProxyTreeModel.ProxyNode,
            IconNode,
            CompositeCreator {
                RootNode() {
                }

                @Override
                public Object getChild(int index) {
                    LazyBrowseTreeModel.this.initModel();
                    return LazyBrowseTreeModel.this.m_model == null ? null : LazyBrowseTreeModel.this.m_model.getChild(LazyBrowseTreeModel.this.m_model.getRoot(), index);
                }

                @Override
                public int getChildCount() {
                    LazyBrowseTreeModel.this.initModel();
                    return LazyBrowseTreeModel.this.m_model == null ? 0 : LazyBrowseTreeModel.this.m_model.getChildCount(LazyBrowseTreeModel.this.m_model.getRoot());
                }

                @Override
                public boolean isLeaf() {
                    return false;
                }

                @Override
                public int getIndexOfChild(Object child) {
                    LazyBrowseTreeModel.this.initModel();
                    return LazyBrowseTreeModel.this.m_model == null ? -1 : LazyBrowseTreeModel.this.m_model.getIndexOfChild(LazyBrowseTreeModel.this.m_model.getRoot(), child);
                }

                @Override
                public Icon getIcon() {
                    return OracleIcons.getIcon((String)"folder.png");
                }

                @Override
                public String getText() {
                    return LazyBrowseModelProvider.this.m_label;
                }

                public String toString() {
                    return LazyBrowseModelProvider.this.m_label;
                }

                @Override
                public Object[] getCompositeTypes() {
                    Object root;
                    if (LazyBrowseTreeModel.this.m_model != null && (root = LazyBrowseTreeModel.this.m_model.getRoot()) instanceof CompositeCreator) {
                        return ((CompositeCreator)root).getCompositeTypes();
                    }
                    return null;
                }

                @Override
                public void createComposite(Object type, String name) throws CompositeCreator.CreationFailureException {
                    CompositeCreator creator = (CompositeCreator)LazyBrowseTreeModel.this.m_model.getRoot();
                    creator.createComposite(type, name);
                }
            }
            return new RootNode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initModel() {
            if (this.m_model == null && !this.m_isLoading) {
                this.m_isLoading = true;
                try {
                    LazyBrowseModelProvider.this.m_provider = (BrowseModelProvider)LazyBrowseModelProvider.this.m_mc.newInstance();
                    this.m_model = LazyBrowseModelProvider.this.m_provider.createTreeModel(this.m_context, this.m_flavors);
                    Object root = this.m_model.getRoot();
                    this.m_model.addTreeModelListener(new ProxyTreeModel.ProxyListener(root));
                    for (int i = this.m_model.getChildCount(root) - 1; i >= 0; --i) {
                        this.m_modelMappings.put(this.m_model.getChild(root, i), this.m_model);
                    }
                    EventQueue.invokeLater(this);
                }
                catch (Exception e) {
                    Logger.getLogger("oracle.bm.ide.browse").log(Level.FINER, e.getMessage(), e);
                }
                finally {
                    this.m_isLoading = false;
                }
            }
        }

        @Override
        public void run() {
            this.fireTreeModelEvent(3, new TreePath(this.getRoot()), null, null);
        }

        @Override
        public TreePath getPathForObject(Object object, Flavor flavor) {
            TreePath path;
            this.initModel();
            if (this.m_model instanceof BrowseTreeModel && (path = ((BrowseTreeModel)this.m_model).getPathForObject(object, flavor)) != null) {
                return this.findProxyPath(new TreePath(this.getRoot()), path, this.m_model);
            }
            return null;
        }
    }
}

