/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class RolloverJButton
extends JButton {
    private boolean m_in = false;
    private boolean m_down = false;

    public RolloverJButton() {
        this.init();
    }

    public RolloverJButton(String text) {
        super(text);
        this.init();
    }

    public RolloverJButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public RolloverJButton(Icon icon) {
        super(icon);
        this.init();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RolloverJButton.this.m_in = true;
                RolloverJButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RolloverJButton.this.m_in = false;
                RolloverJButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RolloverJButton.this.m_down = true;
                RolloverJButton.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RolloverJButton.this.m_down = false;
                RolloverJButton.this.repaint();
            }
        });
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame jfr = new JFrame("argh");
        JTextField tf = new JTextField();
        RolloverJButton jb = new RolloverJButton("Test");
        jfr.getContentPane().add((Component)tf, "Center");
        jfr.getContentPane().add((Component)jb, "East");
        jfr.pack();
        jfr.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_in && this.m_down && this.isEnabled()) {
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, this.getSize().width - 1, 0);
            g.drawLine(0, 0, 0, this.getSize().height - 1);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(this.getSize().width - 1, 1, this.getSize().width - 1, this.getSize().height - 1);
            g.drawLine(1, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
        } else if (this.m_in && this.isEnabled()) {
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(0, 0, this.getSize().width - 1, 0);
            g.drawLine(0, 0, 0, this.getSize().height - 1);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(this.getSize().width - 1, 1, this.getSize().width - 1, this.getSize().height - 1);
            g.drawLine(1, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

