/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JarStorage;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class Helpers {
    public static Storage createFileStorage(String pathName) {
        return new FileStorage(new File(pathName));
    }

    public static Storage createFileStorage(File file) {
        return new FileStorage(file);
    }

    public static boolean isFileStorage(Storage stor) {
        return stor instanceof FileStorage;
    }

    private static List<URL> listOfUniqueClassPathElement(List<Storage> storageList) {
        ArrayList<URL> uniqueElements = null;
        HashMap<URL, URL> map = null;
        if (storageList != null) {
            for (Storage st : storageList) {
                ArrayList l = (ArrayList)st.getProperty("dependantClassPathURLList");
                if (l == null) continue;
                if (map == null) {
                    map = new HashMap<URL, URL>();
                }
                for (int j = 0; j < l.size(); ++j) {
                    URL cp = (URL)l.get(j);
                    if (map.get(cp) != null) continue;
                    map.put(cp, cp);
                    if (uniqueElements == null) {
                        uniqueElements = new ArrayList<URL>();
                    }
                    uniqueElements.add(cp);
                }
            }
        }
        return uniqueElements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addStoragePath(HashSet<URL> seenURLs, List<Storage> storagePath, URL url, boolean isFromManifestFile) {
        String urlPath;
        if (seenURLs.contains(url)) {
            return;
        }
        seenURLs.add(url);
        URL jarFileUrl = null;
        if (JarUtil.isJarURL((URL)url)) {
            jarFileUrl = JarUtil.getJarFileURL((URL)url);
        } else if ("file".equals(url.getProtocol()) && (urlPath = url.getPath()) != null && (urlPath.endsWith(".jar") || urlPath.endsWith(".zip"))) {
            jarFileUrl = URLFactory.newJarURL((URL)url, null);
        }
        if (jarFileUrl != null) {
            if (!URLFileSystem.exists((URL)jarFileUrl) && !new File(jarFileUrl.getPath()).exists()) return;
            JarStorage jarStorage = new JarStorage(url);
            if (isFromManifestFile) {
                jarStorage.setProperty("isFromManifestFile", Boolean.TRUE);
            }
            storagePath.add(jarStorage);
            try {
                String classPathAttr = JarUtil.getClassPath((URL)jarFileUrl);
                if (classPathAttr == null) return;
                URL dirUrl = URLFileSystem.getParent((URL)jarFileUrl);
                StringTokenizer st = new StringTokenizer(classPathAttr);
                while (st.hasMoreTokens()) {
                    String classPathItemStr = st.nextToken();
                    boolean isJar = false;
                    URL classPathItemURL = URLFactory.newURL((URL)dirUrl, (String)classPathItemStr);
                    if (JarUtil.isArchive((String)classPathItemStr)) {
                        isJar = true;
                        classPathItemURL = URLFactory.newJarURL((URL)classPathItemURL, null);
                    }
                    Helpers.addStoragePath(seenURLs, storagePath, classPathItemURL, true);
                }
                return;
            }
            catch (IOException e) {
                return;
            }
        } else {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                storagePath.add((Storage)new DirectoryStorage(file));
                return;
            } else {
                if (!file.exists()) return;
                storagePath.add((Storage)new FileStorage(file));
            }
        }
    }

    static Storage[] urlPathAndDependantPathToStorageArray(URLPath urlPath, List<Storage> storageList) {
        int i;
        int n;
        Storage[] result = null;
        List<URL> cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        int cpElementCnt = cpElements == null ? 0 : cpElements.size();
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        int n2 = n = urls == null ? 0 : urls.length;
        if (n + cpElementCnt == 0) {
            return result;
        }
        HashSet<URL> seenURLs = new HashSet<URL>();
        ArrayList<Storage> storagePathList = new ArrayList<Storage>(n + cpElementCnt);
        for (i = 0; i < n; ++i) {
            Helpers.addStoragePath(seenURLs, storagePathList, urls[i], false);
        }
        for (i = 0; i < cpElementCnt; ++i) {
            Helpers.addStoragePath(seenURLs, storagePathList, cpElements.get(i), false);
        }
        return storagePathList.toArray(new Storage[storagePathList.size()]);
    }

    private static void addStringPath(StringBuffer path, URL url, String separator) {
        File urlFile;
        if (JarUtil.isJarURL((URL)url)) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        if ((urlFile = new File(url.getPath())).exists()) {
            path.append(urlFile.getPath());
            path.append(separator);
        }
    }

    static String urlPathAndDependantPathToString(URLPath urlPath, List<Storage> storageList, String separator) {
        int i;
        List<URL> cpElements = Helpers.listOfUniqueClassPathElement(storageList);
        URL[] urls = urlPath == null ? null : urlPath.getEntries();
        StringBuffer path = new StringBuffer(30);
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                Helpers.addStringPath(path, urls[i], separator);
            }
        }
        if (cpElements != null) {
            for (i = 0; i < cpElements.size(); ++i) {
                Helpers.addStringPath(path, cpElements.get(i), separator);
            }
        }
        if (path.length() > 0) {
            path.deleteCharAt(path.length() - 1);
        }
        return path.toString();
    }

    static String urlPathToString(URLPath urlPath, String separator) {
        return Helpers.urlPathAndDependantPathToString(urlPath, null, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL[] getUrlsThroughIndexer(Workspace ws, Project prj, QueryCriteria queryCriteria, BuildLog buildLog) {
        IndexManager manager = IndexManager.getIndexManager();
        Index index = ws == null ? manager.getIndex(prj) : manager.getIndex(ws, prj);
        BackgroundTask query = index.query(queryCriteria);
        try {
            URL[] uRLArray = (URL[])query.get();
            return uRLArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(CompArb.getString(76));
        }
        catch (Exception e) {
            Diagnostic diagnostic = new Diagnostic(Diagnostic.Kind.ERROR);
            diagnostic.setMessage("Unable to retrieve project content: " + e.getMessage());
            buildLog.diagnostic(diagnostic);
        }
        finally {
            index.release();
        }
        return new URL[0];
    }
}

