/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ojc.interfaces.Storage;

public class IdeStorage
implements Storage {
    private HashMap properties = null;
    public Node node;
    private static String commErrMsg = "compiler/ide communication fatal error: ";

    public IdeStorage(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null in IdeStorage");
        }
        this.node = node;
    }

    public Storage setContext(Storage newContext) {
        return null;
    }

    public void setPackage(String packageName) {
    }

    public boolean equals(Object other) {
        return other.toString() == this.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public long modDate() {
        return this.node.getTimestamp();
    }

    public String getName() {
        return URLFileSystem.getFileName((URL)this.node.getURL());
    }

    public String getPath() {
        return URLFileSystem.getPlatformPathName((URL)this.node.getURL());
    }

    public String getCanonicalPath() {
        return URLFileSystem.getPlatformPathName((URL)this.node.getURL());
    }

    public String getParent() {
        return null;
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isInJar() {
        return !this.node.isNew() && JarUtil.isJarURL((URL)this.node.getURL());
    }

    private InputStream getInputStream() throws IOException {
        if (this.node instanceof TextNode) {
            return ((TextNode)this.node).getInputStream(false);
        }
        return this.node.getInputStream();
    }

    public byte[] read() throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            int avail = is.available();
            byte[] buffer = new byte[avail];
            is.read(buffer, 0, avail);
            byte[] byArray = buffer;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(commErrMsg + "can't read from " + this.getCanonicalPath());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public int read(byte[] buf) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            int avail = is.available();
            int toread = avail < buf.length ? avail : buf.length;
            is.read(buf, 0, toread);
            int n = avail;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(commErrMsg + "can't read from " + this.getCanonicalPath());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        throw new IOException(commErrMsg + "can't write to " + this.getCanonicalPath());
    }

    public String[] list() {
        return null;
    }

    public int size() throws IOException {
        InputStream is = null;
        try {
            int size;
            is = this.getInputStream();
            int n = size = is.available();
            return n;
        }
        catch (Exception e) {
            throw new IOException(commErrMsg + "can't read from " + this.getCanonicalPath());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public ArrayList listStorage() {
        Assert.println((String)"IdeStorage.listStorage() -- assert false");
        return null;
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        return null;
    }

    public Storage openDir(String name) {
        return null;
    }

    public Storage create(String name) throws IOException {
        return null;
    }

    public Storage createDir(String name) throws IOException {
        return null;
    }

    public void close() {
    }
}

