/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.CompArb;
import oracle.ojc.interfaces.Storage;

public class JarStorage
implements Storage {
    private final URL _jarURL;
    private final JarIndex _jarIndex;
    private final String _jarEntry;
    private final File _jarFile;
    private String _canonicalPath;
    private HashMap properties = null;
    private Map<String, Storage> _cachedDirEntries;

    public JarStorage(URL jarURL) {
        LogManager logMgr;
        this._jarURL = jarURL;
        URL jarPath = JarUtil.getJarFileURL((URL)jarURL);
        this._jarFile = new File(jarPath.getPath());
        JarIndex jarIndex = null;
        String exceptionMessage = null;
        try {
            jarIndex = JarUtil.getJarIndex((URL)this._jarURL);
        }
        catch (IOException e) {
            jarIndex = null;
            exceptionMessage = e.getMessage();
        }
        this._jarIndex = jarIndex;
        if ((this._jarIndex == null || this._jarIndex.isEmpty() && this._jarIndex.getTimestamp() > 0L) && (logMgr = LogManager.getLogManager()) != null) {
            final String message = exceptionMessage != null ? CompArb.format(133, this._jarFile.getPath(), exceptionMessage) : (this._jarIndex.isEmpty() && this._jarIndex.getTimestamp() > 0L ? CompArb.format(132, this._jarFile.getPath()) : CompArb.format(63, this._jarFile.getPath()));
            final LogPage page = logMgr.getMsgPage();
            Runnable log = new Runnable(){

                @Override
                public void run() {
                    page.log((Object)message);
                    page.log((Object)"\n");
                }
            };
            if (page instanceof MessagePage) {
                log.run();
            } else {
                SwingUtilities.invokeLater(log);
            }
        }
        this._jarEntry = JarUtil.getJarEntry((URL)this._jarURL);
    }

    private JarStorage(JarStorage orig, String jarEntry) {
        this._jarURL = orig._jarURL;
        this._jarIndex = orig._jarIndex;
        this._jarEntry = jarEntry;
        this._jarFile = orig._jarFile;
        if (!ModelUtil.hasLength((String)orig._jarEntry)) {
            this._canonicalPath = orig.getCanonicalPath() + File.separator + jarEntry.replace('/', File.separatorChar);
        } else {
            this._canonicalPath = orig.getCanonicalPath();
            if (!this._canonicalPath.endsWith(File.separator)) {
                this._canonicalPath = this._canonicalPath + File.separator;
            }
            this._canonicalPath = this._canonicalPath + this.getName().replace('/', File.separatorChar);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JarStorage jarStorage = (JarStorage)o;
        return ModelUtil.areEqual((Object)this._jarEntry, (Object)jarStorage._jarEntry) && ModelUtil.areEqual((Object)this._jarFile, (Object)jarStorage._jarFile);
    }

    public int hashCode() {
        return this._jarURL != null ? this._jarURL.hashCode() : 0;
    }

    public String toString() {
        return this.getCanonicalPath();
    }

    public long modDate() {
        if (this._jarIndex != null) {
            return this._jarIndex.getTimestamp(this._jarEntry);
        }
        return this._jarFile.lastModified();
    }

    public URL getURL() {
        return URLFactory.newJarURL((URL)this._jarURL, (String)this._jarEntry);
    }

    public String getName() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            int lastSlash = this._jarEntry.lastIndexOf("/");
            if (this._jarEntry.endsWith("/") && lastSlash > 0) {
                lastSlash = this._jarEntry.lastIndexOf("/", lastSlash - 1);
            }
            return this._jarEntry.substring(lastSlash + 1);
        }
        return this._jarFile.getName();
    }

    public String getPath() {
        String jarFilePath = this._jarFile.getPath();
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return jarFilePath + "!/" + this._jarEntry;
        }
        return jarFilePath;
    }

    public String getCanonicalPath() {
        if (this._canonicalPath == null) {
            try {
                this._canonicalPath = this._jarFile.getCanonicalPath() + "!";
            }
            catch (IOException e) {
                this._canonicalPath = this._jarFile.getAbsolutePath() + "!";
            }
            if (ModelUtil.hasLength((String)this._jarEntry)) {
                this._canonicalPath = this._canonicalPath + File.separator + this._jarEntry.replace('/', File.separatorChar);
            }
        }
        return this._canonicalPath;
    }

    public String getParent() {
        if (ModelUtil.hasLength((String)this._jarEntry)) {
            return this._jarFile.getPath();
        }
        return this._jarFile.getParent();
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public boolean isDirectory() {
        return !ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/");
    }

    public boolean isInJar() {
        return true;
    }

    public void close() {
        if (this._cachedDirEntries != null) {
            this._cachedDirEntries.clear();
        }
    }

    public int size() throws IOException {
        assert (false);
        return 0;
    }

    public ArrayList listStorage() {
        String[] files = this.list();
        if (files != null) {
            ArrayList<Storage> res = new ArrayList<Storage>(files.length);
            for (int i = 0; i < files.length; ++i) {
                res.add(this.open(files[i]));
            }
            return res;
        }
        return null;
    }

    public String[] list() {
        if (this._jarIndex != null && this.isDirectory()) {
            return this._jarIndex.list(this._jarEntry == null ? "" : this._jarEntry);
        }
        return new String[0];
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        if ((name = name.replace(File.separatorChar, '/')).endsWith("/")) {
            return this.openDir(name);
        }
        String string = name = this._jarEntry == null ? name : this._jarEntry + name;
        if (this._jarIndex != null && this._jarIndex.exists(name)) {
            return new JarStorage(this, name);
        }
        return null;
    }

    public Storage openDir(String name) {
        if (!(name = name.replace(File.separatorChar, '/')).endsWith("/")) {
            name = name + "/";
        }
        name = this._jarEntry == null ? name : this._jarEntry + name;
        Storage entry = null;
        if (this._cachedDirEntries == null) {
            this._cachedDirEntries = new HashMap<String, Storage>();
        } else {
            entry = this._cachedDirEntries.get(name);
        }
        if (entry != null) {
            return entry;
        }
        if (this._jarIndex != null && this._jarIndex.isDirectory(name)) {
            entry = new JarStorage(this, name);
            this._cachedDirEntries.put(name, entry);
            return entry;
        }
        return null;
    }

    public byte[] read() throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        return this._jarIndex.getBytes(this._jarEntry);
    }

    public int read(byte[] buf) throws IOException {
        if (!ModelUtil.hasLength((String)this._jarEntry) || this._jarEntry.endsWith("/")) {
            throw new UnsupportedOperationException();
        }
        byte[] bytes = this._jarIndex.getBytes(this._jarEntry);
        int n = bytes.length;
        if (n > buf.length) {
            return n;
        }
        System.arraycopy(bytes, 0, buf, 0, n);
        return n;
    }

    public Storage setContext(Storage newContext) {
        throw new UnsupportedOperationException();
    }

    public void setPackage(String packageName) {
    }

    public void write(byte[] xs, int start, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage create(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Storage createDir(String name) throws IOException {
        throw new UnsupportedOperationException();
    }
}

