/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Encodings;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionManager;

public class OjcConfigurationPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private JLabel copyResLabel = new JLabel();
    private JTextField copyResTextField = new JTextField();
    private JCheckBox copyFilesNoExtensionCheckBox = new JCheckBox();
    private JCheckBox reverseCopyResCheckBox = new JCheckBox();
    private JLabel encodingLabel = new JLabel();
    private JComboBox encodingComboBox = new JComboBox<String>(new String[0]);
    private JLabel targetLabel = new JLabel();
    private JComboBox targetComboBox = new JComboBox<String>(new String[0]);
    private JLabel sourceLabel = new JLabel();
    private JComboBox sourceComboBox = new JComboBox<String>(new String[0]);
    private JLabel jdkCompatibilityLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean addedActionListeners = false;
    private JCheckBox enableDebugInfoCheckBox = new JCheckBox();
    private JLabel compilerLabel = new JLabel();
    private JComboBox compilerChooser = new JComboBox<String>(new String[0]);
    private JLabel compilerName = new JLabel();
    private JCheckBox outOfProcessCheckBox = new JCheckBox();
    private boolean outOfProcessState = false;
    private JLabel javaOptionsLabel = new JLabel();
    private JTextField javaOptionsTextField = new JTextField();
    private CompilerOptionManager compilerOptionManager;
    private Hashtable<String, Boolean> debugOptionTable = new Hashtable();
    private static final String[] PROPERTY_KEYS = new String[]{"source", "target", "internalEncoding", "copyRes", "reverseCopyRes", "compiler.name", "outOfProcess", "outOfProcessJavaOptions"};

    public OjcConfigurationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDataKey() {
        return OjcConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (tc != null && OjcConfigurationPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_com_proset_compilerdpp_html");
        } else {
            this.setHelpID("f1_com_proset_compiler_html");
        }
        BuildSystemConfiguration buildSystemConfiguration = OjcConfigurationPanel.getBuildSystemConfiguration(tc);
        this.compilerOptionManager = OjcConfigurationPanel.getCompilerOptionManager(tc);
        this.loadFrom(buildSystemConfiguration, this.compilerOptionManager);
        if (!this.addedActionListeners) {
            this.addedActionListeners = true;
            this.targetComboBox.addActionListener(this);
            this.sourceComboBox.addActionListener(this);
            this.compilerChooser.addActionListener(this);
            this.enableDebugInfoCheckBox.addActionListener(this);
            this.outOfProcessCheckBox.addActionListener(this);
        }
    }

    public void onExit(TraversableContext tc) {
        BuildSystemConfiguration buildSystemConfiguration = OjcConfigurationPanel.getBuildSystemConfiguration(tc);
        this.compilerOptionManager = OjcConfigurationPanel.getCompilerOptionManager(tc);
        this.commitTo(buildSystemConfiguration, this.compilerOptionManager);
        if (this.addedActionListeners) {
            this.addedActionListeners = false;
            this.targetComboBox.removeActionListener(this);
            this.sourceComboBox.removeActionListener(this);
            this.compilerChooser.removeActionListener(this);
            this.enableDebugInfoCheckBox.removeActionListener(this);
            this.outOfProcessCheckBox.removeActionListener(this);
        }
    }

    private static BuildSystemConfiguration getBuildSystemConfiguration(TraversableContext tc) {
        PropertyStorage propertyData = OjcConfigurationPanel.getPropertyData((Namespace)tc);
        return BuildSystemConfiguration.getInstance((PropertyStorage)propertyData);
    }

    private static CompilerOptionManager getCompilerOptionManager(TraversableContext tc) {
        PropertyStorage propertyData = OjcConfigurationPanel.getPropertyData((Namespace)tc);
        return CompilerOptionManager.getInstance((PropertyStorage)propertyData);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.targetComboBox || obj == this.sourceComboBox) {
            String s;
            String t = (String)this.targetComboBox.getSelectedItem();
            if (t != null && (s = (String)this.sourceComboBox.getSelectedItem()) != null) {
                String newT = null;
                String newS = null;
                if (obj == this.targetComboBox) {
                    if (t.equals("Default")) {
                        if (!s.equals("Default")) {
                            newS = "Default";
                        }
                    } else if (s.equals("Default")) {
                        newS = this.checkNewSourceTarget(this.sourceComboBox, t);
                    } else if (s.compareTo(t) > 0 && s.compareTo("1.4") >= 0) {
                        newS = this.checkNewSourceTarget(this.sourceComboBox, t);
                    }
                }
                if (obj == this.sourceComboBox) {
                    if (s.equals("Default")) {
                        if (!t.equals("Default")) {
                            newT = "Default";
                        }
                    } else if (t.equals("Default")) {
                        newT = this.checkNewSourceTarget(this.targetComboBox, s);
                    } else if (s.compareTo(t) > 0 && s.compareTo("1.4") >= 0) {
                        newT = this.checkNewSourceTarget(this.targetComboBox, s);
                    }
                }
                if (newT != null) {
                    this.targetComboBox.setSelectedItem(newT);
                } else if (newS != null) {
                    this.sourceComboBox.setSelectedItem(newS);
                }
            }
        } else if (obj == this.compilerChooser) {
            if (this.compilerChooser.getSelectedItem() != null) {
                String currentCompiler = this.compilerChooser.getSelectedItem().toString();
                boolean isDebug = this.debugOptionTable.get(currentCompiler);
                this.enableDebugInfoCheckBox.setSelected(isDebug);
                this.outOfProcessCheckBox.setSelected(this.outOfProcessState);
                this.outOfProcessCheckBox.setEnabled(true);
                this.javaOptionsLabel.setEnabled(this.outOfProcessState);
                this.javaOptionsTextField.setEnabled(this.outOfProcessState);
            }
        } else if (obj == this.enableDebugInfoCheckBox) {
            String currentCompiler = this.compilerChooser.getSelectedItem().toString();
            boolean isDebug = this.enableDebugInfoCheckBox.isSelected();
            this.debugOptionTable.put(currentCompiler, isDebug);
        } else if (obj == this.outOfProcessCheckBox) {
            this.outOfProcessState = this.outOfProcessCheckBox.isSelected();
            this.javaOptionsLabel.setEnabled(this.outOfProcessState);
            this.javaOptionsTextField.setEnabled(this.outOfProcessState);
        }
    }

    private String checkNewSourceTarget(JComboBox comboBox, String newSourceTarget) {
        int size = comboBox.getItemCount();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int x = 0; x < size; ++x) {
            String item = comboBox.getItemAt(x).toString();
            if (item.equals(newSourceTarget)) {
                return item;
            }
            if (item.equals("Default") || item.equals("Default")) continue;
            treeSet.add(item);
        }
        String lastItem = null;
        for (String item : treeSet) {
            if (item.compareTo(newSourceTarget) > 0) {
                return lastItem != null ? lastItem : item;
            }
            lastItem = item;
        }
        return lastItem != null ? lastItem : newSourceTarget;
    }

    private String toStringList(String[] strArray) {
        if (strArray != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < strArray.length; ++i) {
                buffer.append(strArray[i]).append(";");
            }
            if (strArray.length > 0) {
                int lastCharIndex = buffer.length() - 1;
                buffer.deleteCharAt(lastCharIndex);
            }
            return buffer.toString();
        }
        return "";
    }

    private void populateComboBox(JComboBox box, String[] list) {
        box.removeAllItems();
        for (int i = 0; i < list.length; ++i) {
            box.addItem(list[i]);
        }
    }

    private void loadFrom(BuildSystemConfiguration c, CompilerOptionManager compilerOptionManager) {
        this.outOfProcessCheckBox.setSelected(c.getOutOfProcess());
        this.outOfProcessState = c.getOutOfProcess();
        this.javaOptionsTextField.setText(c.getOutOfProcessJavaOptions());
        this.actionPerformed(new ActionEvent(this.outOfProcessCheckBox, 1001, null));
        List compilerList = compilerOptionManager.getCompilers();
        String currentCompiler = compilerOptionManager.getCurrentCompiler();
        boolean foundCurrentCompiler = false;
        this.compilerChooser.removeAllItems();
        this.debugOptionTable.clear();
        for (String compilerName : compilerList) {
            boolean isDebug = compilerOptionManager.isDebugInformation(compilerName);
            this.debugOptionTable.put(compilerName, isDebug);
            this.compilerChooser.addItem(compilerName);
            if (!compilerName.equals(currentCompiler)) continue;
            this.compilerChooser.setSelectedItem(compilerName);
            foundCurrentCompiler = true;
        }
        if (!foundCurrentCompiler) {
            this.compilerChooser.setSelectedIndex(0);
        }
        this.compilerName.setText(currentCompiler);
        if (compilerList.size() > 1) {
            this.compilerName.setVisible(false);
            this.compilerChooser.setVisible(true);
        }
        this.actionPerformed(new ActionEvent(this.compilerChooser, 1001, null));
        this.populateComboBox(this.sourceComboBox, c.getSources());
        this.populateComboBox(this.targetComboBox, c.getTargets());
        this.sourceComboBox.setSelectedItem(c.getSourceString());
        this.targetComboBox.setSelectedItem(c.getTargetString());
        this.copyResTextField.setText(this.toStringList(c.getCopyRes()));
        this.copyFilesNoExtensionCheckBox.setSelected(c.getCopyFilesNoExtension());
        this.reverseCopyResCheckBox.setSelected(c.getReverseCopyRes());
        String enc = c.getCurrentEncoding();
        Encodings.initComboBox((JComboBox)this.encodingComboBox, (boolean)true, (String)enc);
        this.revalidate();
    }

    private String[] toStringArray(String strList) {
        StringTokenizer tokenizer = new StringTokenizer(strList, ";");
        String[] strArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            strArray[i++] = tokenizer.nextToken();
        }
        return strArray;
    }

    private void commitTo(BuildSystemConfiguration c, CompilerOptionManager compilerOptionManager) {
        String newCopyRes;
        String oldCopyRes;
        String newTarget = (String)this.targetComboBox.getSelectedItem();
        if (!c.getTargetString().equals(newTarget)) {
            c.setTarget(newTarget);
        }
        String newSource = (String)this.sourceComboBox.getSelectedItem();
        if (!c.getSourceString().equals(newSource)) {
            c.setSource(newSource);
        }
        if (!(oldCopyRes = this.toStringList(c.getCopyRes())).equals(newCopyRes = this.copyResTextField.getText())) {
            c.setCopyRes(this.toStringArray(newCopyRes));
        }
        c.setCopyFilesNoExtension(this.copyFilesNoExtensionCheckBox.isSelected());
        c.setReverseCopyRes(this.reverseCopyResCheckBox.isSelected());
        c.setOutOfProcess(this.outOfProcessState);
        c.setOutOfProcessJavaOptions(this.javaOptionsTextField.getText());
        if (Boolean.TRUE.equals(this.encodingComboBox.getClientProperty("encodings-loaded"))) {
            String encoding = (String)this.encodingComboBox.getSelectedItem();
            c.setCurrentEncoding("Default".equals(encoding) ? null : encoding);
        }
        String newCompiler = this.compilerChooser.getSelectedItem().toString();
        if (!compilerOptionManager.getCurrentCompiler().equals(newCompiler)) {
            compilerOptionManager.setCurrentCompiler(newCompiler);
        }
        Enumeration<String> compilers = this.debugOptionTable.keys();
        while (compilers.hasMoreElements()) {
            String compilerName = compilers.nextElement();
            boolean isDebug = this.debugOptionTable.get(compilerName);
            compilerOptionManager.setDebugInformation(compilerName, isDebug);
        }
    }

    private void jbInit() throws Exception {
        int controlVGap = 6;
        int controlHGap = 24;
        int majorVGap = 16;
        int labelControlHGap = 8;
        ResourceUtils.resLabel((JLabel)this.copyResLabel, (Component)this.copyResTextField, (String)CompArb.getString(52));
        ResourceUtils.resButton((AbstractButton)this.copyFilesNoExtensionCheckBox, (String)CompArb.getString(127));
        ResourceUtils.resButton((AbstractButton)this.reverseCopyResCheckBox, (String)CompArb.getString(53));
        ResourceUtils.resLabel((JLabel)this.encodingLabel, (Component)this.encodingComboBox, (String)CompArb.getString(49));
        ResourceUtils.resLabel((JLabel)this.targetLabel, (Component)this.targetComboBox, (String)CompArb.getString(54));
        ResourceUtils.resLabel((JLabel)this.sourceLabel, (Component)this.sourceComboBox, (String)CompArb.getString(55));
        ResourceUtils.resLabel((JLabel)this.compilerLabel, (Component)this.compilerChooser, (String)CompArb.getString(87));
        ResourceUtils.resButton((AbstractButton)this.enableDebugInfoCheckBox, (String)CompArb.getString(86));
        ResourceUtils.resButton((AbstractButton)this.outOfProcessCheckBox, (String)CompArb.getString(91));
        ResourceUtils.resLabel((JLabel)this.javaOptionsLabel, (Component)this.javaOptionsTextField, (String)CompArb.getString(92));
        this.jdkCompatibilityLabel.setText(CompArb.getString(56));
        int y = 0;
        this.setLayout(this.gridBagLayout1);
        JPanel compilerPanel = new JPanel();
        compilerPanel.setLayout(new GridBagLayout());
        compilerPanel.add((Component)this.compilerLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        compilerPanel.add((Component)this.compilerChooser, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, labelControlHGap, 0, 0), 0, 0));
        this.compilerChooser.setVisible(false);
        compilerPanel.add((Component)this.compilerName, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, labelControlHGap, 0, 0), 0, 0));
        compilerPanel.add((Component)this.enableDebugInfoCheckBox, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, controlHGap, 0, 0), 0, 0));
        compilerPanel.add((Component)this.outOfProcessCheckBox, new GridBagConstraints2(4, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, controlHGap, 0, 0), 0, 0));
        this.add(compilerPanel, new GridBagConstraints2(0, y, 6, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.javaOptionsLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 18, 2, new Insets(controlVGap, 0, 0, 0), 0, 0));
        this.add(this.javaOptionsTextField, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 0.0, 18, 2, new Insets(controlVGap, 0, 0, 0), 0, 0));
        ++y;
        JPanel scPanel = new JPanel();
        scPanel.setLayout(new GridBagLayout());
        scPanel.add((Component)this.jdkCompatibilityLabel, new GridBagConstraints2(0, 0, 4, 1, 0.0, 0.0, 18, 0, new Insets(majorVGap, 0, 0, 0), 0, 0));
        scPanel.add((Component)this.sourceLabel, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(controlVGap, 0, 0, 0), 0, 0));
        scPanel.add((Component)this.sourceComboBox, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(controlVGap, labelControlHGap, 0, 0), 0, 0));
        scPanel.add((Component)this.targetLabel, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(controlVGap, controlHGap, 0, 0), 0, 0));
        scPanel.add((Component)this.targetComboBox, new GridBagConstraints2(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(controlVGap, labelControlHGap, 0, 0), 0, 0));
        this.add(scPanel, new GridBagConstraints2(0, y, 6, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.encodingLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 18, 2, new Insets(majorVGap, 0, 0, 0), 0, 0));
        this.add(this.encodingComboBox, new GridBagConstraints2(0, ++y, 3, 1, 1.0, 0.0, 18, 2, new Insets(controlVGap, 0, 0, 0), 0, 0));
        this.add(this.copyResLabel, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 0.0, 18, 2, new Insets(majorVGap, 0, 0, 0), 0, 0));
        this.add(this.copyResTextField, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 0.0, 18, 2, new Insets(controlVGap, 0, 0, 0), 0, 0));
        this.add(this.copyFilesNoExtensionCheckBox, new GridBagConstraints2(0, ++y, 3, 1, 0.0, 1.0, 18, 2, new Insets(controlVGap, 0, 0, 0), 0, 0));
        this.add(this.reverseCopyResCheckBox, new GridBagConstraints2(3, y, 3, 1, 0.0, 1.0, 12, 2, new Insets(controlVGap, 8, 0, 0), 0, 0));
        JLabel moreLabel = new JLabel(CompArb.getString(85));
        this.add(moreLabel, new GridBagConstraints2(0, ++y, 6, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

