/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.markers.ActionMarker;
import oracle.ide.markers.Marker;
import oracle.ide.model.LabelProvider;
import oracle.javatools.patterns.Operator;
import oracle.jdeveloper.compiler.CompilerActionMarker;
import oracle.jdevimpl.resource.JdevBuildExtensionManifest;

public class CompilerActionMarkerLabelProvider
implements LabelProvider<CompilerActionMarker>,
AdapterFactory<CompilerActionMarker, LabelProvider> {
    private static final Map<String, Operator<CompilerActionMarker, String>> OPERATORS = new HashMap<String, Operator<CompilerActionMarker, String>>();

    public String labelFor(CompilerActionMarker marker, String key) {
        Operator<CompilerActionMarker, String> operator = OPERATORS.get(key);
        return null != operator ? (String)operator.operate((Object)marker) : "";
    }

    public LabelProvider adapt(CompilerActionMarker marker) {
        return this;
    }

    static {
        OPERATORS.put(LONG_LABEL, new LongLabelOperator());
        OPERATORS.put(SHORT_LABEL, new ShortLabelOperator());
    }

    private static class LongLabelOperator
    implements Operator<CompilerActionMarker, String> {
        private static final String BEGINNING_LABEL_FMT = JdevBuildExtensionManifest.get("COMPILER_ACTION_MARKER_BEGINNING_LABEL");
        private static final String CANCELED_LABEL_FMT = JdevBuildExtensionManifest.get("COMPILER_ACTION_MARKER_CANCELED_LABEL");
        private static final String COMPLETED_LABEL_FMT = JdevBuildExtensionManifest.get("COMPILER_ACTION_MARKER_COMPLETED_LABEL");

        private LongLabelOperator() {
        }

        public String operate(CompilerActionMarker marker) {
            String eventDescription = "";
            Set events = marker.getEvents();
            Iterator i$ = events.iterator();
            if (i$.hasNext()) {
                Marker.EventDescription event = (Marker.EventDescription)i$.next();
                eventDescription = event.getDescription();
            }
            ActionMarker.State state = ActionMarker.State.valueOf((int)marker.state());
            switch (state) {
                case BEGINNING: {
                    return MessageFormat.format(BEGINNING_LABEL_FMT, eventDescription);
                }
                case CANCELED: {
                    return MessageFormat.format(CANCELED_LABEL_FMT, eventDescription);
                }
                case COMPLETED: {
                    int errorCount = marker.errorCount();
                    int warningCount = marker.warningCount();
                    int infoCount = marker.infoCount();
                    int problemCount = errorCount + warningCount + infoCount;
                    return MessageFormat.format(COMPLETED_LABEL_FMT, eventDescription, errorCount, warningCount, infoCount, problemCount);
                }
            }
            return "";
        }
    }

    private static class ShortLabelOperator
    implements Operator<CompilerActionMarker, String> {
        private ShortLabelOperator() {
        }

        public String operate(CompilerActionMarker marker) {
            Set events = marker.getEvents();
            Iterator i$ = events.iterator();
            if (i$.hasNext()) {
                Marker.EventDescription event = (Marker.EventDescription)i$.next();
                return event.getDescription();
            }
            return "";
        }
    }
}

