/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.ideimpl.compiler.BuildToolDefinition;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdevimpl.compiler.BuildSystemHook;

public class TranslatorDefinition
extends BuildToolDefinition<Translator> {
    private static final String category = "translator";
    private Set<String> inputExtensions;
    private Set<String> outputExtensions;

    TranslatorDefinition(HashStructure hash, List inputExtensions, List outputExtensions, String extensionId) {
        super(extensionId, hash, category);
        this.inputExtensions = this.addExtensions(inputExtensions);
        this.outputExtensions = this.addExtensions(outputExtensions);
    }

    public TranslatorDefinition(Translator translator) {
        super((Object)translator, category);
    }

    public String getName() {
        if (this.buildTool != null) {
            return ((Translator)this.buildTool).getName();
        }
        String className = this.getClassName();
        if (className != null) {
            return className;
        }
        return "<unknown>";
    }

    public boolean definesTranslator(Translator translator) {
        return translator == this.buildTool;
    }

    public Set<String> getOutputExtensions() {
        if (this.outputExtensions != null && !this.outputExtensions.isEmpty()) {
            return this.outputExtensions;
        }
        Translator translator = (Translator)this.getOrInstantiateBuildTool();
        if (translator != null) {
            return this.getProgrammaticExtensions(translator.getOutputTypes());
        }
        return Collections.emptySet();
    }

    public Set<String> getInputExtensions() {
        if (this.inputExtensions != null && !this.inputExtensions.isEmpty()) {
            return this.inputExtensions;
        }
        Translator translator = (Translator)this.getOrInstantiateBuildTool();
        if (translator != null) {
            return this.getProgrammaticExtensions(translator.getInputTypes());
        }
        return Collections.emptySet();
    }

    public boolean isPreprocessor() {
        Set<String> in = this.getInputExtensions();
        Set<String> out = this.getOutputExtensions();
        if (in.size() >= 1 && in.size() == out.size()) {
            for (String inExtension : in) {
                if (out.contains(inExtension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<String> getProgrammaticExtensions(List<String> extensions) {
        LinkedHashSet<String> extensionSet = new LinkedHashSet<String>();
        for (String extension : extensions) {
            if (extension.startsWith(".")) {
                extensionSet.add(extension);
                continue;
            }
            extensionSet.add("." + extension);
        }
        return extensionSet;
    }

    private Set<String> addExtensions(List extensionHashes) {
        if (extensionHashes != null && extensionHashes.size() > 0) {
            LinkedHashSet<String> extensionSet = new LinkedHashSet<String>();
            for (int i = 0; i < extensionHashes.size(); ++i) {
                HashStructure hash;
                Object object = extensionHashes.get(i);
                if (!(object instanceof HashStructure) || !(hash = (HashStructure)object).containsKey("#text")) continue;
                String extension = hash.getObject("#text").toString();
                if (!extension.startsWith(".")) {
                    BuildSystemHook.logError("Translator definition in " + this.extensionId + " has extension without leading dot", this.extensionId);
                    extension = "." + extension;
                }
                extensionSet.add(extension);
            }
            return extensionSet;
        }
        return Collections.emptySet();
    }

    boolean handlesAnyExtension(Set<String> knownExtensions) {
        if (this.getInputExtensions().size() > 0) {
            for (String extension : this.getInputExtensions()) {
                if (!knownExtensions.contains(extension)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

