/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.quickdiff.QuickDiffManager;
import oracle.ide.quickdiff.QuickDiffOverview;
import oracle.ide.quickdiff.QuickDiffReference;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.vcs.VCSUtil;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.ColorConstants;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.AbstractFoldingMargin;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchModel;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.SectionView;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil2;

class QuickDiffMargin
extends AbstractFoldingMargin {
    static final String EDITOR_PROPERTY_QUICKDIFF_MARGIN = "quickdiff-margin";
    static final String EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN = "show-quickdiff-margin";
    static final String ENV_QUICKDIFF_THRESHOLD = "QuickDiff_Threshold";
    private final MouseHoverSupport _hoverSupport;
    private Context _ideContext;
    private DocumentListener _documentListener;
    private PeekListener _peekListener;
    private Timer _updateTimer;
    private SequenceCompareModel _compareModel;
    private PopupCodeWindow _popupWindow;
    private CodeEditor _codeEditor;
    private SequenceCompareDifference _currentDifference;
    private QuickDiffReference _reference;
    private Observer _referenceObserver;
    private Observer _referenceProviderObserver;
    private MouseListener _popupTriggerListener;
    private AncestorListener _ancestorListener;
    private NodeListener _nodeRenameListener;
    private int _minimumDifferenceHeight = 2;
    private boolean _paused;
    private QuickDiffOverview _overview;
    private boolean _turnedOff = false;
    private final Lock _executorLock = new ReentrantLock();
    private ThreadPoolExecutor _executor;
    private Integer _threshold;

    public QuickDiffMargin() {
        this.setBackground(UIManager.getColor("window"));
        this._hoverSupport = new MouseHoverSupport((Component)this, 500, false);
        this.setPreferredSize(new Dimension(5, 0));
    }

    private final Context getIDEContext() {
        BasicEditorPane editor = this.getEditorPane();
        if (this._ideContext == null && editor != null) {
            this._ideContext = CodeEditor.getContext((BasicEditorPane)editor);
        }
        return this._ideContext;
    }

    @Override
    public void installImpl(BasicEditorPane editor) {
        Timer updateTimer;
        QuickDiffManager.getInstance().runInitClosure();
        this._executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final ThreadFactory _delegate = Executors.defaultThreadFactory();

            @Override
            public final Thread newThread(Runnable r) {
                Thread t = this._delegate.newThread(r);
                t.setName("QuickDiffMargin");
                return t;
            }
        });
        this._updateTimer = updateTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QuickDiffMargin.this.updateQuickDiff();
            }
        });
        this._updateTimer.setRepeats(false);
        this._updateTimer.setCoalesce(true);
        this._documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        this.getDocument().addDocumentListener(this._documentListener);
        this._peekListener = new PeekListener();
        this.addMouseListener(this._peekListener);
        this.addMouseMotionListener(this._peekListener);
        this._hoverSupport.addMouseHoverListener((MouseHoverListener)this._peekListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(this._peekListener, 8L);
        this.updateContext();
        this._codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)this.getEditorPane());
        this._referenceObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        this.updateReferenceFromProvider();
        this._referenceProviderObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.updateReferenceFromProvider();
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        QuickDiffManager.getInstance().getProviderObservable().addObserver(this._referenceProviderObserver);
        this._nodeRenameListener = new NodeListener(){

            public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
                QuickDiffMargin.this.updateReferenceFromProvider();
                QuickDiffMargin.this.restartUpdateTimer();
            }
        };
        Context ideContext = this.getIDEContext();
        if (ideContext.getNode() != null) {
            ideContext.getNode().addNodeListener(this._nodeRenameListener);
        }
        this.getEditorPane().putClientProperty((Object)EDITOR_PROPERTY_QUICKDIFF_MARGIN, (Object)this);
        this.installComponent();
        this._overview = new QuickDiffOverview(this._codeEditor);
        this.updateMarginVisibility();
        this._popupTriggerListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.maybeTriggerPopup(me);
            }

            private void maybeTriggerPopup(MouseEvent me) {
                if (!me.isPopupTrigger()) {
                    return;
                }
                Context context = new Context(QuickDiffMargin.this.getIDEContext());
                context.setEvent((EventObject)me);
                CodeEditorGutter.getGutterContextMenu().show(context);
            }
        };
        this.addMouseListener(this._popupTriggerListener);
        this._ancestorListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ae) {
                QuickDiffMargin.this.updateTimerState();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ae) {
                QuickDiffMargin.this.updateTimerState();
            }

            @Override
            public void ancestorMoved(AncestorEvent ae) {
            }
        };
        this.addAncestorListener(this._ancestorListener);
    }

    final boolean isTurnedOff() {
        return this._turnedOff;
    }

    private final void updateReferenceFromProvider() {
        QuickDiffReferenceProvider provider;
        if (this._reference != null) {
            this._reference.deleteObserver(this._referenceObserver);
            this._reference.dispose();
        }
        QuickDiffReference quickDiffReference = this._reference = (provider = this.getProviderForURL(this.getURL())) != null ? provider.createReference(this.getURL()) : null;
        if (this._reference != null) {
            this._reference.addObserver(this._referenceObserver);
        }
    }

    private final QuickDiffReferenceProvider getProviderForURL(URL url) {
        QuickDiffReferenceProvider provider = QuickDiffManager.getInstance().getProviderObservable().getProvider();
        return url != null && provider != null && provider.isAvailable(url) ? provider : null;
    }

    private void restartUpdateTimer() {
        if (!this.isVisible()) {
            return;
        }
        if (this._paused) {
            return;
        }
        this._updateTimer.restart();
    }

    private void updateMarginVisibility() {
        this.updateMarginVisibility(EditorProperties.getProperties().getBooleanProperty(EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN));
    }

    private void updateMarginVisibility(boolean showMargin) {
        this.setVisible(showMargin);
        this._overview.setVisible(showMargin);
        this.updateTimerState();
    }

    private void updateTimerState() {
        if (this.isVisible()) {
            this._updateTimer.start();
        } else {
            this._updateTimer.stop();
            this._compareModel = null;
        }
    }

    private void installComponent() {
        Container leftMargin = (Container)this._codeEditor.getScrollableLeftMargin();
        if (leftMargin instanceof SectionView) {
            leftMargin = ((SectionView)leftMargin).getWrappedComponent();
        }
        if (!(leftMargin.getLayout() instanceof BorderLayout)) {
            Assert.fail();
            return;
        }
        Component center = ((BorderLayout)leftMargin.getLayout()).getLayoutComponent("Center");
        if (center == null) {
            Assert.fail();
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(center, "Center");
        panel.add((Component)this, "East");
        this.putClientProperty("quickdiff-center-component", panel);
        this.putClientProperty("decorated-center-component", center);
        leftMargin.remove(center);
        leftMargin.add((Component)panel, "Center");
    }

    private void updateContext() {
        this._ideContext = null;
        this.getIDEContext();
    }

    @Override
    protected void propertyChangeImpl(PropertyChangeEvent pce) {
        this.updateContext();
        if (pce.getPropertyName().equals(EDITOR_PROPERTY_SHOW_QUICKDIFF_MARGIN)) {
            this.updateMarginVisibility((Boolean)pce.getNewValue());
        }
    }

    private URL getURL() {
        Context ideContext = this.getIDEContext();
        Node node = ideContext != null ? ideContext.getNode() : null;
        return node != null ? node.getURL() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuickDiff() {
        this._executorLock.lock();
        try {
            URL url = this.getURL();
            if (url == null) {
                return;
            }
            final BasicDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            final QuickDiffReference reference = this._reference;
            if (reference == null) {
                this._compareModel = null;
                return;
            }
            if (this._executor == null) {
                return;
            }
            if (this._executor.getQueue().size() >= 1) {
                return;
            }
            this._executor.submit(new Runnable(){
                private boolean _expired;

                @Override
                public final void run() {
                    try {
                        final CompareModel compareModel = this.doInBackground();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public final void run() {
                                if (_expired) {
                                    return;
                                }
                                try {
                                    QuickDiffMargin.this._compareModel = (SequenceCompareModel)compareModel;
                                    QuickDiffMargin.this._overview.update(QuickDiffMargin.this._compareModel);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                QuickDiffMargin.this.repaint();
                            }
                        });
                    }
                    catch (Exception e) {
                        FeedbackManager.reportException((Throwable)e);
                    }
                }

                private final CompareModel doInBackground() throws Exception {
                    Node contextNode;
                    TextCompareContributor contributor1 = reference.getCompareContributor();
                    if (contributor1 == null) {
                        return null;
                    }
                    final String type = contributor1.getType();
                    final TextBuffer final_textBuffer = document.getTextBuffer();
                    TextCompareContributor contributor2 = new TextCompareContributor(){

                        public String getType() {
                            return type;
                        }

                        public TextBuffer getTextBuffer() {
                            return final_textBuffer;
                        }
                    };
                    Context ideContext = QuickDiffMargin.this.getIDEContext();
                    Node node = contextNode = ideContext != null ? ideContext.getNode() : null;
                    if (contextNode == null || !contextNode.isOpen()) {
                        this._expired = true;
                        return null;
                    }
                    if (this.thresholdExceeded(contributor1, contributor2)) {
                        QuickDiffMargin.this._turnedOff = true;
                        return null;
                    }
                    QuickDiffMargin.this._turnedOff = false;
                    CompareInvocation invocationContext = new CompareInvocation((Element)contextNode, Collections.singleton(CompareUtil2.getCompareMethodForType((CompareType)CompareType.TEXT)));
                    try {
                        return CompareUtil2.createCompareModel((CompareContributor)contributor1, (CompareContributor)contributor2, (CompareInvocation)invocationContext);
                    }
                    catch (ExpiredTextBufferException etbe) {
                        this._expired = true;
                        QuickDiffMargin.this.updateQuickDiff();
                        return null;
                    }
                }

                private boolean thresholdExceeded(TextCompareContributor contributor1, TextCompareContributor contributor2) {
                    int c1 = contributor1.getTextBuffer().getLength();
                    int c2 = contributor2.getTextBuffer().getLength();
                    if (QuickDiffMargin.this._threshold == null) {
                        String strHold = System.getProperty(QuickDiffMargin.ENV_QUICKDIFF_THRESHOLD, "64");
                        try {
                            QuickDiffMargin.this._threshold = Integer.decode(strHold);
                        }
                        catch (NumberFormatException nfe) {
                            QuickDiffMargin.this._threshold = 64;
                        }
                    }
                    return (double)Math.abs(c2 - c1) > (double)QuickDiffMargin.this._threshold.intValue() * Math.pow(2.0, 10.0);
                }
            });
        }
        finally {
            this._executorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstallImpl(BasicEditorPane editor) {
        if (this._documentListener != null) {
            this.getDocument().removeDocumentListener(this._documentListener);
        }
        this._documentListener = null;
        if (this._peekListener != null) {
            this.removeMouseListener(this._peekListener);
            this.removeMouseMotionListener(this._peekListener);
            this._hoverSupport.removeMouseHoverListener((MouseHoverListener)this._peekListener);
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._peekListener);
        }
        this._peekListener = null;
        if (this._updateTimer != null) {
            this._updateTimer.stop();
        }
        this._updateTimer = null;
        if (this._reference != null) {
            this._reference.deleteObserver(this._referenceObserver);
            this._reference.dispose();
        }
        this._reference = null;
        this._referenceObserver = null;
        QuickDiffManager.getInstance().getProviderObservable().deleteObserver(this._referenceProviderObserver);
        this._referenceProviderObserver = null;
        Context ideContext = this.getIDEContext();
        if (ideContext.getNode() != null && this._nodeRenameListener != null) {
            ideContext.getNode().removeNodeListener(this._nodeRenameListener);
        }
        this._nodeRenameListener = null;
        this.getEditorPane().putClientProperty((Object)EDITOR_PROPERTY_QUICKDIFF_MARGIN, null);
        if (this._popupTriggerListener != null) {
            this.removeMouseListener(this._popupTriggerListener);
        }
        this._popupTriggerListener = null;
        if (this._ancestorListener != null) {
            this.removeAncestorListener(this._ancestorListener);
        }
        this._ancestorListener = null;
        if (this._overview != null) {
            this._overview.dispose();
            this._overview = null;
        }
        this.setVisible(false);
        this.deinstallComponent();
        this._codeEditor = null;
        this._executorLock.lock();
        try {
            if (this._executor != null) {
                this._executor.shutdown();
                this._executor = null;
            }
        }
        finally {
            this._executorLock.unlock();
        }
        this._ideContext = null;
    }

    private void deinstallComponent() {
        Container leftMargin = (Container)this._codeEditor.getScrollableLeftMargin();
        if (leftMargin instanceof SectionView) {
            leftMargin = ((SectionView)leftMargin).getWrappedComponent();
        }
        if (!(leftMargin.getLayout() instanceof BorderLayout)) {
            Assert.fail();
            return;
        }
        Component panel = (Component)this.getClientProperty("quickdiff-center-component");
        Component center = (Component)this.getClientProperty("decorated-center-component");
        if (panel == null || center == null) {
            Assert.fail();
            return;
        }
        if (((BorderLayout)leftMargin.getLayout()).getLayoutComponent("Center") != panel) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return;
        }
        leftMargin.remove(panel);
        leftMargin.add(center, "Center");
    }

    @Override
    protected Observer getCodeFoldingObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                QuickDiffMargin.this.repaint();
            }
        };
    }

    @Override
    public void paint(final Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.visitDifferences(new DifferenceVisitor(){

            @Override
            protected void visit(SequenceCompareDifference difference, int y, int height) {
                if (difference == QuickDiffMargin.this._currentDifference) {
                    g.setColor(QuickDiffMargin.this.processColorForMouseOver(QuickDiffMargin.getDifferenceColor(difference)));
                } else {
                    g.setColor(QuickDiffMargin.getDifferenceColor(difference));
                }
                g.fillRect(0, y, QuickDiffMargin.this.getWidth(), height);
            }
        }, VisitOrder.REVERSE);
    }

    private Color processColorForMouseOver(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        hsb[1] = Math.min(1.0f, hsb[1] * 2.0f);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    static Color getDifferenceColor(SequenceCompareDifference difference) {
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        if (difference.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-addition");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_ADDED;
        }
        if (difference.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-deletion");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_REMOVED;
        }
        if (difference.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            HighlightStyle style = highlightRegistry.lookupStyle("inline-compare-update");
            return style != null ? style.getBackgroundColor() : ColorConstants.COLOR_CHANGED;
        }
        Assert.fail();
        return Color.BLACK;
    }

    @Override
    protected final void updateFontMetrics() {
        super.updateFontMetrics();
        this._minimumDifferenceHeight = Math.max(2, this.getFontMetrics().getHeight() / 4);
    }

    private void visitDifferences(DifferenceVisitor visitor, VisitOrder order) {
        if (this._compareModel == null) {
            return;
        }
        List<SequenceCompareDifference> differences = Arrays.asList(this._compareModel.getDifferenceBlocks());
        if (order == VisitOrder.NATURAL) {
            // empty if block
        }
        if (order == VisitOrder.REVERSE) {
            differences = new ArrayList<SequenceCompareDifference>(differences);
            Collections.reverse(differences);
        }
        int lineHeight = this.getFontMetrics().getHeight();
        int yoffset = 0;
        try {
            yoffset = this.getEditorPane().modelToView((int)0).y;
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        for (SequenceCompareDifference difference : differences) {
            int startLine = this.getVirtualLineForReal(difference.getSecondStart());
            int endLine = this.getVirtualLineForReal(difference.getSecondStart() + difference.getSecondLength());
            int y = startLine * lineHeight + yoffset;
            int height = Math.max(this._minimumDifferenceHeight, (endLine - startLine) * lineHeight);
            visitor.visit(difference, y, height);
            if (!visitor.isExit()) continue;
            return;
        }
    }

    private void showOrHidePopupWindow(MouseEvent me) {
        if (this._compareModel == null) {
            this.hidePopupWindow();
            return;
        }
        if (this._currentDifference == null) {
            this.hidePopupWindow();
            return;
        }
        if (me == null) {
            Assert.fail();
            return;
        }
        PopupCodeWindow popupWindow = this.getPopupWindow();
        String text = QuickDiffMargin.getPatchText(this._compareModel, this._currentDifference);
        if (text == null) {
            return;
        }
        popupWindow.setText(text);
        popupWindow.setBackground(QuickDiffMargin.getDifferenceColor(this._currentDifference));
        Component c = (Component)this.getEditorPane().getProperty("code-folding-margin");
        if (c == null || !c.isVisible()) {
            c = this;
        }
        Point marginPos = c.getLocationOnScreen();
        int xPos = marginPos.x + c.getWidth();
        int yPos = marginPos.y + Math.max(this.getEditorPane().getVisibleRect().y, this.getYCoordinateFromLine(this._currentDifference.getSecondStart()));
        popupWindow.setLocation(xPos, yPos);
        Dimension contentSize = popupWindow.getContentPane().getPreferredSize();
        popupWindow.setSize(contentSize.width, contentSize.height);
        popupWindow.validate();
        popupWindow.setVisible(true);
    }

    static String getPatchText(SequenceCompareModel model, SequenceCompareDifference diff) {
        SequenceCompareModel compareModel = (SequenceCompareModel)model.createInstance((CompareDifference[])new SequenceCompareDifference[]{diff});
        try {
            PatchEntry patchEntry = PatchEngine.createPatchEntry((SequenceCompareModel)compareModel);
            PatchModel patchModel = new PatchModel();
            patchModel.addEntry(patchEntry);
            for (PatchHunk patchHunk : patchEntry.getHunks()) {
                for (PatchHunkLine patchHunkLine : patchHunk.getLines()) {
                    if (QuickDiffMargin.isEqualWhenIgnoringWhitespace(model, diff)) {
                        patchHunkLine.setLineData(QuickDiffMargin.replaceWhitespaceCharsForVisible(patchHunkLine.getLineData()));
                    }
                    patchHunkLine.setLineData(' ' + patchHunkLine.getLineData());
                }
            }
            PatchFormat patchFormat = new PatchFormat();
            TextCompareContributor referenceContributor = (TextCompareContributor)model.getContributor(ContributorKind.FIRST);
            if (referenceContributor instanceof InputStreamTextContributor) {
                patchFormat.setEncoding(((InputStreamTextContributor)referenceContributor).getStreamEncoding());
            }
            String patch = patchFormat.format(patchModel);
            String text = QuickDiffMargin.trimEndOfLineChars(patch.substring(patch.indexOf("@@ ")));
            return text;
        }
        catch (ExpiredTextBufferException etbe) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEqualWhenIgnoringWhitespace(SequenceCompareModel model, SequenceCompareDifference difference) {
        TextCompareContributor referenceContributor = (TextCompareContributor)model.getContributor(ContributorKind.FIRST);
        TextCompareContributor copyEditorContributor = (TextCompareContributor)model.getContributor(ContributorKind.SECOND);
        referenceContributor.setIgnoreWhitespace(true);
        copyEditorContributor.setIgnoreWhitespace(true);
        if (difference.getFirstLength() != difference.getSecondLength()) {
            return false;
        }
        referenceContributor.getTextBuffer().readLock();
        copyEditorContributor.getTextBuffer().readLock();
        try {
            int i = difference.getFirstStart();
            int j = difference.getSecondStart();
            while (i < difference.getFirstStart() + difference.getFirstLength()) {
                if (!referenceContributor.equal(i, (SequenceCompareContributor)copyEditorContributor, j)) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
                ++j;
            }
        }
        catch (ExpiredTextBufferException etbe) {
            boolean bl = false;
            return bl;
        }
        finally {
            referenceContributor.getTextBuffer().readUnlock();
            copyEditorContributor.getTextBuffer().readUnlock();
        }
        return true;
    }

    private static String replaceWhitespaceCharsForVisible(String s) {
        s = s.replace('\t', '\u00bb');
        s = s.replace(' ', '\u00b7');
        return s + '\u00b6';
    }

    private static String trimEndOfLineChars(String s) {
        int length;
        String endOfLineChars = "\r\f\n";
        for (length = s.length(); length > 0 && endOfLineChars.indexOf(s.charAt(length - 1)) >= 0; --length) {
        }
        return length >= s.length() ? s : s.substring(0, length);
    }

    private static String getDifferenceTextFromBuffer(SequenceCompareDifference difference, ContributorKind contributorKind, TextBuffer textBuffer) {
        int[] offsets = QuickDiffMargin.getDifferenceOffsets(difference, contributorKind, textBuffer);
        return offsets != null ? textBuffer.getString(offsets[0], offsets[1] - offsets[0]) : null;
    }

    private static int[] getDifferenceOffsets(SequenceCompareDifference difference, ContributorKind contributorKind, TextBuffer textBuffer) {
        int startLine = difference.getStart(contributorKind);
        int endLine = startLine + difference.getLength(contributorKind) - 1;
        if (endLine < startLine) {
            return null;
        }
        int startOffset = textBuffer.getLineMap().getLineStartOffset(startLine);
        int endOffset = textBuffer.getLineMap().getLineEndOffset(endLine);
        if ((endOffset = Math.min(endOffset, textBuffer.getLength())) < startOffset) {
            return null;
        }
        return new int[]{startOffset, endOffset};
    }

    private void hidePopupWindow() {
        if (this._popupWindow != null && this._popupWindow.isVisible()) {
            this._popupWindow.setVisible(false);
        }
    }

    private int getYCoordinateFromLine(int line) {
        BasicEditorPane editor = this.getEditorPane();
        BasicDocument document = this.getDocument();
        LineMap lineMap = document.getLineMap();
        try {
            int offset = Math.max(0, Math.min(document.getLength(), lineMap.getLineStartOffset(line)));
            Rectangle offsetRect = editor.modelToView(offset);
            return offsetRect.y;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private SequenceCompareDifference getFirstDifferenceAtY(final int y) {
        final SequenceCompareDifference[] difference = new SequenceCompareDifference[1];
        this.visitDifferences(new DifferenceVisitor(){

            @Override
            protected void visit(SequenceCompareDifference difference2, int y2, int height) {
                if (y >= y2 && y <= y2 + height) {
                    difference[0] = difference2;
                    this.exit();
                }
            }
        }, VisitOrder.NATURAL);
        return difference[0];
    }

    Action[] getEditActions(MouseEvent me) {
        SequenceCompareDifference difference = this.getFirstDifferenceAtY(me.getY());
        if (difference == null) {
            return null;
        }
        ArrayList<BaseEditAction> editActions = new ArrayList<BaseEditAction>();
        if (difference.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new DeleteAction(difference));
        }
        if (difference.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new InsertAction(difference));
        }
        if (difference.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
            editActions.add(new RevertAction(difference));
        }
        return editActions.toArray(new Action[0]);
    }

    private void updateCurrentDifference(MouseEvent me) {
        SequenceCompareDifference difference = me == null ? null : this.getFirstDifferenceAtY(me.getY());
        if (difference != this._currentDifference) {
            this._currentDifference = difference;
            this.repaint();
        }
    }

    private PopupCodeWindow getPopupWindow() {
        if (this._popupWindow == null) {
            BasicEditorPane editorPane = this.getEditorPane();
            this._popupWindow = new PopupCodeWindow(editorPane);
        }
        return this._popupWindow;
    }

    private static final class PopupCodeWindow
    extends JWindow {
        private JScrollPane _popupScrollPane;
        private BasicEditorPane _popupEditorPane;

        public PopupCodeWindow(BasicEditorPane editorPane) {
            super(SwingUtilities.getWindowAncestor((Component)editorPane));
            this.initializeFrom(editorPane);
        }

        public void setText(String text) {
            this._popupEditorPane.setText(text);
        }

        public String getText() {
            return this._popupEditorPane.getText();
        }

        @Override
        public void setBackground(Color color) {
            super.setBackground(color);
            this._popupScrollPane.setBackground(color);
        }

        public Insets getPopupInsets() {
            Insets ret = super.getInsets();
            for (Object c = this._popupEditorPane; c != this; c = c.getParent()) {
                Insets insets = c.getInsets();
                ret.top += insets.top;
                ret.left += insets.left;
                ret.bottom += insets.bottom;
                ret.right += insets.right;
            }
            return ret;
        }

        private void initializeFrom(BasicEditorPane editorPane) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            LanguageSupport support = document.getLanguageSupport();
            LanguageSupport popupSupport = LanguageModule.createSupportForFileType(support.getClass());
            BasicDocument popupDocument = new BasicDocument();
            popupDocument.setLanguageSupport(popupSupport);
            this._popupEditorPane = new BasicEditorPane();
            this._popupEditorPane.setDocument((Document)popupDocument);
            this._popupEditorPane.setBorder(BorderFactory.createEmptyBorder());
            this._popupEditorPane.setOpaque(false);
            Border outerBorder = UIManager.getBorder("ToolTip.border");
            this._popupScrollPane = new JScrollPane((Component)this._popupEditorPane);
            this._popupScrollPane.setBorder(outerBorder);
            this._popupScrollPane.setBackground(UIManager.getColor("ToolTip.background"));
            Insets editorInsets = editorPane.getInsets();
            Border innerBorder = BorderFactory.createEmptyBorder(0, editorInsets.left, 0, editorInsets.right);
            this._popupScrollPane.setViewportBorder(innerBorder);
            this._popupScrollPane.getViewport().setOpaque(false);
            this.getContentPane().add(this._popupScrollPane);
            this.setFocusableWindowState(false);
        }
    }

    private class PeekListener
    extends MouseInputAdapter
    implements MouseHoverListener,
    AWTEventListener {
        private PeekListener() {
        }

        public void mouseHovered(MouseEvent event) {
            QuickDiffMargin.this.showOrHidePopupWindow(event);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(event);
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            QuickDiffMargin.this.updateCurrentDifference(null);
            QuickDiffMargin.this.showOrHidePopupWindow(null);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (!QuickDiffMargin.this.isShowing()) {
                return;
            }
        }
    }

    private class RevertAction
    extends BaseEditAction {
        RevertAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(5), difference);
        }
    }

    private class InsertAction
    extends BaseEditAction {
        InsertAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(4), difference);
        }
    }

    private class DeleteAction
    extends BaseEditAction {
        DeleteAction(SequenceCompareDifference difference) {
            super(QuickDiffArb.getString(3), difference);
        }
    }

    private abstract class BaseEditAction
    extends AbstractAction {
        private final SequenceCompareDifference _difference;

        BaseEditAction(String name, SequenceCompareDifference difference) {
            super(name);
            this._difference = difference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            int editorStartOffset;
            int[] editorOffsets;
            int[] referenceOffsets;
            URL url = QuickDiffMargin.this.getURL();
            if (url != null && URLFileSystem.isReadOnly((URL)url) && !VCSUtil.checkOutOnUndoStack((Node)QuickDiffMargin.this.getIDEContext().getNode())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (QuickDiffMargin.this._compareModel == null) {
                return;
            }
            TextBuffer referenceTextBuffer = ((TextCompareContributor)QuickDiffMargin.this._compareModel.getContributor(ContributorKind.FIRST)).getTextBuffer();
            TextBuffer editorTextBuffer = QuickDiffMargin.this.getDocument().getTextBuffer();
            try {
                referenceTextBuffer.readLock();
                editorTextBuffer.readLock();
                try {
                    referenceOffsets = QuickDiffMargin.getDifferenceOffsets(this._difference, ContributorKind.FIRST, referenceTextBuffer);
                    editorOffsets = QuickDiffMargin.getDifferenceOffsets(this._difference, ContributorKind.SECOND, editorTextBuffer);
                    editorStartOffset = editorTextBuffer.getLineMap().getLineStartOffset(this._difference.getSecondStart());
                }
                finally {
                    referenceTextBuffer.readUnlock();
                    editorTextBuffer.readUnlock();
                }
            }
            catch (ExpiredTextBufferException etbe) {
                return;
            }
            QuickDiffMargin.this._paused = true;
            QuickDiffMargin.this.getEditorPane().beginEdit(new EditDescriptor((String)this.getValue("Name")));
            try {
                if (editorOffsets != null) {
                    editorTextBuffer.remove(editorOffsets[0], editorOffsets[1] - editorOffsets[0]);
                }
                if (referenceOffsets != null) {
                    editorTextBuffer.insert(editorStartOffset, referenceTextBuffer.getChars(referenceOffsets[0], referenceOffsets[1] - referenceOffsets[0]));
                }
            }
            finally {
                QuickDiffMargin.this.getEditorPane().endEdit(false, null);
                QuickDiffMargin.this._paused = false;
                QuickDiffMargin.this.restartUpdateTimer();
            }
        }
    }

    private static enum VisitOrder {
        NATURAL,
        REVERSE;

    }

    private abstract class DifferenceVisitor {
        private boolean _exit;

        private DifferenceVisitor() {
        }

        protected abstract void visit(SequenceCompareDifference var1, int var2, int var3);

        protected final void exit() {
            this._exit = true;
        }

        boolean isExit() {
            return this._exit;
        }
    }
}

