/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractFoldingMargin
extends JComponent
implements EditorPlugin {
    protected BasicEditorPane _editor;
    protected FontMetrics _fontMetrics;
    private CodeFoldingModel _codeFoldingModel;
    private CodeFoldingMargin _codeFoldingMargin;
    private CodeFoldingListener _codeFoldingListener;
    private Observer _codeFoldingObserver;

    public final void install(BasicEditorPane editor) {
        this._editor = editor;
        this.updateFontMetrics();
        this._codeFoldingListener = new CodeFoldingListener(editor);
        this._codeFoldingObserver = this.getCodeFoldingObserver();
        if (this._codeFoldingObserver != null) {
            this._codeFoldingListener.addObserver(this._codeFoldingObserver);
        }
        this.updateCodeFolding();
        this.installImpl(editor);
    }

    protected abstract Observer getCodeFoldingObserver();

    protected final Map<Integer, Integer> getCollapsedBlocks() {
        if (this._codeFoldingListener != null) {
            return this._codeFoldingListener.getCollapsedBlocks();
        }
        Map<Integer, Integer> collapsedBlocks = Collections.emptyMap();
        return collapsedBlocks;
    }

    private void updateCodeFolding() {
        if (this._codeFoldingMargin != null) {
            this._codeFoldingMargin.removeCodeExpansionListener((CodeExpansionListener)this._codeFoldingListener);
        }
        if (this._codeFoldingModel != null) {
            this._codeFoldingModel.removeCodeFoldingModelListener((CodeFoldingModelListener)this._codeFoldingListener);
        }
        if (this._editor != null) {
            this._codeFoldingMargin = (CodeFoldingMargin)this._editor.getProperty("code-folding-margin");
            this._codeFoldingModel = (CodeFoldingModel)this._editor.getProperty("code-folding-model");
        } else {
            this._codeFoldingMargin = null;
            this._codeFoldingModel = null;
        }
        this._codeFoldingListener.setCodeFoldingModel(this._codeFoldingModel);
        if (this._codeFoldingMargin != null) {
            this._codeFoldingMargin.addCodeExpansionListener((CodeExpansionListener)this._codeFoldingListener);
        }
        if (this._codeFoldingModel != null) {
            this._codeFoldingModel.addCodeFoldingModelListener((CodeFoldingModelListener)this._codeFoldingListener);
        }
        this._codeFoldingListener.rebuildFoldingFromScratch();
    }

    public final void deinstall(BasicEditorPane editor) {
        this.deinstallImpl(editor);
        if (this._codeFoldingObserver != null) {
            this._codeFoldingListener.deleteObserver(this._codeFoldingObserver);
        }
        this._codeFoldingObserver = null;
        this._editor = null;
        this.updateCodeFolding();
        this._codeFoldingListener = null;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("code-folding-margin-visible") || propertyName.equals("code-folding-model")) {
            this.updateCodeFolding();
            this.repaintComponent();
        }
        if (propertyName.equals("editor-font") || propertyName.equals("editor-font-family") || propertyName.equals("font-helper") || propertyName.equals("editor-font-size")) {
            this.updateFontMetrics();
            this.repaintComponent();
        }
        this.propertyChangeImpl(event);
    }

    protected void updateFontMetrics() {
        if (this._editor == null) {
            return;
        }
        Font font = this._editor.getFont();
        this._fontMetrics = font != null ? this.getFontMetrics(font) : null;
    }

    protected final FontMetrics getFontMetrics() {
        return this._fontMetrics;
    }

    protected void repaintComponent() {
        this.repaint();
    }

    protected final BasicEditorPane getEditorPane() {
        return this._editor;
    }

    protected final BasicDocument getDocument() {
        BasicEditorPane editor = this.getEditorPane();
        return editor != null ? (BasicDocument)editor.getDocument() : null;
    }

    protected void installImpl(BasicEditorPane editor) {
    }

    protected void deinstallImpl(BasicEditorPane editor) {
    }

    protected void propertyChangeImpl(PropertyChangeEvent event) {
    }

    protected final int getVirtualLineForReal(int line) {
        return this.getVirtualLineForReal(line, this.getCollapsedBlocks());
    }

    private int getVirtualLineForReal(int line, Map<Integer, Integer> collapsedBlocks) {
        int virtualLine = line;
        for (Map.Entry<Integer, Integer> entry : collapsedBlocks.entrySet()) {
            if (line < entry.getKey() - 1) break;
            if (entry.getKey() - 1 < line && line < entry.getValue() - 1) {
                virtualLine -= line - (entry.getKey() - 1);
                break;
            }
            if (entry.getValue() - 1 > line) continue;
            virtualLine -= entry.getValue() - entry.getKey();
        }
        return virtualLine;
    }

    private static final class CodeFoldingListener
    extends Observable
    implements CodeExpansionListener,
    CodeFoldingModelListener {
        private final BasicEditorPane _editor;
        private final Map<Integer, Integer> _collapsedBlocks = new TreeMap<Integer, Integer>();
        private CodeFoldingModel _codeFoldingModel = null;

        public CodeFoldingListener(BasicEditorPane editor) {
            this._editor = editor;
        }

        public void setCodeFoldingModel(CodeFoldingModel codeFoldingModel) {
            this._codeFoldingModel = codeFoldingModel;
        }

        public Map<Integer, Integer> getCollapsedBlocks() {
            return this._collapsedBlocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void codeExpanded(CodeExpansionEvent event) {
            if (this._codeFoldingModel != null) {
                this._codeFoldingModel.readLock();
                try {
                    Object block = event.getBlock();
                    this.removeCollapsedBlock(block);
                    this.addCollapsedChildren(block);
                }
                finally {
                    this._codeFoldingModel.readUnlock();
                }
            }
            this._notifyObservers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void codeCollapsed(CodeExpansionEvent event) {
            if (this._codeFoldingModel != null) {
                this._codeFoldingModel.readLock();
                try {
                    Object block = event.getBlock();
                    this.removeCollapsedChildren(block);
                    this.addCollapsedBlock(block);
                }
                finally {
                    this._codeFoldingModel.readUnlock();
                }
            }
            this._notifyObservers();
        }

        public void structureChanged(CodeFoldingModelEvent event) {
            this.rebuildFoldingFromScratch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rebuildFoldingFromScratch() {
            this._collapsedBlocks.clear();
            if (this._codeFoldingModel != null) {
                this._codeFoldingModel.readLock();
                try {
                    Object root = this._codeFoldingModel.getRoot();
                    if (root != null) {
                        this.addCollapsedChildren(root);
                    }
                }
                finally {
                    this._codeFoldingModel.readUnlock();
                }
            }
            this._notifyObservers();
        }

        private void addCollapsedChildren(Object parent) {
            Iterator it = this._codeFoldingModel.getChildren(parent);
            while (it.hasNext()) {
                Object child = it.next();
                if (this._codeFoldingModel.isExpanded(child)) {
                    this.addCollapsedChildren(child);
                    continue;
                }
                this.addCollapsedBlock(child);
            }
        }

        private void removeCollapsedChildren(Object parent) {
            Iterator it = this._codeFoldingModel.getChildren(parent);
            while (it.hasNext()) {
                Object child = it.next();
                if (this._codeFoldingModel.isExpanded(child)) {
                    this.removeCollapsedChildren(child);
                    continue;
                }
                this.removeCollapsedBlock(child);
            }
        }

        private void addCollapsedBlock(Object block) {
            int[] offsets = this._codeFoldingModel.getTextOffsets(block, null);
            int startLine = this._editor.getLineFromOffset(offsets[0]) + 1;
            int endLine = this._editor.getLineFromOffset(offsets[1]) + 1;
            Integer key = startLine;
            Integer value = endLine;
            this._collapsedBlocks.put(key, value);
        }

        private void removeCollapsedBlock(Object block) {
            int[] offsets = this._codeFoldingModel.getTextOffsets(block, null);
            int startLine = this._editor.getLineFromOffset(offsets[0]) + 1;
            Integer key = startLine;
            this._collapsedBlocks.remove(key);
        }

        private void _notifyObservers() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

