/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.Component;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JLabeledRadioButton;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.resource.ADABundle;
import oracle.ide.util.TriStateBoolean;

public class JTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final boolean _isMotif;
    private int _lastRowWithFocus = -1;
    private JLabeledCheckBox _lcb = new JLabeledCheckBox();
    private JSelectableLabel _sl = new JSelectableLabel();
    private JLabeledRadioButton _lrb = new JLabeledRadioButton();

    public JTreeCellRenderer() {
        this._isMotif = "Motif".equalsIgnoreCase(UIManager.getLookAndFeel().getID());
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (hasFocus) {
            this._lastRowWithFocus = row;
        }
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (!(value instanceof JMutableTreeNode)) {
            return this;
        }
        JTreeCellData treeCellData = ((JMutableTreeNode)value).getModel();
        if (treeCellData == null) {
            return this;
        }
        boolean hasCheckBox = treeCellData.getHasCheckBox();
        boolean hasRadioButton = treeCellData.getHasRadioButton();
        if (hasCheckBox) {
            this._lcb.checkBox.setBorderPaintedFlat(true);
            this._lcb.checkBox.setFocusPainted(false);
            this._lcb.label.setHeightAdjustment(treeCellData.getHeightAdjustment());
            if (!tree.isEnabled()) {
                this._lcb.label.setEnabled(false);
                this._lcb.checkBox.setEnabled(false);
            } else {
                this._lcb.label.setEnabled(treeCellData.isTextEnabled());
                this._lcb.checkBox.setEnabled(treeCellData.isCheckBoxEnabled());
            }
            this._lcb.label.setSelected(selected);
            this._lcb.label.setText(treeCellData.getText());
            this._lcb.label.setIcon(treeCellData.getIcon());
            this._lcb.label.setHasFocus(hasFocus);
            this._lcb.setToolTipText(treeCellData.getToolTipText());
            TriStateBoolean checkBoxTriState = treeCellData.getCheckBoxState();
            boolean isCheckboxSelected = false;
            if (!checkBoxTriState.isTriState()) {
                isCheckboxSelected = checkBoxTriState.booleanValue();
            }
            this._lcb.getAccessibleContext().setAccessibleName(treeCellData.getText());
            if (hasFocus) {
                this._lcb.getAccessibleContext().firePropertyChange("AccessibleState", isCheckboxSelected ? null : AccessibleState.CHECKED, isCheckboxSelected ? AccessibleState.CHECKED : null);
                String notChecked = ADABundle.get("ADA_UNCHECKED_STATE");
                tree.getAccessibleContext().firePropertyChange("AccessibleDescription", isCheckboxSelected ? notChecked : AccessibleState.CHECKED.toDisplayString(), isCheckboxSelected ? AccessibleState.CHECKED.toDisplayString() : notChecked);
            }
            ButtonModel bm = this._lcb.checkBox.getModel();
            if (!checkBoxTriState.isTriState()) {
                JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, checkBoxTriState.booleanValue(), treeCellData);
            } else if (treeCellData.isArmed() && treeCellData.isPressed()) {
                if (!this._isMotif) {
                    this._lcb.checkBox.setEnabled(false);
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, true, true);
                } else {
                    this._lcb.checkBox.setEnabled(true);
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, false, true, true);
                }
            } else {
                this._lcb.checkBox.setEnabled(true);
                if (!this._isMotif) {
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, true, true);
                } else {
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, false, false);
                }
            }
            return this._lcb;
        }
        if (hasRadioButton) {
            this._lrb.label.setHeightAdjustment(treeCellData.getHeightAdjustment());
            if (!tree.isEnabled() || !treeCellData.isInternalRadioEnabled()) {
                this._lrb.label.setEnabled(false);
                this._lrb.radioButton.setEnabled(false);
            } else {
                this._lrb.label.setEnabled(treeCellData.isTextEnabled());
                this._lrb.radioButton.setEnabled(treeCellData.isRadioButtonEnabled());
            }
            this._lrb.label.setSelected(selected);
            this._lrb.label.setText(treeCellData.getText());
            this._lrb.label.setIcon(treeCellData.getIcon());
            this._lrb.label.setHasFocus(hasFocus);
            this._lrb.radioButton.setSelected(treeCellData.isRadioButtonSelected());
            this._lrb.setToolTipText(treeCellData.getToolTipText());
            this._lrb.getAccessibleContext().setAccessibleName(treeCellData.getText());
            JTreeCellRenderer.setButtonModelState(this._lrb.radioButton, treeCellData);
            return this._lrb;
        }
        this._sl.setHeightAdjustment(treeCellData.getHeightAdjustment());
        this._sl.setEnabled(tree.isEnabled() ? treeCellData.isTextEnabled() : false);
        this._sl.setSelected(selected);
        this._sl.setText(treeCellData.getText());
        this._sl.getAccessibleContext().setAccessibleName(treeCellData.getText());
        this._sl.setIcon(treeCellData.getIcon());
        this._sl.setHasFocus(hasFocus);
        this._sl.setToolTipText(treeCellData.getToolTipText());
        return this._sl;
    }

    private static void setCheckBoxState(JCheckBox cb, boolean selected, boolean pressed, boolean armed) {
        JTreeCellRenderer.setCheckBoxSelected(cb, selected);
        JTreeCellRenderer.setButtonModelState(cb, pressed, armed);
    }

    private static void setCheckBoxState(JCheckBox cb, boolean selected, JTreeCellData treeCellData) {
        JTreeCellRenderer.setCheckBoxSelected(cb, selected);
        JTreeCellRenderer.setButtonModelState(cb, treeCellData);
    }

    private static void setCheckBoxSelected(JCheckBox cb, boolean selected) {
        cb.setSelected(selected);
    }

    private static void setButtonModelState(AbstractButton button, JTreeCellData treeCellData) {
        JTreeCellRenderer.setButtonModelState(button, treeCellData.isPressed(), treeCellData.isArmed());
    }

    private static void setButtonModelState(AbstractButton button, boolean pressed, boolean armed) {
        ButtonModel bm = button.getModel();
        bm.setArmed(armed);
        bm.setPressed(pressed);
    }

    public int getLastRowWithFocus() {
        return this._lastRowWithFocus;
    }
}

