/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.marshal.xml.Array2Dom;
import oracle.ide.marshal.xml.ClassLoaderHelper;
import oracle.ide.marshal.xml.Color2Dom;
import oracle.ide.marshal.xml.File2Dom;
import oracle.ide.marshal.xml.HashMapProxy;
import oracle.ide.marshal.xml.HashStructure2Dom;
import oracle.ide.marshal.xml.List2Dom;
import oracle.ide.marshal.xml.Map2Dom;
import oracle.ide.marshal.xml.MarshalArb;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.marshal.xml.Object2String2Dom;
import oracle.ide.marshal.xml.ObjectComparator;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.Set2Dom;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.marshal.xml.ToDomConverter2;
import oracle.ide.marshal.xml.URL2Dom;
import oracle.ide.marshal.xml.XMLObjectStore;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public final class Object2Dom
extends XMLObjectStore {
    public static final int REPORT_NO_ERRORS = 0;
    public static final int REPORT_WELL_FORMED_ERRORS = 1;
    public static final int REPORT_VALIDATION_ERRORS = 2;
    public static final int REPORT_DATA_CONSTRAINT_ERRORS = 3;
    public static final String ID_ATTR = "id";
    public static final String IDREF_ATTR = "idref";
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String ITEM_TAG = "Item";
    public static final HashSet<String> obsoleteClassNames = new HashSet();
    private static final Class _toDomConverterClass = ToDomConverter.class;
    private static final Class _hashMapProxyClass = HashMapProxy.class;
    private static final ArrayList _exemptFromIdref = new ArrayList(7);
    private static final List<ToDomConverter> _converters = new CopyOnWriteArrayList<ToDomConverter>();
    private static final HashMap _doctypes = new HashMap();
    private static final HashMap _xmlns = new HashMap();
    private final boolean _useIdNumbers;
    private final boolean _namedArrayElems;
    private final boolean _nullIfEmpty;
    private final boolean _includeNulls;
    private final boolean _includeClassAttrs;
    private Map _objectToElement;
    private Map _elementToId;
    private Map _idToObject;
    private URL _documentURL;
    private XMLDocument _xmlDocument;
    private String _encoding;
    private String _publicID;
    private String _systemID;
    private String _namespaceURI;
    private DTD _dtd = new DTD();
    private boolean _dtdOverridden = false;
    private int _reportLevel;
    private Object2DomLogger _logger;
    private HashSet<String> _temporaryIgnoreClassNames = new HashSet();

    private Object2Dom(boolean useIdNumbers, boolean namedArrayElems, boolean nullIfEmpty, boolean includeNulls, boolean includeClassAttrs) {
        this._useIdNumbers = useIdNumbers;
        this._namedArrayElems = namedArrayElems;
        this._nullIfEmpty = nullIfEmpty;
        this._includeNulls = includeNulls;
        this._includeClassAttrs = includeClassAttrs;
    }

    public static Object2Dom newInstance() {
        return new Object2Dom(true, false, false, true, true);
    }

    public static Object2Dom newInstanceForSchemaCompiledBeans() {
        return new Object2Dom(false, true, true, false, false);
    }

    public XMLDocument toDocument(Object object, String rootTag, URL outURL) throws IOException {
        return this.toDocument(object, rootTag, null, outURL);
    }

    public XMLDocument toDocument(Object object, String rootTag, Class defaultClass, URL outURL) throws IOException {
        this.setDocumentURL(outURL);
        XMLDocument xmlDocument = this.toDocument(object, rootTag, defaultClass);
        XMLUtil.writeXML(xmlDocument, outURL);
        return xmlDocument;
    }

    public XMLDocument toDocument(Object object, String rootTag) {
        return this.toDocument(object, rootTag, (Class)null);
    }

    public XMLDocument toDocument(Object object, String rootTag, Class defaultClass) {
        if (rootTag == null) {
            throw new NullPointerException("Root tag is null.");
        }
        this._objectToElement = new TreeMap(new ObjectComparator());
        this._elementToId = new HashMap();
        this._xmlDocument = new XMLDocument();
        this._xmlDocument.setVersion("1.0");
        this._xmlDocument.setEncoding(this.getEncoding());
        if (ModelUtil.hasLength((String)this._systemID)) {
            this._xmlDocument.setDoctype(rootTag, this._systemID, this._publicID);
        }
        Element rootElement = this.toElement(object, rootTag, defaultClass, this._namespaceURI, false);
        this._xmlDocument.appendChild((Node)rootElement);
        return this._xmlDocument;
    }

    @Deprecated
    public Object toObject(InputStream inputStream, Class defaultClass) throws IOException {
        return this.toObject(this.getDocument(inputStream, null), defaultClass);
    }

    public Object toObject(InputStream inputStream, Class defaultClass, ClassLoader cl) throws IOException {
        return this.toObject(this.getDocument(inputStream, null), defaultClass, cl);
    }

    @Deprecated
    public Object toObject(Reader reader, Class defaultClass) throws IOException {
        return this.toObject(this.getDocument(null, reader), defaultClass);
    }

    public Object toObject(Reader reader, Class defaultClass, ClassLoader cl) throws IOException {
        return this.toObject(this.getDocument(null, reader), defaultClass, cl);
    }

    public Object toObject(URL url, ClassLoader cl) throws IOException {
        return this.toObject(url, null, cl);
    }

    public Object toObject(URL url) throws IOException {
        return this.toObject(url, null, this.getClass().getClassLoader());
    }

    public Object toObject(URL url, Class defaultClass, ClassLoader loader) throws IOException {
        this.setDocumentURL(url);
        Object object = this.toObject(this.getDocument(url), defaultClass, loader);
        return object;
    }

    public Object toObject(URL url, Class defaultClass) throws IOException {
        return this.toObject(url, defaultClass, this.getClass().getClassLoader());
    }

    public Object toObject(XMLDocument document) {
        return this.toObject(document, null);
    }

    public Object toObject(XMLDocument document, Class defaultClass, ClassLoader loader) {
        Object object = this.toObject(this.initAndGetRootElement((Document)document), defaultClass, false, loader);
        if (this._logger != null) {
            this._logger.logXMLDocument(document);
        }
        return object;
    }

    @Deprecated
    public Object toObject(XMLDocument document, Class defaultClass) {
        return this.toObject(document, defaultClass, defaultClass != null ? defaultClass.getClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    public String getEncoding() {
        return this._encoding != null ? this._encoding : "UTF-8";
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setDoctypeID(String publicID, String systemID) {
        this._publicID = publicID;
        this._systemID = publicID != null ? (systemID != null ? systemID : "") : systemID;
    }

    public void setDTD(DTD dtd) {
        this._dtd = dtd;
        this._dtdOverridden = true;
    }

    public void setNamespaceURI(String namespaceURI) {
        this._namespaceURI = namespaceURI;
    }

    public void setLogger(int reportLevel, Object2DomLogger logger) {
        if (reportLevel < 0 || reportLevel > 3) {
            throw new IllegalArgumentException("Invalid report level");
        }
        this._reportLevel = reportLevel;
        this._logger = logger;
    }

    public void setTemporaryIgnoreClassNames(Collection<String> tempIgnoreClasses) {
        this._temporaryIgnoreClassNames.addAll(tempIgnoreClasses);
    }

    public static void registerConverter(ToDomConverter converter) {
        if (!_converters.contains(converter)) {
            _converters.add(converter);
        }
    }

    public static void registerDoctype(Class objectClass, String rootName, String publicID, String systemID) {
        Doctype doctype = new Doctype(rootName, publicID, systemID);
        _doctypes.put(objectClass, doctype);
    }

    public static void registerNamespaceElem(Class objectClass, String namespaceURI, String localElemName) {
        if (ModelUtil.hasLength((String)namespaceURI)) {
            _xmlns.put(objectClass, new NSElem(namespaceURI, localElemName));
        }
    }

    public static void exemptTypeFromIdref(Class type) {
        _exemptFromIdref.add(type);
    }

    public boolean isNamedArrayElems() {
        return this._namedArrayElems;
    }

    public boolean isNullIfEmpty() {
        return this._nullIfEmpty;
    }

    public boolean isIncludeNulls() {
        return this._includeNulls;
    }

    @Deprecated
    public Element toElement(Object object, String tag, Class defaultClass) {
        new UnsupportedOperationException("The method Object2Dom.toElement(Object, String, Class) has been deprecated.  Calls to this method will produce incorrect results.  Please update your code.").printStackTrace();
        return this.toElement(object, tag, defaultClass, null);
    }

    public Element toElement(Object object, String tag, Class defaultClass, String namespaceURI) {
        return this.toElement(object, tag, defaultClass, namespaceURI, this._nullIfEmpty);
    }

    public Object toObject(Element element, Class defaultClass, ClassLoader loader) {
        return this.toObject(element, defaultClass, true, loader);
    }

    @Deprecated
    public Object toObject(Element element, Class defaultClass) {
        return this.toObject(element, defaultClass, true, this.getClass().getClassLoader());
    }

    public static NodeList getChildrenByTagName(Element element, String tag) {
        if (element instanceof XMLElement) {
            return ((XMLElement)element).getChildrenByTagName(tag);
        }
        throw new UnsupportedOperationException("Not implemented without Oracle XML parser.");
    }

    public void marshalAttributes(Element element, Object object) {
        if (element == null || object == null) {
            return;
        }
        PropertyIterator pi = new PropertyIterator(object);
        while (pi.hasNext()) {
            Class propertyClass;
            Object propertyValue;
            String attributeValue;
            PropertyInfo propertyInfo = pi.next();
            if (!propertyInfo.isAttribute() || (attributeValue = ToStringManager.toString((Object)(propertyValue = propertyInfo.getPropertyValue(object)), (Class)(propertyClass = propertyInfo.getPropertyClass()))) == null) continue;
            String propertyName = propertyInfo.getXMLName();
            element.setAttribute(propertyName, attributeValue);
        }
    }

    public void unmarshalAttributes(Element element, Object object) {
        PropertyIterator pi = new PropertyIterator(object);
        while (pi.hasNext()) {
            PropertyInfo propertyInfo = pi.next();
            if (!propertyInfo.isAttribute()) continue;
            String propertyName = propertyInfo.getXMLName();
            Attr attr = element.getAttributeNode(propertyName);
            if (attr == null) {
                this.setPropertyValue(propertyInfo, object, null, element);
                continue;
            }
            String attrValue = attr.getValue();
            Class propertyClass = propertyInfo.getPropertyClass();
            Object propertyObject = ToStringManager.fromString((String)attrValue, (Class)propertyClass);
            this.setPropertyValue(propertyInfo, object, propertyObject, attr);
        }
    }

    public Object load(URL url) throws IOException {
        Object object = this.toObject(url);
        this.flush();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open(URL url, Object object) throws IOException {
        String key = this.getClass().getName() + ".open." + url;
        PerformanceLogger.get().startTiming(key);
        try {
            Element rootElement;
            block9: {
                String classAttrStr;
                block8: {
                    this.setDocumentURL(url);
                    rootElement = this.initAndGetRootElement((Document)this.getDocument(url));
                    classAttrStr = this.getClassAttr(rootElement);
                    if (ModelUtil.hasLength((String)classAttrStr)) break block8;
                    boolean bl = false;
                    PerformanceLogger.get().stopTiming(key, "Loaded " + URLFileSystem.getFileName((URL)url));
                    this.flush();
                    return bl;
                }
                rootElement = this.applyTransforms(rootElement, null, null);
                classAttrStr = this.getClassAttr(rootElement);
                if (object.getClass().getName().equals(classAttrStr)) break block9;
                boolean bl = false;
                PerformanceLogger.get().stopTiming(key, "Loaded " + URLFileSystem.getFileName((URL)url));
                this.flush();
                return bl;
            }
            try {
                this.initObject(rootElement, object, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                this.logOtherExceptionImpl(e);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            PerformanceLogger.get().stopTiming(key, "Loaded " + URLFileSystem.getFileName((URL)url));
            this.flush();
        }
    }

    public boolean save(URL url, Object object) throws IOException {
        String rootElementName;
        if (object == null) {
            return false;
        }
        Assert.startTiming((String)(this.getClass().getName() + ".save." + url), null, (boolean)false);
        Class<?> objClass = object.getClass();
        NSElem nsElem = (NSElem)_xmlns.get(objClass);
        if (nsElem != null) {
            rootElementName = nsElem.localElemName;
        } else {
            Doctype doctype = (Doctype)_doctypes.get(object.getClass());
            if (doctype == null) {
                throw this.newO2DException("Cannot save the specified object because no namespace or doctype is registered", null);
            }
            this.setDoctypeID(doctype.publicID, doctype.systemID);
            rootElementName = doctype.rootName;
        }
        this.toDocument(object, rootElementName, url);
        this.flush();
        Assert.endTiming((String)(this.getClass().getName() + ".save." + url), (String)("Saved " + URLFileSystem.getPlatformPathName((URL)url)), (String)"  ", (boolean)false);
        return true;
    }

    public URL getDocumentURL() {
        return this._documentURL;
    }

    public void setDocumentURL(URL documentURL) {
        this._documentURL = documentURL;
    }

    @Override
    void logOtherExceptionImpl(Throwable t) {
        if (this._logger != null) {
            this._logger.logOtherException(t);
        } else {
            t.printStackTrace();
        }
    }

    private void logMessageImpl(String mesg) {
        if (this._logger != null) {
            this._logger.logMessage(mesg + "\n");
        } else {
            System.err.println(mesg);
        }
    }

    public Element toElement(XMLDocument document, Object object, String tag, Class defaultClass, String namespaceURI) {
        this._xmlDocument = document;
        if (this._objectToElement == null) {
            this._objectToElement = new TreeMap(new ObjectComparator());
        }
        if (this._elementToId == null) {
            this._elementToId = new HashMap();
        }
        return this.toElement(object, tag, defaultClass, namespaceURI, this._nullIfEmpty);
    }

    private Element toElement(Object object, String tag, Class defaultClass, String namespaceURI, boolean allowNullRoot) {
        Element element = Object2Dom.newElementNS(object, tag, defaultClass, (Document)this._xmlDocument, namespaceURI);
        if (object == null) {
            return element;
        }
        Class<?> objectClass = object.getClass();
        if (!(!this._useIdNumbers || defaultClass != null && defaultClass.isPrimitive() || Object2Dom.isExemptFromIdref(objectClass))) {
            if (this._objectToElement.containsKey(object)) {
                Element referencedElem = (Element)this._objectToElement.get(object);
                if (this._elementToId.containsKey(referencedElem)) {
                    Integer idref = (Integer)this._elementToId.get(referencedElem);
                    element.setAttribute(IDREF_ATTR, idref.toString());
                } else {
                    Integer id = this.assignNewId(referencedElem);
                    element.setAttribute(IDREF_ATTR, id.toString());
                }
                return element;
            }
            this.mapObjectToElement(object, element);
        }
        if (objectClass != ToStringManager.wrapPrimitive((Class)defaultClass)) {
            this.setClassAttr(element, objectClass);
        }
        ObjectWrapper wrapper = new ObjectWrapper(object);
        if (object instanceof ToDomConverter && ((ToDomConverter)object).toElement(wrapper, element, objectClass, this)) {
            return this.assignClassIfEmpty(element, objectClass, this._nullIfEmpty);
        }
        for (ToDomConverter converter : _converters) {
            if (!converter.toElement(wrapper, element, objectClass, this)) continue;
            return this.assignClassIfEmpty(element, objectClass, this._nullIfEmpty);
        }
        PropertyIterator pi = new PropertyIterator(object);
        while (pi.hasNext()) {
            Element childElement;
            PropertyInfo propertyInfo = pi.next();
            String propertyName = propertyInfo.getXMLName();
            Object propertyValue = propertyInfo.getPropertyValue(object);
            Class propertyClass = propertyInfo.getPropertyClass();
            if (propertyInfo.isAttribute()) {
                String attributeValue = ToStringManager.toString((Object)propertyValue, (Class)propertyClass);
                if (attributeValue == null) continue;
                element.setAttribute(propertyName, attributeValue);
                continue;
            }
            if (propertyValue == null && propertyInfo.isOmittedWhenNull() || propertyValue == null && !this._includeNulls || (childElement = this.toElement(propertyValue, propertyName, propertyClass, element.getNamespaceURI())) == null) continue;
            if (this._namedArrayElems && propertyValue.getClass().isArray()) {
                this.addArrayElems(childElement, element);
                continue;
            }
            element.appendChild(childElement);
        }
        return this.assignClassIfEmpty(element, objectClass, allowNullRoot);
    }

    private static boolean isExemptFromIdref(Class type) {
        int n = _exemptFromIdref.size();
        for (int i = 0; i < n; ++i) {
            if (type != _exemptFromIdref.get(i)) continue;
            return true;
        }
        return false;
    }

    private void addArrayElems(Element arrayElement, Element parent) {
        if (this._namedArrayElems) {
            NodeList nodeList = arrayElement.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = nodeList.item(0);
                parent.appendChild(child);
            }
        } else {
            parent.appendChild(arrayElement);
        }
    }

    public Object toObject(Element element, Class defaultClass, boolean nullIfEmpty, ClassLoader loader, boolean setup) {
        if (setup) {
            this._idToObject = new HashMap(257);
        }
        return this.toObject(element, defaultClass, nullIfEmpty, loader);
    }

    private Object toObject(Element element, Class defaultClass, boolean nullIfEmpty, ClassLoader loader) {
        String idrefStr;
        if (this._useIdNumbers && ModelUtil.hasLength((String)(idrefStr = element.getAttribute(IDREF_ATTR)))) {
            Integer idref = Integer.valueOf(idrefStr);
            Object object = this._idToObject.get(idref);
            if (object == null) {
                try {
                    XMLDocument doc = (XMLDocument)element.getOwnerDocument();
                    Element elementWithID = (Element)doc.selectSingleNode("//*[@id='" + idrefStr + "']");
                    Object objectWithID = this.toObject(elementWithID, defaultClass, nullIfEmpty, loader);
                    this._idToObject.put(idref, objectWithID);
                    return objectWithID;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return object;
        }
        if (!this._includeClassAttrs && defaultClass == null) {
            Assert.println((String)"if _includeClassAttrs is false, defaultClass must not be null!");
        }
        if (nullIfEmpty) {
            String classAttrStr = this.getClassAttr(element);
            boolean hasClassAttr = classAttrStr != null;
            NamedNodeMap attrs = element.getAttributes();
            if (!(element.hasChildNodes() || hasClassAttr || attrs != null && attrs.getLength() != 0)) {
                return null;
            }
        }
        try {
            ObjectWrapper wrapper;
            ToDomConverter object;
            element = this.applyTransforms(element, defaultClass, null);
            String updatedClassAttrStr = this.getClassAttr(element);
            Class objectClass = Object2Dom.getClassObject(updatedClassAttrStr, loader, defaultClass);
            if (_toDomConverterClass.isAssignableFrom(objectClass) && (object = (ToDomConverter)objectClass.newInstance()).toObject(wrapper = new ObjectWrapper(object), element, objectClass, this)) {
                return this.mapIdToObject(this.getId(element), wrapper.getObject());
            }
            ObjectWrapper wrapper2 = new ObjectWrapper();
            for (ToDomConverter converter : _converters) {
                if (!(converter instanceof ToDomConverter2 ? ((ToDomConverter2)converter).toObject(wrapper2, element, objectClass, this, loader) : converter.toObject(wrapper2, element, objectClass, this))) continue;
                return this.mapIdToObject(this.getId(element), wrapper2.getObject());
            }
            Object object2 = objectClass.newInstance();
            return this.initObject(element, object2, loader);
        }
        catch (ClassNotFoundException e) {
            String message = e.getMessage();
            String className = null;
            String[] parts = message.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                String[] parts2;
                if (parts[i].trim().length() == 0 || !parts[i].trim().startsWith("Missing") || (parts2 = parts[i].split(":")).length <= 1) continue;
                className = parts2[1].trim();
                break;
            }
            if (!(className == null && message != null && this._temporaryIgnoreClassNames.contains(message) || className != null && obsoleteClassNames.contains(className))) {
                this.logMessageImpl(MarshalArb.format(0, message));
                this.logMessageImpl(MarshalArb.getString(1));
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.logOtherExceptionImpl(e);
        }
        return null;
    }

    private void mapObjectToElement(Object object, Element element) {
        this._objectToElement.put(object, element);
    }

    private Object mapIdToObject(Integer id, Object object) {
        if (this._useIdNumbers && id != null) {
            this._idToObject.put(id, object);
        }
        return object;
    }

    private Integer getId(Element element) {
        String idStr;
        if (this._useIdNumbers && ModelUtil.hasLength((String)(idStr = element.getAttribute(ID_ATTR)))) {
            return Integer.valueOf(idStr);
        }
        return null;
    }

    private Integer assignNewId(Element element) {
        Integer id = new Integer(this._elementToId.size());
        element.setAttribute(ID_ATTR, id.toString());
        this._elementToId.put(element, id);
        return id;
    }

    String getClassAttr(Element element) {
        return this._includeClassAttrs ? ModelUtil.nullifyIfEmpty((String)element.getAttribute("class")) : null;
    }

    void setClassAttr(Element element, Class objectClass) {
        if (this._includeClassAttrs) {
            element.setAttribute("class", objectClass != _hashMapProxyClass ? objectClass.getName() : "java.util.HashMap");
        }
    }

    private static Class getClassObject(String classStr, ClassLoader loader, Class defaultClass) throws ClassNotFoundException {
        ClassLoader classloader = ClassLoaderHelper.getClassLoader(classStr) != null ? ClassLoaderHelper.getClassLoader(classStr) : loader;
        return classStr != null ? Class.forName(classStr, true, classloader) : defaultClass;
    }

    private static Element newElementNS(Object o, String qname, Class defaultClass, Document doc, String parentNamespaceURI) {
        Class<?> cls = o != null ? o.getClass() : defaultClass;
        NSElem nsElem = (NSElem)_xmlns.get(cls);
        if (nsElem != null) {
            String localElemName = nsElem.localElemName;
            Element elem = doc.createElementNS(nsElem.namespaceURI, localElemName);
            elem.setAttribute("nselem", localElemName);
            return elem;
        }
        return doc.createElementNS(parentNamespaceURI, qname);
    }

    private Element assignClassIfEmpty(Element element, Class objectClass, boolean nullIfEmpty) {
        NamedNodeMap attrs;
        if (!(element.hasChildNodes() || (attrs = element.getAttributes()) != null && attrs.getLength() != 0)) {
            if (nullIfEmpty) {
                return null;
            }
            this.setClassAttr(element, objectClass);
        }
        return element;
    }

    private XMLDocument getDocument(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        return this.getDocument(URLFileSystem.openInputStream((URL)url), null);
    }

    private XMLDocument getDocument(InputStream inputStream, Reader reader) throws IOException {
        Assert.precondition((boolean)(inputStream == null ^ reader == null));
        DOMParser domParser = new DOMParser();
        domParser.setPreserveWhitespace(false);
        if (this._reportLevel > 0) {
            domParser.setDebugMode(true);
        }
        if (this._dtd != null) {
            domParser.setDoctype(this._dtd);
        }
        if (this._dtdOverridden && this._reportLevel >= 2) {
            domParser.setValidationMode(2);
        }
        BufferedInputStream bis = null;
        BufferedReader br = null;
        try {
            if (inputStream != null) {
                bis = new BufferedInputStream(inputStream);
                domParser.parse((InputStream)bis);
            } else {
                br = new BufferedReader(reader);
                domParser.parse((Reader)br);
            }
            XMLDocument xMLDocument = domParser.getDocument();
            return xMLDocument;
        }
        catch (XMLParseException e) {
            if (this.isLoggingParseErrors()) {
                this._logger.logXMLParseException(e);
            }
            throw this.newO2DException("Error parsing XML", (Exception)((Object)e));
        }
        catch (SAXParseException e) {
            if (this.isLoggingParseErrors()) {
                this._logger.logSAXParseException(e);
            }
            throw this.newO2DException("Error parsing XML", e);
        }
        catch (Exception e) {
            if (this.isLoggingParseErrors()) {
                this._logger.logOtherException(e);
            }
            e.printStackTrace();
            throw this.newO2DException("Error parsing XML", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Object2DomException newO2DException(String message, Exception cause) {
        try {
            URL url = this.getDocumentURL();
            if (url != null) {
                message = message + " -- " + URLFileSystem.getPlatformPathName((URL)url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Object2DomException(message, cause);
    }

    private boolean isLoggingParseErrors() {
        return this._logger != null && this._reportLevel > 0;
    }

    private void flush() {
        if (this._objectToElement != null) {
            this._objectToElement.clear();
        }
        if (this._elementToId != null) {
            this._elementToId.clear();
        }
        if (this._idToObject != null) {
            this._idToObject.clear();
        }
        this.setDocumentURL(null);
    }

    private Element initAndGetRootElement(Document document) {
        this._idToObject = new HashMap(257);
        this._xmlDocument = null;
        return document.getDocumentElement();
    }

    private Object initObject(Element element, Object object, ClassLoader loader) {
        this.mapIdToObject(this.getId(element), object);
        try {
            PropertyIterator pi = new PropertyIterator(object);
            while (pi.hasNext()) {
                PropertyInfo propertyInfo = pi.next();
                String propertyName = propertyInfo.getXMLName();
                if (propertyInfo.isAttribute()) {
                    Attr attr = element.getAttributeNode(propertyName);
                    if (attr == null) {
                        this.setPropertyValue(propertyInfo, object, null, element);
                        continue;
                    }
                    String attrValue = attr.getValue();
                    Class propertyClass = propertyInfo.getPropertyClass();
                    Object propertyObject = ToStringManager.fromString((String)attrValue, (Class)propertyClass);
                    this.setPropertyValue(propertyInfo, object, propertyObject, attr);
                    continue;
                }
                NodeList nodeList = Object2Dom.getChildrenByTagName(element, propertyName);
                int nodeListLen = nodeList.getLength();
                if (nodeListLen < 1) continue;
                if (!this._namedArrayElems && nodeListLen > 1) {
                    IllegalStateException e = new IllegalStateException("Named property '" + propertyName + "' is not unique.");
                    this.logOtherExceptionImpl(e);
                    continue;
                }
                Element propertyElement = (Element)nodeList.item(0);
                Class propertyClass = propertyInfo.getPropertyClass();
                Object propertyObject = this.toObject(propertyElement, propertyClass, loader);
                this.setPropertyValue(propertyInfo, object, propertyObject, propertyElement);
            }
            return object;
        }
        catch (Exception e) {
            this.logOtherExceptionImpl(e);
            return null;
        }
    }

    private void setPropertyValue(PropertyInfo propertyInfo, Object object, Object property, Node curNode) {
        Throwable t = null;
        try {
            propertyInfo.setPropertyValue(object, property);
            return;
        }
        catch (InvocationTargetException e) {
            t = e.getTargetException();
        }
        catch (Exception e) {
            t = e;
        }
        if (this.isLoggingDataConstraintsErrors()) {
            int line = -1;
            int col = -1;
            if (curNode instanceof XMLNode) {
                XMLNode xmlNode = (XMLNode)curNode;
                line = xmlNode.getLineNumber();
                col = xmlNode.getColumnNumber();
            }
            this._logger.logUnmarshalException(line, col, t);
        }
    }

    private boolean isLoggingDataConstraintsErrors() {
        return this._logger != null && this._reportLevel == 3;
    }

    static {
        Object2Dom.registerConverter(new URL2Dom());
        Object2Dom.registerConverter(new File2Dom());
        Object2Dom.registerConverter(new Object2String2Dom());
        Object2Dom.registerConverter(new Array2Dom());
        Object2Dom.registerConverter(new List2Dom());
        Object2Dom.registerConverter(new Map2Dom());
        Object2Dom.registerConverter(new Set2Dom());
        Object2Dom.registerConverter(new HashStructure2Dom());
        Object2Dom.registerConverter(new Color2Dom());
        Object2Dom.exemptTypeFromIdref(String.class);
        Object2Dom.exemptTypeFromIdref(Class.class);
        Object2Dom.exemptTypeFromIdref(URL.class);
        Object2Dom.exemptTypeFromIdref(Boolean.class);
    }

    private static class Doctype {
        final String rootName;
        final String publicID;
        final String systemID;

        Doctype(String rootName, String publicID, String systemID) {
            this.rootName = rootName;
            this.publicID = publicID;
            this.systemID = systemID;
        }
    }

    private static class NSElem {
        final String namespaceURI;
        final String localElemName;

        NSElem(String namespaceURI, String localElemName) {
            this.namespaceURI = namespaceURI;
            this.localElemName = localElemName;
        }
    }
}

