/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileChangesExpiredException;
import oracle.ide.file.FileScope;
import oracle.ide.file.FileSetTable;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntHashMap;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.ResultCollector;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;

final class IndexIdTable {
    private static final AssemblyFactory ASSEMBLY_FACTORY = new IndexIdTableAssemblyFactory();
    public static final byte STORAGE_CODE = 82;
    private static final Set<String> FILE_QUERIES = new HashSet<String>(Arrays.asList("file.all", "file.name", "file.extension", "file.modified.after", "file.modified.at.or.after", "file.modified.at.or.before", "file.modified.before", "file.name.contains", "file.name.starts.with", "file.name.ends.with", "file.size.equals", "file.size.greater", "file.size.greater.or.equal", "file.size.less", "file.size.less.or.equal"));
    private final FileSetTable fileTable;
    private final int version;
    private final long cookie;
    private final int nextId;
    private final IntHashMap<Integer> indexIdToFileId;
    private final IntHashMap<Integer> fileIdToIndexId;
    private final IntHashMap<Long> timestamps;

    public static IndexIdTable getInstance(FileSetTable fileTable, byte[] tableData, int version, long cookie) throws InterruptedException, AssemblyException, IOException, FileChangesExpiredException {
        final IntHashMap timestamps = new IntHashMap();
        final IndexIdTableData data = tableData != null ? (IndexIdTableData)ASSEMBLY_FACTORY.assemble(tableData) : new IndexIdTableData();
        final int[] newVersion = new int[1];
        final long[] newCookie = new long[1];
        FileChangeListener listener = new FileChangeListener(){

            public void filesChanged(FileScope scope, FileChanges changes) {
                newVersion[0] = changes.getVersion();
                newCookie[0] = changes.getCookie();
                block4: for (FileChange change : changes) {
                    switch (change.getChangeType()) {
                        case ADDED: 
                        case MODIFIED: 
                        case BUFFER_MODIFIED: {
                            int id = data.nextId++;
                            data.indexIdToFileId.put(id, (Object)change.getId());
                            timestamps.put(id, (Object)change.getLastModified());
                            Integer oldId = (Integer)data.fileIdToIndexId.get(change.getId());
                            if (oldId != null) {
                                data.indexIdToFileId.remove(oldId.intValue());
                            }
                            data.fileIdToIndexId.put(change.getId(), (Object)id);
                            break;
                        }
                        case REMOVED: {
                            Integer oldId = (Integer)data.fileIdToIndexId.remove(change.getId());
                            if (oldId == null) continue block4;
                            data.indexIdToFileId.remove(oldId.intValue());
                            break;
                        }
                    }
                }
            }
        };
        fileTable.getChangesSince(version, cookie, listener);
        return new IndexIdTable(fileTable, newVersion[0], newCookie[0], data.nextId, (IntHashMap<Integer>)data.indexIdToFileId, (IntHashMap<Integer>)data.fileIdToIndexId, (IntHashMap<Long>)timestamps);
    }

    private IndexIdTable(FileSetTable fileTable, int version, long cookie, int nextId, IntHashMap<Integer> indexIdToFileId, IntHashMap<Integer> fileIdToIndexId, IntHashMap<Long> timestamps) {
        this.fileTable = fileTable;
        this.version = version;
        this.cookie = cookie;
        this.nextId = nextId;
        this.indexIdToFileId = indexIdToFileId;
        this.fileIdToIndexId = fileIdToIndexId;
        this.timestamps = timestamps;
        fileTable.activate();
    }

    public byte[] save() throws AssemblyException {
        IndexIdTableData data = new IndexIdTableData(this.nextId, this.indexIdToFileId, (IntHashMap<Integer>)new IntHashMap());
        return ASSEMBLY_FACTORY.disassemble((Object)data);
    }

    public long getVersion() {
        return this.version;
    }

    public long getCookie() {
        return this.cookie;
    }

    public FileSetTable getFileTable() {
        return this.fileTable;
    }

    public int[] getChangedFiles() throws InterruptedException {
        if (this.timestamps != null) {
            int[] changes = new int[this.timestamps.size()];
            int i = 0;
            Iterator i$ = this.timestamps.keySet().iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                changes[i++] = id;
            }
            return changes;
        }
        return new int[0];
    }

    public boolean isValid(int id) {
        return this.indexIdToFileId == null ? false : this.indexIdToFileId.containsKey(id);
    }

    public int getFileTableId(int id) {
        Integer fileId;
        if (this.indexIdToFileId != null && (fileId = (Integer)this.indexIdToFileId.get(id)) != null) {
            return fileId;
        }
        return -1;
    }

    public URL getFileURL(int id) throws InterruptedException {
        Integer fileId;
        if (this.indexIdToFileId != null && (fileId = (Integer)this.indexIdToFileId.get(id)) != null) {
            try {
                return this.fileTable.getURL(fileId.intValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public long getTimestamp(int id) {
        Long l;
        if (this.timestamps != null && (l = (Long)this.timestamps.get(id)) != null) {
            return l;
        }
        return -1L;
    }

    void query(QueryCriteria criteria, ResultCollector results, boolean endResults) throws InterruptedException, QueryFailedException {
        QueryCriteria copy = new QueryCriteria();
        copy.putAll(criteria);
        this.handleNameAndExtensionQueries(copy, results, endResults);
        Set entries = copy.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (!IndexIdTable.isFileQuery(key)) continue;
            results.startResultSet(endResults && !iterator.hasNext());
            this.handleQuery((String)key, (String)entry.getValue(), results);
            results.endResultSet();
        }
    }

    public void release() {
        this.fileTable.deactivate();
    }

    void dump() {
        if (!IndexLogger.getLogger().isLoggable(Level.FINEST)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Index ID table for " + this.fileTable + ":\n");
        if (this.indexIdToFileId.isEmpty()) {
            builder.append(" <Emtpy>");
        } else {
            Iterator keyIterator = this.indexIdToFileId.keySet().iterator();
            while (keyIterator.hasNext()) {
                int indexId = (Integer)keyIterator.next();
                int fileId = (Integer)this.indexIdToFileId.get(indexId);
                builder.append(" " + indexId + " -> " + fileId + "\n");
            }
        }
        IndexLogger.getLogger().finest(builder.toString());
    }

    static boolean isFileQuery(Object key) {
        return FILE_QUERIES.contains(key);
    }

    private void handleNameAndExtensionQueries(QueryCriteria criteria, ResultCollector results, boolean endResults) throws InterruptedException, QueryFailedException {
        try {
            String name = (String)criteria.remove("file.name");
            String extension = (String)criteria.remove("file.extension");
            if (name != null) {
                String[] extensions = extension == null ? null : extension.split("\\|");
                results.startResultSet(endResults && criteria.isEmpty());
                for (URL url : this.fileTable.getFiles()) {
                    Integer indexId;
                    String fileName = URLFileSystem.getFileName((URL)url);
                    String suffix = URLFileSystem.getSuffix((URL)url);
                    if (!(fileName = fileName.substring(0, fileName.length() - suffix.length())).equals(name)) continue;
                    boolean match = false;
                    if (extensions == null) {
                        match = true;
                    } else {
                        for (String current : extensions) {
                            if (!suffix.equalsIgnoreCase(current)) continue;
                            match = true;
                            break;
                        }
                    }
                    if (!match) continue;
                    int fileId = this.fileTable.getId(url);
                    if (fileId == -1 || (indexId = (Integer)this.fileIdToIndexId.get(fileId)) == null) break;
                    results.add("file.name", indexId, url);
                    break;
                }
                results.endResultSet();
            }
        }
        catch (IOException e) {
            throw new QueryFailedException(e);
        }
    }

    private void handleQuery(String key, String value, ResultCollector results) throws InterruptedException, QueryFailedException {
        try {
            if ("file.extension".equals(key)) {
                if (value != null) {
                    String[] extensions = value.split("\\|");
                    block2: for (URL url : this.fileTable.getFiles()) {
                        String suffix = URLFileSystem.getSuffix((URL)url);
                        for (String current : extensions) {
                            Integer indexId;
                            int fileId;
                            if (!suffix.equalsIgnoreCase(current) || (fileId = this.fileTable.getId(url)) == -1 || (indexId = (Integer)this.fileIdToIndexId.get(fileId)) == null) continue;
                            results.add(key, indexId, url);
                            continue block2;
                        }
                    }
                }
            } else if ("file.name.starts.with".equals(key)) {
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    URL url = this.fileTable.getURL(fileId);
                    if (url == null) continue;
                    String fileName = URLFileSystem.getFileName((URL)url);
                    String suffix = URLFileSystem.getSuffix((URL)url);
                    String name = fileName.substring(0, fileName.length() - suffix.length());
                    if (!name.toLowerCase().startsWith(value.toLowerCase())) continue;
                    results.add(key, indexId, url);
                }
            } else if ("file.name.ends.with".equals(key)) {
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    URL url = this.fileTable.getURL(fileId);
                    if (url == null) continue;
                    String fileName = URLFileSystem.getFileName((URL)url);
                    String suffix = URLFileSystem.getSuffix((URL)url);
                    String name = fileName.substring(0, fileName.length() - suffix.length());
                    if (!name.toLowerCase().endsWith(value.toLowerCase())) continue;
                    results.add(key, indexId, url);
                }
            } else if ("file.name.contains".equals(key)) {
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    URL url = this.fileTable.getURL(fileId);
                    if (url == null) continue;
                    String fileName = URLFileSystem.getFileName((URL)url);
                    String suffix = URLFileSystem.getSuffix((URL)url);
                    String name = fileName.substring(0, fileName.length() - suffix.length());
                    if (!name.toLowerCase().contains(value.toLowerCase())) continue;
                    results.add(key, indexId, url);
                }
            } else if ("file.size.equals".equals(key)) {
                long targetLength = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long length = this.fileTable.getLength(fileId);
                    if (length != targetLength) continue;
                    results.add(key, indexId);
                }
            } else if ("file.size.greater".equals(key)) {
                long targetLength = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long length = this.fileTable.getLength(fileId);
                    if (length <= targetLength) continue;
                    results.add(key, indexId);
                }
            } else if ("file.size.greater.or.equal".equals(key)) {
                long targetLength = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long length = this.fileTable.getLength(fileId);
                    if (length < targetLength) continue;
                    results.add(key, indexId);
                }
            } else if ("file.size.less".equals(key)) {
                long targetLength = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long length = this.fileTable.getLength(fileId);
                    if (length >= targetLength) continue;
                    results.add(key, indexId);
                }
            } else if ("file.size.less.or.equal".equals(key)) {
                long targetLength = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long length = this.fileTable.getLength(fileId);
                    if (length > targetLength) continue;
                    results.add(key, indexId);
                }
            } else if ("file.modified.after".equals(key)) {
                long targetModified = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long lastModified = this.fileTable.getLastModified(fileId);
                    if (lastModified <= targetModified) continue;
                    results.add(key, indexId);
                }
            } else if ("file.modified.at.or.after".equals(key)) {
                long targetModified = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long lastModified = this.fileTable.getLastModified(fileId);
                    if (lastModified < targetModified) continue;
                    results.add(key, indexId);
                }
            } else if ("file.modified.before".equals(key)) {
                long targetModified = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long lastModified = this.fileTable.getLastModified(fileId);
                    if (lastModified >= targetModified) continue;
                    results.add(key, indexId);
                }
            } else if ("file.modified.at.or.before".equals(key)) {
                long targetModified = Long.parseLong(value);
                Iterator i$ = this.indexIdToFileId.keySet().iterator();
                while (i$.hasNext()) {
                    int indexId = (Integer)i$.next();
                    int fileId = (Integer)this.indexIdToFileId.get(indexId);
                    long lastModified = this.fileTable.getLastModified(fileId);
                    if (lastModified > targetModified) continue;
                    results.add(key, indexId);
                }
            }
        }
        catch (IOException e) {
            throw new QueryFailedException(e);
        }
    }

    private static final class IndexIdTableAssemblyFactory
    extends ObjectFactory {
        private IndexIdTableAssemblyFactory() {
        }

        public byte getObjectCode() {
            return 82;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            int[] values;
            int nextId = input.readInt();
            IntHashMap indexIdToFileId = new IntHashMap();
            IntHashMap fileIdToIndexId = new IntHashMap();
            int[] keys = (int[])VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY.assemble(input);
            if (keys.length != (values = (int[])VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY.assemble(input)).length) {
                throw new AssemblyException("invalid ID table", (AssemblyFactory)this);
            }
            for (int i = 0; i < keys.length; ++i) {
                indexIdToFileId.put(keys[i], (Object)values[i]);
                fileIdToIndexId.put(values[i], (Object)keys[i]);
            }
            return new IndexIdTableData(nextId, (IntHashMap<Integer>)indexIdToFileId, (IntHashMap<Integer>)fileIdToIndexId);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            IndexIdTableData data = (IndexIdTableData)object;
            output.writeInt(data.nextId);
            IntHashMap indexIdToFileId = data.indexIdToFileId;
            int[] keys = new int[indexIdToFileId.size()];
            int[] values = new int[indexIdToFileId.size()];
            int i = 0;
            for (Integer key : indexIdToFileId.keySet()) {
                keys[i] = key;
                values[i++] = (Integer)indexIdToFileId.get(key.intValue());
            }
            VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY.disassemble((Object)keys, output);
            VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY.disassemble((Object)values, output);
        }
    }

    private static final class IndexIdTableData {
        private int nextId;
        private final IntHashMap<Integer> indexIdToFileId;
        private final IntHashMap<Integer> fileIdToIndexId;

        IndexIdTableData() {
            this(0, (IntHashMap<Integer>)new IntHashMap(), (IntHashMap<Integer>)new IntHashMap());
        }

        IndexIdTableData(int nextId, IntHashMap<Integer> indexIdToFileId, IntHashMap<Integer> fileIdToIndexId) {
            this.nextId = nextId;
            this.indexIdToFileId = indexIdToFileId;
            this.fileIdToIndexId = fileIdToIndexId;
        }
    }
}

