/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.file.FileSet;
import oracle.ide.file.FileSetTable;
import oracle.ide.file.Path;
import oracle.ide.file.ProjectCache;
import oracle.ide.index.Index;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.index.QueryProgress;
import oracle.ide.index.QueryResult;
import oracle.ide.index.ReentrantLockException;
import oracle.ide.index.ReentrantQueryException;
import oracle.ide.index.ResultCallback;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.ApplicationContent;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ideimpl.index.BlockingQueueResultCallback;
import oracle.ideimpl.index.BuildFailedException;
import oracle.ideimpl.index.DataLocator;
import oracle.ideimpl.index.IndexIdTable;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexProgressMonitor;
import oracle.ideimpl.index.IndexRoot;
import oracle.ideimpl.index.IndexingClient;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.ideimpl.index.NullResultCallback;
import oracle.ideimpl.index.QueryResultImpl;
import oracle.ideimpl.index.ResultCollector;
import oracle.ideimpl.index.task.BackgroundTaskImpl;
import oracle.ideimpl.index.task.ProgressMonitor;
import oracle.javatools.data.PropertyStorage;
import org.openide.util.RequestProcessor;

public class IndexImpl
implements Index {
    protected static final ExecutorService QUERY_SCHEDULER = new RequestProcessor("Index Query", 3, true);
    private static final Set<String> OPTIMIZED_FILE_QUERIES = new HashSet<String>(Arrays.asList("file.all", "file.name", "file.extension"));
    private static final String[] FILE_QUERIES = new String[]{"file.all", "file.extension", "file.modified.after", "file.modified.at.or.after", "file.modified.at.or.before", "file.modified.before", "file.name", "file.name.contains", "file.name.starts.with", "file.name.ends.with", "file.size.equals", "file.size.greater", "file.size.greater.or.equal", "file.size.less", "file.size.less.or.equal"};
    private final IndexRoot[] roots;
    private final Workspace workspace;
    private final Project project;
    private volatile boolean released;
    private final AtomicInteger lockCount = new AtomicInteger();
    private final FeedbackLogOptions created = new FeedbackLogOptions((Throwable)new IllegalStateException(), 3);

    private static Path getContentPath(Workspace workspace, ContentSet content) {
        return IndexImpl.getPath(ContentSetRoot.getContentSetRoots((Workspace)workspace, (ContentSet)content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path getContentPath(Workspace workspace, Project project) {
        ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);
        try {
            Path path = cache.getContentPath(project);
            return path;
        }
        finally {
            cache.close();
        }
    }

    private static Path getContentPath(Project project, ContentSet content) {
        return IndexImpl.getPath(ContentSetRoot.getContentSetRoots((Project)project, (ContentSet)content));
    }

    private static Path getPath(Collection<ContentSetRoot> roots) {
        Path path = Path.getInstance((int)roots.size());
        for (ContentSetRoot root : roots) {
            path.add(root.asFileSet());
        }
        return path;
    }

    public IndexImpl(Workspace workspace) {
        this(workspace, ApplicationContent.getInstance((PropertyStorage)workspace).getAllContents());
    }

    public IndexImpl(Workspace workspace, ContentSet content) {
        this(workspace, null, IndexImpl.getContentPath(workspace, content));
    }

    public IndexImpl(Workspace workspace, URLPath path) {
        this(workspace, null, Path.getInstance((URLPath)path));
    }

    public IndexImpl(Workspace workspace, URL url) {
        this(workspace, null, FileSet.getInstance((URL)url));
    }

    public IndexImpl(Workspace workspace, Project project) {
        this(workspace, project, IndexImpl.getContentPath(workspace, project));
        this.created.setApiDepth(Integer.valueOf(4));
    }

    public IndexImpl(Workspace workspace, Project project, ContentSet content) {
        this(workspace, project, IndexImpl.getContentPath(project, content));
    }

    public IndexImpl(Workspace workspace, Project project, Path path) {
        this.workspace = workspace;
        this.project = project;
        this.roots = new IndexRoot[path.size()];
        for (int i = 0; i < this.roots.length; ++i) {
            this.roots[i] = IndexRoot.getIndexRoot(workspace, project, (FileSet)path.get(i));
        }
    }

    public IndexImpl(Workspace workspace, Project project, FileSet fileSet) {
        this(workspace, project, Path.getInstance((FileSet[])new FileSet[]{fileSet}));
    }

    public IndexImpl(Workspace workspace, Project project, URLPath path) {
        this(workspace, project, Path.getInstance((URLPath)path));
    }

    public IndexImpl(Workspace workspace, Project project, URL url) {
        this(workspace, project, Path.getInstance((FileSet[])new FileSet[]{FileSet.getInstance((URL)url)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws InterruptedException, LockFailedException {
        int i;
        if (IndexingClient.isRunning()) {
            throw new ReentrantLockException();
        }
        boolean success = false;
        boolean[] locked = new boolean[this.roots.length];
        try {
            for (i = 0; i < this.roots.length; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.roots[i].lock();
                locked[i] = true;
            }
            this.lockCount.incrementAndGet();
            success = true;
        }
        finally {
            if (!success) {
                for (i = 0; i < this.roots.length; ++i) {
                    if (!locked[i]) continue;
                    this.roots[i].unlock();
                }
            }
        }
    }

    @Override
    public void unlock() {
        if (this.lockCount.decrementAndGet() < 0) {
            throw new IllegalStateException("Index not locked");
        }
        for (IndexRoot root : this.roots) {
            root.unlock();
        }
    }

    @Override
    public BackgroundTask build() {
        IndexProgressMonitor progress = new IndexProgressMonitor();
        IndexBuilder builder = new IndexBuilder(progress);
        Future<?> future = QUERY_SCHEDULER.submit(builder);
        return new IndexTask(future, progress);
    }

    @Override
    public void blockingBuild() throws InterruptedException {
        if (!IndexingClient.isRunning()) {
            this.checkEventThread();
            this.buildImpl(null);
        }
    }

    private void buildImpl(IndexProgressMonitor progress) throws InterruptedException {
        int total = 0;
        int[] numFilesToIndex = new int[this.roots.length];
        for (int i = 0; i < this.roots.length; ++i) {
            numFilesToIndex[i] = this.roots[i].getChangedFileCount();
            total += numFilesToIndex[i];
        }
        if (total > 0) {
            int current = 0;
            if (progress != null) {
                progress.setTotal(total);
                current = progress.getCurrentValue();
            }
            for (int i = 0; i < this.roots.length; ++i) {
                this.roots[i].update(progress);
                if (progress == null) continue;
                progress.setCurrentValue(current += numFilesToIndex[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryImpl(QueryCriteria criteria, ResultCallback<QueryResult> callback, IndexProgressMonitor progress) throws InterruptedException, QueryFailedException {
        block11: {
            boolean complete = false;
            PerformanceLogger.get().startTiming("IndexImpl.queryImpl");
            try {
                int i;
                if (IndexImpl.isFileOnlyQuery(criteria)) {
                    this.handleFileOnlyQuery(criteria, callback, progress);
                    return;
                }
                QueryCriteria copy = new QueryCriteria();
                copy.putAll(criteria);
                QueryCriteria fileCriteria = IndexImpl.getFileCriteria(copy);
                copy.keySet().removeAll(fileCriteria.keySet());
                IndexIdTable[] tables = new IndexIdTable[this.roots.length];
                ResultCollector[] results = new ResultCollector[this.roots.length];
                for (i = 0; i < this.roots.length; ++i) {
                    tables[i] = this.roots[i].getFileTable();
                    results[i] = new ResultCollector(tables[i], callback);
                    tables[i].query(fileCriteria, results[i], copy.isEmpty());
                }
                if (copy.isEmpty()) break block11;
                try {
                    this.buildImpl(progress);
                }
                catch (RejectedExecutionException e) {
                    throw new QueryFailedException(e);
                }
                for (i = 0; i < this.roots.length; ++i) {
                    this.roots[i].query(copy, results[i]);
                }
            }
            finally {
                if (complete) {
                    PerformanceLogger.get().stopTiming("IndexImpl.queryImpl", "Index query complete", 200);
                } else {
                    PerformanceLogger.get().stopTiming("IndexImpl.queryImpl", null);
                }
            }
        }
    }

    @Override
    public URL[] blockingQuery(QueryCriteria criteria) throws InterruptedException, QueryFailedException {
        if (IndexingClient.isRunning()) {
            throw new ReentrantQueryException();
        }
        this.checkEventThread();
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexImpl.logQuery(criteria);
        NullResultCallback<URL> callback = new NullResultCallback<URL>();
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        this.queryImpl(criteria, resultCallback, null);
        return resultCallback.getResults();
    }

    @Override
    public Collection<QueryResult> blockingQueryEx(QueryCriteria criteria) throws InterruptedException, QueryFailedException {
        if (IndexingClient.isRunning()) {
            throw new ReentrantQueryException();
        }
        this.checkEventThread();
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexImpl.logQuery(criteria);
        NullResultCallback<QueryResult> callback = new NullResultCallback<QueryResult>();
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        this.queryImpl(criteria, resultCallback, null);
        return resultCallback.getResults();
    }

    @Override
    public BackgroundTask<URL[]> query(QueryCriteria criteria) {
        return this.query(criteria, (BlockingQueue<URL>)null);
    }

    @Override
    public BackgroundTask<Collection<QueryResult>> queryEx(QueryCriteria criteria) {
        return this.queryEx(criteria, (BlockingQueue<QueryResult>)null);
    }

    @Override
    public BackgroundTask<URL[]> query(QueryCriteria criteria, BlockingQueue<URL> queue) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        BlockingQueueResultCallback<URL> callback = new BlockingQueueResultCallback<URL>(queue, END_OF_RESULTS);
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        IndexQuery<URL[]> query = new IndexQuery<URL[]>(criteria, resultCallback, progress);
        Future<URL[]> future = QUERY_SCHEDULER.submit(query);
        return new IndexTask<URL[]>(future, progress);
    }

    @Override
    public BackgroundTask<Collection<QueryResult>> queryEx(QueryCriteria criteria, BlockingQueue<QueryResult> queue) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        BlockingQueueResultCallback<QueryResult> callback = new BlockingQueueResultCallback<QueryResult>(queue, LAST_RESULT);
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        IndexQuery<Collection<QueryResult>> query = new IndexQuery<Collection<QueryResult>>(criteria, resultCallback, progress);
        Future<Collection<QueryResult>> future = QUERY_SCHEDULER.submit(query);
        return new IndexTask<Collection<QueryResult>>(future, progress);
    }

    @Override
    public QueryProgress query(QueryCriteria criteria, ResultCallback<URL> callback) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        UrlResultCollectingCallback resultCallback = new UrlResultCollectingCallback(callback);
        IndexQuery<URL[]> query = new IndexQuery<URL[]>(criteria, resultCallback, progress);
        Future<URL[]> future = QUERY_SCHEDULER.submit(query);
        return new IndexTask<URL[]>(future, progress);
    }

    @Override
    public QueryProgress queryEx(QueryCriteria criteria, ResultCallback<QueryResult> callback) {
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Empty index query");
        }
        IndexProgressMonitor progress = new IndexProgressMonitor();
        QueryResultCollectingCallback resultCallback = new QueryResultCollectingCallback(callback);
        IndexQuery<Collection<QueryResult>> query = new IndexQuery<Collection<QueryResult>>(criteria, resultCallback, progress);
        Future<Collection<QueryResult>> future = QUERY_SCHEDULER.submit(query);
        return new IndexTask<Collection<QueryResult>>(future, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] locate(URL url, Object key, Object value) {
        DataLocator data = new DataLocator(key);
        IndexingContextImpl context = new IndexingContextImpl(this.workspace, this.project);
        context.setFilterKey(key);
        context.setFilterValue(value);
        context.startIndexing();
        try {
            context.index(url, -1L, data);
        }
        finally {
            context.endIndexing();
        }
        return data.getLocations();
    }

    @Override
    public QueryProgress findNodes(Class nodeClass, ResultCallback<Node> callback) {
        QueryCriteria criteria = new QueryCriteria();
        criteria.put("file.all", "file.all");
        return this.findNodes(criteria, nodeClass, callback);
    }

    @Override
    public QueryProgress findNodes(QueryCriteria criteria, Class nodeClass, ResultCallback<Node> callback) {
        return this.query(criteria, new FindNodesResultCallback(nodeClass, callback));
    }

    @Override
    public void release() {
        assert (!this.released);
        this.releaseRoots();
        this.released = true;
    }

    public void finalize() {
        if (!this.released) {
            IndexLogger.getLogger().log(Level.SEVERE, "Index not released", this.created);
        }
        if (this.lockCount.get() > 0) {
            IndexLogger.getLogger().log(Level.SEVERE, "Index not unlocked", this.created);
        }
    }

    private void acquireRoots() {
        for (IndexRoot root : this.roots) {
            root.acquire();
        }
    }

    private void releaseRoots() {
        for (IndexRoot root : this.roots) {
            root.release();
        }
    }

    private void checkEventThread() {
        if (EventQueue.isDispatchThread()) {
            IndexLogger.getLogger().log(Level.FINEST, "Blocking index call on event thread", new IllegalStateException());
        }
    }

    private static void logQuery(QueryCriteria criteria) {
        Logger logger = Logger.getLogger("oracle.ide.index.Query");
        if (logger.isLoggable(Level.FINE)) {
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder();
            builder.append("Index query executed with criteria:");
            builder.append(lineSeparator);
            for (Map.Entry entry : criteria.entrySet()) {
                builder.append("  ");
                builder.append(entry.getKey().toString());
                builder.append(" = ");
                builder.append(entry.getValue().toString());
                builder.append(lineSeparator);
            }
            if (logger.isLoggable(Level.FINEST)) {
                StackTraceElement[] trace;
                builder.append("Call stack of query:");
                builder.append(lineSeparator);
                for (StackTraceElement element : trace = Thread.currentThread().getStackTrace()) {
                    builder.append("\tat ");
                    builder.append(element.toString());
                    builder.append(lineSeparator);
                }
            }
            logger.fine(builder.toString());
        }
    }

    private static boolean isFileOnlyQuery(QueryCriteria criteria) {
        for (Map.Entry e : criteria.entrySet()) {
            if (OPTIMIZED_FILE_QUERIES.contains(e.getKey())) continue;
            return false;
        }
        return true;
    }

    private void handleFileOnlyQuery(QueryCriteria criteria, ResultCallback<QueryResult> callback, IndexProgressMonitor progress) throws InterruptedException, QueryFailedException {
        Storage storage = this.workspace == null ? Storages.getProjectStorage((Project)this.project) : Storages.getApplicationStorage((Workspace)this.workspace);
        storage.open();
        try {
            boolean isAllFilesQuery = criteria.containsKey("file.all");
            String name = (String)criteria.get("file.name");
            String extension = (String)criteria.get("file.extension");
            String[] extensions = extension == null ? null : extension.split("\\|");
            for (IndexRoot root : this.roots) {
                FileSet fileSet = root.getFileSet();
                FileSetTable fileTable = FileSetTable.getInstance((Storage)storage, (FileSet)fileSet);
                for (URL url : fileTable.getFiles()) {
                    boolean match = isAllFilesQuery;
                    if (!match) {
                        boolean nameMatches;
                        String suffix = null;
                        if (name != null) {
                            String fileName = URLFileSystem.getFileName((URL)url);
                            suffix = URLFileSystem.getSuffix((URL)url);
                            fileName = fileName.substring(0, fileName.length() - suffix.length());
                            nameMatches = fileName.equals(name);
                        } else {
                            nameMatches = true;
                        }
                        if (nameMatches) {
                            if (extensions != null) {
                                if (suffix == null) {
                                    suffix = URLFileSystem.getSuffix((URL)url);
                                }
                                for (String current : extensions) {
                                    if (!suffix.equalsIgnoreCase(current)) continue;
                                    match = true;
                                    break;
                                }
                            } else {
                                match = true;
                            }
                        }
                    }
                    if (!match) continue;
                    try {
                        callback.result(new QueryResultImpl("file.all", url, -1, -1));
                    }
                    catch (RuntimeException e) {
                        IndexLogger.getLogger().log(Level.SEVERE, "Exception in ResultCallback for " + url, e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new QueryFailedException(e);
        }
        finally {
            storage.close();
        }
    }

    public static QueryCriteria getFileCriteria(QueryCriteria criteria) {
        Set entries = criteria.entrySet();
        QueryCriteria fileCriteria = new QueryCriteria();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            if (!IndexImpl.isFileQuery(key)) continue;
            fileCriteria.put(key, entry.getValue());
        }
        return fileCriteria;
    }

    private static boolean isFileQuery(Object key) {
        if (key instanceof String) {
            String keyStr = (String)key;
            for (String str : FILE_QUERIES) {
                if (!str.equals(keyStr)) continue;
                return true;
            }
        }
        return false;
    }

    private class IndexTask<V>
    extends BackgroundTaskImpl<V> {
        public IndexTask(Future<V> future, ProgressMonitor progress) {
            super(future, progress);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (IndexingClient.isRunning()) {
                throw new ExecutionException(new ReentrantQueryException());
            }
            IndexImpl.this.checkEventThread();
            return super.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (IndexingClient.isRunning()) {
                throw new ExecutionException(new ReentrantQueryException());
            }
            IndexImpl.this.checkEventThread();
            return super.get(timeout, unit);
        }
    }

    private static class FindNodesResultCallback
    implements ResultCallback<URL> {
        private Class nodeClass;
        private ResultCallback<Node> callback;

        public FindNodesResultCallback(Class nodeClass, ResultCallback<Node> callback) {
            this.nodeClass = nodeClass;
            this.callback = callback;
        }

        @Override
        public void result(URL url) throws InterruptedException {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (this.nodeClass.isAssignableFrom(node.getClass())) {
                    this.callback.result(node);
                }
            }
            catch (IllegalAccessException iae) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to find node", iae);
            }
            catch (InstantiationException ie) {
                IndexLogger.getLogger().log(Level.SEVERE, "Unable to find node", ie);
            }
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }
    }

    private class IndexBuilder
    implements Runnable {
        private IndexProgressMonitor progress;

        public IndexBuilder(IndexProgressMonitor progress) {
            this.progress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IndexImpl.this.acquireRoots();
            try {
                IndexImpl.this.lock();
                try {
                    IndexImpl.this.buildImpl(this.progress);
                }
                finally {
                    IndexImpl.this.unlock();
                }
            }
            catch (LockFailedException lfe) {
                throw new BuildFailedException(lfe);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                IndexImpl.this.releaseRoots();
            }
        }
    }

    private static class QueryResultCollectingCallback
    implements ResultCollectingCallback<Collection<QueryResult>> {
        private final ResultCallback<QueryResult> callback;
        private final Set<QueryResult> results = new HashSet<QueryResult>();

        public QueryResultCollectingCallback(ResultCallback<QueryResult> callback) {
            this.callback = callback;
        }

        @Override
        public void result(QueryResult result) throws InterruptedException {
            if (this.results.add(result)) {
                this.callback.result(result);
            }
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }

        @Override
        public Collection<QueryResult> getResults() {
            return Collections.unmodifiableSet(this.results);
        }
    }

    private static class UrlResultCollectingCallback
    implements ResultCollectingCallback<URL[]> {
        private final ResultCallback<URL> callback;
        private final Set<URLKey> results = new HashSet<URLKey>();

        public UrlResultCollectingCallback(ResultCallback<URL> callback) {
            this.callback = callback;
        }

        @Override
        public void result(QueryResult result) throws InterruptedException {
            URL url = result.getURL();
            if (this.results.add(URLKey.getInstance((URL)url))) {
                this.callback.result(url);
            }
        }

        @Override
        public void done() throws InterruptedException {
            this.callback.done();
        }

        @Override
        public URL[] getResults() {
            return URLKey.asURLs(this.results).toArray(new URL[this.results.size()]);
        }
    }

    private static interface ResultCollectingCallback<E>
    extends ResultCallback<QueryResult> {
        public E getResults();
    }

    private class IndexQuery<E>
    implements Callable<E> {
        private QueryCriteria criteria;
        private ResultCollectingCallback<E> callback;
        private IndexProgressMonitor progress;

        public IndexQuery(QueryCriteria criteria, ResultCollectingCallback<E> callback, IndexProgressMonitor progress) {
            this.criteria = criteria;
            this.callback = callback;
            this.progress = progress;
            IndexImpl.logQuery(criteria);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E call() throws QueryFailedException {
            try {
                IndexImpl.this.acquireRoots();
                try {
                    boolean isFileOnlyQuery = IndexImpl.isFileOnlyQuery(this.criteria);
                    if (!isFileOnlyQuery) {
                        IndexImpl.this.lock();
                    }
                    try {
                        IndexImpl.this.queryImpl(this.criteria, this.callback, this.progress);
                    }
                    finally {
                        if (!isFileOnlyQuery) {
                            IndexImpl.this.unlock();
                        }
                    }
                }
                catch (LockFailedException lfe) {
                    throw new QueryFailedException(lfe);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    IndexImpl.this.releaseRoots();
                }
            }
            finally {
                try {
                    this.callback.done();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    IndexLogger.getLogger().log(Level.SEVERE, "Exception in ResultCallback", e);
                }
            }
            return this.callback.getResults();
        }
    }
}

