/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import oracle.ide.index.QueryResult;
import oracle.ide.index.ResultCallback;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.index.IndexIdTable;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexingClient;
import oracle.ideimpl.index.QueryResultImpl;

public class ResultCollector {
    private IndexIdTable table;
    private ResultCallback<QueryResult> callback;
    private HashMap<Integer, Collection<QueryResultImpl>> results = new HashMap();
    private HashMap<Integer, Collection<QueryResultImpl>> current = new HashMap();
    private boolean first = true;
    private boolean last;

    public ResultCollector(IndexIdTable table, ResultCallback<QueryResult> callback) {
        this.table = table;
        this.callback = callback;
    }

    public void add(String key, int id) throws InterruptedException {
        this.add(key, id, null);
    }

    public void add(String key, int id, URL url) throws InterruptedException {
        this.add(key, id, url, -1, -1);
    }

    public void add(String key, int id, URL url, int offset, int length) throws InterruptedException {
        QueryResultImpl result = new QueryResultImpl(key, url, offset, length);
        Collection<QueryResultImpl> results = this.current.get(id);
        if (results == null) {
            results = new ArrayList<QueryResultImpl>();
            this.current.put(id, results);
        }
        results.add(result);
    }

    public void startResultSet(boolean last) {
        this.last = last;
        this.current.clear();
    }

    public void endResultSet() {
        if (this.first && this.last) {
            this.results = this.current;
        } else if (this.first) {
            this.results.putAll(this.current);
            this.first = false;
        } else {
            this.results.keySet().retainAll(this.current.keySet());
            for (Map.Entry<Integer, Collection<QueryResultImpl>> entry : this.current.entrySet()) {
                Collection<QueryResultImpl> collection = this.results.get(entry.getKey());
                if (collection == null) continue;
                collection.addAll(entry.getValue());
            }
        }
        if (this.last) {
            this.invokeCallback(this.results);
        }
    }

    private void invokeCallback(Map<Integer, Collection<QueryResultImpl>> results) {
        try {
            block2: for (Map.Entry<Integer, Collection<QueryResultImpl>> entry : results.entrySet()) {
                int id = entry.getKey();
                URL url = null;
                for (QueryResultImpl result : entry.getValue()) {
                    if (result.getURL() == null) {
                        if (url == null && (url = this.table.getFileURL(id)) == null) continue block2;
                        result.setURL(url);
                    }
                    if (url == null) {
                        url = result.getURL();
                    }
                    this.invokeCallback(result);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void invokeCallback(final QueryResultImpl result) throws InterruptedException {
        try {
            IndexingClient.call(new Callable<Void>(){

                @Override
                public Void call() throws InterruptedException {
                    ResultCollector.this.callback.result(result);
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String file = URLFileSystem.getPlatformPathName((URL)result.getURL());
            IndexLogger.getLogger().log(Level.SEVERE, "Exception in ResultCallback for " + file, e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

