/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWFunctionNotSupported;
import oracle.AWXML.BaseObject;

public class ExtendedProperty
extends BaseObject {
    private String m_creator;
    private String m_extensionName;
    private String m_extensionValue;
    private String m_referencedObjectId;

    protected ExtendedProperty() {
    }

    public ExtendedProperty(String string, String string2, BaseObject baseObject) {
        if (string.equalsIgnoreCase("SYSTEM")) {
            throw new AWException("Invalid Creator");
        }
        this.m_creator = string;
        this.m_extensionName = string2;
        this.m_referencedObjectId = baseObject.getId();
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.toUpperCase();
        return this.m_name.toUpperCase() + "." + string.toUpperCase();
    }

    public String getCreator() {
        return this.m_creator;
    }

    public void setCreator(String string) {
        this.m_creator = string;
    }

    public String getExtensionName() {
        return this.m_extensionName;
    }

    public void setExtensionName(String string) {
        this.m_extensionName = string;
    }

    public String getExtensionValue() {
        return this.m_extensionValue;
    }

    public void setExtensionValue(String string) {
        this.m_extensionValue = string;
    }

    public String getReferencedObjectId() {
        return this.m_referencedObjectId;
    }

    public void setReferencedObjectId(String string) {
        this.m_referencedObjectId = string;
    }

    public String WriteToXML() {
        String string = null;
        string = ExtendedProperty.TAB() + this.WriteElementStart("ExtendedProperty");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + ExtendedProperty.TAB() + this.WriteElementEndTag("ExtendedProperty") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        string = string == null ? this.WriteAsAttribute("Creator", this.m_creator) : string + this.WriteAsAttribute("Creator", this.m_creator);
        string = string == null ? this.WriteAsAttribute("ExtensionName", this.m_extensionName) : string + this.WriteAsAttribute("ExtensionName", this.m_extensionName);
        string = string == null ? this.WriteAsAttribute("ExtensionValue", this.m_extensionValue) : string + this.WriteAsAttribute("ExtensionValue", this.m_extensionValue);
        string = string == null ? this.WriteAsAttribute("ReferencedObjectId", this.m_referencedObjectId) : string + this.WriteAsAttribute("ReferencedObjectId", this.m_referencedObjectId);
        return string;
    }

    public String WriteContentsToXML() {
        ++s_Indent;
        String string = super.WriteContentsToXML();
        --s_Indent;
        return string;
    }

    public String Create(AWConnection aWConnection) {
        String string = "Success";
        try {
            String string2 = AWNULL;
            if (this.m_extensionValue != null) {
                string2 = this.quoteValue(this.m_extensionValue);
            }
            String string3 = aWConnection.executeCommand("call create_tools_property(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_referencedObjectId) + "," + this.quoteValue(this.m_creator) + "," + this.quoteValue(this.m_extensionName) + "," + string2 + "," + AWConnection.CommitMode + ")");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException("AWXML-ERR-NUM-900009", new Object[]{this.getId(), this.m_commandResultText});
            }
        }
        catch (Exception exception) {
            throw new AWException("AWXML-ERR-NUM-900009", new Object[]{this.getId()}, exception);
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "Success";
        String string2 = aWConnection.executeCommand("call delete_tools_property(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-900010", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Alter(AWConnection aWConnection) {
        throw new AWFunctionNotSupported("Alter not supported on this object");
    }
}

