/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildableObject
extends AbstractDBObject {
    public AbstractBuildableObject() {
    }

    protected AbstractBuildableObject(String name, DBObjectID id) {
        super(name, id);
    }

    @Override
    AbstractDBObject.PropertySupport createPropertySupport() {
        return new BuildablePropertySupport();
    }

    @Override
    BuildablePropertySupport getPropertySupport() {
        return (BuildablePropertySupport)super.getPropertySupport();
    }

    final boolean isBuilt(String prop) {
        BuildablePropertySupport props = this.getPropertySupport();
        return prop != null && (props.isBuilt(prop) || props.getBuilder(prop) == null);
    }

    protected boolean needsInitialization() {
        return this.getPropertySupport().needsInitialization();
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected void checkInit(String prop) {
        this.getPropertySupport().checkBuilt(prop);
    }

    protected void checkInit() {
        this.checkInit(null);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.getPropertySupport().getLazyMapWrapper();
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        Collection<String> properties = this.getChildPropertiesForTypes(types);
        if (properties == null) {
            this.checkInit();
        } else {
            for (String prop : properties) {
                this.checkInit(prop);
            }
        }
        super.getOwnedObjectsImpl(c, types);
    }

    private Collection<String> getChildPropertiesForTypes(String[] types) {
        ArrayList<String> retval = null;
        if (types != null) {
            PropertyIterator pi = new PropertyIterator(this.getClass(), null);
            for (Map.Entry<String, PropertyInfo> entry : pi.getPropertyInfos(false, false, false).entrySet()) {
                String propName = entry.getKey();
                PropertyInfo info = entry.getValue();
                Class<?> clz = info.getPropertyClass();
                if (clz.isArray()) {
                    clz = clz.getComponentType();
                }
                if (!DBObject.class.isAssignableFrom(clz)) continue;
                String type = Metadata.getType(clz);
                for (String desiredType : types) {
                    if (!ModelUtil.areEqual((Object)desiredType, (Object)type)) continue;
                    if (retval == null) {
                        retval = new ArrayList<String>();
                    }
                    retval.add(propName);
                }
            }
        }
        return retval;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        this.checkInit();
        super.getReferenceIDsImpl(refs);
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        BuildablePropertySupport props = this.getPropertySupport();
        if (!props.supportsCopyBuilder(idPolicy) && !(idPolicy instanceof IDPolicy.SameIDPolicy)) {
            props.checkBuilt(null);
            ((AbstractBuildableObject)copy).getPropertySupport().markAsBuilt();
        }
        super.copyToImpl(copy, copyParent, idPolicy);
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject target) {
        AbstractBuildableObject other = (AbstractBuildableObject)target;
        this.getPropertySupport().syncBuildState(other.getPropertySupport());
        return super.equalsImpl(target);
    }

    DBObject createStaticCopy() {
        return this.copyTo(null, new StaticCopyPolicy());
    }

    @Override
    protected void fireObjectUpdated(final DBObjectChange change) {
        final BuildablePropertySupport props = this.getPropertySupport();
        if (!props.isBuilding()) {
            boolean clear = false;
            DerivedPropertyBuilder dpb = props.getDerivedPropertyBuilder();
            if (dpb != null && !props.m_clearingDerivedProperties) {
                for (String builtProp : props.m_currentlyBuiltProps) {
                    if (!dpb.isBuildableProperty(builtProp)) continue;
                    clear = true;
                    break;
                }
            }
            if (clear) {
                props.runUnderPropertyLock(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        props.m_clearingDerivedProperties = true;
                        try {
                            AbstractBuildableObject.super.fireObjectUpdated(change);
                            props.clearDerivedProperties(change);
                        }
                        finally {
                            props.m_clearingDerivedProperties = false;
                        }
                    }
                }, true);
            } else {
                super.fireObjectUpdated(change);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyPropertiesMap
    extends AbstractMap<String, Object> {
        private LazyPropertiesMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            AbstractBuildableObject.this.checkInit();
            return AbstractBuildableObject.super.getProperties().entrySet();
        }

        @Override
        public Object put(String key, Object value) {
            AbstractBuildableObject.this.setProperty(key, value);
            return true;
        }

        @Override
        public Object get(Object key) {
            Object retval = null;
            if (key instanceof String) {
                BuildablePropertySupport props = AbstractBuildableObject.this.getPropertySupport();
                props.checkBuilt((String)key);
                retval = props.get((String)key);
            }
            return retval;
        }

        @Override
        public Object remove(Object key) {
            Object retval = null;
            if (key instanceof String) {
                retval = this.get(key);
                this.put((String)key, (Object)null);
            }
            return retval;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }
    }

    class TemporaryCopyBuilder
    extends AbstractDBObjectBuilder {
        private final AbstractBuildableObject m_original;
        private final TemporaryObjectID.TemporaryIDPolicy m_idPolicy;
        private final AbstractDBObjectBuilder m_delegate;

        TemporaryCopyBuilder(AbstractBuildableObject original, AbstractDBObjectBuilder delegate, TemporaryObjectID.TemporaryIDPolicy idPolicy) {
            super(delegate.getProvider(), original.getType());
            this.m_original = original;
            this.m_idPolicy = idPolicy;
            this.m_delegate = delegate;
            this.copyTimestamp(AbstractBuildableObject.this);
        }

        public AbstractBuildableObject createObject(String name, Schema schema, DBObjectID id) {
            throw new UnsupportedOperationException("TemporaryCopyBuilder doesn't support create");
        }

        protected boolean isBuildableProperty(String prop) {
            return !s_specialProps.contains(prop);
        }

        protected void fillInObject(AbstractBuildableObject copy) throws DBException {
            this.m_original.checkInit();
            BuildablePropertySupport origProps = this.m_original.getPropertySupport();
            BuildablePropertySupport copyProps = copy.getPropertySupport();
            TreeSet<String> excludeFromCopy = new TreeSet<String>(copyProps.m_currentlyBuiltProps);
            for (String builtOnce : copyProps.m_clearedDerivedProps) {
                if (excludeFromCopy.contains(builtOnce) || copyProps.m_derivedPropertyBuilder == null || !copyProps.m_derivedPropertyBuilder.isBuildableProperty(builtOnce)) continue;
                excludeFromCopy.add(builtOnce);
            }
            origProps.copyTo(copyProps, this.m_idPolicy, excludeFromCopy);
            copy.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
        }

        protected boolean fillInObjectComponentImpl(AbstractBuildableObject copy, String prop) throws DBException {
            BuildablePropertySupport origProps = this.m_original.getPropertySupport();
            BuildablePropertySupport copyProps = copy.getPropertySupport();
            origProps.checkBuiltEx(prop);
            Object v = AbstractBuildableObject.this.copyObject(origProps.get(prop), copy, this.m_idPolicy);
            copyProps.put(prop, v);
            copy.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
            return true;
        }

        protected boolean canBuildComponents() {
            return true;
        }

        protected void registerObject(AbstractBuildableObject object) throws DBException {
            this.copyTimestamp(object);
        }

        private void copyTimestamp(AbstractBuildableObject object) {
            Object ts = this.m_original.getPropertySupport().get("Timestamp");
            if (ts != null) {
                object.setProperty("Timestamp", ts);
            }
        }

        String[] getPropertyDependencies(String property) {
            return this.m_delegate.getPropertyDependencies(property);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BuiltStatus {
        UNBUILT,
        PARTIAL,
        BUILT;

    }

    private class StaticCopyPolicy
    extends IDPolicy.SameIDPolicy {
        private StaticCopyPolicy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BuildablePropertySupport
    extends AbstractDBObject.PropertySupport {
        private final Holder<Map<String, Object>> m_lazyWrapper;
        private DBObjectBuilder m_builder;
        private DerivedPropertyBuilder m_derivedPropertyBuilder;
        private final Set<String> m_building;
        private boolean m_buildingAll;
        private final ReentrantLock m_propertyLock;
        private final Set<String> m_currentlyBuiltProps;
        private boolean m_clearingDerivedProperties;
        private final Set<String> m_clearedDerivedProps;
        private volatile BuiltStatus m_status;

        BuildablePropertySupport() {
            super(AbstractBuildableObject.this);
            this.m_lazyWrapper = new Holder();
            this.m_building = new TreeSet<String>();
            this.m_propertyLock = new ReentrantLock();
            this.m_currentlyBuiltProps = new CopyOnWriteArraySet<String>();
            this.m_clearedDerivedProps = new CopyOnWriteArraySet<String>();
            this.m_status = BuiltStatus.BUILT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getLazyMapWrapper() {
            Holder<Map<String, Object>> holder = this.m_lazyWrapper;
            synchronized (holder) {
                Map retval = (Map)this.m_lazyWrapper.get();
                if (retval == null) {
                    retval = new LazyPropertiesMap();
                    this.m_lazyWrapper.set((Object)retval);
                }
                return retval;
            }
        }

        void setBuilder(DBObjectBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException("builder cannot be null");
            }
            this.m_builder = builder;
            this.m_currentlyBuiltProps.clear();
            this.m_clearedDerivedProps.clear();
            this.m_status = BuiltStatus.UNBUILT;
        }

        void setDerivedPropertyBuilder(DerivedPropertyBuilder builder) {
            this.m_derivedPropertyBuilder = builder;
        }

        DerivedPropertyBuilder getDerivedPropertyBuilder() {
            return this.m_derivedPropertyBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runUnderPropertyLock(Runnable runnable, boolean fireEvents) {
            if (!this.m_propertyLock.tryLock()) {
                AbstractBuildableObject.this.getLogger().log(Level.FINE, "Waiting for property lock on " + Thread.currentThread().getName());
                this.m_propertyLock.lock();
            }
            try {
                AbstractBuildableObject.this.invokeCompoundChange(runnable, fireEvents);
            }
            finally {
                this.m_propertyLock.unlock();
            }
        }

        void markAsBuilt() {
            if (this.m_status != BuiltStatus.BUILT) {
                this.m_status = BuiltStatus.BUILT;
            }
        }

        boolean needsInitialization() {
            return this.m_status != BuiltStatus.BUILT;
        }

        void setBuildingAll() {
            this.m_buildingAll = true;
        }

        boolean isBuilding() {
            return this.m_buildingAll || !this.m_building.isEmpty();
        }

        void startBuilding(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    if (this.m_building.contains(prop)) {
                        DBLog.getLogger(this).severe("already building " + prop);
                    }
                    this.m_building.add(prop);
                }
            }
        }

        void finishBuilding(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    this.m_building.remove(prop);
                }
            }
        }

        void setBuilt(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    this.m_currentlyBuiltProps.add(prop);
                    this.m_clearedDerivedProps.remove(prop);
                }
            }
        }

        void setUnbuilt(String ... props) {
            if (props != null) {
                for (String prop : props) {
                    this.m_currentlyBuiltProps.remove(prop);
                }
            }
        }

        boolean isBuilt(String prop) {
            boolean retval = false;
            if (prop == null || this.m_derivedPropertyBuilder == null || !this.m_derivedPropertyBuilder.isBuildableProperty(prop)) {
                boolean bl = retval = this.m_status == BuiltStatus.BUILT;
            }
            if (!retval) {
                if (prop == null) {
                    retval = false;
                } else if (this.m_currentlyBuiltProps.contains(prop)) {
                    retval = true;
                }
            }
            return retval;
        }

        void checkBuilt(String prop) {
            DBObjectBuilder builder = this.getBuilder(prop);
            if (builder != null) {
                try {
                    this.checkBuiltEx(prop, builder);
                }
                catch (DBSQLException sqle) {
                    AbstractBuildableObject.this.getLogger().log(Level.SEVERE, "Error : \"" + sqle.getMessage() + "\" building {0}, executing sql:\n {1}", new Object[]{AbstractBuildableObject.this.getName(), sqle.getSQL()});
                }
                catch (CancelledException ce) {
                    this.logBuildCancelled(prop);
                }
                catch (DBException dbe) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.logBuildCancelled(prop);
                    }
                    String name = (String)this.get("name");
                    String msg = ModelUtil.hasLength((String)prop) ? APIBundle.format("BUILD_OBJ_COMP_ERROR", dbe.getMessage(), prop, AbstractBuildableObject.this.getType(), name) : APIBundle.format("BUILD_OBJ_ERROR", dbe.getMessage(), AbstractBuildableObject.this.getType(), name);
                    AbstractBuildableObject.this.getLogger().log(Level.FINE, msg, dbe);
                    AbstractBuildableObject.this.getLogger().severe(msg);
                }
            }
        }

        private void logBuildCancelled(String prop) {
            String name = (String)this.get("name");
            String msg = ModelUtil.hasLength((String)prop) ? APIBundle.format("BUILD_OBJ_COMP_CANCELLED", prop, AbstractBuildableObject.this.getType(), name) : APIBundle.format("BUILD_OBJ_CANCELLED", AbstractBuildableObject.this.getType(), name);
            AbstractBuildableObject.this.getLogger().log(Level.WARNING, msg);
        }

        void checkBuiltEx(String prop) throws DBException {
            DBObjectBuilder builder = this.getBuilder(prop);
            if (builder != null) {
                this.checkBuiltEx(prop, builder);
            }
        }

        private void checkBuiltEx(String prop, DBObjectBuilder builder) throws DBException {
            if (builder == null || this.isBuilt(prop)) {
                return;
            }
            if (this.m_buildingAll || prop != null && this.m_building.contains(prop)) {
                AbstractBuildableObject.this.getLogger().log(Level.FINEST, "Querying " + prop + " while it is being built");
                return;
            }
            if (!(prop == null || builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)builder).canBuildComponents() || this.m_derivedPropertyBuilder == null || !this.m_derivedPropertyBuilder.isBuildableProperty(prop))) {
                this.buildImpl(builder, null);
                if (!this.isBuilt(prop)) {
                    this.buildImpl(this.m_derivedPropertyBuilder, prop);
                }
            } else {
                this.buildImpl(builder, prop);
            }
        }

        void ensureDerivedPropertiesBuilt() throws DBException {
            if (this.m_derivedPropertyBuilder != null && !this.m_buildingAll) {
                this.buildImpl(this.m_derivedPropertyBuilder, null);
            }
        }

        private void buildImpl(final DBObjectBuilder builder, final String prop) throws DBException {
            final Holder exHolder = new Holder();
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        BuildablePropertySupport.this.buildImplWhileLocked(builder, prop);
                    }
                    catch (DBException dbe) {
                        exHolder.set((Object)dbe);
                    }
                }
            };
            CancelledException.checkInterrupt();
            this.runUnderPropertyLock(runnable, false);
            DBException dbe = (DBException)exHolder.get();
            if (dbe != null) {
                throw dbe;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void buildImplWhileLocked(DBObjectBuilder builder, String prop) throws DBException {
            long millis;
            block11: {
                if (prop != null && builder != this.m_derivedPropertyBuilder && this.isBuilt(prop)) {
                    return;
                }
                millis = System.currentTimeMillis();
                boolean cancelled = false;
                try {
                    block10: {
                        try {
                            if (prop == null) {
                                this.m_buildingAll = true;
                                builder.buildObject(AbstractBuildableObject.this);
                                if (builder == this.m_builder) {
                                    this.m_status = BuiltStatus.BUILT;
                                }
                                break block10;
                            }
                            builder.buildObjectComponent(AbstractBuildableObject.this, prop);
                            if (builder == this.m_builder && this.m_status == BuiltStatus.UNBUILT) {
                                this.m_status = BuiltStatus.PARTIAL;
                            }
                        }
                        catch (DBException dbe) {
                            if (!(dbe instanceof CancelledException)) throw dbe;
                            cancelled = true;
                            if (prop == null) throw dbe;
                            this.m_currentlyBuiltProps.remove(prop);
                            throw dbe;
                        }
                    }
                    Object var8_5 = null;
                    this.m_buildingAll = false;
                    if (prop == null || cancelled) break block11;
                    this.m_currentlyBuiltProps.add(prop);
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.m_buildingAll = false;
                    if (prop != null && !cancelled) {
                        this.m_currentlyBuiltProps.add(prop);
                    }
                    if ((millis = System.currentTimeMillis() - millis) <= 20L) throw throwable;
                    AbstractBuildableObject.this.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1} took {2}ms", new Object[]{prop == null ? "all" : prop, AbstractBuildableObject.this.getName(), Long.toString(millis)});
                    throw throwable;
                }
            }
            if ((millis = System.currentTimeMillis() - millis) <= 20L) return;
            AbstractBuildableObject.this.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1} took {2}ms", new Object[]{prop == null ? "all" : prop, AbstractBuildableObject.this.getName(), Long.toString(millis)});
        }

        private DBObjectBuilder getBuilder(String prop) {
            DBObjectBuilder retval = this.m_builder;
            if (prop != null) {
                boolean canBeBuilt;
                boolean canBeDerived = this.m_derivedPropertyBuilder != null && this.m_derivedPropertyBuilder.isBuildableProperty(prop);
                boolean bl = canBeBuilt = this.m_builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)this.m_builder).isBuildableProperty(prop);
                if (canBeDerived && (!canBeBuilt || this.m_clearedDerivedProps.contains(prop))) {
                    retval = this.m_derivedPropertyBuilder;
                } else if (!canBeBuilt) {
                    retval = null;
                }
            }
            return retval;
        }

        @Override
        public void copyTo(AbstractDBObject.PropertySupport target, IDPolicy idPolicy) {
            super.copyTo(target, idPolicy);
            BuildablePropertySupport copy = (BuildablePropertySupport)target;
            DerivedPropertyBuilder preservedDerivedPropertyBuilder = copy.m_derivedPropertyBuilder;
            copy.m_derivedPropertyBuilder = null;
            boolean copyDerivedPropertyState = false;
            if (idPolicy instanceof StaticCopyPolicy) {
                copyDerivedPropertyState = true;
                copy.markAsBuilt();
            } else if (idPolicy instanceof IDPolicy.SameIDPolicy) {
                copyDerivedPropertyState = true;
                if (this.m_status != BuiltStatus.BUILT) {
                    if (this.m_builder instanceof TemporaryCopyBuilder) {
                        copy.initCopyBuilder(((TemporaryCopyBuilder)this.m_builder).m_original, ((TemporaryCopyBuilder)this.m_builder).m_delegate, new TemporaryObjectID.TemporaryIDPolicy());
                    } else {
                        copy.m_builder = this.m_builder;
                    }
                    this.copyPropertyStateTo(copy);
                }
            } else if (this.supportsCopyBuilder(idPolicy)) {
                copyDerivedPropertyState = true;
                if (this.m_status != BuiltStatus.BUILT) {
                    copy.initCopyBuilder(AbstractBuildableObject.this, (AbstractDBObjectBuilder)this.m_builder, (TemporaryObjectID.TemporaryIDPolicy)idPolicy);
                    this.copyPropertyStateTo(copy);
                }
            } else if (idPolicy instanceof TemporaryObjectID.TemporaryIDPolicy || idPolicy instanceof TemporaryObjectID.CopyBackPolicy) {
                copyDerivedPropertyState = true;
            }
            if (copyDerivedPropertyState) {
                if (this.m_derivedPropertyBuilder != null) {
                    AbstractDBObjectProvider pro = this.m_derivedPropertyBuilder.getProvider();
                    copy.m_derivedPropertyBuilder = pro.getDescriptor().getDerivedPropertyBuilder(AbstractBuildableObject.this.getClass(), pro);
                    this.copyDerivedPropertyStateTo(copy);
                } else if (preservedDerivedPropertyBuilder != null) {
                    copy.m_derivedPropertyBuilder = preservedDerivedPropertyBuilder;
                    this.copyDerivedPropertyStateTo(copy);
                }
            }
        }

        private void copyPropertyStateTo(BuildablePropertySupport copy) {
            copy.m_status = this.m_status;
            copy.m_currentlyBuiltProps.addAll(this.m_currentlyBuiltProps);
            copy.m_currentlyBuiltProps.retainAll(this.m_currentlyBuiltProps);
        }

        private void copyDerivedPropertyStateTo(BuildablePropertySupport copy) {
            copy.m_clearedDerivedProps.addAll(this.m_clearedDerivedProps);
            copy.m_clearedDerivedProps.retainAll(this.m_clearedDerivedProps);
            copy.m_currentlyBuiltProps.removeAll(this.m_clearedDerivedProps);
        }

        private void initCopyBuilder(AbstractBuildableObject original, AbstractDBObjectBuilder builder, TemporaryObjectID.TemporaryIDPolicy idPolicy) {
            this.setBuilder(new TemporaryCopyBuilder(original, builder, idPolicy));
        }

        private boolean supportsCopyBuilder(IDPolicy idPolicy) {
            return idPolicy instanceof TemporaryObjectID.TemporaryIDPolicy && this.m_builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)this.m_builder).canBuildComponents();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof BuildablePropertySupport && super.equals(obj) && this.equalsImpl((BuildablePropertySupport)obj);
        }

        private boolean equalsImpl(BuildablePropertySupport other) {
            boolean same = ModelUtil.areEqual((Object)((Object)this.m_status), (Object)((Object)other.m_status));
            if (same && this.m_status != BuiltStatus.BUILT) {
                same = this.m_currentlyBuiltProps.equals(other.m_currentlyBuiltProps);
            }
            return same;
        }

        private boolean isTempCopyOf(BuildablePropertySupport other) {
            boolean retval = false;
            if (this.m_builder instanceof TemporaryCopyBuilder) {
                retval = ((TemporaryCopyBuilder)this.m_builder).m_original == other.getParentForChildren();
            }
            return retval;
        }

        private void syncBuildState(BuildablePropertySupport other) {
            boolean first = this.isTempCopyOf(other);
            boolean second = other.isTempCopyOf(this);
            if (first || second) {
                if (!this.needsInitialization()) {
                    other.checkBuilt(null);
                } else if (!other.needsInitialization()) {
                    this.checkBuilt(null);
                } else {
                    BuildablePropertySupport copy;
                    BuildablePropertySupport original;
                    if (first) {
                        original = other;
                        copy = this;
                    } else {
                        original = this;
                        copy = other;
                    }
                    TreeSet<String> copyBuiltProps = new TreeSet<String>(copy.m_currentlyBuiltProps);
                    for (String prop : copyBuiltProps) {
                        original.checkBuilt(prop);
                    }
                    TreeSet<String> originalBuiltProps = new TreeSet<String>(original.m_currentlyBuiltProps);
                    originalBuiltProps.removeAll(copyBuiltProps);
                    for (String prop : originalBuiltProps) {
                        copy.checkBuilt(prop);
                    }
                }
            } else {
                this.checkBuilt(null);
                other.checkBuilt(null);
            }
        }

        @Override
        public Object put(final String name, final Object value) {
            Object retval;
            if (this.m_derivedPropertyBuilder == null || this.isBuilding()) {
                retval = super.put(name, value);
                this.setBuilt(name);
            } else {
                final Holder holder = new Holder();
                this.runUnderPropertyLock(new Runnable(){

                    public void run() {
                        Object replaced = BuildablePropertySupport.super.put(name, value);
                        holder.set(replaced);
                        BuildablePropertySupport.this.setBuilt(name);
                    }
                }, true);
                retval = holder.get();
            }
            return retval;
        }

        private void clearDerivedProperties(DBObjectChange change) {
            Collection<String> derivedProps;
            if (this.m_derivedPropertyBuilder != null && (derivedProps = this.m_derivedPropertyBuilder.clearDerivedProperties(AbstractBuildableObject.this, change)) != null && !derivedProps.isEmpty()) {
                this.m_currentlyBuiltProps.removeAll(derivedProps);
                this.m_clearedDerivedProps.addAll(derivedProps);
            }
        }
    }
}

