/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObject
implements DBObject {
    private final ListenerSupport m_listenerSupport = new ListenerSupport();
    private final PropertySupport m_properties = this.createPropertySupport();
    private DBObjectID m_id;
    private Holder<oracle.javatools.db.event.DBObjectChange> m_compoundChange;
    private DBObject m_parent;
    private Schema m_schema;

    protected AbstractDBObject() {
        this(null, null);
    }

    protected AbstractDBObject(String name) {
        this(name, null);
    }

    protected AbstractDBObject(String name, DBObjectID id) {
        this.setName(name);
        this.setID(id);
    }

    PropertySupport createPropertySupport() {
        return new PropertySupport();
    }

    PropertySupport getPropertySupport() {
        return this.m_properties;
    }

    @Override
    public final void addObjectListener(oracle.javatools.db.event.DBObjectListener list) {
        this.m_listenerSupport.addObjectListener(list);
    }

    @Override
    public final void removeObjectListener(oracle.javatools.db.event.DBObjectListener list) {
        this.m_listenerSupport.removeObjectListener(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void invokeCompoundChange(Runnable run, boolean fireEvents) {
        PropertySupport propertySupport;
        oracle.javatools.db.event.DBObjectChange change2;
        boolean alreadyCompound = true;
        try {
            PropertySupport propertySupport2 = this.m_properties;
            synchronized (propertySupport2) {
                if (this.m_compoundChange == null) {
                    this.m_compoundChange = new Holder();
                    alreadyCompound = false;
                }
            }
            run.run();
            Object var7_6 = null;
            change2 = null;
            propertySupport = this.m_properties;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            oracle.javatools.db.event.DBObjectChange change2 = null;
            PropertySupport propertySupport3 = this.m_properties;
            synchronized (propertySupport3) {
                if (!alreadyCompound && this.m_compoundChange != null) {
                    change2 = (oracle.javatools.db.event.DBObjectChange)this.m_compoundChange.get();
                    this.m_compoundChange = null;
                }
            }
            if (change2 != null && fireEvents) {
                this.fireObjectUpdatedImpl(change2);
            }
            throw throwable;
        }
        synchronized (propertySupport) {
            if (!alreadyCompound && this.m_compoundChange != null) {
                change2 = (oracle.javatools.db.event.DBObjectChange)this.m_compoundChange.get();
                this.m_compoundChange = null;
            }
        }
        if (change2 != null && fireEvents) {
            this.fireObjectUpdatedImpl(change2);
        }
    }

    protected void fireObjectUpdated(oracle.javatools.db.event.DBObjectChange change) {
        if (change != null) {
            if (this.m_compoundChange != null) {
                this.m_compoundChange.set((Object)oracle.javatools.db.event.DBObjectChange.merge(change, (oracle.javatools.db.event.DBObjectChange)this.m_compoundChange.get()));
            } else {
                this.fireObjectUpdatedImpl(change);
            }
        }
    }

    private void fireObjectUpdatedImpl(final oracle.javatools.db.event.DBObjectChange change) {
        String parentProp;
        this.m_listenerSupport.fireObjectUpdated(change);
        DBObject parent = this.getParent();
        if (parent instanceof AbstractDBObject && (parentProp = DBUtil.getParentProperty(this)) != null) {
            oracle.javatools.db.event.DBObjectChange parChange = new oracle.javatools.db.event.DBObjectChange(parent, change.getProvider()){

                @Override
                public Map<DBObject, oracle.javatools.db.event.DBObjectChange> getOwnedObjectsUpdated() {
                    return Collections.singletonMap(AbstractDBObject.this, change);
                }

                @Override
                public Collection<String> getAllChangedProperties() {
                    return Collections.singleton(parentProp);
                }
            };
            ((AbstractDBObject)parent).fireObjectUpdated(parChange);
        }
    }

    @Deprecated
    public final void addObjectListener(DBObjectListener list) {
        this.m_listenerSupport.addBridgedListener(list);
    }

    @Deprecated
    public final void removeObjectListener(DBObjectListener list) {
        this.m_listenerSupport.removeBridgedListener(list);
    }

    @Deprecated
    public final void removeObjectListener(SchemaObjectListener list) {
        this.m_listenerSupport.removeBridgedListener(list);
    }

    @Deprecated
    public final void addObjectListener(SchemaObjectListener list) {
        this.m_listenerSupport.addBridgedListener(list);
    }

    @Override
    public final Object copyTo(Object target) {
        DBObject retval = target != null && this.m_id instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)this.m_id) == target ? this.copyTo((DBObject)target, new TemporaryObjectID.CopyBackPolicy()) : this.copyTo((DBObject)target, false);
        return retval;
    }

    @Override
    public final DBObject copyTo(DBObject target, boolean temporaryCopy) {
        return this.copyTo(target, temporaryCopy ? new TemporaryObjectID.TemporaryIDPolicy() : new IDPolicy.DefaultIDPolicy());
    }

    @Override
    public final DBObject copyTo(DBObject target, IDPolicy idPolicy) {
        DBObject parent = null;
        if (target instanceof ChildDBObject) {
            parent = target.getParent();
        }
        if (parent == null && this instanceof ChildDBObject) {
            parent = this.getParent();
        }
        AbstractDBObject copy = (AbstractDBObject)this.copyTo(target, parent, idPolicy);
        copy.replaceReferenceIDsDirectly(idPolicy.getIDMap());
        return copy;
    }

    boolean replaceReferenceIDsDirectly(Map<DBObjectID, DBObjectID> idMap) {
        boolean retval = false;
        if (idMap != null && !idMap.isEmpty()) {
            retval = this.replaceReferenceIDs(idMap);
            for (DBObject kid : this.getPropertySupport().getOwnedObjects(new String[0])) {
                retval = ((AbstractDBObject)kid).replaceReferenceIDsDirectly(idMap) || retval;
            }
        }
        return retval;
    }

    protected final DBObject copyTo(DBObject target, final DBObject copyParent, final IDPolicy idPolicy) {
        if (target == null) {
            try {
                target = (DBObject)this.getClass().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate new object for copy", e);
            }
        }
        final AbstractDBObject realTarget = (AbstractDBObject)target;
        realTarget.invokeCompoundChange(new Runnable(){

            public void run() {
                AbstractDBObject.this.copyToImpl(realTarget, copyParent, idPolicy);
            }
        }, true);
        return target;
    }

    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        if (this == copy) {
            throw new IllegalStateException("cannot copy an object to itself");
        }
        copy.m_schema = this.m_schema;
        copy.m_parent = copyParent;
        if (idPolicy != null) {
            idPolicy.copyID(this, copy);
        }
        this.m_properties.copyTo(copy.m_properties, idPolicy);
    }

    protected <T> T copyObject(T value, DBObject copy, IDPolicy idPolicy) {
        return DBUtil.copyPropertyValue(value, this, copy, idPolicy);
    }

    @Override
    public final boolean equals(Object other) {
        boolean retval = false;
        if (other != null && this.getClass().isAssignableFrom(other.getClass())) {
            retval = this.equalsImpl((AbstractDBObject)other);
        }
        return retval;
    }

    protected boolean equalsImpl(AbstractDBObject other) {
        return ModelUtil.areEqual((Object)this.getType(), (Object)other.getType()) && ModelUtil.areEqual((Object)this.getName(), (Object)other.getName()) && DBUtil.areNamesAndTypesEqual(this.m_schema, other.m_schema) && ModelUtil.areEqual((Object)this.m_properties, (Object)other.m_properties);
    }

    protected int compareToImpl(AbstractDBObject target) {
        String otherName = target.getName();
        String thisName = this.getName();
        return thisName == null ? (otherName == null ? 0 : -1) : (otherName == null ? 1 : thisName.compareTo(otherName));
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public void setName(String name) {
        this.setProperty("name", name);
    }

    @Override
    @TextProperty(internalName=true)
    public String getName() {
        return (String)this.getProperty("name");
    }

    @Override
    @Transient
    public final DBObject getParent() {
        return (DBObject)this.getProperty("parent");
    }

    public final <T extends DBObject> T findParent(Class<T> parentClass) {
        for (DBObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    @Override
    public void setID(DBObjectID id) {
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject origObj = ((TemporaryObjectID)id).resolveOriginalID();
                if (origObj == this) {
                    throw new IllegalStateException("an object's TemporaryObjectID cannot point back to itself as the original object.");
                }
                DBObject obj = ((TemporaryObjectID)id).resolveID();
                if (obj != this) {
                    throw new IllegalStateException("an object's TemporaryObjectID must resolve to itself.");
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        this.m_id = id;
    }

    @Override
    public final DBObjectID getID() {
        DBObjectID retval = this.m_id;
        if (this.m_id != null && !(this.m_id instanceof TemporaryObjectID)) {
            retval = (DBObjectID)this.m_id.copyTo(null);
        }
        return retval;
    }

    final DBObjectID obtainActualID() {
        return this.m_id;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    public Object getProperty(String key) {
        Object retval = "type".equals(key) ? this.getType() : ("ID".equals(key) ? this.m_id : ("schema".equals(key) ? this.m_schema : ("parent".equals(key) ? this.m_parent : this.getProperties().get(key))));
        return retval;
    }

    public final Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public void setProperties(Map properties) {
        if (properties != this.m_properties) {
            Iterator keys = this.m_properties.keySet().iterator();
            while (keys.hasNext()) {
                Class<?> clz = this.getClass();
                while (clz.isAnnotationPresent(Deprecated.class)) {
                    clz = clz.getSuperclass();
                }
                String key = (String)keys.next();
                if (properties.containsKey(key) || Metadata.getInstance().isBeanProperty(clz, key)) continue;
                keys.remove();
            }
            this.m_properties.putAll(properties);
        }
    }

    public void setProperty(String key, Object value) {
        if ("ID".equals(key)) {
            this.m_id = (DBObjectID)value;
        } else if ("schema".equals(key)) {
            Schema oldValue = this.m_schema;
            this.m_schema = (Schema)value;
            this.firePropertyChanged(key, oldValue, value);
        } else if ("parent".equals(key)) {
            DBObject oldValue = this.m_parent;
            this.m_parent = (DBObject)value;
        } else if (!"type".equals(key)) {
            this.m_properties.put(key, value);
        }
    }

    protected final void firePropertyChanged(final String key, Object oldValue, Object newValue) {
        if (ModelUtil.areDifferent((Object)oldValue, (Object)newValue)) {
            final PropertyChangeEvent pce = new PropertyChangeEvent(this, key, oldValue, newValue);
            oracle.javatools.db.event.DBObjectChange change = new oracle.javatools.db.event.DBObjectChange(this, null){

                @Override
                public Map<String, PropertyChangeEvent> getPropertiesChanged() {
                    return Collections.singletonMap(key, pce);
                }
            };
            this.fireObjectUpdated(change);
        }
    }

    protected final void removeThisAsParent(ChildDBObject child) {
        if (child != null && child.getParent() == this) {
            child.setParent(null);
        }
    }

    protected final void changeParent(ChildDBObject oldChild, ChildDBObject newChild) {
        this.removeThisAsParent(oldChild);
        if (newChild != null) {
            newChild.setParent(this);
        }
    }

    @Override
    public final DBObject[] getOwnedObjects() {
        return this.getOwnedObjects(null);
    }

    @Override
    public final DBObject[] getOwnedObjects(String ... types) {
        String[] typeArray = types;
        if (types != null) {
            for (String type : types) {
                if (!"UNSPECIFIED_TYPE".equals(type)) continue;
                typeArray = null;
                break;
            }
        }
        ArrayList<DBObject> kids = new ArrayList<DBObject>();
        this.getOwnedObjectsImpl(kids, typeArray);
        return kids.toArray(new DBObject[kids.size()]);
    }

    @Override
    public final DBObject findOwnedObject(String type, String name) {
        DBObject retval = null;
        DBObject[] kids = this.getOwnedObjects(type);
        for (int i = 0; i < kids.length; ++i) {
            if (!ModelUtil.areEqual((Object)name, (Object)kids[i].getName())) continue;
            retval = kids[i];
            break;
        }
        return retval;
    }

    @Override
    public final DBObject findOwnedObject(DBObjectID id) {
        return this.findOwnedObject(id, true);
    }

    @Override
    public DBObject findOwnedObject(DBObjectID id, boolean strict) {
        return this.findOwnedObject(id, strict, false);
    }

    protected final DBObject findOwnedObject(DBObjectID id, boolean strict, boolean deep) {
        DBObject retval = null;
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject obj = id.resolveID();
                if (obj.getParent() == this) {
                    retval = obj;
                }
            }
            catch (DBException e) {}
        } else if (id != null) {
            DBObject kid;
            int i$;
            DBObject[] arr$ = this.getOwnedObjects(id.getType());
            int len$ = arr$.length;
            for (i$ = 0; !(i$ >= len$ || id.equals((kid = arr$[i$]).getID(), strict) && (retval = kid) != null); ++i$) {
            }
            if (deep && retval == null) {
                arr$ = this.getOwnedObjects();
                len$ = arr$.length;
                for (i$ = 0; !(i$ >= len$ || (kid = arr$[i$]) instanceof AbstractDBObject && (retval = ((AbstractDBObject)kid).findOwnedObject(id, strict, true)) != null); ++i$) {
                }
            }
        }
        return retval;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        objs.addAll(this.m_properties.getOwnedObjects(types));
    }

    protected final void includeOwnedObject(Collection<DBObject> objs, DBObject obj, String ... types) {
        if (this.includesType(obj, types)) {
            objs.add(obj);
        }
    }

    protected final boolean includesType(String type, String ... types) {
        return this.includesType(type, (Class<? extends DBObject>)null, types);
    }

    protected final boolean includesType(DBObject obj, String ... types) {
        if (obj != null) {
            return this.includesType(obj.getType(), obj.getClass(), types);
        }
        return false;
    }

    private final boolean includesType(String type, Class<? extends DBObject> clz, String ... types) {
        if (ModelUtil.hasNonNullElement((Object[])types)) {
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals(type)) continue;
                return true;
            }
            Metadata m = Metadata.getInstance();
            for (String searchType : types) {
                Collection<String> implTypes;
                Class<? extends DBObject> searchClass = m.getObjectClass(searchType);
                if (searchClass == null) continue;
                if (clz != null && searchClass.isAssignableFrom(clz)) {
                    return true;
                }
                if (Metadata.isRealBean(searchClass) || !(implTypes = m.getAllTypes(searchClass)).contains(type)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean removeOwnedObject(DBObject child) {
        return this.m_properties.removeOwnedObject(child);
    }

    @Override
    public final DBObjectID[] getReferenceIDs() {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        this.getReferenceIDsImpl(refs);
        return refs.toArray(new DBObjectID[refs.size()]);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        this.m_properties.addAllReferenceIDs(refs);
    }

    @Override
    public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> idMap) {
        return this.m_properties.replaceReferenceIDs(idMap);
    }

    protected final ChildSupport getChildSupport(String propName) {
        return this.m_properties.findOrCreateChildSupport(propName);
    }

    private boolean isChildUnordered(String propName) {
        return propName.equals("constraints") || propName.equals("indexes");
    }

    private class ListenerBridge
    extends oracle.javatools.db.event.DBObjectListener {
        private Object m_list;

        ListenerBridge(Object list) {
            this.m_list = list;
        }

        public void objectUpdated(oracle.javatools.db.event.DBObjectChange change) {
            if (change instanceof DBObjectChange) {
                if (this.m_list instanceof SchemaObjectListener) {
                    ((SchemaObjectListener)this.m_list).schemaObjectUpdated((DBObjectChange)change);
                } else if (this.m_list instanceof oracle.javatools.db.event.DBObjectListener) {
                    ((oracle.javatools.db.event.DBObjectListener)this.m_list).objectUpdated((DBObjectChange)change);
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof ListenerBridge && ModelUtil.areEqual((Object)this.m_list, (Object)((ListenerBridge)obj).m_list);
        }
    }

    protected final class ListenerSupport {
        private final Collection<oracle.javatools.db.event.DBObjectListener> m_listeners = new CopyOnWriteArraySet<oracle.javatools.db.event.DBObjectListener>();

        public void addBridgedListener(Object obj) {
            if (obj != null) {
                this.addObjectListener(new ListenerBridge(obj));
            }
        }

        public void removeBridgedListener(Object obj) {
            if (obj != null) {
                this.removeObjectListener(new ListenerBridge(obj));
            }
        }

        public void removeObjectListener(oracle.javatools.db.event.DBObjectListener list) {
            if (list != null) {
                this.m_listeners.remove(list);
            }
        }

        public void addObjectListener(oracle.javatools.db.event.DBObjectListener list) {
            if (list != null) {
                this.m_listeners.add(list);
            }
        }

        public void fireObjectUpdated(oracle.javatools.db.event.DBObjectChange change) {
            for (oracle.javatools.db.event.DBObjectListener list : this.m_listeners) {
                try {
                    list.objectUpdated(change);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, MessageFormat.format("listener {0} threw exception:", list.getClass()), e);
                }
            }
        }
    }

    private abstract class ChildRunnable {
        private ChildRunnable() {
        }

        public abstract void run(List var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertySupport
    extends AbstractMap<String, Object> {
        private final Map<String, Object> m_cache = new ConcurrentHashMap<String, Object>();
        private final Map<String, ChildSupport> m_childSupportCache = new HashMap<String, ChildSupport>();

        PropertySupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChildSupport findOrCreateChildSupport(String prop) {
            Map<String, ChildSupport> map = this.m_childSupportCache;
            synchronized (map) {
                ChildSupport retval = this.m_childSupportCache.get(prop);
                if (retval == null) {
                    retval = new ChildSupport(prop);
                    this.m_childSupportCache.put(prop, retval);
                }
                return retval;
            }
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.m_cache.entrySet();
        }

        @Override
        public Object put(String name, Object value) {
            Object replaced = value == null ? this.m_cache.remove(name) : this.m_cache.put(name, value);
            if (replaced != value) {
                if (replaced instanceof Object[] || value instanceof Object[]) {
                    if (value instanceof DBObject[]) {
                        if (AbstractDBObject.this.isChildUnordered(name)) {
                            Arrays.sort((DBObject[])value, DBUtil.getTypeComparator());
                        }
                        for (Object o : (Object[])value) {
                            if (o != null) continue;
                            DBLog.getLogger(this).severe("null child");
                        }
                    }
                    this.findOrCreateChildSupport(name).ensureParentsAndFireEvents((Object[])replaced, (Object[])value);
                } else {
                    this.removeCurrentParent(replaced);
                    this.setCurrentParent(value);
                    AbstractDBObject.this.firePropertyChanged(name, replaced, value);
                }
            }
            return replaced;
        }

        private void removeCurrentParent(Object child) {
            if (child instanceof ChildDBObject) {
                AbstractDBObject.this.removeThisAsParent((ChildDBObject)child);
            } else if (child instanceof Object[]) {
                for (Object obj : (Object[])child) {
                    if (!(obj instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.removeThisAsParent((ChildDBObject)obj);
                }
            }
        }

        private void setCurrentParent(Object child) {
            if (child instanceof ChildDBObject) {
                AbstractDBObject.this.changeParent(null, (ChildDBObject)child);
            } else if (child instanceof Object[]) {
                for (Object obj : (Object[])child) {
                    if (!(obj instanceof ChildDBObject)) continue;
                    AbstractDBObject.this.changeParent(null, (ChildDBObject)obj);
                }
            }
        }

        void addAllReferenceIDs(Collection<DBObjectID> retval) {
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                String key = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(key)) continue;
                Object obj = entry.getValue();
                if (obj instanceof DBObjectID) {
                    retval.add((DBObjectID)obj);
                    continue;
                }
                if (!(obj instanceof Object[])) continue;
                for (Object item : (Object[])obj) {
                    if (!(item instanceof DBObjectID)) continue;
                    retval.add((DBObjectID)item);
                }
            }
        }

        public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> idMap) {
            boolean replaced = false;
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                String key = entry.getKey();
                if (Metadata.getInstance().isStaticReferenceProperty(key)) continue;
                Object value = entry.getValue();
                if (value instanceof DBObjectID) {
                    DBObjectID replacement = idMap.get(value);
                    if (replacement == null) continue;
                    entry.setValue(replacement);
                    replaced = true;
                    continue;
                }
                if (!(value instanceof Object[])) continue;
                Object[] arr = (Object[])value;
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    if (!(o instanceof DBObjectID) || !idMap.containsKey(o)) continue;
                    arr[i] = idMap.get(o);
                    replaced = true;
                }
            }
            return replaced;
        }

        public Collection<DBObject> getOwnedObjects(String ... types) {
            ArrayList<DBObject> kids = new ArrayList<DBObject>();
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof DBObject && ModelUtil.areDifferent((Object)"schema", (Object)entry.getKey())) {
                    AbstractDBObject.this.includeOwnedObject(kids, (DBObject)value, types);
                    continue;
                }
                if (!(value instanceof Object[])) continue;
                for (Object kid : (Object[])value) {
                    if (!(kid instanceof DBObject)) continue;
                    AbstractDBObject.this.includeOwnedObject(kids, (DBObject)kid, types);
                }
            }
            return kids;
        }

        public boolean removeOwnedObject(DBObject child) {
            boolean retval = false;
            for (Map.Entry<String, Object> entry : this.m_cache.entrySet()) {
                ChildSupport cs;
                String propName = entry.getKey();
                Object value = entry.getValue();
                if (value == child) {
                    this.remove(propName);
                    retval = true;
                    break;
                }
                if (!(value instanceof Object[]) || !(cs = AbstractDBObject.this.getChildSupport(propName)).removeChild(child)) continue;
                retval = true;
                break;
            }
            return retval;
        }

        public void copyTo(PropertySupport target, IDPolicy idPolicy) {
            this.copyTo(target, idPolicy, null);
        }

        protected final void copyTo(PropertySupport target, IDPolicy idPolicy, Collection<String> excludes) {
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(this.m_cache.keySet());
            allKeys.addAll(target.m_cache.keySet());
            if (excludes != null) {
                allKeys.removeAll(excludes);
            }
            for (String propName : allKeys) {
                Object value = this.m_cache.get(propName);
                AbstractDBObject targetParent = target.getParentForChildren();
                if (value instanceof Object[]) {
                    if (target.containsKey(propName)) {
                        ChildSupport sourceKids = new ChildSupport(propName);
                        AbstractDBObject abstractDBObject = targetParent;
                        abstractDBObject.getClass();
                        ChildSupport targetKids = abstractDBObject.new ChildSupport(propName);
                        sourceKids.copyTo(targetKids, targetParent, idPolicy);
                        continue;
                    }
                    target.put(propName, AbstractDBObject.this.copyObject(value, targetParent, idPolicy));
                    continue;
                }
                if (value != null) {
                    Object existing = target.get(propName);
                    Object targetValue = value instanceof AbstractDBObject && existing != null && value.getClass().equals(existing.getClass()) ? ((AbstractDBObject)value).copyTo((AbstractDBObject)existing, targetParent, idPolicy) : AbstractDBObject.this.copyObject(value, targetParent, idPolicy);
                    target.put(propName, targetValue);
                    continue;
                }
                target.remove(propName);
            }
        }

        @Override
        public Object remove(Object key) {
            return this.put((String)key, (Object)null);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PropertySupport && this.equalsImpl((PropertySupport)obj);
        }

        private boolean equalsImpl(PropertySupport other) {
            return DBUtil.areEqualIgnoreNullValues(this.m_cache, other.m_cache);
        }

        public AbstractDBObject getParentForChildren() {
            return AbstractDBObject.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildSupport {
        private final String m_key;
        private final Lock m_lock = new ReentrantLock();
        private Class m_clz;

        private ChildSupport(String key) {
            this.m_key = key;
        }

        private void lock() {
            this.m_lock.lock();
        }

        private void unlock() {
            this.m_lock.unlock();
        }

        private Class getComponentType() {
            if (this.m_clz == null) {
                PropertyInfo info = PropertyHelper.findPropertyInfo(AbstractDBObject.this.getClass(), this.m_key, (DBObjectProvider)null);
                if (info == null) {
                    DBLog.getLogger(AbstractDBObject.this).warning("unrecognized child property: " + this.m_key);
                } else {
                    Class propClz = info.getPropertyClass();
                    if (propClz.isArray()) {
                        this.m_clz = propClz.getComponentType();
                    } else {
                        DBLog.getLogger(AbstractDBObject.this).warning("child property is not an array: " + this.m_key);
                    }
                }
            }
            return this.m_clz;
        }

        private boolean canAddChild(List childList, Object child) {
            boolean retval = true;
            if (child instanceof ChildDBObject) {
                retval = this.indexOfChildDBObject(childList, (ChildDBObject)child) < 0;
            }
            return retval;
        }

        private int indexOfChild(List childList, Object child) {
            int retval = -1;
            retval = child instanceof ChildDBObject ? this.indexOfChildDBObject(childList, (ChildDBObject)child) : childList.indexOf(child);
            return retval;
        }

        private int indexOfChildDBObject(List childList, ChildDBObject child) {
            int retval = -1;
            if (child != null) {
                for (int i = 0; i < childList.size(); ++i) {
                    Object listed = childList.get(i);
                    if (child != listed) continue;
                    retval = i;
                    break;
                }
            }
            return retval;
        }

        public void addChild(Object child) {
            this.addChildImpl(null, child);
        }

        public void addChild(int idx, Object child) {
            this.addChildImpl(idx, child);
        }

        private void addChildImpl(final Integer idx, final Object child) {
            if (child != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    public void run(List childList) {
                        if (ChildSupport.this.canAddChild(childList, child)) {
                            if (idx == null) {
                                childList.add(child);
                            } else {
                                childList.add(idx, child);
                            }
                            ChildSupport.this.setChildren(childList);
                        }
                    }
                });
            }
        }

        public boolean moveChild(final Object child, final int newIdx) {
            final Holder retval = new Holder((Object)false);
            if (child != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    public void run(List kids) {
                        int oldIndex;
                        if (kids != null && (oldIndex = kids.indexOf(child)) != newIdx && ChildSupport.this.removeFromList(kids, child)) {
                            kids.add(newIdx, child);
                            ChildSupport.this.setChildren(kids);
                            retval.set((Object)true);
                        }
                    }
                });
            }
            return (Boolean)retval.get();
        }

        public int indexOfChild(final Object child) {
            final Holder retval = new Holder((Object)-1);
            if (child != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    public void run(List childList) {
                        if (childList != null) {
                            retval.set((Object)ChildSupport.this.indexOfChild(childList, child));
                        }
                    }
                });
            }
            return (Integer)retval.get();
        }

        @Deprecated
        public <T> T setChildAt(int index, T child) {
            return null;
        }

        public boolean removeChild(final Object child) {
            final Holder retval = new Holder((Object)false);
            this.runUnderChildLock(new ChildRunnable(){

                public void run(List childList) {
                    if (childList != null && ChildSupport.this.removeFromList(childList, child)) {
                        retval.set((Object)true);
                        ChildSupport.this.setChildren(childList);
                    }
                }
            });
            return (Boolean)retval.get();
        }

        private boolean removeFromList(List list, Object child) {
            boolean retval = false;
            if (child instanceof ChildDBObject) {
                int i = this.indexOfChildDBObject(list, (ChildDBObject)child);
                if (i >= 0) {
                    list.remove(i);
                    retval = true;
                }
            } else {
                retval = list.remove(child);
            }
            return retval;
        }

        public Object findChild(String childName) {
            return this.findChild(childName, null);
        }

        private Object findChild(final String childName, final Integer childIndex) {
            final Holder retval = new Holder();
            if (childName != null) {
                this.runUnderChildLock(new ChildRunnable(){

                    public void run(List kids) {
                        for (int i = 0; i < kids.size(); ++i) {
                            boolean alreadyFound = false;
                            Object kid = kids.get(i);
                            if (!(kid instanceof DBObject) || !ModelUtil.areEqual((Object)childName, (Object)((DBObject)kid).getName())) continue;
                            retval.set(kid);
                            if (childIndex == null || i == childIndex) break;
                            if (alreadyFound) {
                                retval.set(null);
                                break;
                            }
                            boolean bl = true;
                        }
                    }
                });
            }
            return retval.get();
        }

        public void clearChildren() {
            AbstractDBObject.this.setProperty(this.m_key, null);
        }

        public <T> T[] getChildArray(Class<T> clz) {
            Object[] val = this.getArrayPropertyValue();
            Object[] retval = val == null ? (Object[])Array.newInstance(clz, 0) : val;
            return retval;
        }

        public void setChildArray(Object[] newKids) {
            if (newKids != null && newKids.length == 0) {
                newKids = null;
            }
            AbstractDBObject.this.setProperty(this.m_key, newKids);
        }

        private void setChildren(List newKids) {
            this.setChildArray(this.toArray(newKids));
        }

        /*
         * WARNING - void declaration
         */
        private void ensureParentsAndFireEvents(final Object[] oldKids, final Object[] kids) {
            final ArrayList<Object> addedKids = new ArrayList<Object>();
            final ArrayList<Object> removedKids = new ArrayList<Object>();
            if (oldKids != null) {
                void var7_12;
                Object[] arr$ = oldKids;
                int len$ = arr$.length;
                boolean bl = false;
                while (var7_12 < len$) {
                    Object oldKid = arr$[var7_12];
                    removedKids.add(oldKid);
                    ++var7_12;
                }
            }
            boolean sameOrder = true;
            if (kids != null) {
                void var7_14;
                List<Object> oldKidsList = oldKids == null ? Collections.emptyList() : Arrays.asList(oldKids);
                boolean bl = false;
                while (var7_14 < kids.length) {
                    Object newKid = kids[var7_14];
                    if (newKid != null) {
                        int oldIndex = this.indexOfChild(oldKidsList, newKid);
                        if (oldIndex != var7_14) {
                            sameOrder = false;
                        }
                        if (oldIndex > -1) {
                            this.removeFromList(removedKids, newKid);
                        } else {
                            addedKids.add(newKid);
                            AbstractDBObject.this.m_properties.setCurrentParent(newKid);
                        }
                    }
                    ++var7_14;
                }
            }
            for (Object e : removedKids) {
                AbstractDBObject.this.m_properties.removeCurrentParent(e);
            }
            if (addedKids.size() > 0 || removedKids.size() > 0 || !sameOrder) {
                final boolean isChildDBObject = oldKids instanceof DBObject[] || kids instanceof DBObject[];
                AbstractDBObject.this.fireObjectUpdated(new oracle.javatools.db.event.DBObjectChange(AbstractDBObject.this, null){

                    @Override
                    public List<DBObject> getOwnedObjectsAdded() {
                        return isChildDBObject ? addedKids : super.getOwnedObjectsAdded();
                    }

                    @Override
                    public List<DBObject> getOwnedObjectsRemoved() {
                        return isChildDBObject ? removedKids : super.getOwnedObjectsRemoved();
                    }

                    @Override
                    public Map<String, PropertyChangeEvent> getPropertiesChanged() {
                        try {
                            PropertyChangeEvent event = new PropertyChangeEvent(AbstractDBObject.this, ChildSupport.this.m_key, oldKids, kids);
                            return Collections.singletonMap(ChildSupport.this.m_key, event);
                        }
                        catch (Exception e) {
                            DBLog.getLogger(this).log(Level.SEVERE, "Error firing property change", e);
                            return super.getPropertiesChanged();
                        }
                    }
                });
            }
        }

        private Object[] toArray(List childList) {
            Object[] retval = null;
            if (childList != null && childList.size() > 0) {
                Class clz = this.getComponentType();
                if (clz == null) {
                    for (Object child : childList) {
                        if (child == null) continue;
                        Class<?> kidClz = child.getClass();
                        clz = DBUtil.findCommonSuperclass(kidClz, clz);
                    }
                }
                if (clz != null) {
                    try {
                        retval = (Object[])Array.newInstance(clz, childList.size());
                        retval = childList.toArray(retval);
                    }
                    catch (ArrayStoreException ase) {
                        DBLog.getLogger(this).severe("Invalid property value for property " + this.m_key);
                    }
                }
            }
            return retval;
        }

        public int getChildCount() {
            Object[] val = this.getArrayPropertyValue();
            return val == null ? 0 : val.length;
        }

        @Deprecated
        public List getChildList(boolean create) {
            Object[] array = this.getArrayPropertyValue();
            return array == null ? Collections.emptyList() : Arrays.asList(array);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runUnderChildLock(ChildRunnable run) {
            ArrayList<Object> kids = new ArrayList<Object>();
            Object[] array = this.getArrayPropertyValue();
            this.lock();
            try {
                if (array != null) {
                    for (Object kid : array) {
                        kids.add(kid);
                    }
                }
                run.run(kids);
                Object var9_8 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.unlock();
                throw throwable;
            }
        }

        private Object[] getArrayPropertyValue() {
            Object[] retval;
            Object obj = AbstractDBObject.this.getProperty(this.m_key);
            if (obj instanceof Object[]) {
                retval = (Object[])obj;
            } else if (obj == null) {
                retval = null;
            } else {
                throw new IllegalStateException("property is not a list: " + this.m_key);
            }
            return retval;
        }

        private void copyTo(ChildSupport target, AbstractDBObject copyParent, IDPolicy idPolicy) {
            Object[] kids = this.getArrayPropertyValue();
            if (kids == null) {
                target.clearChildren();
            } else {
                ArrayList<Object> newKids = new ArrayList<Object>(kids.length);
                for (int i = 0; i < kids.length; ++i) {
                    Object copy;
                    Object obj = kids[i];
                    if (obj instanceof AbstractDBObject) {
                        String name = (String)((AbstractDBObject)obj).m_properties.get("name");
                        DBObject existing = name == null ? null : (DBObject)target.findChild(name, i);
                        copy = ((AbstractDBObject)obj).copyTo(existing, copyParent, idPolicy);
                    } else {
                        copy = AbstractDBObject.this.copyObject(obj, copyParent, idPolicy);
                    }
                    newKids.add(copy);
                }
                target.setChildren(newKids);
            }
        }
    }
}

