/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectBuilder<T extends AbstractBuildableObject>
implements DBObjectBuilder<T> {
    static final Collection<String> s_specialProps = Arrays.asList("name", "ID", "parent", "properties", "schema", "type");
    private final AbstractDBObjectProvider m_pro;
    private final String m_type;
    private Boolean m_supportsTimestamp;
    private Map<String, Method> m_propMap;
    private MultiMap<String, String> m_derivedProperties;
    private final ConcurrentMap<String, Boolean> m_cancelled = new ConcurrentHashMap<String, Boolean>();

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider pro, String type) {
        this.m_type = type;
        this.m_pro = pro;
        if (this.m_pro == null) {
            this.m_supportsTimestamp = false;
        }
    }

    protected final String getObjectType() {
        return this.m_type;
    }

    protected final AbstractDBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    @Override
    public boolean canBuildEditableObject() {
        return true;
    }

    @Override
    public void cancelCurrentBuild(T object) {
        String key = this.getTimestampKey(object);
        this.m_cancelled.replace(key, false, true);
    }

    protected boolean isCurrentBuildCancelled(T object) {
        String key = this.getTimestampKey(object);
        return Boolean.TRUE.equals(this.m_cancelled.get(key));
    }

    protected void checkInterruptOrCancel(T object) throws CancelledException {
        if (Thread.currentThread().isInterrupted() || this.isCurrentBuildCancelled(object)) {
            throw new CancelledException();
        }
    }

    protected final Schema getSchema(String name) throws DBException {
        return this.m_pro.findSchema(name);
    }

    protected final SystemObject findObjectInProviderCache(String type, Schema schema, String name) {
        return this.m_pro == null ? null : this.m_pro.findObject(type, schema, name);
    }

    protected final SystemObject findObjectInProviderCache(DBObjectID id) {
        return this.m_pro == null ? null : this.m_pro.findObject(id);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clz, String name) {
        return this.newObject(clz, null, name);
    }

    protected final <D extends DBObject> D newObject(Class<? extends D> clz, DBObject parent, String name) {
        DBObjectFactory fac = this.getProvider().getObjectFactory();
        D retval = fac.newObject(clz, parent, false, false);
        retval.setName(name);
        return retval;
    }

    @Override
    public T createObject(String name, Schema schema, DBObjectID id) {
        String type = this.getObjectType();
        Class<? extends DBObject> clz = Metadata.getInstance().getObjectClass(type);
        AbstractBuildableObject retval = null;
        if (clz != null) {
            try {
                AbstractBuildableObject obj = (AbstractBuildableObject)this.newObject(clz, schema, name);
                obj.setID(id);
                retval = obj;
            }
            catch (Exception ex) {
                DBLog.getLogger(this).log(Level.SEVERE, "Error instantiating object", ex);
            }
        }
        return (T)retval;
    }

    private String getTimestampKey(T object) {
        return this.getClass().getSimpleName() + ":" + object.getType() + "#" + System.identityHashCode(object);
    }

    private void checkTimestamp(T obj) {
        if (!(this instanceof DerivedPropertyBuilder) && this.m_pro != null && this.m_pro.supportsTimestamps(obj.getType())) {
            AbstractBuildableObject exists = null;
            try {
                DBObjectID id = ((AbstractDBObject)obj).getID();
                exists = id == null ? (AbstractBuildableObject)DBUtil.getProviderDefinition(obj, (DBObjectProvider)this.m_pro) : (AbstractBuildableObject)id.resolveID();
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, "Couldn't lookup existing object: " + dbe.getMessage());
            }
            if (exists == null) {
                DBLog.getLogger(this).log(Level.WARNING, "Building {0} {1} but it doesn't exist any more.", new String[]{obj.getType(), ((AbstractDBObject)obj).getName()});
            }
        }
    }

    private boolean startBuild(T object) {
        boolean retval;
        String key = this.getTimestampKey(object);
        boolean bl = retval = this.m_cancelled.putIfAbsent(key, false) == null;
        if (retval) {
            DBUtil.suspendTimestampChecking(this.m_pro, key);
        }
        return retval;
    }

    private void finishBuild(T object) {
        String key = this.getTimestampKey(object);
        this.m_cancelled.remove(key);
        DBUtil.resumeTimestampChecking(this.m_pro, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void buildObject(T object) throws DBException {
        boolean started = this.startBuild(object);
        try {
            ((AbstractBuildableObject)object).getPropertySupport().setBuildingAll();
            this.checkTimestamp(object);
            this.fillInObject(object);
            ((AbstractBuildableObject)object).getPropertySupport().markAsBuilt();
            this.registerObject(object);
            Object var4_3 = null;
            if (started) {
                this.finishBuild(object);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (started) {
                this.finishBuild(object);
            }
            throw throwable;
        }
    }

    protected void fillInObject(T object) throws DBException {
        if (this.canBuildComponents()) {
            for (String key : this.getPropertyMethodMap().keySet()) {
                this.ensureComponent(object, key);
            }
        }
        for (DBObject obj : ((AbstractDBObject)object).getOwnedObjects()) {
            if (!(obj instanceof AbstractBuildableObject)) continue;
            ((AbstractBuildableObject)obj).checkInit();
        }
    }

    protected void registerObject(T object) throws DBException {
        this.updateTimestamp(object);
        if (object instanceof SchemaObject) {
            SchemaObjectManager m;
            SchemaObjectManager schemaObjectManager = m = this.m_pro == null ? null : this.m_pro.getCascadeManager();
            if (m != null) {
                m.registerObject((SystemObject)((SchemaObject)object), true);
            }
        }
    }

    @PropertyBuilder(value={"Timestamp"})
    public final void updateTimestamp(T object) throws DBException {
        this.updateTimestamp(object, false);
    }

    protected final void updateTimestamp(T object, boolean force) throws DBException {
        if (this.m_supportsTimestamp == null) {
            this.m_supportsTimestamp = this.m_pro.supportsTimestamps(this.getObjectType());
        }
        if (this.m_supportsTimestamp.booleanValue() && object instanceof SystemObject) {
            if (force) {
                this.m_pro.putCachedTimestampKey(((AbstractDBObject)object).getID(), null);
            }
            if (force || DBUtil.getFrozenProperties(object).get("Timestamp") == null) {
                ((AbstractDBObject)object).setProperty("Timestamp", this.m_pro.getExternalTimestamp((SystemObject)object));
            }
        }
    }

    protected final boolean needsBuilding(T obj, String key) {
        return this.needsBuilding(obj, key, false);
    }

    public final boolean needsBuilding(T obj, String key, boolean checkBuilder) {
        if (checkBuilder && !((AbstractBuildableObject)obj).needsInitialization()) {
            return false;
        }
        return !((AbstractBuildableObject)obj).isBuilt(key);
    }

    protected final void markAsBuilt(T obj) {
        ((AbstractBuildableObject)obj).getPropertySupport().markAsBuilt();
    }

    protected final void setBuilder(T obj) {
        ((AbstractBuildableObject)obj).getPropertySupport().setBuilder(this);
    }

    protected final void ensureComponent(T obj, String key) throws DBException {
        if (this.needsBuilding(obj, key)) {
            this.buildObjectComponent(obj, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void buildObjectComponent(T object, String key) throws DBException {
        if (!this.isBuildableProperty(key)) return;
        if (this.canBuildComponents()) {
            boolean started = this.startBuild(object);
            try {
                if (this.fillInObjectComponent(object, key)) {
                    this.registerObject(object);
                }
                Object var5_4 = null;
                if (!started) return;
                this.finishBuild(object);
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!started) throw throwable;
                this.finishBuild(object);
                throw throwable;
            }
        } else {
            this.buildObject(object);
        }
    }

    protected final boolean fillInObjectComponent(T object, String key) throws DBException {
        this.checkInterruptOrCancel(object);
        boolean retval = false;
        if (this.isBuildableProperty(key)) {
            if (!"Timestamp".equals(key)) {
                this.checkTimestamp(object);
            }
            String[] props = this.getBuiltProperties(key);
            try {
                try {
                    ((AbstractBuildableObject)object).getPropertySupport().startBuilding(props);
                    String[] depKeys = this.getPropertyDependencies(key);
                    if (depKeys != null) {
                        for (String depKey : depKeys) {
                            this.ensureComponent(object, depKey);
                        }
                    }
                    retval = this.fillInObjectComponentImpl(object, key);
                    this.markAsBuilt(object, props);
                }
                catch (CancelledException ce) {
                    ((AbstractBuildableObject)object).getPropertySupport().setUnbuilt(props);
                    throw ce;
                }
                Object var11_11 = null;
                ((AbstractBuildableObject)object).getPropertySupport().finishBuilding(props);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                ((AbstractBuildableObject)object).getPropertySupport().finishBuilding(props);
                throw throwable;
            }
        }
        return retval;
    }

    protected final void markAsBuilt(T object, String ... props) {
        ((AbstractBuildableObject)object).getPropertySupport().setBuilt(props);
    }

    protected boolean fillInObjectComponentImpl(T object, String prop) throws DBException {
        Method m = this.getPropertyMethodMap().get(prop);
        return this.invokeBuilderMethod(m, object, prop);
    }

    private boolean invokeBuilderMethod(Method m, T object, String key) throws DBException {
        boolean retval = true;
        try {
            Object got = m.invoke((Object)this, object);
            retval = !Boolean.FALSE.equals(got);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if (t instanceof DBException) {
                throw (DBException)t;
            }
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw new CancelledException();
            }
            String msg = "Build of property " + key + " failed: " + t.getMessage();
            this.getLogger().log(Level.SEVERE, msg, t);
            throw new DBException((DBObject)object, msg, t);
        }
        return retval;
    }

    protected boolean canBuildComponents() {
        return false;
    }

    protected boolean isBuildableProperty(String key) {
        boolean retval;
        boolean bl = retval = !s_specialProps.contains(key);
        if (retval && this.canBuildComponents()) {
            retval = this.getPropertyMethodMap().containsKey(key);
        }
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> c = this.getClass();
            for (Method m : c.getMethods()) {
                PropertyBuilder v = m.getAnnotation(PropertyBuilder.class);
                if (v == null) continue;
                for (String p : this.getBuiltProperties(v)) {
                    this.m_propMap.put(p, m);
                }
            }
        }
        return this.m_propMap;
    }

    protected String[] getBuiltProperties(String key) {
        String[] stringArray;
        PropertyBuilder pb = this.getAnnotation(key);
        if (pb == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = key;
        } else {
            stringArray = this.getBuiltProperties(pb);
        }
        return stringArray;
    }

    private String[] getBuiltProperties(PropertyBuilder pb) {
        String[] retval;
        if (pb.derived()) {
            ArrayList<String> props = new ArrayList<String>();
            for (String prop : pb.value()) {
                Collection<String> derived = this.getDerivedProperties(prop);
                if (derived == null) continue;
                props.addAll(derived);
            }
            retval = props.toArray(new String[props.size()]);
        } else {
            retval = pb.value();
        }
        return retval;
    }

    String[] getPropertyDependencies(String property) {
        PropertyBuilder pb = this.getAnnotation(property);
        return pb == null ? null : pb.depends();
    }

    private PropertyBuilder getAnnotation(String key) {
        PropertyBuilder pb = null;
        Method m = this.getPropertyMethodMap().get(key);
        if (m != null) {
            pb = m.getAnnotation(PropertyBuilder.class);
        }
        return pb;
    }

    private synchronized Map<String, Collection<String>> getDerivedPropertyMap() {
        if (this.m_derivedProperties == null) {
            this.m_derivedProperties = new MultiMap();
            Metadata m = Metadata.getInstance();
            Class<? extends DBObject> objClz = m.getObjectClass(this.getObjectType());
            PropertyManager propMgr = this.getProvider().getPropertyManager();
            for (String prop : m.getSupportedProperties(objClz, null)) {
                PropertyInfo info = propMgr.findPropertyInfo(objClz, prop);
                if (info == null || !info.isDerived()) continue;
                this.m_derivedProperties.add((Object)info.getDerivedSourceProperty(), (Object)prop);
            }
        }
        return this.m_derivedProperties;
    }

    public Collection<String> getDerivedProperties(String property) {
        Collection<String> c = this.getDerivedPropertyMap().get(property);
        return c == null ? null : Collections.unmodifiableCollection(c);
    }

    protected String getDerivedPropertySource(String property) {
        String retval = null;
        for (Map.Entry<String, Collection<String>> entry : this.getDerivedPropertyMap().entrySet()) {
            if (!entry.getValue().contains(property)) continue;
            retval = entry.getKey();
            break;
        }
        return retval;
    }

    protected void replaceReferenceIDs(T object, Map<DBObjectID, DBObjectID> idMap) {
        ((AbstractDBObject)object).replaceReferenceIDsDirectly(idMap);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PropertyBuilder {
        public String[] value();

        public String[] depends() default {};

        public boolean derived() default false;
    }
}

