/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ObjectCache;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.CascadeProcessor;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.util.DBObjectIDMultiMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.db.util.NameComparator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectProvider
implements DBObjectProvider {
    public static final int MIXED_CASE_NAME_POLICY = 0;
    public static final int LOWER_CASE_NAME_POLICY = 1;
    public static final int UPPER_CASE_NAME_POLICY = 2;
    public static final int CASE_SENSITIVE_NAME_POLICY = 3;
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    public static final String NEW_FROM_TEMPLATE_TYPE = "<?>";
    private final Set<String> m_timestampKeys = new HashSet<String>();
    private final Map m_timestamps = new HashMap();
    private SchemaObjectManager m_objManager;
    private final ObjectCache m_objectCache;
    private final List<oracle.javatools.db.event.DBObjectProviderListener> m_listeners = new CopyOnWriteArrayList<oracle.javatools.db.event.DBObjectProviderListener>();
    private final MultiMap<DBObjectCriteria, DBObjectListener> m_objectListeners = new MultiMap(ConcurrentHashMap.class, CopyOnWriteArrayList.class);
    private final MultiMap<DBObjectID, DBObjectListener> m_objectSpecficListeners = new DBObjectIDMultiMap<DBObjectListener>(true, true);
    private final Collection<DBObject> m_resetLocks = new IdentitySet<DBObject>();
    private DBObjectFactory m_dbObjFactory;
    private DDLGenerator m_ddlGenerator;
    protected static final String[] EMPTY_LIST = new String[0];

    protected AbstractDBObjectProvider() {
        this(false);
    }

    protected AbstractDBObjectProvider(boolean weakCaching) {
        this.m_objectCache = new ObjectCache(this, weakCaching);
    }

    @Override
    public final String getDescription() {
        return DBObjectProviderFactory.getDescription(this.getProviderType(), this.getProviderIdentifier());
    }

    public boolean isClosed() {
        return false;
    }

    @Override
    public final void removeProviderListener(oracle.javatools.db.event.DBObjectProviderListener list) {
        this.m_listeners.remove(list);
    }

    @Override
    @Deprecated
    public final void removeProviderListener(DBObjectProviderListener list) {
        for (oracle.javatools.db.event.DBObjectProviderListener rl : this.m_listeners) {
            if (!(rl instanceof ListenerBridge) || !((ListenerBridge)rl).isBridgeFor(list)) continue;
            this.m_listeners.remove(rl);
        }
    }

    @Override
    public final void addProviderListener(oracle.javatools.db.event.DBObjectProviderListener list) {
        if (list != null && !this.m_listeners.contains(list)) {
            this.m_listeners.add(list);
        }
    }

    @Override
    @Deprecated
    public final void addProviderListener(DBObjectProviderListener list) {
        this.addProviderListener(new ListenerBridge(list));
    }

    @Override
    public final void addObjectListener(DBObjectListener list, DBObjectCriteria crit) {
        if (list != null) {
            crit = crit == null ? DBObjectCriteria.createTypeCriteria(new String[0]) : crit.clone();
            crit.setDatabaseDescriptor(this.getDescriptor());
            if (!this.m_objectListeners.contains(crit, (Object)list)) {
                this.m_objectListeners.add(crit, (Object)list);
            }
        }
    }

    @Override
    public final void addObjectListener(DBObjectListener list, SystemObject obj) {
        this.addObjectListener(list, obj.getID());
    }

    @Override
    public final void addObjectListener(DBObjectListener list, DBObjectID id) {
        if (id != null && list != null && !this.m_objectSpecficListeners.contains((Object)id, (Object)list)) {
            this.m_objectSpecficListeners.add((Object)id, (Object)list);
        }
    }

    @Override
    public final void removeObjectListener(DBObjectListener list) {
        for (Object key : this.m_objectListeners.keySet()) {
            this.m_objectListeners.remove(key, (Object)list);
        }
        for (Object key : this.m_objectSpecficListeners.keySet()) {
            this.m_objectSpecficListeners.remove(key, (Object)list);
        }
    }

    protected final void fireProviderClosed() {
        this.logEvent("fire provider {0} closed", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
            try {
                list.providerClosed(this);
            }
            catch (Exception e) {
                this.processListenerException(list, e);
            }
        }
    }

    @Deprecated
    public final void fireProviderDeleted() {
    }

    protected final void fireProviderOpened() {
        this.logEvent("fire provider {0} opened", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
            try {
                list.providerOpened(this);
            }
            catch (Exception e) {
                this.processListenerException(list, e);
            }
        }
    }

    protected final void fireProviderReloaded() {
        this.logEvent("fire provider {0} reloaded", this.getName());
        for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
            try {
                list.providerReloaded(this);
            }
            catch (Exception e) {
                this.processListenerException(list, e);
            }
        }
    }

    @Deprecated
    protected final void fireSchemaAdded(Schema schema) {
        this.fireObjectsAdded(Collections.singleton(schema));
    }

    protected final void fireObjectsAdded(Collection<? extends SystemObject> sysObjs) {
        if (sysObjs != null && sysObjs.size() > 0) {
            this.logListEvent("system objects added", sysObjs);
            for (Map.Entry<Schema, Collection<SystemObject>> entry : DBUtil.sortIntoSchemas(sysObjs).entrySet()) {
                Schema schema = entry.getKey();
                for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
                    try {
                        Collection<SystemObject> sortedObjs = entry.getValue();
                        if (schema == null) {
                            list.systemObjectsAdded(this, sortedObjs);
                            continue;
                        }
                        list.schemaObjectsAdded(this, schema, sortedObjs);
                    }
                    catch (Exception e) {
                        this.processListenerException(list, e);
                    }
                }
            }
        }
    }

    @Deprecated
    protected final void fireSchemaUpdated(DBObjectChange change) {
        this.fireObjectUpdated(change);
    }

    @Deprecated
    protected final void fireSchemaObjectUpdated(DBObjectChange change) {
        this.fireObjectUpdated(change);
    }

    protected final void fireObjectUpdated(DBObjectChange change) {
        DBObject obj = change.getDBObject();
        if (!(obj instanceof SystemObject)) {
            throw new IllegalStateException("cannot fire event on non-SystemObject.");
        }
        this.logEvent("fire schema object {0} updated in {1}", obj.getName(), this.getName());
        HashSet listeners = new HashSet();
        Set entrySet = this.m_objectListeners.entrySet();
        for (Map.Entry entry : entrySet) {
            DBObjectCriteria dBObjectCriteria = (DBObjectCriteria)entry.getKey();
            boolean accept = true;
            if (dBObjectCriteria != null) {
                PropertyChangeEvent renameEvent = change.getPropertyChange("name");
                accept = renameEvent != null ? dBObjectCriteria.accept(obj.getType(), DBUtil.getSchema(obj), (String)renameEvent.getOldValue()) : dBObjectCriteria.accept((SystemObject)obj);
            }
            if (!accept) continue;
            listeners.addAll((Collection)entry.getValue());
        }
        DBObjectID id = obj.getID();
        if (id != null) {
            DBObjectID oldID = null;
            PropertyChangeEvent propertyChangeEvent = change.getPropertyChange("ID");
            if (propertyChangeEvent != null) {
                oldID = (DBObjectID)propertyChangeEvent.getOldValue();
            } else if (id instanceof NameBasedID) {
                PropertyChangeEvent nameEvent = change.getPropertyChange("name");
                PropertyChangeEvent schemaEvent = change.getPropertyChange("schema");
                if (nameEvent != null || schemaEvent != null) {
                    oldID = (NameBasedID)id.copyTo(null);
                    if (nameEvent != null) {
                        ((NameBasedID)oldID).setName((String)nameEvent.getOldValue());
                    }
                    if (schemaEvent != null) {
                        ((NameBasedID)oldID).setSchema((Schema)schemaEvent.getOldValue());
                    }
                }
            }
            Collection objListeners = null;
            if (oldID == null) {
                objListeners = this.m_objectSpecficListeners.get((Object)id);
            } else if (!oldID.equals(id, true) && (objListeners = this.m_objectSpecficListeners.get((Object)oldID)) != null) {
                this.m_objectSpecficListeners.addAll((Object)id, objListeners);
                this.m_objectSpecficListeners.remove((Object)oldID);
            }
            if (objListeners != null) {
                listeners.addAll(objListeners);
            }
        }
        for (DBObjectListener dBObjectListener : listeners) {
            try {
                dBObjectListener.objectUpdated(change);
            }
            catch (Exception e) {
                this.processListenerException(dBObjectListener, e);
            }
        }
        for (oracle.javatools.db.event.DBObjectProviderListener dBObjectProviderListener : this.m_listeners) {
            try {
                dBObjectProviderListener.objectUpdated(change);
            }
            catch (Exception e) {
                this.processListenerException(dBObjectProviderListener, e);
            }
        }
    }

    @Deprecated
    protected final void fireSchemaRemoved(Schema schema) {
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    private void logListEvent(String action, Iterable<? extends DBObject> objs) {
        Level level;
        Logger log = this.getLogger();
        if (log.isLoggable(level = DBLog.getEventLogLevel())) {
            StringBuffer b = new StringBuffer();
            b.append("fire ");
            b.append(action);
            b.append(" in provider ");
            b.append(this.getName());
            b.append(": ");
            for (DBObject dBObject : objs) {
                b.append(DBUtil.getFullyQualifiedName(dBObject, true));
                b.append(" ");
            }
            this.logEvent(b.toString(), new Object[0]);
        }
    }

    protected final void fireObjectsRemoved(Collection<? extends SystemObject> sysObjs) {
        if (sysObjs != null && sysObjs.size() > 0) {
            this.logListEvent("system objects removed", sysObjs);
            for (Map.Entry<Schema, Collection<SystemObject>> entry : DBUtil.sortIntoSchemas(sysObjs).entrySet()) {
                Schema schema = entry.getKey();
                for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
                    try {
                        Collection<SystemObject> sortedObjs = entry.getValue();
                        if (schema == null) {
                            list.systemObjectsRemoved(this, sortedObjs);
                            continue;
                        }
                        list.schemaObjectsRemoved(this, schema, sortedObjs);
                    }
                    catch (Exception e) {
                        this.processListenerException(list, e);
                    }
                }
            }
        }
    }

    @Deprecated
    public final void fireObjectsAdded(Schema schema, SchemaObject[] objs) {
        this.fireObjectsAdded(Arrays.asList(objs));
    }

    @Deprecated
    protected final void fireObjectsRemoved(Schema schema, SchemaObject[] objs) {
        this.fireObjectsRemoved(Arrays.asList(objs));
    }

    private void processListenerException(Object listener, Exception e) {
        this.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", listener.getClass()), e);
    }

    protected final void registerType(String type, DBObjectBuilder builder, DBObjectValidator validator) {
        this.m_objectCache.registerType(type, builder, validator);
    }

    protected final void registerBuilder(String type, DBObjectBuilder builder) {
        this.registerType(type, builder, null);
    }

    protected DBObjectBuilder getBuilderForType(String type) {
        return this.m_objectCache.getBuilderForType(type);
    }

    protected final void registerValidator(String type, DBObjectValidator validator) {
        this.registerType(type, null, validator);
    }

    public final DBObjectValidator getValidatorForType(String type) {
        return this.m_objectCache.getValidatorForType(type);
    }

    protected SystemObject findObject(String type, Schema schema, String name) {
        return this.m_objectCache.findObject(type, null, schema, name);
    }

    protected final SystemObject findObject(DBObjectID id) {
        SystemObject object = null;
        if (id != null) {
            object = this.m_objectCache.findObject(id);
        }
        return object;
    }

    protected void destroyCache() {
        this.clearAllCaches();
        this.m_objectCache.destroyCache();
    }

    public void clearAllCaches() {
        this.m_objectCache.clearAllCaches();
        if (this.m_objManager != null) {
            this.m_objManager.clearAllCaches();
        }
        if (this.m_timestampKeys != null) {
            this.m_timestampKeys.clear();
            this.m_timestamps.clear();
        }
        this.m_ddlGenerator = null;
    }

    @Override
    public synchronized SchemaObjectManager getCascadeManager() {
        if (this.m_objManager == null) {
            this.m_objManager = this.createObjectManager();
        }
        return this.m_objManager;
    }

    @Override
    @Deprecated
    public final SchemaObjectManager getObjectManager() {
        return this.getCascadeManager();
    }

    protected SchemaObjectManager createObjectManager() {
        return new SchemaObjectManager(this);
    }

    protected void cacheObject(SystemObject object, boolean loadOperation) {
        if (object != null) {
            this.m_objectCache.cacheObject(object);
            this.getCascadeManager().registerObject(object, loadOperation);
        }
    }

    protected final void uncacheObject(SystemObject object) {
        if (object != null) {
            this.m_objectCache.uncacheObject(object);
            if (object instanceof Table && !DBUtil.needsBuilding(object, "indexes")) {
                Index[] indexes;
                for (Index index : indexes = ((Table)object).getIndexes()) {
                    this.uncacheObject(index);
                }
            }
            if (this.m_objManager != null) {
                this.m_objManager.unregisterObject(object);
            }
        }
    }

    protected String[] listObjectsImpl(String type, Schema schema, String ref) throws DBException {
        DBObjectCriteria<SystemObject> criteria = DBObjectCriteria.createCriteria(type, schema, ref);
        Collection<SystemObject> objects = this.listObjects(criteria);
        String[] names = new String[objects.size()];
        int i = 0;
        for (SystemObject obj : objects) {
            names[i] = obj.getName();
            ++i;
        }
        return names;
    }

    @Deprecated
    protected Collection<SystemObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        return this.listObjects(DBObjectCriteria.createCriteria(objectTypes, schema, ref));
    }

    protected abstract <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> var1) throws DBException;

    protected final <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> criteria) {
        criteria.setDatabaseDescriptor(this.getDescriptor());
        return this.m_objectCache.listObjectsFromCache(criteria);
    }

    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> criteria) throws DBException {
        criteria.setDatabaseDescriptor(this.getDescriptor());
        String name = criteria.getNameLike();
        String schemaName = criteria.getSchemaName();
        String dbName = criteria.getDatabaseName();
        ArrayList<String> objectTypes = new ArrayList<String>(criteria.getTypes());
        Iterator typeIterator = objectTypes.iterator();
        while (typeIterator.hasNext()) {
            if (this.m_objectCache.hasTypeEntry((String)typeIterator.next())) continue;
            typeIterator.remove();
        }
        if (objectTypes.isEmpty() || !ModelUtil.hasLength((String)name)) {
            return null;
        }
        SystemObject object = null;
        Schema schema = null;
        if (ModelUtil.hasLength((String)schemaName)) {
            schema = this.findSchema(schemaName);
        }
        for (String objectType : objectTypes) {
            object = this.m_objectCache.findObject(objectType, dbName, schema, name);
            if (object != null && !criteria.getSkipTimestampCheck()) {
                object = this.checkCachedObject(object);
            }
            if (object == null) continue;
            break;
        }
        if (object == null) {
            for (String objectType : objectTypes) {
                object = this.loadObjectImpl(objectType, schema, name);
                if (object == null) continue;
                this.cacheObject(object, true);
                break;
            }
        }
        return (T)object;
    }

    protected final Long getExistingTimestamp(SystemObject object) {
        return object == null ? null : (Long)((AbstractDBObject)((Object)object)).getPropertySupport().get(TIMESTAMP_PROPERTY);
    }

    protected <T extends SystemObject> T checkCachedObject(T object) throws DBException {
        Long t;
        String objectType = object.getType();
        boolean checked = false;
        if (this.supportsTimestamps(objectType) && (t = this.getExistingTimestamp(object)) != null) {
            checked = true;
            Long t2 = this.getExternalTimestamp(object);
            if (t2 == null || t2.compareTo(t) > 0) {
                SystemObject exists = this.loadObjectImpl(objectType, DBUtil.getSchema(object), object.getName());
                if (exists != null) {
                    this.resetObject(object, exists, t2);
                } else {
                    this.uncacheObject(object);
                    object = null;
                }
            }
        }
        if (!checked) {
            DBObjectID id = object.getID();
            if (id != null) {
                boolean bl = checked = this.putCachedTimestampKey(id, true) != null;
            }
            if (checked) {
                this.getLogger().log(Level.FINE, "Database {0}: exists test skipped for {1} {2}", new Object[]{this.getName(), object.getType(), DBUtil.getFullyQualifiedName(object)});
            } else {
                SystemObject obj2 = this.loadObjectImpl(objectType, DBUtil.getSchema(object), object.getName());
                if (obj2 == null) {
                    this.uncacheObject(object);
                    object = null;
                } else if (obj2 != object) {
                    this.resetObject(object, obj2, null);
                }
            }
        }
        return object;
    }

    @Override
    public Schema[] listSchemas() throws DBException {
        return this.listSchemas(true);
    }

    @Override
    public Schema[] listSchemas(boolean showAll) throws DBException {
        DBObjectCriteria<Schema> criteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
        criteria.setUserOnly(!showAll);
        criteria.setDatabaseDescriptor(this.getDescriptor());
        Collection<Schema> s = this.listObjectsImpl(criteria);
        return s.toArray(new Schema[s.size()]);
    }

    @Override
    public Schema getSchema(String name) throws DBException {
        return this.getSchemaImpl(name, false);
    }

    protected Schema findSchema(String name) throws DBException {
        return this.getSchemaImpl(name, true);
    }

    private Schema getSchemaImpl(String name, boolean skipTimestamps) throws DBException {
        Schema retval = null;
        if (ModelUtil.hasLength((String)name)) {
            DBObjectCriteria<Schema> criteria = new DBObjectCriteria<Schema>(Schema.class, new String[0]);
            criteria.setName(name);
            criteria.setSkipTimestampCheck(skipTimestamps);
            retval = this.getObject(criteria);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resumeTimestampQueries(String key) {
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (this.m_timestampKeys.remove(key)) {
                    if (this.m_timestampKeys.size() == 0) {
                        this.m_timestamps.clear();
                        this.getLogger().log(Level.FINE, "Database {0}: timestamp resume", this.getName());
                    }
                } else {
                    this.getLogger().log(Level.SEVERE, "Database " + this.getName() + ": timestamp resume for " + key + " but a suspend is not active for that key!", new IllegalStateException());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspendTimestampQueries(String key) {
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (this.m_timestampKeys.isEmpty()) {
                    this.m_timestamps.clear();
                    this.getLogger().log(Level.FINE, "Database {0}: timestamp suspend", this.getName());
                } else if (this.m_timestampKeys.contains(key)) {
                    this.getLogger().log(Level.SEVERE, "Database " + this.getName() + ": timestamp suspend called for " + key + " but that key is already suspended!", new IllegalStateException());
                }
                this.m_timestampKeys.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getCachedTimestamp(Object obj) {
        Object retval = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (!this.m_timestampKeys.isEmpty()) {
                    retval = this.m_timestamps.get(obj);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putCachedTimestampKey(Object obj, Object value) {
        Object retval = null;
        if (this.m_timestampKeys != null) {
            Set<String> set = this.m_timestampKeys;
            synchronized (set) {
                if (value == null) {
                    this.m_timestamps.remove(obj);
                } else if (!this.m_timestampKeys.isEmpty()) {
                    retval = this.m_timestamps.put(obj, value);
                }
            }
        }
        return retval;
    }

    @Override
    public boolean supportsTimestamps(String objectType) {
        return false;
    }

    @Deprecated
    public boolean supportsTimestamps() {
        return false;
    }

    @Override
    public final Long getTimestamp(String type, Schema schema, String objectName) throws DBException {
        SchemaObject obj;
        Long result = null;
        if (this.supportsTimestamps(type) && (obj = this.getObject(type, schema, objectName)) != null) {
            result = (Long)obj.getProperty(TIMESTAMP_PROPERTY);
        }
        return result;
    }

    @Override
    public final Long getTimestamp(DBObjectID id) throws DBException {
        if (this.supportsTimestamps(id.getType())) {
            DBObject obj = this.resolveID(id);
            return obj != null ? (Long)obj.getProperty(TIMESTAMP_PROPERTY) : null;
        }
        return null;
    }

    protected DBObject resolveID(DBObjectID id) throws DBException {
        SystemObject retval = null;
        if (id instanceof ReferenceID) {
            retval = this.resolveReferenceID((ReferenceID)id);
        } else if (id instanceof BaseObjectID) {
            retval = this.resolveIDImpl((BaseObjectID)id);
        }
        return retval;
    }

    protected SystemObject resolveIDImpl(BaseObjectID id) throws DBException {
        SystemObject retval = null;
        String type = id.getType();
        if (this.m_objectCache.hasTypeEntry(type)) {
            SystemObject cachedObject = this.m_objectCache.findObject(id);
            if (cachedObject == null) {
                retval = this.loadObjectImpl(id);
                if (retval != null) {
                    this.cacheObject(retval, true);
                }
            } else {
                Long t2;
                Long t;
                retval = cachedObject;
                if (this.supportsTimestamps(type) && (t = this.getExistingTimestamp(cachedObject)) != null && ((t2 = this.getExternalTimestamp(cachedObject)) == null || t2.compareTo(t) > 0)) {
                    SystemObject exists = this.loadObjectImpl(id);
                    if (exists == null && id instanceof IdentifierBasedID) {
                        String objName = retval.getName();
                        exists = this.loadObjectImpl(type, DBUtil.getSchema(retval), objName);
                        if (exists != null) {
                            this.getLogger().info(APIBundle.format("OBJ_DROPPED_AND_CREATED", type, objName, this.getName()));
                            retval = null;
                        }
                    }
                    if (exists != null) {
                        this.resetObject(cachedObject, exists, t2);
                    } else {
                        this.uncacheObject(cachedObject);
                        this.fireObjectsRemoved(Collections.singleton(cachedObject));
                        retval = null;
                    }
                }
            }
        }
        return retval;
    }

    protected SystemObject resolveReferenceID(ReferenceID id) throws DBException {
        String key = id.toString();
        SystemObject retval = (SystemObject)this.getCachedTimestamp(key);
        if (retval == null) {
            String type = id.getType();
            if ("UNSPECIFIED_TYPE".equals(type)) {
                retval = this.resolveUnspecifiedTypeID(id);
            } else if (this.m_objectCache.hasTypeEntry(type)) {
                Object identifier = id.getIdentifier();
                if (identifier != null) {
                    IdentifierBasedID idId = new IdentifierBasedID(type, identifier, this);
                    retval = this.resolveIDImpl(idId);
                }
                if (retval == null) {
                    String name = id.getName();
                    String schemaName = id.getSchemaName();
                    if (name != null) {
                        NameBasedID nameId = new NameBasedID(type, schemaName, name, this);
                        retval = this.resolveIDImpl(nameId);
                    }
                }
            }
            if (retval != null) {
                this.putCachedTimestampKey(key, retval);
            }
        }
        return retval;
    }

    protected SystemObject resolveUnspecifiedTypeID(ReferenceID id) throws DBException {
        SystemObject retval = null;
        String name = id.getName();
        if (ModelUtil.hasLength((String)name)) {
            int bracketIndex;
            DBObjectCriteria<SystemObject> crit;
            Collection<SystemObject> objs;
            String schemaName = id.getSchemaName();
            String dbName = id.getDatabaseName();
            TreeMap<String, String> typeMap = new TreeMap<String, String>();
            for (String type : this.listObjectTypes()) {
                String prefix = "1";
                if ("TABLE".equals(type)) {
                    prefix = "0";
                } else if (!Metadata.getInstance().isSchemaObject(type)) {
                    prefix = "2";
                }
                typeMap.put(prefix + type, type);
            }
            ArrayList<String> queriedTypes = new ArrayList<String>();
            for (String type : typeMap.values()) {
                if (queriedTypes.contains(type)) continue;
                DBObjectCriteria<SystemObject> crit2 = this.getNamespaceCriteria(type, null, name);
                if (crit2 == null) {
                    crit2 = DBObjectCriteria.createSingleObjectCriteria(type, dbName, schemaName, name);
                } else {
                    crit2.setSchemaName(schemaName);
                    crit2.setDatabaseName(dbName);
                }
                queriedTypes.addAll(crit2.getTypes());
                Collection<SystemObject> objs2 = this.listObjects(crit2);
                if (objs2.isEmpty()) continue;
                retval = objs2.iterator().next();
                break;
            }
            String pubSchemaName = this.getDescriptor().getPublicSchemaName();
            if (retval == null && this.supportsObjectType("SYNONYM") && pubSchemaName != null && !(objs = this.listObjects(crit = DBObjectCriteria.createSingleObjectCriteria("SYNONYM", dbName, pubSchemaName, name))).isEmpty()) {
                retval = objs.iterator().next();
            }
            if (retval == null && (this.supportsObjectType("PROCEDURE") || this.supportsObjectType("FUNCTION")) && (bracketIndex = name.indexOf("(")) > 0) {
                String baseName = name.substring(0, name.indexOf("("));
                DBObjectCriteria<SystemObject> crit3 = DBObjectCriteria.createTypeCriteria("FUNCTION", "PROCEDURE", "SYNONYM");
                crit3.setName(baseName);
                crit3.setDatabaseName(dbName);
                crit3.setSchemaName(schemaName);
                Collection<SystemObject> objs3 = this.listObjects(crit3);
                if (!objs3.isEmpty() && (retval = objs3.iterator().next()) instanceof Synonym && !(DBUtil.getSynonymReference((Synonym)retval) instanceof Procedure)) {
                    retval = null;
                }
            }
        }
        return retval;
    }

    protected DBObjectChange resetObject(SystemObject object, SystemObject listed, Long timestamp) {
        return this.resetObject(object, listed, timestamp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DBObjectChange resetObject(SystemObject object, SystemObject listed, Long timestamp, boolean updated) {
        DBObjectChange retval = null;
        boolean locked = false;
        Collection<DBObject> collection = this.m_resetLocks;
        synchronized (collection) {
            if (this.m_resetLocks.contains(object)) {
                this.getLogger().log(Level.WARNING, "resetObject is already active for {0} {1}", new Object[]{object.getType(), object.getName()});
            } else {
                this.m_resetLocks.add(object);
                locked = true;
            }
        }
        if (locked) {
            Collection<DBObject> collection2;
            try {
                retval = this.resetObjectImpl(object, listed, timestamp, updated);
                Object var10_9 = null;
                collection2 = this.m_resetLocks;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                Collection<DBObject> collection3 = this.m_resetLocks;
                synchronized (collection3) {
                    this.m_resetLocks.remove(object);
                }
                throw throwable;
            }
            synchronized (collection2) {
                this.m_resetLocks.remove(object);
            }
        }
        return retval;
    }

    private DBObjectChange resetObjectImpl(SystemObject object, SystemObject listed, Long timestamp, boolean updated) {
        this.uncacheObject(object);
        this.uncacheObject(listed);
        SystemObject copyOfOriginal = null;
        if (updated && listed != null) {
            copyOfOriginal = object instanceof AbstractBuildableObject ? (SystemObject)((AbstractBuildableObject)((Object)object)).createStaticCopy() : (SystemObject)object.copyTo(null, new IDPolicy.SameIDPolicy());
        }
        try {
            DBObjectID id;
            Schema schema;
            String name;
            if (listed == null) {
                name = object.getName();
                schema = DBUtil.getSchema(object);
                id = object.getID();
            } else {
                name = listed.getName();
                schema = DBUtil.getSchema(listed);
                id = listed.getID();
            }
            SystemObject emptyTemplate = (SystemObject)object.getClass().newInstance();
            emptyTemplate.setName(name);
            emptyTemplate.setID(id);
            if (emptyTemplate instanceof SchemaObject) {
                ((SchemaObject)emptyTemplate).setSchema(schema);
            }
            emptyTemplate.copyTo((DBObject)object, new IDPolicy.SameIDPolicy());
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error wiping object properties - object reset may have failed", e);
        }
        if (timestamp == null) {
            this.putCachedTimestampKey(object.getID(), null);
        } else {
            object.setProperty(TIMESTAMP_PROPERTY, timestamp);
        }
        this.markForLazyInit((AbstractBuildableObject)((Object)object));
        this.cacheObject(object, updated);
        DBObjectChange change = null;
        if (copyOfOriginal != null) {
            change = DifferenceApplier.fireLazyChangeEvent(object, copyOfOriginal, this);
            this.fireObjectUpdated(change);
        }
        return change;
    }

    protected SystemObject loadObjectImpl(String type, Schema schema, String name) throws DBException {
        DBObjectCriteria<SystemObject> crit = DBObjectCriteria.createSingleObjectCriteria(type, schema, name);
        crit.setSkipTimestampCheck(true);
        for (SystemObject obj : this.listObjects(crit)) {
            if (!this.isRequestedObject(obj, type, schema, name)) continue;
            return obj;
        }
        return null;
    }

    protected boolean isRequestedObject(SystemObject object, String type, Schema schema, String name) {
        boolean schemasSame = true;
        if (object instanceof SchemaObject) {
            schemasSame = DBUtil.areNamesAndTypesEqual(schema, DBUtil.getSchema(object));
        }
        return object != null && ModelUtil.areEqual((Object)type, (Object)object.getType()) && schemasSame && this.getDescriptorOrFail().areNamesEqual(name, object.getName(), object.getType(), false);
    }

    protected SystemObject loadObjectImpl(BaseObjectID id) throws DBException {
        Schema s = this.findSchema(id.getSchemaName());
        SystemObject retval = this.loadObjectImpl(id.getType(), s, id.getName());
        if (retval != null && retval.getID() == null) {
            retval.setID(id);
        }
        return retval;
    }

    protected Long getExternalTimestampImpl(SystemObject object) throws DBException {
        return null;
    }

    protected final Long getExternalTimestamp(SystemObject object) throws DBException {
        DBObjectID id = object.getID();
        Object ts = this.getCachedTimestamp(id);
        if (ts instanceof Long) {
            this.getLogger().log(Level.FINE, "Database {0}: timestamp query skipped for id {1}", new Object[]{this.getName(), id});
            return (Long)ts;
        }
        Long result = this.getExternalTimestampImpl(object);
        if (result != null) {
            this.putCachedTimestampKey(id, result);
        }
        return result;
    }

    protected final void markForLazyInit(AbstractBuildableObject object) {
        DBObjectBuilder builder = this.getBuilderForType(object.getType());
        this.markForLazyInit(object, builder);
    }

    protected final void markForLazyInit(AbstractBuildableObject object, DBObjectBuilder builder) {
        if (builder != null) {
            object.getPropertySupport().setBuilder(builder);
        }
        this.getObjectFactory().ensureDerivedPropertyBuilder(object);
    }

    public static String convertObject(DBObject obj) {
        String name = obj != null ? obj.getName() : "";
        return ModelUtil.hasLength((String)name) ? name : "";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String[] listObjectTypes() {
        return this.m_objectCache.listObjectTypes();
    }

    @Override
    public boolean supportsObjectType(String type) {
        if (this.isNewFromTemplateType(type)) {
            return true;
        }
        Object[] objTypes = this.listObjectTypes();
        return Arrays.binarySearch(objTypes, type) >= 0;
    }

    @Override
    public final String[] listObjects(String objectType, Schema schema) throws DBException {
        return this.listObjects(objectType, schema, null);
    }

    @Override
    public final String[] listObjects(String objectType, Schema schema, String ref) throws DBException {
        return this.listObjectsImpl(objectType, schema, ref);
    }

    @Override
    public final SchemaObject[] listObjects(String[] objectTypes, Schema schema) throws DBException {
        return this.listObjects(objectTypes, schema, null);
    }

    @Override
    public final SchemaObject[] listObjects(String[] objectTypes, Schema schema, String ref) throws DBException {
        DBObjectCriteria<SystemObject> criteria = DBObjectCriteria.createCriteria(DBUtil.filterSchemaObjectTypes(objectTypes), schema, ref);
        Collection<SystemObject> retval = this.listObjects(criteria);
        return retval.toArray(new SchemaObject[retval.size()]);
    }

    @Override
    public final <T extends SystemObject> Collection<T> listObjects(DBObjectCriteria<T> criteria) throws DBException {
        criteria.setDatabaseDescriptor(this.getDescriptor());
        return this.listObjectsImpl(criteria);
    }

    @Override
    public final <T extends SystemObject> T getObject(DBObjectCriteria<T> criteria) throws DBException {
        if (criteria.isNameWild()) {
            this.getLogger().warning("getObject cannot process wildcards - use criteria \"name\" not \"nameLike\".");
        }
        return this.getObjectImpl(criteria);
    }

    @Override
    public final SchemaObject getObject(String objectType, Schema schema, String name) throws DBException {
        SystemObject obj;
        SchemaObject retval = null;
        if (objectType != null && Arrays.binarySearch(this.listObjectTypes(), objectType) >= 0 && schema != null && ModelUtil.hasLength((String)name) && (obj = this.getObjectImpl(DBObjectCriteria.createSingleObjectCriteria(objectType, schema, name))) instanceof SchemaObject) {
            retval = (SchemaObject)obj;
        }
        return retval;
    }

    @Override
    @Deprecated
    public boolean hasPriviledge(String type, Schema schema, String priv) {
        return this.hasSystemPrivilege(type, schema, priv);
    }

    @Override
    public boolean hasSystemPrivilege(String type, Schema schema, String priv) {
        return true;
    }

    @Override
    public boolean hasObjectPrivilege(SystemObject object, String priv) {
        return true;
    }

    @Override
    public void canUpdate(Difference listDiff, boolean replace, boolean cascade) throws DBException {
        if (!listDiff.isList()) {
            throw new IllegalArgumentException("listDiff must be a LIST Difference");
        }
        if (!(listDiff.getOriginalObject() instanceof SystemObject[])) {
            throw new IllegalArgumentException("listDiff must be a LIST Difference of SystemObject[]");
        }
        DBException dbe = null;
        for (Difference difference : listDiff.getChildren()) {
            SystemObject orig = (SystemObject)difference.getOriginalObject();
            SystemObject update = (SystemObject)difference.getUpdatedObject();
            if (orig != null || this.canCreate(update, replace)) continue;
            dbe = DBException.append(dbe, new NameInUseException(update));
        }
        if (!cascade) {
            List<UpdateProcessor> procs = this.getDescriptorOrFail().getUpdateProcessors();
            for (UpdateProcessor up : procs) {
                if (!(up instanceof CascadeProcessor)) continue;
                try {
                    DBObjectTransaction txn = new DBObjectTransaction(this);
                    txn.setReplace(replace);
                    txn.setCascade(true);
                    txn.setUpdateProcessors(Collections.singletonList(up));
                    txn.includeListDifference(listDiff);
                    Difference cascadedListDiff = txn.getTransactionDifference();
                    DBObject[] orig = (SystemObject[])listDiff.getOriginalObject();
                    DBObject[] processed = (SystemObject[])cascadedListDiff.getOriginalObject();
                    DBObjectIDSet idSet = new DBObjectIDSet(true);
                    idSet.addAll(processed);
                    idSet.removeAll(orig);
                    if (!idSet.isEmpty()) {
                        throw new CascadeRequiredException(Arrays.asList(orig), (Collection<DBObjectID>)idSet);
                    }
                }
                catch (DBException e) {
                    dbe = DBException.append(dbe, e);
                }
                break;
            }
        }
        if (dbe != null) {
            throw dbe;
        }
    }

    @Override
    public final void createObject(SystemObject obj, boolean replace) throws DBException {
        this.createObjects(new SystemObject[]{obj}, replace);
    }

    @Override
    public final void deleteObject(SystemObject obj, boolean cascade) throws DBException {
        this.deleteObjects(new SystemObject[]{obj}, cascade);
    }

    @Override
    public final void updateObject(SystemObject oldObject, SystemObject newObject) throws DBException {
        this.updateObjects(new SystemObject[]{oldObject}, new SystemObject[]{newObject});
    }

    @Override
    public final void updateObjects(SystemObject[] oldObjects, SystemObject[] newObjects) throws DBException {
        if (oldObjects == null || newObjects == null || oldObjects.length == 0) {
            return;
        }
        if (oldObjects.length != newObjects.length) {
            throw new IllegalArgumentException("Number of old and new objects don't match");
        }
        DiffEngine de = this.getDiffEngine();
        if (de == null) {
            throw new IllegalStateException("Diff not supported, cannot update objects.");
        }
        Difference diff = de.difference(oldObjects = DBUtil.getProviderDefinitions((SystemObject[])oldObjects, (DBObjectProvider)this), newObjects);
        if (!diff.isSame()) {
            this.updateObjects(diff, false, false);
        }
    }

    @Override
    public void createSchema(Schema schema, boolean replace) throws DBException {
        this.createObject(schema, replace);
    }

    @Override
    public void deleteSchema(Schema schema, boolean cascade) throws DBException {
        this.deleteObject(schema, cascade);
    }

    @Override
    public void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        this.updateObject(oldSchema, newSchema);
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.getDDLGenerator();
    }

    @Override
    public final DDLGenerator getDDLGenerator() {
        DatabaseDescriptor desc;
        if (this.m_ddlGenerator == null && (desc = this.getDescriptor()) != null) {
            this.m_ddlGenerator = desc.getDDLGenerator(this);
        }
        return this.m_ddlGenerator;
    }

    private DatabaseDescriptor getDescriptorOrFail() {
        DatabaseDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("provider is missing a descriptor");
        }
        return descriptor;
    }

    protected final int getCasePolicy() {
        return this.getDescriptorOrFail().getCasePolicy();
    }

    @Deprecated
    protected final int getQuotedNameCasePolicy() {
        return this.getDescriptorOrFail().getQuotedNameCasePolicy();
    }

    @Override
    @Deprecated
    public final boolean isValidName(String name) {
        return this.isValidName(null, name);
    }

    @Override
    public final boolean isValidName(String type, String name) {
        return this.getDescriptorOrFail().isValidName(type, name);
    }

    @Override
    @Deprecated
    public final void validateName(String name) throws InvalidNameException {
        this.validateName(null, name);
    }

    @Override
    public final void validateName(String type, String name) throws InvalidNameException {
        DBObjectValidator validator;
        DBObjectValidator dBObjectValidator = validator = type == null ? null : this.getValidatorForType(type);
        if (validator == null) {
            this.getDescriptorOrFail().validateName(type, name);
        } else {
            validator.validateName(type, name);
        }
    }

    @Override
    public final String quoteIdentifier(String internalName, boolean force) throws DBException {
        return this.getDescriptorOrFail().quoteIdentifier(internalName, force);
    }

    @Override
    public final String getInternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getInternalName(name, objectType);
    }

    @Override
    public final String getInternalName(String name) {
        return this.getInternalName(name, null);
    }

    @Override
    public final String getExternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getExternalName(name, objectType);
    }

    @Override
    public final String getExternalName(String name) {
        return this.getExternalName(name, null);
    }

    @Override
    public DataType[] listSupportedDataTypes() {
        Collection<DataType> types = this.getDescriptorOrFail().listSupportedDataTypes();
        return types.toArray(new DataType[types.size()]);
    }

    @Override
    public DataType getDataType(String typeName) {
        return this.getDescriptorOrFail().getDataType(typeName);
    }

    @Override
    public DataType getOrCreateDataType(String typeName) {
        DataType type = this.getDataType(typeName);
        if (type == null) {
            Class<? extends Database> clz = this.getDescriptorOrFail().getDatabaseClass();
            this.getLogger().log(Level.FINE, "DataTypeRegistry had no \"" + typeName + "\" for provider " + clz.getName());
            type = DataTypeRegistry.getInstance().createUserDataType(typeName, clz);
        }
        return type;
    }

    @Override
    public void validateObject(DBObject object) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(object.getType());
        if (v == null) {
            throw new MissingValidatorException(object);
        }
        v.validateObject(object);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject object, String property) throws ValidationException {
        this.validateObjectProperty(object, property);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject object, Object property) throws ValidationException {
        this.validateObjectProperty(object, property == null ? null : String.valueOf(property));
    }

    @Override
    public void validateObjectProperty(DBObject object, String property) throws ValidationException {
        if (property == null) {
            this.validateObject(object);
        } else {
            DBObjectValidator v = this.getValidatorForType(object.getType());
            if (v == null) {
                throw new MissingValidatorException(object);
            }
            v.validateObjectProperty(object, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema schema) throws ValidationException {
        this.validateObject(schema);
    }

    @Override
    public void validateObject(DBObject original, DBObject update) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(update.getType());
        if (v == null) {
            throw new MissingValidatorException(update);
        }
        this.getObjectFactory().ensureDerivedPropertyBuilder(update);
        v.validateObject(original, update);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject original, DBObject update, String property) throws ValidationException {
        this.validateObjectProperty(original, update, property);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(DBObject original, DBObject updated, Object property) throws ValidationException {
        this.validateObjectProperty(original, updated, property == null ? null : String.valueOf(property));
    }

    @Override
    public void validateObjectProperty(DBObject original, DBObject update, String property) throws ValidationException {
        if (property == null) {
            this.validateObject(original, update);
        } else {
            DBObjectValidator v = this.getValidatorForType(update.getType());
            if (v == null) {
                throw new MissingValidatorException(update);
            }
            this.getObjectFactory().ensureDerivedPropertyBuilder(update);
            v.validateObjectProperty(original, update, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema original, Schema update) throws ValidationException {
        this.validateObject((DBObject)original, update);
    }

    @Override
    public final void validateUniqueName(String type, DBObject contextObject, String name) throws NameInUseException {
        if (ModelUtil.hasLength((String)name)) {
            type = this.normaliseType(type);
            DBObject object = Metadata.getInstance().newInstance(type);
            if (object == null) {
                throw new IllegalStateException("Unknown or invalid type " + type);
            }
            object.setName(name);
            if (object instanceof SchemaObject && contextObject instanceof Schema) {
                ((SchemaObject)object).setSchema((Schema)contextObject);
            }
            this.validateUniqueName(object, contextObject);
        }
    }

    @Override
    public void validateUniqueName(DBObject object, DBObject contextObject) throws NameInUseException {
        block14: {
            String type;
            String name;
            block16: {
                block15: {
                    Iterator i$;
                    name = object.getName();
                    if (!ModelUtil.hasLength((String)name)) break block14;
                    type = object.getType();
                    if (!this.supportsObjectType(type) || contextObject != null && !(contextObject instanceof Schema)) break block15;
                    Collection existingObjects = null;
                    try {
                        DBObjectCriteria crit = this.getNamespaceCriteria(type, (Schema)contextObject, name);
                        if (crit != null) {
                            existingObjects = this.listObjects(crit);
                        }
                    }
                    catch (DBException dbe) {
                        this.getLogger().log(Level.WARNING, APIBundle.format("UNIQUE_NAME_CHECK_ERR", dbe.getMessage()));
                    }
                    if (existingObjects != null && (i$ = existingObjects.iterator()).hasNext()) {
                        SystemObject existing = (SystemObject)i$.next();
                        throw new NameInUseException(object, existing);
                    }
                    break block14;
                }
                if (!(contextObject instanceof Schema)) break block16;
                ArrayList<String> types = new ArrayList<String>();
                Collection<String> ownerTypes = Metadata.getInstance().getOwnerTypes(type);
                for (String typeToTest : this.listObjectTypes()) {
                    if (!ownerTypes.contains(typeToTest)) continue;
                    types.add(typeToTest);
                }
                if (types.size() <= 0) break block14;
                SchemaObject[] schemaObjects = null;
                try {
                    schemaObjects = this.listObjects(types.toArray(new String[types.size()]), (Schema)contextObject);
                }
                catch (DBException x) {
                    this.getLogger().log(Level.WARNING, APIBundle.format("UNIQUE_NAME_CHECK_ERR", x.getMessage()));
                }
                if (schemaObjects != null) {
                    for (SchemaObject listedObj : schemaObjects) {
                        DBObject[] kids;
                        if (DBUtil.areNamesAndTypesEqual(listedObj, object.getParent())) continue;
                        if (type.equals("CONSTRAINT") && listedObj instanceof Relation) {
                            Collection<Constraint> cons = Constraint.getConstraints((Relation)listedObj, "UniqueConstraint", "PKConstraint");
                            kids = cons.toArray(new DBObject[cons.size()]);
                        } else {
                            kids = listedObj.getOwnedObjects(type);
                        }
                        for (DBObject kid : kids) {
                            if (!this.getDescriptor().areNamesEqual(kid.getName(), name, kid.getType(), false)) continue;
                            throw new NameInUseException(object, kid);
                        }
                    }
                }
                break block14;
            }
            if (contextObject != null) {
                for (DBObject kid : contextObject.getOwnedObjects(type)) {
                    if (!this.getDescriptor().areNamesEqual(kid.getName(), name, kid.getType(), false)) continue;
                    throw new NameInUseException(object, kid);
                }
            }
        }
    }

    private DBObjectCriteria getNamespaceCriteria(String type, Schema schema, String base) {
        DBObjectCriteria<SystemObject> retval = null;
        if (this.supportsObjectType(type)) {
            DBObjectValidator.NamespaceType nsType;
            DBObjectValidator v = this.getValidatorForType(type);
            DBObjectValidator.NamespaceType namespaceType = nsType = v == null ? DBObjectValidator.NamespaceType.SCHEMA : v.getNamespaceType();
            Collection<String> types = nsType == DBObjectValidator.NamespaceType.SCHEMA ? this.getDescriptor().listSchemaNamespaceTypes(this) : (nsType == DBObjectValidator.NamespaceType.TYPE ? Collections.singleton(type) : Collections.emptyList());
            if (types.size() > 0) {
                retval = DBObjectCriteria.createTypeCriteria(types);
                retval.setSchema(schema);
                retval.setName(base);
            }
        }
        return retval;
    }

    @Override
    public String getUniqueName(String type, DBObject contextObject, String base) {
        return this.getUniqueName(type, contextObject, base, null);
    }

    @Override
    public String getUniqueName(String type, DBObject contextObject, String base, Collection<String> bannedNames) {
        DBObjectValidator v;
        Set<String> names = NameComparator.createNameSet(this.getDescriptor(), false);
        if (bannedNames != null) {
            names.addAll(bannedNames);
        }
        type = this.normaliseType(type);
        if (!ModelUtil.hasLength((String)base)) {
            base = type + 1;
        }
        int casePolicy = this.getCasePolicy();
        if (contextObject == null || contextObject instanceof Schema) {
            boolean child = false;
            DBObjectCriteria<SystemObject> listCrit = this.getNamespaceCriteria(type, (Schema)contextObject, base);
            if (listCrit == null) {
                child = true;
                Collection<String> ownerTypes = Metadata.getInstance().getOwnerTypes(type);
                ownerTypes.retainAll(Arrays.asList(this.listObjectTypes()));
                if (!ownerTypes.isEmpty()) {
                    listCrit = DBObjectCriteria.createTypeCriteria(ownerTypes);
                    listCrit.setSchema((Schema)contextObject);
                }
            } else {
                String nameLike = null;
                if (!child && casePolicy != 0 && (nameLike = (String)DBUtil.splitBaseName(base).getFirst()) != null) {
                    nameLike = nameLike + DBObjectCriteria.LIKE_WILDCARD;
                }
                listCrit.setNameLike(nameLike);
            }
            Collection sysObjects = null;
            if (listCrit != null) {
                try {
                    sysObjects = this.listObjects(listCrit);
                }
                catch (DBException x) {
                    this.getLogger().warning(APIBundle.format("UNIQUE_NAME_CHECK_ERR", x.getMessage()));
                }
            }
            if (sysObjects != null) {
                for (SystemObject sysObj : sysObjects) {
                    if (child) {
                        this.addChildrenNames(sysObj.getOwnedObjects(type), names);
                        continue;
                    }
                    names.add(sysObj.getName());
                }
            }
        } else if (contextObject instanceof SystemObject && ((v = this.getValidatorForType(type)) == null || v.getNamespaceType() != DBObjectValidator.NamespaceType.NONE)) {
            this.addChildrenNames(contextObject.getOwnedObjects(type), names);
        }
        int maxLength = this.getDescriptor().getMaxNameLength(type);
        return DBUtil.getUniqueName(names, base, true, maxLength);
    }

    @Deprecated
    protected boolean getUniqueNameTreatIndexAsSchemaObject() {
        return false;
    }

    private void addChildrenNames(DBObject[] children, Collection names) {
        for (int i = 0; i < children.length; ++i) {
            names.add(children[i].getName());
        }
    }

    protected String normaliseType(String type) {
        return Constraint.getConstraintTypes().contains(type) ? "CONSTRAINT" : type;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return null;
    }

    protected Difference ensureSystemObjectListDifference(Difference diff) throws IllegalArgumentException {
        Difference retval;
        if (diff instanceof ResultSet && diff.isMap() && diff.getOriginalObject() instanceof SystemObject) {
            SystemObject[] oldObjects = new SystemObject[]{(SystemObject)diff.getOriginalObject()};
            SystemObject[] newObjects = new SystemObject[]{(SystemObject)diff.getUpdatedObject()};
            retval = new ResultSet(null, oldObjects, (Object)newObjects, null, "LIST");
            ((ResultSet)retval).addToList((ResultSet)diff);
        } else if (diff.isList()) {
            retval = diff;
        } else {
            throw new IllegalStateException("updateObjects must be called with a LIST Difference.");
        }
        return retval;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected void logEvent(String msg, Object ... params) {
        this.getLogger().log(DBLog.getEventLogLevel(), msg, params);
    }

    @Override
    public boolean isEditable(DBObject object) {
        String type;
        DBObjectBuilder builder;
        SystemObject sysobj;
        boolean retval = false;
        if (object != null && (sysobj = DBUtil.getSystemObject(object)) != null && (builder = this.getBuilderForType(type = sysobj.getType())) != null && builder.canBuildEditableObject()) {
            PropertyManager pm = this.getPropertyManager();
            retval = pm != null && (pm.supportsAction(type, PropertyAction.Type.REPLACE) || pm.supportsAction(type, PropertyAction.Type.ALTER));
        }
        return retval;
    }

    @Override
    public DBObject getDefaultTemplateForType(String type) {
        return null;
    }

    @Override
    public void setDefaultTemplateForType(String type, DBObject template) {
        throw new RuntimeException("Cannot store defaults online");
    }

    @Override
    public boolean isNewFromTemplateType(String type) {
        return NEW_FROM_TEMPLATE_TYPE.equals(type);
    }

    @Deprecated
    protected void registerSchemaObjectExpander(SchemaObjectExpander expander) {
    }

    @Deprecated
    public SchemaObjectExpander[] getSchemaObjectExpanders() {
        return new SchemaObjectExpander[0];
    }

    @Override
    public DBObjectFactory getObjectFactory() {
        if (this.m_dbObjFactory == null) {
            this.m_dbObjFactory = this.createObjectFactory();
        }
        return this.m_dbObjFactory;
    }

    protected DBObjectFactory createObjectFactory() {
        return new DBObjectFactory(this);
    }

    @Override
    public final void updateObjects(Difference listDiff, boolean replace, boolean cascade) throws DBException {
        listDiff = this.ensureSystemObjectListDifference(listDiff);
        DBObjectTransaction txn = new DBObjectTransaction(this);
        txn.setCascade(cascade);
        txn.setReplace(replace);
        txn.includeListDifference(listDiff);
        this.commitTransaction(txn);
    }

    @Override
    public final void commitTransaction(DBObjectTransaction txn) throws DBException {
        Collection<DBObjectChange> changes;
        for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
            try {
                list.transactionSubmitted(txn);
            }
            catch (Exception e) {
                this.processListenerException(list, e);
            }
        }
        Difference listDiff = txn.getTransactionDifference();
        listDiff.print();
        for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
            try {
                list.transactionProcessed(txn, listDiff);
            }
            catch (Exception e) {
                this.processListenerException(list, e);
            }
        }
        if (!listDiff.isSame() && (changes = this.commitTransaction(txn, listDiff)) != null) {
            for (oracle.javatools.db.event.DBObjectProviderListener list : this.m_listeners) {
                try {
                    list.transactionCommited(txn, listDiff, changes);
                }
                catch (Exception e) {
                    this.processListenerException(list, e);
                }
            }
        }
    }

    protected abstract Collection<DBObjectChange> commitTransaction(DBObjectTransaction var1, Difference var2) throws DBException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListenerBridge
    extends oracle.javatools.db.event.DBObjectProviderListener {
        private DBObjectProviderListener m_list;

        ListenerBridge(DBObjectProviderListener l) {
            this.m_list = l;
        }

        @Override
        public void schemaObjectsAdded(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.m_list.schemaObjectsAdded(provider, schema, objs.toArray(new SchemaObject[objs.size()]));
        }

        @Override
        public void schemaObjectsRemoved(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.m_list.schemaObjectsRemoved(provider, schema, objs.toArray(new SchemaObject[objs.size()]));
        }

        @Override
        public void systemObjectsAdded(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            for (SystemObject systemObject : objs) {
                if (!(systemObject instanceof Schema)) continue;
                this.m_list.schemaAdded(provider, (Schema)systemObject);
            }
        }

        @Override
        public void systemObjectsRemoved(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            for (SystemObject systemObject : objs) {
                if (!(systemObject instanceof Schema)) continue;
                this.m_list.schemaRemoved(provider, (Schema)systemObject);
            }
        }

        @Override
        public void providerOpened(DBObjectProvider provider) {
            this.m_list.providerOpened(provider);
        }

        @Override
        public void providerClosed(DBObjectProvider provider) {
            this.m_list.providerClosed(provider);
        }

        @Override
        public void providerReloaded(DBObjectProvider provider) {
            this.m_list.providerReloaded(provider);
        }

        boolean isBridgeFor(DBObjectProviderListener l) {
            return ModelUtil.areEqual((Object)this.m_list, (Object)l);
        }
    }
}

