/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabase
extends AbstractDBObjectProvider
implements Database {
    private static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private static final String ODBC_NOT_IMPLEMENTED = "IM001";
    private String m_connStore;
    private String m_connName;
    private Connection m_conn;
    private Connection m_oldConn;
    private DatabaseDescriptor m_descriptor;
    private boolean m_reconnecting;
    private Statement m_statement;
    private final Lock m_aliveCheckLock = new ReentrantLock();
    private final Holder<String> m_currentSchemaName = new Holder();
    private final Holder<String> m_username = new Holder();
    private final Holder<String> m_catalog = new Holder();

    protected AbstractDatabase(String connStore, String connName, Connection conn) {
        this(connStore, connName, conn, null);
    }

    protected AbstractDatabase(String connStore, String connName, Connection conn, String type, int version) {
        this(connStore, connName, conn, DatabaseRegistry.getInstance().getDatabaseDescriptor(type, version));
    }

    private AbstractDatabase(String connStore, String connName, Connection conn, DatabaseDescriptor desc) {
        this.m_connStore = connStore;
        this.m_connName = connName;
        this.m_conn = conn;
        this.m_descriptor = desc;
        this.getLogger().log(DBLog.getEventLogLevel(), "{0}: new {1}", new Object[]{connName, this.getClass().getName()});
        if (DBObjectRegistry.isActive()) {
            for (Map.Entry<String, DBObjectBuilder> entry : DBObjectRegistry.getInstance().getBuilders(this.getDatabaseType(), this.getDatabaseVersion(), this).entrySet()) {
                this.registerBuilder(entry.getKey(), entry.getValue());
            }
        }
        this.registerBuilders();
        this.registerValidators();
    }

    @Override
    public final String getProviderType() {
        return "db";
    }

    @Override
    public final Object getProviderIdentifier() {
        return this.getQualifiedName();
    }

    @Override
    public final String getDatabaseType() {
        return this.getDescriptor().getDatabaseType();
    }

    @Override
    public final int getDatabaseVersion() {
        return this.getDescriptor().getDatabaseVersion();
    }

    protected void registerValidators() {
        Map<String, DBObjectValidator> v = this.getDescriptor().getValidators(this);
        for (String type : v.keySet()) {
            this.registerValidator(type, v.get(type));
        }
    }

    protected final boolean exists(SystemObject obj) {
        if (obj != null) {
            String name;
            String type;
            if (obj instanceof MaterializedViewLog) {
                type = "TABLE";
                name = ((MaterializedViewLog)obj).getLogTable();
            } else {
                type = obj.getType();
                name = AbstractDatabase.convertObject(obj);
            }
            return this.exists(type, AbstractDatabase.convertObject(DBUtil.getSchema(obj)), name);
        }
        return false;
    }

    protected abstract void registerBuilders();

    @Override
    public final Connection getConnection() {
        try {
            return this.getConnection(true);
        }
        catch (DBException dBException) {
            return this.getConnectionImpl();
        }
    }

    @Override
    public final Connection getConnection(boolean reconnect) throws DBException {
        if (!this.m_reconnecting && reconnect && !this.isConnectionAlive()) {
            this.reconnect();
        }
        return this.getConnectionImpl();
    }

    private Connection getConnectionImpl() {
        return this.m_conn == null ? this.m_oldConn : this.m_conn;
    }

    @Override
    public final boolean isClosed() {
        return !this.isConnectionAlive();
    }

    @Override
    public final boolean isConnectionAlive() {
        boolean alive = false;
        if (this.m_conn != null) {
            alive = this.testIsConnectionAlive(this.m_conn);
        }
        return alive;
    }

    protected boolean isConnectionAlive(Connection conn) {
        boolean alive = false;
        String stmt = this.getAliveTestStatement();
        if (ModelUtil.hasLength((String)stmt)) {
            StatementWrapper wrap = new StatementWrapper(this.m_connName, conn, stmt);
            wrap.setBypassExecutionProxy(true);
            try {
                alive = wrap.execute();
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, dbe.getMessage()});
            }
        } else {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                alive = true;
            }
            catch (SQLException ex) {
                this.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, ex.getMessage()});
            }
        }
        return alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testIsConnectionAlive(final Connection conn) {
        String aliveKey = "CONNECTION_ALIVE";
        Object checked = this.getCachedTimestamp("CONNECTION_ALIVE");
        if (checked instanceof Boolean) {
            this.getLogger().log(Level.FINE, "Database {0}: isAlive test skipped", new Object[]{this.getName()});
            return (Boolean)checked;
        }
        final Holder isAlive = new Holder();
        if (this.m_aliveCheckLock.tryLock()) {
            try {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (isAlive.get() == null) {
                            Connection connection = conn;
                            synchronized (connection) {
                                if (!Thread.interrupted()) {
                                    isAlive.set((Object)AbstractDatabase.this.isConnectionAlive(conn));
                                }
                            }
                        }
                    }
                };
                if (Thread.holdsLock(conn)) {
                    r.run();
                } else {
                    Thread t = new Thread(r, "CONNECTION_ALIVE");
                    Holder holder = isAlive;
                    synchronized (holder) {
                        t.start();
                        int wait = 1;
                        Thread.State state = t.getState();
                        while (isAlive.get() == null && state != Thread.State.BLOCKED && state != Thread.State.TERMINATED) {
                            try {
                                isAlive.wait(wait);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            state = t.getState();
                            if (wait >= 64) continue;
                            wait *= 2;
                        }
                    }
                    if (t.getState() == Thread.State.BLOCKED) {
                        t.interrupt();
                        DBLog.getLogger(this).log(Level.FINE, "Alive check for {0} was blocked (connection busy).", new Object[]{this.getConnectionName()});
                    }
                }
                Object var13_13 = null;
                this.m_aliveCheckLock.unlock();
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.m_aliveCheckLock.unlock();
                throw throwable;
            }
        }
        DBLog.getLogger(this).log(Level.INFO, "Alive check for {0} was skipped (one already in progress).", new Object[]{this.getConnectionName()});
        boolean alive = Boolean.FALSE != isAlive.get();
        isAlive.set((Object)Boolean.FALSE);
        this.putCachedTimestampKey("CONNECTION_ALIVE", alive);
        return alive;
    }

    protected String getAliveTestStatement() {
        return null;
    }

    @Override
    public Boolean isConnectionClosed(SQLException sqe) {
        Boolean retval = null;
        if (sqe != null && sqe.getSQLState() == "08003") {
            this.getLogger().info(APIBundle.format("CLOSED_EX", this.getName()));
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasTransaction() {
        String queryText;
        if (this.m_statement != null) {
            return true;
        }
        if (this.m_conn != null && ModelUtil.hasLength((String)(queryText = this.getTransactionTestQuery()))) {
            final Holder retval = new Holder((Object)false);
            final Holder done = new Holder((Object)false);
            Runnable runner = new Runnable(){

                public void run() {
                    QueryWrapper wrap = new QueryWrapper((Database)AbstractDatabase.this, queryText);
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void processResultSet(ResultSet rs) throws DBException {
                            try {
                                block8: {
                                    try {
                                        String id;
                                        if (!rs.next() || !ModelUtil.hasLength((String)(id = rs.getString(1)))) break block8;
                                        retval.set((Object)true);
                                    }
                                    catch (SQLException sQLException) {
                                        Object var4_5 = null;
                                        Holder holder3 = done;
                                        synchronized (holder3) {
                                            done.set((Object)true);
                                            done.notifyAll();
                                            return;
                                        }
                                    }
                                }
                                Object var4_4 = null;
                                Holder holder = done;
                                synchronized (holder) {
                                    done.set((Object)true);
                                    done.notifyAll();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Holder holder2 = done;
                                synchronized (holder2) {
                                    done.set((Object)true);
                                    done.notifyAll();
                                    throw throwable;
                                }
                            }
                        }
                    };
                    try {
                        wrap.executeQuery(r);
                    }
                    catch (DBException dbe) {
                        AbstractDatabase.this.getLogger().log(Level.INFO, "hasTransaction query failed for {0}: {1}", new Object[]{AbstractDatabase.this.m_connName, dbe.getMessage()});
                    }
                }
            };
            Thread t = new Thread(runner, "DatabaseHasTransactionThread");
            t.start();
            while (!((Boolean)done.get()).booleanValue()) {
                Holder holder = done;
                synchronized (holder) {
                    try {
                        done.wait(200L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (t.getState() == Thread.State.BLOCKED) {
                        this.getLogger().log(Level.INFO, "Connection for \"{0}\" is busy, cannot perform hasTransaction test.", new Object[]{this.m_connName});
                        break;
                    }
                    if (t.getState() == Thread.State.TERMINATED) {
                        break;
                    }
                }
            }
            return (Boolean)retval.get();
        }
        return false;
    }

    protected String getTransactionTestQuery() {
        return null;
    }

    @Override
    public void testSQLStatement(String sql) throws DBException {
        QueryWrapper wrap = new QueryWrapper((Database)this, sql);
        try {
            wrap.executeQuery(null);
        }
        catch (DBException dbe) {
            throw new InvalidSQLException(sql, dbe.getMessage());
        }
    }

    @Override
    public final String getName() {
        return this.m_connName;
    }

    final void setConnectionName(String name) {
        this.m_connName = name;
    }

    @Override
    public final String getConnectionName() {
        return this.m_connName;
    }

    @Override
    public final String getConnectionStore() {
        return this.m_connStore;
    }

    @Override
    public final String getQualifiedName() {
        return DatabaseFactory.encodeIdentifier(this.getConnectionStore(), this.getConnectionName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reconnect() throws DBException {
        if (this.m_reconnecting) {
            this.getLogger().severe(this.getName() + ": failed to reconnect: cannot create new connection");
            return;
        }
        try {
            Connection c;
            DatabaseFactory.ConnectionCreator cc;
            this.m_reconnecting = true;
            this.closeImpl();
            if (this.m_connStore != null && this.m_connName != null && (cc = DatabaseFactory.findConnectionCreator(this.m_connStore)) != null && (c = cc.createConnectionImpl(this.m_connName)) != null && c != this.m_conn) {
                if (this.m_oldConn == null || cc.shouldClearCaches(this.m_oldConn, c, this)) {
                    this.clearAllCaches();
                }
                this.m_conn = c;
                this.reconnected(this.m_conn);
                this.fireProviderReloaded();
                this.getLogger().info(APIBundle.format("CONN_RECONNECTED", this.getName()));
            }
            Object var4_3 = null;
            this.m_reconnecting = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_reconnecting = false;
            throw throwable;
        }
    }

    protected void reconnected(Connection c) {
    }

    @Override
    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_username.set(null);
        this.m_currentSchemaName.set(null);
        this.m_catalog.set(null);
    }

    @Override
    public void close() {
        this.closeImpl();
        this.clearAllCaches();
        this.fireProviderClosed();
    }

    private void closeImpl() {
        if (this.m_conn != null) {
            try {
                if (!this.m_conn.isClosed()) {
                    this.getLogger().log(Level.FINE, APIBundle.format("INFO_DISCONNECTING", this.m_connName));
                    this.m_conn.close();
                }
            }
            catch (SQLException sqe) {
                this.getLogger().log(Level.WARNING, APIBundle.format("ERROR_DISCONNECTING", this.m_connName) + sqe.getMessage());
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, APIBundle.format("ERROR_DISCONNECTING", this.m_connName) + ex.getMessage(), ex);
            }
            this.m_oldConn = this.m_conn;
            this.m_conn = null;
        }
    }

    @Override
    public boolean exists(String type, String schema, String name) {
        boolean exists = false;
        try {
            DBObjectCriteria<SystemObject> criteria = new DBObjectCriteria<SystemObject>(SystemObject.class, type);
            criteria.setSchemaName(schema);
            criteria.setName(name);
            exists = !this.listObjects(criteria).isEmpty();
        }
        catch (DBException ex) {
            this.getLogger().warning(APIBundle.format("EXISTS_CHECK_ERR", type, name, ex.getMessage()));
        }
        return exists;
    }

    @Override
    public boolean isObjectValid(String objectType, String schema, String objectName) {
        return this.exists(objectType, schema, objectName);
    }

    protected final Schema createSchema(String name) {
        Schema s = new Schema(name);
        s.setID(new NameBasedID((DBObject)s, (AbstractDBObjectProvider)this));
        return s;
    }

    @Deprecated
    protected void finishCreate(SystemObject[] objects, SystemObject[] oldObjects) throws DBException {
    }

    public Collection<DBObjectChange> finishUpdates(Difference listDiff) throws DBException {
        ArrayList<SystemObject> newObjs = new ArrayList<SystemObject>();
        ArrayList<SystemObject> deletedObjs = new ArrayList<SystemObject>();
        ArrayList<DBObjectChange> updates = new ArrayList<DBObjectChange>();
        DBException dbe = null;
        for (Difference difference : listDiff.getChildren()) {
            SystemObject obj;
            SystemObject upd = (SystemObject)difference.getUpdatedObject();
            SystemObject old = (SystemObject)difference.getOriginalObject();
            if (upd == null) {
                if (old == null) continue;
                deletedObjs.add(old);
                continue;
            }
            Schema objSchema = DBUtil.getSchema(upd);
            Schema schema = objSchema == null ? null : this.findSchema(objSchema.getName());
            boolean objNotThere = false;
            if (old == null) {
                obj = this.getCreatedObject(upd.getType(), schema, upd.getName());
                if (obj == null) {
                    objNotThere = true;
                } else {
                    this.resetObject(upd, obj, this.getExistingTimestamp(obj), false);
                    newObjs.add(upd);
                }
            } else {
                obj = this.loadObjectImpl(upd.getType(), schema, upd.getName());
                if (obj == null) {
                    this.uncacheObject(old);
                    objNotThere = true;
                } else {
                    ArrayList<DBObject> changedKids = new ArrayList<DBObject>();
                    this.collectCascadableChildChanges(difference, changedKids);
                    for (DBObject kid : changedKids) {
                        this.resetCachedDependentObjects(kid);
                    }
                    DBObjectChange change = this.resetObject(old, obj, this.getExistingTimestamp(obj));
                    if (change != null) {
                        updates.add(change);
                    }
                }
            }
            if (!objNotThere) continue;
            dbe = DBException.append(dbe, new DBException((DBObject)upd, APIBundle.format("ERROR_FETCHING_NEW_OBJECT", upd.getType(), upd.getName())));
        }
        if (newObjs.size() > 0) {
            this.fireObjectsAdded(newObjs);
        }
        if (deletedObjs.size() > 0) {
            this.fireObjectsRemoved(deletedObjs);
            for (SystemObject systemObject : deletedObjs) {
                Table t;
                if (systemObject instanceof Index && (t = ((Index)systemObject).getTable()) != null) {
                    t.removeIndex((Index)systemObject);
                    DBObjectChange.fireChildrenRemoved(t, Collections.singletonList(systemObject));
                }
                this.resetCachedDependentObjects(systemObject);
                this.uncacheObject(systemObject);
            }
        }
        if (dbe != null) {
            throw dbe;
        }
        return updates;
    }

    private void collectCascadableChildChanges(Difference diff, Collection<DBObject> changed) {
        if (!diff.isSame()) {
            DBObject update;
            Object orig = diff.getOriginalObject();
            if (orig instanceof DBObject && ((update = (DBObject)diff.getUpdatedObject()) == null || !DBUtil.areNamesAndTypesEqual((DBObject)orig, update))) {
                changed.add((DBObject)orig);
            }
            for (Difference difference : diff.getChildren()) {
                this.collectCascadableChildChanges(difference, changed);
            }
        }
    }

    private void resetCachedDependentObjects(DBObject obj) {
        SchemaObjectManager mgr = this.getCascadeManager();
        try {
            for (DBObjectID ref : ((CascadeManager)mgr).listReferers(obj)) {
                try {
                    DBObjectID topID = DBUtil.getUppermostParent(ref);
                    SystemObject referer = (SystemObject)topID.resolveID();
                    if (referer == null) continue;
                    this.resetObject(referer, null, null);
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, APIBundle.format("CASCADE_DELETE_ID_ERR", obj.getType(), obj.getName(), dbe.getMessage()));
                }
            }
        }
        catch (CancelledException ce) {
            this.getLogger().log(Level.SEVERE, "This process shouldn't be cancellable, the cache will now be invalid.", ce);
        }
    }

    protected SystemObject getCreatedObject(String type, Schema schema, String name) throws DBException {
        return this.loadObjectImpl(type, schema, name);
    }

    @Deprecated
    protected void finishDelete(SystemObject[] objs) {
    }

    @Override
    public String getDatabaseSource(String objectType, Schema schema, String objectName) throws DBException {
        return null;
    }

    @Override
    public String getDatabaseSource(String objectType, Schema schema, String objectName, String sourceType) throws DBException {
        return null;
    }

    @Override
    public Schema getDefaultSchema() throws DBException {
        String schemaName = this.getCurrentSchemaName();
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            schema = this.getSchema(null);
        }
        return schema;
    }

    @Deprecated
    protected boolean isUsernameCaseInsensitive() {
        return true;
    }

    protected final String getCurrentSchemaName() throws DBException {
        String retval = (String)this.m_currentSchemaName.get();
        if (retval == null) {
            retval = this.queryCurrentSchemaName();
            if (retval == null) {
                retval = this.getUserName();
            }
            this.m_currentSchemaName.set((Object)retval);
        }
        return retval;
    }

    protected String queryCurrentSchemaName() throws DBException {
        return null;
    }

    public final String getCatalog() {
        String retval = (String)this.m_catalog.get();
        if (retval == null) {
            try {
                retval = this.queryCatalog();
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, APIBundle.format("CATALOG_QUERY_ERR", dbe.getMessage()));
            }
            if (retval == null) {
                retval = "";
            }
            this.m_catalog.set((Object)retval);
        }
        return retval;
    }

    protected String queryCatalog() throws DBException {
        ConnectionWrapper wrapper = new ConnectionWrapper(this, APIBundle.get("GET_CATALOG"));
        return wrapper.call(new ConnectionWrapper.SQLCallable<String>(wrapper){

            @Override
            public String call() throws SQLException {
                String retval;
                block2: {
                    retval = null;
                    try {
                        retval = this.getConnection().getCatalog();
                    }
                    catch (SQLException sqe) {
                        if (AbstractDatabase.this.isUnsupportedOperation(sqe)) break block2;
                        throw sqe;
                    }
                }
                return retval;
            }
        });
    }

    @Override
    public final String getUserName() {
        String retval = (String)this.m_username.get();
        if (retval == null) {
            try {
                retval = this.queryCurrentUserName();
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, APIBundle.format("USER_QUERY_ERR", dbe.getMessage()));
            }
            this.m_username.set((Object)retval);
        }
        return retval;
    }

    protected String queryCurrentUserName() throws DBException {
        ConnectionWrapper wrapper = new ConnectionWrapper(this, APIBundle.get("GET_USER_NAME"));
        return wrapper.call(new ConnectionWrapper.SQLCallable<String>(wrapper){

            @Override
            public String call() throws SQLException {
                String username = this.getConnection().getMetaData().getUserName();
                return AbstractDatabase.this.getInternalName(username, "SCHEMA");
            }
        });
    }

    @Override
    public boolean supportsDebugging() {
        return false;
    }

    @Override
    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> criteria) throws DBException {
        T retval = null;
        if (!criteria.isAllowedType("SCHEMA")) {
            retval = this.getDescriptor().getBuiltInObject(criteria);
        }
        if (retval == null) {
            retval = super.getObjectImpl(criteria);
        }
        return retval;
    }

    @Override
    public DatabaseDescriptor getDescriptor() {
        if (this.m_descriptor == null) {
            this.m_descriptor = DatabaseFactory.getDatabaseDescriptor(this);
        }
        return this.m_descriptor;
    }

    @Override
    public boolean canRestrictSchemaList() {
        return false;
    }

    public void setStatement(Statement statement) {
        if (this.m_statement != null && statement != null) {
            throw new IllegalArgumentException("Cannot set statement when already set");
        }
        this.m_statement = statement;
    }

    public void cancelStatement() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected final SystemObject findOrCreateObject(String type, Schema schema, String name, Object idVal) throws DBException {
        return this.findOrCreateObject(type, null, schema, name, idVal);
    }

    protected final SystemObject findOrCreateObject(String type, String dbName, Schema schema, String name, Object idVal) throws DBException {
        return this.findOrCreateObject(type, dbName, schema, name, idVal, null);
    }

    protected final SystemObject findOrCreateObject(String type, String dbName, Schema schema, String name, Object idVal, Long timestamp) throws DBException {
        return this.findOrCreateObject(type, dbName, schema, name, idVal, timestamp, false);
    }

    protected final SystemObject findOrCreateObject(DBObjectLister.ObjectInfo info, DBObjectCriteria criteria) throws DBException {
        return this.findOrCreateObject(info.getType(), criteria.getDatabaseName(), info.getSchema(), info.getName(), info.getIdentifier(), info.getTimestamp(), criteria.getSkipTimestampCheck());
    }

    private SystemObject findOrCreateObject(String type, String dbName, Schema schema, String name, Object idVal, Long timestamp, boolean skipTimestampCheck) throws DBException {
        DBObjectID id = this.createID(dbName, schema, name, type, idVal);
        SystemObject object = this.findObject(type, schema, name);
        if (object == null || ModelUtil.areDifferent((Object)object.getID(), (Object)id)) {
            DBObjectBuilder builder = this.getBuilderForType(type);
            if (builder == null) {
                throw new DBException(null, "missing builder for type " + type);
            }
            object = (SystemObject)builder.createObject(name, schema, id);
            this.markForLazyInit((AbstractBuildableObject)((Object)object));
            this.cacheObject(object, true);
        }
        if (timestamp != null) {
            Long existingTS;
            if (!skipTimestampCheck && (existingTS = this.getExistingTimestamp(object)) != null && existingTS < timestamp) {
                this.resetObject(object, object, timestamp);
            }
            object.setProperty("Timestamp", timestamp);
            this.putCachedTimestampKey(object.getID(), timestamp);
        }
        return object;
    }

    public final DBObjectID createID(Schema schema, String name, String type, Object id) {
        return this.createID(null, schema, name, type, id);
    }

    public final DBObjectID createID(String dbName, Schema schema, String name, String type, Object id) {
        BaseObjectID newID;
        if (id == null) {
            newID = new NameBasedID(type, schema == null ? null : schema.getName(), name, this);
        } else {
            IdentifierBasedID ibid = new IdentifierBasedID(type, id, (AbstractDBObjectProvider)this);
            ibid.setName(name);
            if (schema != null) {
                ibid.setSchemaName(schema.getName());
            }
            newID = ibid;
        }
        if (newID instanceof BaseObjectID && ModelUtil.hasLength((String)dbName)) {
            ((BaseObjectID)newID).setDatabaseName(dbName);
        }
        return newID;
    }

    public String getDBExceptionMessage(SQLException sqe) {
        return sqe.toString();
    }

    public boolean isUnsupportedOperation(SQLException sqe) {
        boolean retval = false;
        retval = sqe instanceof SQLFeatureNotSupportedException ? true : AbstractDatabase.isSQLStateNotImplemented(sqe);
        return retval;
    }

    public static boolean isSQLStateNotImplemented(SQLException sqe) {
        boolean retval = false;
        String state = sqe.getSQLState();
        if (ModelUtil.areEqual((Object)state, (Object)SQLSTATE_NOT_IMPLEMENTED) || ModelUtil.areEqual((Object)state, (Object)ODBC_NOT_IMPLEMENTED)) {
            retval = true;
        }
        return retval;
    }
}

