/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeRequiredException
extends DBException {
    private final Collection<DBObjectID> m_deps = new ArrayList<DBObjectID>();
    private final Collection<DBObject> m_objs = new ArrayList<DBObject>();
    private String m_detailMessage;

    public CascadeRequiredException(DBObject obj, String msg) {
        this(obj);
        this.m_detailMessage = msg;
    }

    public CascadeRequiredException(DBObject obj) {
        this(obj, (Collection<DBObjectID>)null);
    }

    public CascadeRequiredException(DBObject obj, Collection<DBObjectID> deps) {
        this(Arrays.asList(obj), deps);
    }

    public CascadeRequiredException(Collection<? extends DBObject> objs, Collection<DBObjectID> deps) {
        super((Throwable)null);
        if (objs != null) {
            this.m_objs.addAll(objs);
        }
        if (deps != null) {
            this.m_deps.addAll(deps);
        }
    }

    public void include(CascadeRequiredException cre2) {
        this.m_objs.addAll(cre2.m_objs);
        this.m_deps.addAll(cre2.m_deps);
    }

    @Override
    public String getMessage() {
        String retval;
        if (this.m_objs == null || this.m_objs.size() == 0) {
            retval = APIBundle.get("CASCADE_DELETE");
        } else {
            StringBuilder names = new StringBuilder();
            for (DBObject obj : this.m_objs) {
                if (obj == null) continue;
                names.append("\n").append(obj.getName());
            }
            names.append("\n");
            if (this.m_deps != null && this.m_deps.size() > 0) {
                StringBuilder buff = new StringBuilder();
                for (DBObjectID dep : this.m_deps) {
                    buff.append("\n").append(DBUtil.getFullyQualifiedName(dep));
                }
                retval = APIBundle.format("CASCADE_DELETE_ERR_VERBOSE", names, buff.toString());
            } else {
                String msg = APIBundle.format("CASCADE_DELETE_ERR", names);
                retval = ModelUtil.hasLength((String)this.m_detailMessage) ? msg + " " + this.m_detailMessage : msg;
            }
        }
        return retval;
    }

    @Override
    public DBObject getObject() {
        return this.m_objs == null || this.m_objs.size() == 0 ? super.getObject() : this.m_objs.iterator().next();
    }

    public Collection<DBObject> getObjects() {
        return this.m_objs;
    }

    public Collection<DBObjectID> getDependents() {
        return this.m_deps;
    }
}

