/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBException
extends Exception {
    private DBException m_next;
    private DBObject m_object;
    private DBObject[] m_relatedObjects;

    public DBException(DBObject obj, String msg) {
        super(msg);
        this.m_object = obj;
    }

    public DBException(DBObject obj, String msg, Throwable cause) {
        super(msg, cause);
        this.m_object = obj;
    }

    public DBException(DBObject obj, Throwable cause) {
        super(cause);
        this.m_object = obj;
    }

    public DBException(Throwable cause) {
        super(cause);
    }

    protected DBException() {
    }

    public DBObject getObject() {
        return this.m_object;
    }

    public DBObject[] getRelatedObjects() {
        return this.m_relatedObjects;
    }

    public void setRelatedObjects(DBObject ... objs) {
        this.m_relatedObjects = objs;
    }

    public DBException getNextException() {
        return this.m_next;
    }

    public synchronized void setNextException(DBException ex) {
        if (ex == this) {
            throw new IllegalStateException("Attempt to add this as nextException");
        }
        DBException theEnd = this;
        while (theEnd.m_next != null) {
            theEnd = theEnd.m_next;
        }
        theEnd.m_next = ex;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getAllMessages() {
        String retval;
        if (this.m_next == null) {
            retval = this.getMessage();
        } else {
            StringBuilder buff = new StringBuilder();
            for (DBException dbe = this; dbe != null; dbe = dbe.getNextException()) {
                if (buff.length() > 0) {
                    buff.append("\n");
                }
                buff.append(dbe.getMessage());
            }
            retval = buff.toString();
        }
        return retval;
    }

    public static <T extends DBException> T append(T dbe1, T dbe2) {
        T retval;
        if (dbe1 != null) {
            retval = dbe1;
            if (dbe2 != null) {
                retval.setNextException(dbe2);
            }
        } else {
            retval = dbe2;
        }
        return retval;
    }
}

